/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.os.Looper;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.db;
import com.tencent.ugc.dc;

@JNINamespace(value="liteav::ugc")
public class UGCInitializer {
    private static final String TAG = "UGCInitializer";
    private static int sRefCount = 0;
    private static CustomHandler sInitializerHandler = new CustomHandler(Looper.getMainLooper());

    public static synchronized void initialize() {
        if (sRefCount == 0) {
            boolean bl2 = UGCInitializer.runAndWaitDownOnInitialThread(db.a());
            LiteavLog.i(TAG, "initialize ".concat(String.valueOf(bl2)));
        }
        ++sRefCount;
    }

    public static synchronized void uninitialize() {
        if (sRefCount == 1) {
            boolean bl2 = UGCInitializer.runAndWaitDownOnInitialThread(dc.a());
            LiteavLog.i(TAG, "uninitialize ".concat(String.valueOf(bl2)));
        }
        if (sRefCount > 0) {
            --sRefCount;
        }
    }

    private static boolean runAndWaitDownOnInitialThread(Runnable task) {
        boolean bl2 = true;
        if (Looper.myLooper() == sInitializerHandler.getLooper()) {
            task.run();
        } else {
            bl2 = sInitializerHandler.runAndWaitDone(task);
        }
        return bl2;
    }

    private static native void nativeInitialize();

    private static native void nativeUninitialize();

    static /* synthetic */ void access$lambda$0() {
        UGCInitializer.nativeInitialize();
    }

    static /* synthetic */ void access$lambda$1() {
        UGCInitializer.nativeUninitialize();
    }
}

