/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.utils;

import android.text.TextUtils;
import android.util.Log;
import com.tencent.thumbplayer.api.TPPlayerMgr;
import java.util.MissingFormatArgumentException;

public class TPLogUtil {
    public static final int ERROR = 10;
    public static final int WARNING = 20;
    public static final int INFO = 40;
    public static final int DEBUG = 50;
    public static final int VERBOSE = 60;
    private static boolean isDebug = true;
    private static TPPlayerMgr.OnLogListener onLogListener = null;
    private static int logPrintLevel = 50;

    public static void v(String string, String string2) {
        TPLogUtil.printTag(60, string, string2, new Object[0]);
    }

    public static void d(String string, String string2) {
        TPLogUtil.printTag(50, string, string2, new Object[0]);
    }

    public static void i(String string, String string2) {
        TPLogUtil.printTag(40, string, string2, new Object[0]);
    }

    public static void w(String string, String string2) {
        TPLogUtil.printTag(20, string, string2, new Object[0]);
    }

    public static void e(String string, String string2) {
        TPLogUtil.printTag(10, string, string2, new Object[0]);
    }

    public static void e(String string, Throwable throwable) {
        TPLogUtil.e(string, throwable, "");
    }

    public static void e(String string, Throwable throwable, String string2) {
        String string3 = "";
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string3 = string2 + "\n";
        }
        if (throwable != null) {
            string3 = string3 + Log.getStackTraceString((Throwable)throwable);
        }
        TPLogUtil.printTag(10, string, string3, new Object[0]);
    }

    public static void setDebugEnable(boolean bl2) {
        isDebug = bl2;
    }

    public static void setOnLogListener(TPPlayerMgr.OnLogListener onLogListener) {
        TPLogUtil.onLogListener = onLogListener;
    }

    public static void setLogPrintLevel(int n2) {
        logPrintLevel = n2;
    }

    private static void printTag(int n2, String string, String string2, Object ... objectArray) {
        if (n2 == 20) {
            n2 = 10;
        }
        try {
            String string3;
            String string4 = string3 = objectArray == null || objectArray.length == 0 ? string2 : String.format(string2, objectArray);
            if (onLogListener != null) {
                if (n2 <= logPrintLevel) {
                    TPLogUtil.logToLogListener(n2, string, string3);
                    return;
                }
            } else if (isDebug && n2 <= logPrintLevel) {
                Log.println((int)TPLogUtil.toSysLevel(n2), (String)string, (String)string3);
            }
            return;
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            missingFormatArgumentException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            return;
        }
    }

    private static int toSysLevel(int n2) {
        int n3 = 0;
        switch (n2) {
            case 60: {
                n3 = 2;
                break;
            }
            case 50: {
                n3 = 3;
                break;
            }
            case 40: {
                n3 = 4;
                break;
            }
            case 20: {
                n3 = 5;
                break;
            }
            case 10: {
                n3 = 6;
            }
        }
        return n3;
    }

    private static void logToLogListener(int n2, String string, String string2) {
        switch (n2) {
            case 60: {
                onLogListener.v(string, string2);
                return;
            }
            case 50: {
                onLogListener.d(string, string2);
                return;
            }
            case 40: {
                onLogListener.i(string, string2);
                return;
            }
            case 20: {
                onLogListener.w(string, string2);
                return;
            }
            case 10: {
                onLogListener.e(string, string2);
            }
        }
    }
}

