/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.watermark;

import com.tencent.liteav.base.util.Size;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.videoprocessor.watermark.PasterBase;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SubtitleFilterChain
extends PasterBase {
    private List<TXVideoEditConstants.TXSubtitle> mSubtitleList;
    private CopyOnWriteArrayList<TXVideoEditConstants.TXSubtitle> mNormalizedList = new CopyOnWriteArrayList();

    public void setSubtitleList(List<TXVideoEditConstants.TXSubtitle> subtitleList, Size renderSize) {
        this.mRenderSize = renderSize;
        this.mSubtitleList = subtitleList;
        this.mNormalizedList.clear();
    }

    public List<TXVideoEditConstants.TXSubtitle> getSubtitleList() {
        return this.mNormalizedList;
    }

    @Override
    public void normalized(int frameW, int frameH, int renderMode) {
        if (this.mSubtitleList == null || this.mSubtitleList.size() == 0) {
            return;
        }
        for (TXVideoEditConstants.TXSubtitle tXSubtitle : this.mSubtitleList) {
            if (tXSubtitle == null) continue;
            TXVideoEditConstants.TXRect tXRect = this.calculateRect(frameW, frameH, renderMode, tXSubtitle.frame);
            TXVideoEditConstants.TXSubtitle tXSubtitle2 = this.construct(tXSubtitle, tXRect);
            this.mNormalizedList.add(tXSubtitle2);
        }
    }

    private TXVideoEditConstants.TXSubtitle construct(TXVideoEditConstants.TXSubtitle subtitle, TXVideoEditConstants.TXRect rect) {
        TXVideoEditConstants.TXSubtitle tXSubtitle = new TXVideoEditConstants.TXSubtitle();
        new TXVideoEditConstants.TXSubtitle().frame = rect;
        tXSubtitle.titleImage = subtitle.titleImage;
        tXSubtitle.startTime = subtitle.startTime;
        tXSubtitle.endTime = subtitle.endTime;
        return tXSubtitle;
    }

    @Override
    public void clear() {
        super.clear();
        SubtitleFilterChain subtitleFilterChain = this;
        subtitleFilterChain.clearSubtitleList(subtitleFilterChain.mNormalizedList);
        SubtitleFilterChain subtitleFilterChain2 = this;
        subtitleFilterChain2.clearSubtitleList(subtitleFilterChain2.mSubtitleList);
        this.mSubtitleList = null;
    }

    private void clearSubtitleList(List<TXVideoEditConstants.TXSubtitle> list) {
        if (list != null) {
            for (TXVideoEditConstants.TXSubtitle tXSubtitle : list) {
                if (tXSubtitle == null || tXSubtitle.titleImage == null || tXSubtitle.titleImage.isRecycled()) continue;
                tXSubtitle.titleImage.recycle();
                tXSubtitle.titleImage = null;
            }
            list.clear();
        }
    }
}

