/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.os.Message;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.callback.RCRTCLiveCallback;
import cn.rongcloud.rtc.api.stream.RCRTCAudioInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCCDNInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoView;
import cn.rongcloud.rtc.api.stream.view.RCRTCBaseView;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RCRTCSubscribeState;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCLocalUserImpl;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCRTCAudioInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCRTCCDNInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoInputStreamImpl;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.action.PubSubAction;
import cn.rongcloud.rtc.engine.action.PubSubActionQueue;
import cn.rongcloud.rtc.engine.tools.HandleChatRoomKVTools;
import cn.rongcloud.rtc.plugin.PluginUtils;
import cn.rongcloud.rtc.plugin.player.IPlayerPrepareListener;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AudienceState
extends AbstractBaseState {
    private static final String TAG = "AudienceState";
    private PubSubActionQueue actionQueue;
    private HandleChatRoomKVTools chatRoomKVTools;
    private RCRoomImpl room;
    private List<RCRTCInputStream> mCacheStreams = new ArrayList<RCRTCInputStream>();
    private int playerReconnectState = 0;

    public AudienceState(RTCEngineImpl engine) {
        super(engine);
        this.actionQueue = new PubSubActionQueue();
    }

    @Override
    public void enter() {
        super.enter();
        this.mCacheStreams.clear();
        this.actionQueue.clear();
        this.room = this.mEngine.mRoom;
        this.chatRoomKVTools = new HandleChatRoomKVTools(this.room, this);
        this.mEngine.mPlayer = PluginUtils.loadPlayerPlugin();
    }

    @Override
    protected boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 2060: {
                this.onAddTrack((String)obj.getData(0), (String)obj.getData(1), (RCRTCMediaType)((Object)obj.getData(2)), (MediaStreamTrack)obj.getData(3));
                break;
            }
            case 8000: {
                this.reconnect();
                break;
            }
            case 8001: {
                FinLog.d(TAG, "Live Reconnected onSuccess");
                break;
            }
            case 8002: {
                FinLog.e(TAG, "Live Reconnected Failed: " + obj.getData(0));
                RTCEngineImpl.getInstance().engineError(RTCErrorCode.RECONNECT_ERROR);
                break;
            }
            case 2010: {
                this.mEngine.mRTCCore.setRTCStatusReportListener((IRCRTCStatusReportListener)obj.getData());
                break;
            }
            case 2011: {
                this.mEngine.mRTCCore.setRTCStatusReportListener(null);
                break;
            }
            case 4000: {
                this.subscribeCDNStream((List)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 5047: {
                int width_cdnUri = (Integer)obj.getData(0);
                int height_cdnUri = (Integer)obj.getData(1);
                int FPS_cdnUri = (Integer)obj.getData(2);
                String RTMP_cdnUri = (String)obj.getData(3);
                this.playerPrepare(RTMP_cdnUri, width_cdnUri, height_cdnUri, FPS_cdnUri, (RCRTCCDNInputStream)obj.getData(5), (List)obj.getData(4), (IRCRTCResultCallback)obj.getData(6));
                break;
            }
            case 5033: {
                int width = (Integer)obj.getData(2);
                int height = (Integer)obj.getData(3);
                int FPS = (Integer)obj.getData(4);
                String playbackAddress_sub_success = (String)obj.getData(5);
                if (this.room.getCDNStream() != null && this.room.getCDNStream().getVideoResolution() == null) {
                    ((RCRTCCDNInputStreamImpl)this.room.getCDNStream()).setStreamConfig(RCRTCParamsType.RCRTCVideoResolution.getVideoResolution(width, height), RCRTCParamsType.RCRTCVideoFps.parseVideoFps(FPS));
                }
                this.updateCDNStreamHighestInfo(width, height, FPS, this.room, playbackAddress_sub_success);
                this.subscribeCDNStreamSuccess((List)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 5034: {
                RTCErrorCode subCDNStream_Code = (RTCErrorCode)((Object)obj.getData(0));
                IRCRTCResultCallback subCDNStream_callBack = (IRCRTCResultCallback)obj.getData(1);
                this.updateCDNStreamDesiredVideoResolution((RCRTCCDNInputStreamImpl)this.room.getCDNStream(), 0, 0, 0);
                this.onFailedCallback(subCDNStream_Code, subCDNStream_callBack);
                break;
            }
            case 4001: {
                if (this.mEngine.mPlayer != null) {
                    this.mEngine.mPlayer.start();
                }
                this.onSubscribeStreamSuccess((List)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 4002: {
                if (this.mEngine.mPlayer != null) {
                    this.mEngine.mPlayer.release();
                }
                ((IRCRTCResultDataCallback)obj.getData(1)).onFailed((RTCErrorCode)((Object)obj.getData(0)));
                break;
            }
            case 3091: {
                this.onSubscribeStreamSuccess((List)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 4042: {
                ((IRCRTCResultDataCallback)obj.getData(1)).onFailed((RTCErrorCode)((Object)obj.getData(0)));
                break;
            }
            case 4040: {
                this.unSubscribeStream((List)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 4041: {
                this.onUnsubscribeResourcesSuccess((List)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 3090: {
                this.actionQueue.offer(new PubSubAction(6, Collections.singletonList((RCRTCInputStream)obj.getData(1)), obj.getData(0), (IRCRTCFailedCallback)((IRCRTCResultCallback)obj.getData(2))){

                    @Override
                    protected void execute() {
                        AudienceState.this.switchStream((Boolean)this.getExtra(), this.getStreams(), this.getCallback());
                    }
                });
                break;
            }
            case 3092: {
                this.onSwitchStreamFailed((Boolean)obj.getData(0), (List)obj.getData(1), (RTCErrorCode)((Object)obj.getData(2)), (IRCRTCResultDataCallback)obj.getData(3));
                break;
            }
            case 9000: {
                this.releaseRoom((IRCRTCResultCallback)obj.getData());
                break;
            }
            case 5052: {
                this.room.getEventsListener().onReportFirstFrame((RCRTCInputStream)obj.getData(0), (RCRTCMediaType)((Object)obj.getData(1)));
                break;
            }
            case 3301: {
                this.room.getEventsListener().onFirstRemoteVideoFrame((String)obj.getData(0), (String)obj.getData(1));
                break;
            }
            case 1011: 
            case 10000: {
                this.mEngine.clearDeferredMessage();
                this.mEngine.deferMessage(msg);
                this.releaseRoom(null);
                break;
            }
            case 1012: {
                this.pullKV(this.getRoomId());
                this.reconnect();
                break;
            }
            case 2086: {
                String roomId = (String)obj.getData();
                if (roomId.equals(this.getRoomId())) {
                    this.pullKV(roomId);
                    break;
                }
                ReportUtil.libError(ReportUtil.TAG.PULL_KV, "roomId|desc", this.getRoomId(), "Current user is not in room :: " + roomId);
                break;
            }
            case 5030: {
                this.subscribeLiveUrl((String)obj.getData(0), (RCRTCAVStreamType)((Object)obj.getData(1)), (RCRTCLiveCallback)obj.getData(2));
                break;
            }
            case 5031: {
                this.subscribeLiveUrlSuccess((List)obj.getData(0), (RCRTCAVStreamType)((Object)obj.getData(1)), (RCRTCLiveCallback)obj.getData(2));
                break;
            }
            case 5039: {
                int errorCode = (Integer)obj.getData();
                ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "code", errorCode);
                RTCEngineImpl.getInstance().engineError(RTCErrorCode.valueOf(errorCode));
                break;
            }
            case 5055: {
                Object[] objMute = (Object[])obj.getData(0);
                String rtmp = null;
                if (objMute != null && objMute.length > 0) {
                    rtmp = (String)objMute[0];
                    this.updateCDNStreamHighestInfo((Integer)objMute[1], (Integer)objMute[2], (Integer)objMute[3], this.room, rtmp);
                }
                this.playerRestore(rtmp, (Boolean)obj.getData(1), (IRCRTCResultCallback)obj.getData(2));
                break;
            }
            case 5049: {
                if (this.room.getCDNStream() != null) {
                    boolean mute_failed = (Boolean)obj.getData(1);
                    ((RCRTCCDNInputStreamImpl)this.room.getCDNStream()).setMute(!mute_failed);
                }
                this.onFailedCallback((RTCErrorCode)((Object)obj.getData(0)), (IRCRTCFailedCallback)obj.getData(2));
                break;
            }
            case 5050: {
                this.updateCDNStreamHighestInfo(-1, -1, -1, this.room, (String)obj.getData(0));
                this.onSuccessCallback((IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 5040: {
                this.playerMute((Boolean)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 2087: {
                if (this.chatRoomKVTools != null) {
                    this.chatRoomKVTools.handleChatRoomKVUpdate((String)obj.getData(0), (Map)obj.getData(1));
                    break;
                }
                ReportUtil.libError(ReportUtil.TAG.PULL_KV, "roomId|desc", "", "HandleChatRoomKVTools is empty");
                break;
            }
            case 5041: 
            case 5048: {
                if (this.room.getCDNStream() != null) {
                    this.room.getEventsListener().onReportFirstFrame(this.room.getCDNStream(), msg.what == 5041 ? RCRTCMediaType.VIDEO : RCRTCMediaType.AUDIO);
                    break;
                }
                ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "roomId|desc", this.room.getRoomId(), "CDN video stream first frame notification failed.CDNStream is empty.");
                break;
            }
            case 5042: {
                int videoWidth = (Integer)obj.getData(0);
                int videoHeight = (Integer)obj.getData(1);
                int videoSarNum = (Integer)obj.getData(2);
                int videoSarDen = (Integer)obj.getData(3);
                if (this.room.getCDNStream() != null && this.room.getCDNStream().getVideoView() != null) {
                    ((RCRTCVideoView)this.room.getCDNStream().getVideoView()).setVideoSize(videoWidth, videoHeight);
                    ((RCRTCVideoView)this.room.getCDNStream().getVideoView()).setVideoSampleAspectRatio(videoSarNum, videoSarDen);
                    break;
                }
                ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "desc", "CDNStream or surfaceView is empty");
                break;
            }
            case 5043: {
                IRCRTCResultCallback resultCallback_CDN_size_change = (IRCRTCResultCallback)obj.getData(3);
                if (this.room.getCDNStream() != null && ((RCInputStreamImpl)((Object)this.room.getCDNStream())).getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) {
                    this.onSuccessCallback(resultCallback_CDN_size_change);
                    ReportUtil.appRes(ReportUtil.TAG.CHANGE_CDN_VIDEO_SIZE, "code|desc", 0, "CDN stream is not subscribed");
                    break;
                }
                int cdn_width = (Integer)obj.getData(0);
                int cdn_height = (Integer)obj.getData(1);
                int cdn_fps = (Integer)obj.getData(2);
                this.changeCDNVideoSize(cdn_width, cdn_height, cdn_fps, resultCallback_CDN_size_change);
                break;
            }
            case 5044: {
                int width_change_size = (Integer)obj.getData(1);
                int height_change_size = (Integer)obj.getData(2);
                int FPS_change_size = (Integer)obj.getData(3);
                String playbackAddress_change_video_size = (String)obj.getData(4);
                this.updateCDNStreamHighestInfo(width_change_size, height_change_size, FPS_change_size, this.room, playbackAddress_change_video_size);
                this.onSuccessCallback((IRCRTCResultCallback)obj.getData(0));
                break;
            }
            case 5045: {
                if (this.room.getCDNStream() != null && ((RCInputStreamImpl)((Object)this.room.getCDNStream())).getSubscribeState() == RCRTCSubscribeState.SUBSCRIBED) {
                    this.updateCDNStreamDesiredVideoResolution((RCRTCCDNInputStreamImpl)this.room.getCDNStream(), this.room.getCDNStream().getVideoResolution().getWidth(), this.room.getCDNStream().getVideoResolution().getHeight(), this.room.getCDNStream().getVideoFps().getFps());
                } else {
                    this.updateCDNStreamDesiredVideoResolution((RCRTCCDNInputStreamImpl)this.room.getCDNStream(), 0, 0, 0);
                }
                this.onFailedCallback((RTCErrorCode)((Object)obj.getData(0)), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 5046: {
                if (this.mEngine.mPlayer == null) break;
                this.mEngine.mPlayer.release();
                break;
            }
            case 5053: {
                this.playerReconnect((RCRTCCDNInputStreamImpl)obj.getData());
                break;
            }
            case 5057: {
                this.playerReconnect((RCRTCCDNInputStreamImpl)this.room.getCDNStream());
                break;
            }
            case 5054: {
                this.playerReconnectSuccess((Object[])obj.getData());
                break;
            }
            case 5056: {
                int responseCode = (Integer)obj.getData();
                this.playerReconnectState = 0;
                if (responseCode != 60000) break;
                RCRTCCDNInputStreamImpl inputStream_cache_not_exists = (RCRTCCDNInputStreamImpl)this.room.getCDNStream();
                boolean CDNNotEmpty = inputStream_cache_not_exists != null;
                ReportUtil.libStatus(ReportUtil.TAG.PLAYER_RECONNECT, "CDNNotEmpty", CDNNotEmpty);
                if (!CDNNotEmpty) break;
                if (this.room.getVirtualLiveUser() != null) {
                    ((RCRemoteUserImpl)this.room.getVirtualLiveUser()).removeCDNStream();
                }
                if (this.room.getEventsListener() == null) break;
                this.room.getEventsListener().onUnpublishCDNStream(new RCRTCCDNInputStreamImpl(inputStream_cache_not_exists.getCDNServer(), this.room.getRoomType(), this.room.getRoomId(), inputStream_cache_not_exists.getHighestResolution(), inputStream_cache_not_exists.getHighestFPS(), inputStream_cache_not_exists.isPull_safe(), inputStream_cache_not_exists.getOriginalMaximumWidth(), inputStream_cache_not_exists.getOriginalMaximumHeight()));
                break;
            }
            case 5058: {
                this.replay((Integer)obj.getData(0), (Integer)obj.getData(1), (Integer)obj.getData(2));
                break;
            }
            case 5059: {
                if (this.mEngine.mPlayer == null) break;
                int tmpPFS = (Integer)obj.getData(2);
                String path = (String)obj.getData(3);
                int desiredWidth = (Integer)obj.getData(4);
                int desiredHeight = (Integer)obj.getData(5);
                int desiredFPS = (Integer)obj.getData(6);
                this.updateCDNStreamHighestInfo((Integer)obj.getData(0), (Integer)obj.getData(1), tmpPFS, this.room, path);
                this.updateCDNStreamDesiredVideoResolution((RCRTCCDNInputStreamImpl)this.room.getCDNStream(), desiredWidth, desiredHeight, desiredFPS);
                this.mEngine.mPlayer.switchPlaybackAddress(path, tmpPFS, new IPlayerPrepareListener(){

                    @Override
                    public void onCompletion() {
                        ReportUtil.libRes(ReportUtil.TAG.PLAYER_STATE, "replay", "onCompletion");
                    }

                    @Override
                    public void onError() {
                        ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "replay", "player initialization completed");
                    }
                });
                break;
            }
            case 5064: {
                msg.what = 5075;
                this.mEngine.deferMessage(msg);
                this.mEngine.transitionTo(this.mEngine.mSwitching);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void replay(final int width, final int height, final int fps) {
        String CDNServer = "";
        if (this.room.getCDNStream() != null) {
            CDNServer = ((RCRTCCDNInputStreamImpl)this.room.getCDNStream()).getCDNServer();
        }
        if (TextUtils.isEmpty((CharSequence)CDNServer)) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "replay", "CDNServer is empty");
            return;
        }
        SignalManager.getInstance().getCDNUri(CDNServer, this.getRoomId(), this.room.getSessionId(), width, height, fps, new IRCRTCResultDataCallback<Object[]>(){

            @Override
            public void onSuccess(Object[] objects) {
                String rtmp = (String)objects[0];
                int width_rtmp = (Integer)objects[1];
                int height_rtmp = (Integer)objects[2];
                int FPS = (Integer)objects[3];
                AudienceState.this.sendMessage(5059, width_rtmp, height_rtmp, FPS, rtmp, width, height, fps);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "replay|code", "CDNServer is empty", errorCode.getValue());
            }
        });
    }

    private void playerReconnectSuccess(Object[] objects) {
        String rtmp_reconnect = null;
        if (objects != null && objects.length > 0) {
            rtmp_reconnect = (String)objects[0];
            this.updateCDNStreamHighestInfo((Integer)objects[1], (Integer)objects[2], (Integer)objects[3], this.room, rtmp_reconnect);
        }
        ReportUtil.libRes(ReportUtil.TAG.PLAYER_RECONNECT, "rtmp|mPlayer", rtmp_reconnect, this.mEngine.mPlayer != null);
        if (this.mEngine.mPlayer != null) {
            this.mEngine.mPlayer.restore(rtmp_reconnect, new IPlayerPrepareListener(){

                @Override
                public void onCompletion() {
                    ReportUtil.libRes(ReportUtil.TAG.PLAYER_RECONNECT, "desc", "player initialization completed");
                }

                @Override
                public void onError() {
                    ReportUtil.libError(ReportUtil.TAG.PLAYER_RECONNECT, "desc", "player initialization failed");
                }
            });
        }
        this.playerReconnectState = 0;
    }

    private void playerReconnect(RCRTCCDNInputStreamImpl inputStreamImpl) {
        if (this.playerReconnectState == 1) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_RECONNECT, "desc", "player is reconnecting.");
            return;
        }
        if (inputStreamImpl == null) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_RECONNECT, "desc", "RCRTCCDNInputStream is empty.");
            return;
        }
        if (inputStreamImpl.getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_RECONNECT, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "RCRTCCDNInputStream is not subscribed");
            return;
        }
        if (inputStreamImpl.isMute()) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_RECONNECT, "desc", "isMute");
            return;
        }
        this.playerReconnectState = 1;
        boolean isPull_safe = inputStreamImpl.isPull_safe();
        ReportUtil.libTask(ReportUtil.TAG.PLAYER_RECONNECT, "CDNServer|Pull_safe", inputStreamImpl.getCDNServer(), isPull_safe);
        if (isPull_safe) {
            this.getRTMP(inputStreamImpl, new IRCRTCResultDataCallback<Object[]>(){

                @Override
                public void onSuccess(Object[] objects) {
                    AudienceState.this.sendMessage(5054, objects);
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    ReportUtil.libError(ReportUtil.TAG.PLAYER_RECONNECT, "code", errorCode.getValue());
                    AudienceState.this.sendMessage(5056, (Object)errorCode.getValue());
                }
            });
        } else {
            this.playerReconnectSuccess(null);
        }
    }

    private void playerMute(final boolean mute, final IRCRTCResultCallback callback) {
        if (this.room.getCDNStream() == null) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_MUTE, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "RCRTCCDNInputStream is empty");
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callback);
            return;
        }
        boolean CDNSubscribed = false;
        if (((RCInputStreamImpl)((Object)this.room.getCDNStream())).getSubscribeState() == RCRTCSubscribeState.SUBSCRIBED) {
            CDNSubscribed = true;
        }
        RCRTCCDNInputStreamImpl inputStream = (RCRTCCDNInputStreamImpl)this.room.getCDNStream();
        ReportUtil.libTask(ReportUtil.TAG.PLAYER_MUTE, "mute|CDNSubscribeState", mute, CDNSubscribed);
        if (!CDNSubscribed) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_MUTE, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "RCRTCCDNInputStream is not subscribed");
            inputStream.setMute(!mute);
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callback);
            return;
        }
        if (this.mEngine.mPlayer == null) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_MUTE, "code", RTCErrorCode.PLAYER_MODULE_NOT_FOUND.getValue());
            inputStream.setMute(!mute);
            this.onFailedCallback(RTCErrorCode.PLAYER_MODULE_NOT_FOUND, callback);
            return;
        }
        boolean isPull_safe = inputStream.isPull_safe();
        if (mute) {
            this.mEngine.mPlayer.pause();
            this.onSuccessCallback(callback);
        } else if (isPull_safe) {
            this.getRTMP(inputStream, new IRCRTCResultDataCallback<Object[]>(){

                @Override
                public void onSuccess(Object[] objects) {
                    AudienceState.this.sendMessage(5055, objects, mute, callback);
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    AudienceState.this.sendMessage(5049, new Object[]{errorCode, mute, callback});
                }
            });
        } else {
            this.playerRestore(null, mute, callback);
        }
    }

    private void playerRestore(final String rtmp, final boolean mute, final IRCRTCResultCallback callback) {
        this.mEngine.mPlayer.restore(null, new IPlayerPrepareListener(){

            @Override
            public void onCompletion() {
                AudienceState.this.sendMessage(5050, rtmp, callback);
            }

            @Override
            public void onError() {
                AudienceState.this.sendMessage(5049, new Object[]{RTCErrorCode.PLAYER_MODULE_INIT_ERROR, mute, callback});
            }
        });
    }

    private void updateCDNStreamHighestInfo(int width, int height, int FPS, RCRoomImpl roomImpl, String playbackAddress) {
        if (roomImpl.getCDNStream() != null) {
            if (width != -1) {
                ((RCRTCCDNInputStreamImpl)roomImpl.getCDNStream()).setOriginalMaximum(width, height);
                int tmpWidth = width;
                int tmpHeight = height;
                if (width > height) {
                    tmpWidth = height;
                    tmpHeight = width;
                }
                ((RCRTCCDNInputStreamImpl)roomImpl.getCDNStream()).setHighestResolution(RCRTCParamsType.RCRTCVideoResolution.parseVideoResolution(tmpWidth, tmpHeight));
            }
            if (FPS != -1) {
                ((RCRTCCDNInputStreamImpl)roomImpl.getCDNStream()).setHighestFPS(RCRTCParamsType.RCRTCVideoFps.parseVideoFps(FPS));
            }
            if (!TextUtils.isEmpty((CharSequence)playbackAddress)) {
                ((RCRTCCDNInputStreamImpl)roomImpl.getCDNStream()).setCurrentPlaybackAddress(playbackAddress);
            }
        }
    }

    private void subscribeCDNStreamSuccess(List<RCRTCInputStream> inputStreamList, IRCRTCResultCallback callback) {
        boolean isOnlyCDNStream = true;
        for (int i = 0; i < inputStreamList.size(); ++i) {
            if (inputStreamList.get(i) instanceof RCRTCCDNInputStream) {
                ((RCInputStreamImpl)inputStreamList.get(i)).setSubscribeState(RCRTCSubscribeState.SUBSCRIBED);
                if (this.room.getCDNStream() == null) continue;
                ((RCInputStreamImpl)((Object)this.room.getCDNStream())).setSubscribeState(RCRTCSubscribeState.SUBSCRIBED);
                continue;
            }
            isOnlyCDNStream = false;
            break;
        }
        if (isOnlyCDNStream) {
            ReportUtil.libStatus(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "desc", "Only subscribe to CDN stream successfully");
            if (this.mEngine.mPlayer != null) {
                this.mEngine.mPlayer.start();
            }
            this.onSuccessCallback(callback);
        } else {
            this.actionQueue.offer(new PubSubAction(3, inputStreamList, (IRCRTCFailedCallback)callback){

                @Override
                protected void execute() {
                    AudienceState.this.subscribeStreams(this.getStreams(), this.getCallback());
                }
            });
        }
    }

    private void pullKV(final String roomId) {
        SignalManager.getInstance().pullKV(roomId, new IRCRTCResultDataCallback<Map<String, String>>(){

            @Override
            public void onSuccess(Map<String, String> data) {
                AudienceState.this.sendMessage(2087, roomId, data);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
            }
        });
    }

    private void onAddTrack(String userId, String tag, RCRTCMediaType mediaType, MediaStreamTrack track) {
        RCRTCRemoteUser remoteUser;
        RCRTCRemoteUser rCRTCRemoteUser = remoteUser = this.room.getVirtualLiveUser() != null && TextUtils.equals((CharSequence)this.room.getVirtualLiveUser().getUserId(), (CharSequence)userId) ? this.room.getVirtualLiveUser() : this.room.getRemoteUser(userId);
        if (remoteUser == null) {
            this.cacheTracks(userId, tag, mediaType, track);
            FinLog.e(TAG, "addTrack Failed: not find remoteUser, userId=" + userId);
            return;
        }
        RCRTCInputStream stream = remoteUser.getStream(tag, mediaType);
        if (stream == null) {
            this.cacheTracks(userId, tag, mediaType, track);
            FinLog.e(TAG, "addTrack Failed: not find InputStream, tag=" + tag + ", mediaType=" + (Object)((Object)mediaType));
            return;
        }
        FinLog.d(TAG, "addTrack : " + stream.getUri());
        stream.setTrack(track);
        if (mediaType == RCRTCMediaType.VIDEO) {
            this.room.getEventsListener().onVideoTrackAdd(userId, tag);
        }
    }

    private void cacheTracks(String userId, String tag, RCRTCMediaType mediaType, MediaStreamTrack track) {
        String streamId = RCStreamImpl.makeStreamId(userId, tag);
        boolean isAudio = mediaType == RCRTCMediaType.AUDIO;
        RCInputStreamImpl inputStream = isAudio ? new RCRTCAudioInputStreamImpl(userId, tag, streamId) : new RCVideoInputStreamImpl(userId, tag, streamId);
        inputStream.setTrack(track);
        this.mCacheStreams.add(inputStream);
    }

    public void subscribeLiveUrl(String liveUrl, final RCRTCAVStreamType avStreamType, final RCRTCLiveCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.SUBSCRIBELIVEURL, "roomId|liveUrl|liveType|simulcast", this.getRoomId(), liveUrl, avStreamType.getMediaType(), avStreamType.getSimulcast());
        if (TextUtils.isEmpty((CharSequence)liveUrl)) {
            ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVEURL, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "liveUrl is null !");
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        this.mEngine.mRTCCore.subscribeLiveUrl(liveUrl, avStreamType, this.getRoomId(), this.room.getAllSubscribedStreams(), this.room.getSessionId(), this.room.getClientSessionId(), new IRCRTCResultDataCallback<List<MediaResourceInfo>>(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVEURL, "code|desc", errorCode.getValue(), errorCode.getReason());
                AudienceState.this.onFailedCallback(errorCode, callBack);
            }

            @Override
            public void onSuccess(List<MediaResourceInfo> mediaResourceInfos) {
                ReportUtil.libRes(ReportUtil.TAG.SUBSCRIBELIVEURL, "code", 0);
                AudienceState.this.postCallback(new Runnable(){

                    @Override
                    public void run() {
                        callBack.onSuccess();
                    }
                });
                AudienceState.this.sendMessage(5031, new Object[]{mediaResourceInfos, avStreamType, callBack});
            }
        });
    }

    public void subscribeLiveUrlSuccess(List<MediaResourceInfo> mediaResourceInfos, RCRTCAVStreamType avStreamType, RCRTCLiveCallback callBack) {
        FinLog.d(TAG, "subscribeLiveUrlSuccess: MediaResourceInfo Size is " + mediaResourceInfos.size());
        RCRemoteUserImpl liveUser = (RCRemoteUserImpl)this.room.getVirtualLiveUser();
        if (liveUser == null) {
            liveUser = (RCRemoteUserImpl)HandleChatRoomKVTools.createUserByMediaInfo(mediaResourceInfos.get(0));
            this.room.setVirtualLiveUser(liveUser);
        }
        for (RCRTCInputStream stream : this.mCacheStreams) {
            liveUser.addStream(stream);
        }
        this.mCacheStreams.clear();
        for (MediaResourceInfo mediaResourceInfo : mediaResourceInfos) {
            RCRTCInputStream stream = liveUser.getStream(mediaResourceInfo.getTag(), mediaResourceInfo.getType());
            if (stream == null) {
                stream = mediaResourceInfo.getType() == RCRTCMediaType.AUDIO ? new RCRTCAudioInputStreamImpl(liveUser.getUserId(), mediaResourceInfo) : new RCVideoInputStreamImpl(liveUser.getUserId(), mediaResourceInfo);
                liveUser.addStream(stream);
            }
            RCRTCSubscribeState preSubscribeState = ((RCInputStreamImpl)stream).getSubscribeState();
            ((RCInputStreamImpl)stream).setSubscribeState(RCRTCSubscribeState.INIT);
            switch (avStreamType.getMediaType()) {
                case 0: {
                    this.onAudioStreamReceived(callBack, preSubscribeState, stream);
                    break;
                }
                case 1: {
                    this.onVideoStreamReceived(callBack, preSubscribeState, stream, avStreamType);
                    break;
                }
                case 2: {
                    if (stream.getMediaType() == RCRTCMediaType.VIDEO) {
                        this.onVideoStreamReceived(callBack, preSubscribeState, stream, avStreamType);
                        break;
                    }
                    this.onAudioStreamReceived(callBack, preSubscribeState, stream);
                }
            }
        }
    }

    private void onVideoStreamReceived(final RCRTCLiveCallback callBack, RCRTCSubscribeState preSubscribeState, final RCRTCInputStream finalStream, RCRTCAVStreamType avStreamType) {
        if (finalStream.getMediaType() != RCRTCMediaType.VIDEO) {
            return;
        }
        ((RCInputStreamImpl)finalStream).setSubscribeState(RCRTCSubscribeState.SUBSCRIBED);
        ((RCRTCVideoInputStream)finalStream).setStreamType(RCRTCStreamType.valueOf(avStreamType.getSimulcast()));
        if (callBack == null || preSubscribeState == RCRTCSubscribeState.SUBSCRIBED) {
            return;
        }
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                callBack.onVideoStreamReceived((RCRTCVideoInputStream)finalStream);
            }
        });
    }

    private void onAudioStreamReceived(final RCRTCLiveCallback callBack, RCRTCSubscribeState preSubscribeState, final RCRTCInputStream finalStream) {
        if (finalStream.getMediaType() != RCRTCMediaType.AUDIO) {
            return;
        }
        ((RCInputStreamImpl)finalStream).setSubscribeState(RCRTCSubscribeState.SUBSCRIBED);
        if (callBack == null || preSubscribeState == RCRTCSubscribeState.SUBSCRIBED) {
            return;
        }
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                callBack.onAudioStreamReceived((RCRTCAudioInputStream)finalStream);
            }
        });
    }

    public void subscribeStreams(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.ENGINESUBSCRIBESTREAMS, "roomId|streams", this.room.getRoomId(), ReportUtil.resourceToString(streams));
        ArrayList<RCRTCInputStream> allInputStreams = new ArrayList<RCRTCInputStream>();
        for (RCRTCRemoteUser remoteUser : this.room.getRemoteUsers()) {
            allInputStreams.addAll(remoteUser.getStreams());
        }
        List<RCRTCInputStream> liveStreams = this.room.getLiveStreams();
        if (liveStreams != null) {
            allInputStreams.addAll(liveStreams);
        }
        if (RongRTCUtils.resourceNotExist(allInputStreams, streams)) {
            ReportUtil.libErrorW(ReportUtil.TAG.ENGINESUBSCRIBESTREAMS, RTCErrorCode.RongRTCCodeSubscribeNotExistResources, "roomId", this.room.getRoomId());
            callBack.onFailed(RTCErrorCode.RongRTCCodeSubscribeNotExistResources);
            return;
        }
        List<IStreamResource> subscribedStreams = this.room.getAllSubscribedStreams();
        for (RCRTCInputStream rCRTCInputStream : streams) {
            Iterator<IStreamResource> iterator = subscribedStreams.iterator();
            while (iterator.hasNext()) {
                IStreamResource streamResource = iterator.next();
                RCRTCMediaType mediaType = rCRTCInputStream.getMediaType();
                if (!TextUtils.equals((CharSequence)streamResource.getStreamId(), (CharSequence)rCRTCInputStream.getStreamId()) || mediaType != streamResource.getMediaType()) continue;
                FinLog.d(TAG, "subscribedStreams.Delete duplicate.Uri : " + streamResource.getUri() + " , new :" + rCRTCInputStream.getUri());
                iterator.remove();
            }
        }
        subscribedStreams.addAll(streams);
        this.onSubScribeStreams(subscribedStreams, callBack, 4001, 4002, ReportUtil.TAG.ENGINESUBSCRIBESTREAMS, this.getAVStreamType());
    }

    private void onSubscribeStreamSuccess(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callback) {
        for (RCRTCInputStream rCRTCInputStream : streams) {
            ((RCInputStreamImpl)rCRTCInputStream).setSubscribeState(RCRTCSubscribeState.SUBSCRIBED);
        }
        callback.onSuccess(null);
    }

    private void onSubScribeStreams(List<? extends IStreamResource> allSubStreams, IRCRTCResultDataCallback callback, int successCode, int failedCode, ReportUtil.TAG tag, RCRTCAVStreamType avStreamType) {
        this.onSubScribeStreams(allSubStreams, allSubStreams, callback, successCode, failedCode, tag, avStreamType);
    }

    private void onSubScribeStreams(List<? extends IStreamResource> allSubStreams, final List<? extends IStreamResource> updateStreams, final IRCRTCResultDataCallback callback, final int successCode, final int failedCode, final ReportUtil.TAG tag, RCRTCAVStreamType avStreamType) {
        this.mEngine.mRTCCore.subscribeLiveStream(allSubStreams, this.room.getSessionId(), this.room.getClientSessionId(), avStreamType, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                if (tag != null) {
                    ReportUtil.libErrorW(tag, errorCode, "roomId", AudienceState.this.getRoomId());
                }
                AudienceState.this.sendMessage(failedCode, new Object[]{errorCode, callback});
            }

            @Override
            public void onSuccess() {
                if (tag != null) {
                    ReportUtil.libRes(tag, AudienceState.this.getRoomId());
                }
                AudienceState.this.sendMessage(successCode, updateStreams, callback);
            }
        });
    }

    public void unsubscribeStreams(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, "roomId|streams", this.getRoomId(), ReportUtil.resourceToString(streams));
        List<IStreamResource> subscribedStreams = this.room.getAllSubscribedStreams();
        subscribedStreams.removeAll(streams);
        this.onSubScribeStreams(subscribedStreams, streams, callback, 4041, 4042, ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, this.getAVStreamType());
    }

    private void onUnsubscribeResourcesSuccess(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callback) {
        for (RCRTCInputStream rCRTCInputStream : streams) {
            if (rCRTCInputStream == null) continue;
            ((RCInputStreamImpl)rCRTCInputStream).setSubscribeState(RCRTCSubscribeState.INIT);
        }
        callback.onSuccess(null);
    }

    public void switchStream(final boolean tiny, final List<RCRTCInputStream> streams, final IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "roomId|isTiny", this.getRoomId(), tiny);
        for (RCRTCStream rCRTCStream : streams) {
            ((RCVideoInputStreamImpl)rCRTCStream).setStreamType(tiny ? RCRTCStreamType.TINY : RCRTCStreamType.NORMAL);
        }
        List<IStreamResource> subStreams = this.room.getAllSubscribedStreams();
        for (RCRTCInputStream stream : streams) {
            if (subStreams.contains(stream)) continue;
            subStreams.add(stream);
        }
        this.mEngine.mRTCCore.subscribeLiveStream(subStreams, this.room.getSessionId(), this.room.getClientSessionId(), this.getAVStreamType(), new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "code", 0);
                AudienceState.this.sendMessage(3091, streams, callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "code|desc", errorCode.getValue(), errorCode.getReason());
                AudienceState.this.sendMessage(3092, new Object[]{tiny, streams, errorCode, callback});
            }
        });
    }

    private void onSwitchStreamFailed(boolean tiny, List<RCRTCStream> streams, RTCErrorCode errorCode, IRCRTCResultDataCallback callback) {
        for (RCRTCStream stream : streams) {
            ((RCVideoInputStreamImpl)stream).setStreamType(!tiny ? RCRTCStreamType.TINY : RCRTCStreamType.NORMAL);
        }
        callback.onFailed(errorCode);
    }

    private void reconnect() {
        FinLog.d(TAG, "reConnect");
        this.onSubScribeStreams(this.room.getAllSubscribedStreams(), null, 8001, 8002, null, this.getAVStreamType());
        this.playerReconnect((RCRTCCDNInputStreamImpl)this.room.getCDNStream());
    }

    private RCRTCAVStreamType getAVStreamType() {
        if (this.room.getRoomType() == RCRTCRoomType.LIVE_AUDIO) {
            return RCRTCAVStreamType.AUDIO;
        }
        return RCRTCAVStreamType.AUDIO_VIDEO;
    }

    public void resubscribeStreams() {
        FinLog.d(TAG, "resubscribeStreams");
        this.onSubScribeStreams(this.room.getAllSubscribedStreams(), null, 4003, 4004, null, this.getAVStreamType());
    }

    public void releaseRoom(final IRCRTCResultCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.RELEASEROOM, "roomId", this.getRoomId());
        this.actionQueue.clear();
        RongRtcStatMagr.instance.release();
        this.mEngine.version2UserIDs.clear();
        this.mEngine.mDefaultAudioStream.resetStream();
        this.mEngine.mDefaultVideoStream.resetStream();
        ((RCLocalUserImpl)this.room.getLocalUser()).release();
        RCRTCRoomType roomType = this.room.getRoomType();
        String sessionId = this.room.getSessionId();
        String clientSessionId = this.room.getClientSessionId();
        this.room.release();
        final String roomId = this.room.getRoomId();
        if (!TextUtils.isEmpty((CharSequence)sessionId)) {
            SignalManager.getInstance().quitLive(null, roomType.getRoomType(), sessionId, clientSessionId, null);
        } else {
            FinLog.w(TAG, "releaseRoom: sessionId is null ");
        }
        SignalManager.getInstance().viewerQuitRoom(roomId, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libErrorW(ReportUtil.TAG.RELEASEROOM, errorCode, "roomId", roomId);
                AudienceState.this.onSuccessCallback(callBack);
            }

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.RELEASEROOM, roomId);
                AudienceState.this.onSuccessCallback(callBack);
            }
        });
        this.room = null;
        this.mEngine.mRoom = null;
        if (this.mEngine.mPlayer != null) {
            this.mEngine.mPlayer.release();
            this.mEngine.mPlayer.quitLooper();
            this.mEngine.mPlayer = null;
        }
        this.mEngine.resetPreSpeakerphoneState();
        this.transitionTo(this.mEngine.mDisConnectingState);
        FinLog.i(TAG, "releaseAll end");
    }

    private String getRoomId() {
        return this.mEngine.getRoomId();
    }

    @Override
    public void exit() {
        super.exit();
        this.mCacheStreams.clear();
        this.actionQueue.clear();
        this.chatRoomKVTools.release();
    }

    @Override
    public String getName() {
        return TAG;
    }

    private void subscribeCDNStream(final List<RCRTCInputStream> streams, final IRCRTCResultCallback callBack) {
        RCRTCCDNInputStream inputStream = null;
        boolean hasCDNInputStream = false;
        for (RCRTCInputStream stream : streams) {
            if (!(stream instanceof RCRTCCDNInputStream)) continue;
            hasCDNInputStream = true;
            inputStream = (RCRTCCDNInputStream)stream;
            break;
        }
        if (!hasCDNInputStream) {
            ReportUtil.appStatus(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "desc", "No need to subscribe to CDN stream");
            this.subscribeCDNStreamSuccess(streams, callBack);
            return;
        }
        if (inputStream == null) {
            ReportUtil.appError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|code|desc", this.getRoomId(), RTCErrorCode.RongRTCCodeParameterError.getValue(), "The subscribed CDN stream is empty");
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        if (this.mEngine.mPlayer == null) {
            this.updateCDNStreamDesiredVideoResolution((RCRTCCDNInputStreamImpl)this.room.getCDNStream(), 0, 0, 0);
            ReportUtil.appError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|code|desc", this.getRoomId(), RTCErrorCode.PLAYER_MODULE_NOT_FOUND.getValue(), RTCErrorCode.PLAYER_MODULE_NOT_FOUND.getReason());
            this.onFailedCallback(RTCErrorCode.PLAYER_MODULE_NOT_FOUND, callBack);
            return;
        }
        final RCRTCCDNInputStreamImpl finalInputStream1 = (RCRTCCDNInputStreamImpl)inputStream;
        this.getRTMP((RCRTCCDNInputStreamImpl)inputStream, new IRCRTCResultDataCallback<Object[]>(){

            @Override
            public void onSuccess(Object[] objects) {
                String rtmp = (String)objects[0];
                int width = (Integer)objects[1];
                int height = (Integer)objects[2];
                int FPS = (Integer)objects[3];
                AudienceState.this.sendMessage(5047, width, height, FPS, rtmp, streams, finalInputStream1, callBack);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                AudienceState.this.sendMessage(5034, new Object[]{errorCode, callBack});
            }
        });
    }

    private void playerPrepare(final String rtmp, final int width, final int height, final int FPS, RCRTCCDNInputStream finalInputStream, final List<RCRTCInputStream> streams, final IRCRTCResultCallback callBack) {
        if (this.mEngine.mPlayer != null) {
            int tmpFPS = finalInputStream.getVideoFps() == null ? FPS : finalInputStream.getVideoFps().getFps();
            this.mEngine.mPlayer.prepare(rtmp, (RCRTCBaseView)finalInputStream.getVideoView(), tmpFPS, 0, new IPlayerPrepareListener(){

                @Override
                public void onCompletion() {
                    AudienceState.this.sendMessage(5033, streams, callBack, width, height, FPS, rtmp);
                }

                @Override
                public void onError() {
                    ReportUtil.libError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|code|desc", AudienceState.this.getRoomId(), RTCErrorCode.PLAYER_MODULE_INIT_ERROR.getValue(), RTCErrorCode.PLAYER_MODULE_INIT_ERROR.getReason());
                    AudienceState.this.sendMessage(5034, new Object[]{RTCErrorCode.PLAYER_MODULE_INIT_ERROR, callBack});
                }
            });
        } else {
            ReportUtil.libError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|code|desc", this.getRoomId(), RTCErrorCode.PLAYER_MODULE_NOT_FOUND.getValue(), RTCErrorCode.PLAYER_MODULE_NOT_FOUND.getReason());
            this.sendMessage(5034, new Object[]{RTCErrorCode.PLAYER_MODULE_NOT_FOUND, callBack});
        }
    }

    private void unSubscribeStream(List<RCRTCInputStream> streams, IRCRTCResultCallback callBack) {
        boolean hasCDNInputStream = false;
        for (RCRTCInputStream stream : streams) {
            if (!(stream instanceof RCRTCCDNInputStream)) continue;
            hasCDNInputStream = true;
            if (!(stream instanceof RCRTCCDNInputStream)) break;
            ((RCRTCCDNInputStreamImpl)stream).setCurrentPlaybackAddress("");
            ((RCInputStreamImpl)stream).setSubscribeState(RCRTCSubscribeState.INIT);
            ((RCRTCCDNInputStreamImpl)stream).setStreamConfig(null, null);
            if (this.room.getCDNStream() == null) break;
            ((RCInputStreamImpl)((Object)this.room.getCDNStream())).setSubscribeState(RCRTCSubscribeState.INIT);
            ((RCRTCCDNInputStreamImpl)this.room.getCDNStream()).setCurrentPlaybackAddress("");
            ((RCRTCCDNInputStreamImpl)this.room.getCDNStream()).setStreamConfig(null, null);
            break;
        }
        if (hasCDNInputStream && this.mEngine.mPlayer != null) {
            this.mEngine.mPlayer.release();
        }
        if (hasCDNInputStream && streams.size() == 1) {
            ReportUtil.libRes(ReportUtil.TAG.UNSUB_CDN_STREAM, "desc", "Only unsubscribe the CDN stream successfully");
            this.onSuccessCallback(callBack);
            return;
        }
        this.actionQueue.offer(new PubSubAction(5, streams, (IRCRTCFailedCallback)callBack){

            @Override
            protected void execute() {
                AudienceState.this.unsubscribeStreams(this.getStreams(), this.getCallback());
            }
        });
    }

    private void changeCDNVideoSize(int width, int height, final int fps, final IRCRTCResultCallback callback) {
        RCRTCCDNInputStreamImpl cdnStreamImpl = null;
        if (this.mEngine.getRoom() == null || (cdnStreamImpl = (RCRTCCDNInputStreamImpl)this.mEngine.getRoom().getCDNStream()) == null) {
            ReportUtil.appError(ReportUtil.TAG.CHANGE_CDN_VIDEO_SIZE, "roomId|code|desc", new Object[]{this.getRoomId(), RTCErrorCode.RongRTCCodeParameterError, "room or cdnStream is empty"});
            if (callback != null) {
                this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callback);
            }
            return;
        }
        String CDNServer = cdnStreamImpl.getCDNServer();
        String sessionId = this.room.getSessionId();
        int highestWidth = 0;
        int highestHeight = 0;
        int tmpWidth = 0;
        int tmpHeight = 0;
        if (cdnStreamImpl.getOriginalMaximumWidth() != 0 && cdnStreamImpl.getOriginalMaximumHeight() != 0) {
            highestWidth = cdnStreamImpl.getOriginalMaximumWidth();
            highestHeight = cdnStreamImpl.getOriginalMaximumHeight();
        }
        int[] objects = RongRTCUtils.videoResolutionConversion(width, height, highestWidth, highestHeight);
        tmpWidth = objects[0];
        tmpHeight = objects[1];
        SignalManager.getInstance().getCDNUri(CDNServer, this.getRoomId(), sessionId, tmpWidth, tmpHeight, fps, new IRCRTCResultDataCallback<Object[]>(){

            @Override
            public void onSuccess(Object[] objects) {
                final String rtmp = (String)objects[0];
                final int width = (Integer)objects[1];
                final int height = (Integer)objects[2];
                final int FPS = (Integer)objects[3];
                if (AudienceState.this.mEngine.mPlayer != null) {
                    AudienceState.this.mEngine.mPlayer.switchPlaybackAddress(rtmp, fps, new IPlayerPrepareListener(){

                        @Override
                        public void onCompletion() {
                            AudienceState.this.sendMessage(5044, callback, width, height, FPS, rtmp);
                        }

                        @Override
                        public void onError() {
                            ReportUtil.libError(ReportUtil.TAG.CHANGE_CDN_VIDEO_SIZE, "roomId|code|desc", AudienceState.this.getRoomId(), RTCErrorCode.PLAYER_MODULE_INIT_ERROR.getValue(), RTCErrorCode.PLAYER_MODULE_INIT_ERROR.getReason());
                            AudienceState.this.sendMessage(5045, new Object[]{RTCErrorCode.PLAYER_MODULE_INIT_ERROR, callback});
                        }
                    });
                } else {
                    ReportUtil.libError(ReportUtil.TAG.CHANGE_CDN_VIDEO_SIZE, "roomId|code|desc", AudienceState.this.getRoomId(), RTCErrorCode.PLAYER_MODULE_NOT_FOUND.getValue(), RTCErrorCode.PLAYER_MODULE_NOT_FOUND.getReason());
                    AudienceState.this.sendMessage(5045, new Object[]{RTCErrorCode.PLAYER_MODULE_NOT_FOUND, callback});
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                AudienceState.this.sendMessage(5045, new Object[]{errorCode, callback});
            }
        });
    }

    private void getRTMP(RCRTCCDNInputStreamImpl stream, IRCRTCResultDataCallback<Object[]> callBack) {
        String CDNServer = stream.getCDNServer();
        int tmpWidth = 0;
        int tmpHeight = 0;
        int FPS = 0;
        int highestWidth = 0;
        int highestHeight = 0;
        if (stream.getDesiredWidth() > 0 && stream.getDesiredHeight() > 0) {
            tmpWidth = stream.getDesiredWidth();
            tmpHeight = stream.getDesiredHeight();
        }
        if (stream.getDesiredFPS() != null) {
            FPS = stream.getDesiredFPS().getFps();
        }
        if (stream.getOriginalMaximumWidth() != 0 && stream.getOriginalMaximumHeight() != 0) {
            highestWidth = stream.getOriginalMaximumWidth();
            highestHeight = stream.getOriginalMaximumHeight();
        }
        int[] objects = RongRTCUtils.videoResolutionConversion(tmpWidth, tmpHeight, highestWidth, highestHeight);
        int width = objects[0];
        int height = objects[1];
        SignalManager.getInstance().getCDNUri(CDNServer, this.getRoomId(), this.room.getSessionId(), width, height, FPS, callBack);
    }

    private void updateCDNStreamDesiredVideoResolution(RCRTCCDNInputStreamImpl inputStream, int width, int height, int fps) {
        if (inputStream != null) {
            RCRTCParamsType.RCRTCVideoFps videoFps = null;
            if (fps != 0) {
                videoFps = RCRTCParamsType.RCRTCVideoFps.parseVideoFps(fps);
            }
            inputStream.setDesiredVideoResolution(width, height, videoFps);
        }
    }
}

