/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message;

import android.os.Parcel;
import android.os.Parcelable;
import cn.rongcloud.rtc.proxy.message.messagebeans.KickMessageUserInfo;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RCRTC:kick", flag=16)
public class KickMessage
extends MessageContent {
    private static final String TAG = "KickMessage";
    private List<KickMessageUserInfo> userInfoArrayList = new ArrayList<KickMessageUserInfo>();
    public static final Parcelable.Creator<KickMessage> CREATOR = new Parcelable.Creator<KickMessage>(){

        public KickMessage createFromParcel(Parcel source) {
            return new KickMessage(source);
        }

        public KickMessage[] newArray(int size) {
            return new KickMessage[size];
        }
    };

    private KickMessage(Parcel source) {
        source.readList(this.userInfoArrayList, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public KickMessage(byte[] data) {
        super(data);
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)e);
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            String array = "";
            if (jsonObject.has("users")) {
                array = jsonObject.getString("users");
            }
            JSONArray jsonArray = new JSONArray(array);
            JSONObject obj = null;
            KickMessageUserInfo userInfo = null;
            for (int i = 0; i < jsonArray.length(); ++i) {
                obj = jsonArray.getJSONObject(i);
                userInfo = new KickMessageUserInfo();
                if (obj.has("userId")) {
                    userInfo.setUserId(obj.getString("userId"));
                }
                if (obj.has("type")) {
                    userInfo.setType(obj.getInt("type"));
                }
                this.userInfoArrayList.add(userInfo);
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
            ReportUtil.libError(ReportUtil.TAG.KICKEDFROMSERVER, "desc", e.getMessage());
        }
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            JSONArray jsonArray = new JSONArray();
            for (KickMessageUserInfo info : this.userInfoArrayList) {
                jsonArray.put((Object)info.getJsonObject());
            }
            jsonObj.putOpt("users", (Object)jsonArray);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.userInfoArrayList);
    }

    public List<KickMessageUserInfo> getUserInfoArrayList() {
        return this.userInfoArrayList;
    }
}

