/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import android.opengl.GLES20;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.ugc.videoprocessor.videoeffect.TXCGPUEffectFilterBase;
import java.nio.FloatBuffer;

public class TXCGPUSplitScreenFilter
extends TXCGPUEffectFilterBase {
    private static final int DURATION_SPLIT_SCREEN = 1000;
    private SplitSceenParam mSplitScreenParam;
    private int mSpliteNumber = 0;
    private final int[] mSupportSplitNumber = new int[]{1, 4, 9};
    private a[] mSubWindowPosition = null;

    @Override
    public void setNextFrameTimestamp(long pts) {
        long l2;
        super.setNextFrameTimestamp(pts);
        if (this.mSplitScreenParam == null) {
            this.mSplitScreenParam = new SplitSceenParam();
        }
        if ((l2 = Math.abs(pts - this.mEffectStartTime)) <= 1000L) {
            this.mSplitScreenParam.splitScreenNumber = 4;
        } else if (l2 <= 2000L) {
            this.mSplitScreenParam.splitScreenNumber = 9;
        } else {
            this.mEffectStartTime = -1L;
        }
        TXCGPUSplitScreenFilter tXCGPUSplitScreenFilter = this;
        tXCGPUSplitScreenFilter.updateParams(tXCGPUSplitScreenFilter.mSplitScreenParam);
    }

    private void updateParams(SplitSceenParam splitParam) {
        int n2;
        if (splitParam.splitScreenNumber == this.mSpliteNumber || splitParam.splitScreenNumber != this.mSupportSplitNumber[0] && splitParam.splitScreenNumber != this.mSupportSplitNumber[1] && splitParam.splitScreenNumber != this.mSupportSplitNumber[2]) {
            return;
        }
        this.mSpliteNumber = splitParam.splitScreenNumber;
        this.mSubWindowPosition = new a[this.mSpliteNumber];
        for (n2 = 0; n2 < this.mSpliteNumber; ++n2) {
            this.mSubWindowPosition[n2] = new a(0);
        }
        n2 = this.getOutputSize().width;
        int n3 = this.getOutputSize().height;
        if (splitParam.splitScreenNumber == this.mSupportSplitNumber[0]) {
            this.mSubWindowPosition[0].a = 0;
            this.mSubWindowPosition[0].b = 0;
            this.mSubWindowPosition[0].c = n2;
            this.mSubWindowPosition[0].d = n3;
            return;
        }
        if (splitParam.splitScreenNumber == this.mSupportSplitNumber[1]) {
            for (int i2 = 0; i2 < this.mSupportSplitNumber[1]; ++i2) {
                this.mSubWindowPosition[i2].a = i2 % 2 * n2 / 2;
                this.mSubWindowPosition[i2].b = i2 / 2 * n3 / 2;
                this.mSubWindowPosition[i2].c = n2 / 2;
                this.mSubWindowPosition[i2].d = n3 / 2;
            }
            return;
        }
        if (splitParam.splitScreenNumber == this.mSupportSplitNumber[2]) {
            for (int i3 = 0; i3 < this.mSupportSplitNumber[2]; ++i3) {
                this.mSubWindowPosition[i3].a = i3 % 3 * n2 / 3;
                this.mSubWindowPosition[i3].b = i3 / 3 * n3 / 3;
                this.mSubWindowPosition[i3].c = n2 / 3;
                this.mSubWindowPosition[i3].d = n3 / 3;
            }
        }
    }

    @Override
    public void onDraw(int textureId, d outTexture, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        if (this.mSubWindowPosition == null) {
            super.onDraw(textureId, outTexture, cubeBuffer, textureBuffer);
        }
        a[] aArray = this.mSubWindowPosition;
        int n2 = this.mSubWindowPosition.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            a a2 = aArray[i2];
            if (a2 != null) {
                GLES20.glViewport((int)a2.a, (int)a2.b, (int)a2.c, (int)a2.d);
            }
            super.onDraw(textureId, outTexture, cubeBuffer, textureBuffer);
        }
        GLES20.glViewport((int)0, (int)0, (int)this.getOutputSize().width, (int)this.getOutputSize().height);
    }

    static final class a {
        int a = 0;
        public int b = 0;
        public int c = 0;
        public int d = 0;

        private a() {
        }

        /* synthetic */ a(byte by2) {
            this();
        }
    }

    public static class SplitSceenParam
    extends TXCGPUEffectFilterBase.VideoEffectParams {
        public int splitScreenNumber;
    }
}

