/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message;

import android.os.Parcel;
import android.os.Parcelable;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.utils.FinLog;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RCRTC:PublishResource", flag=16)
public class PublishResourceMessage
extends MessageContent {
    private static final String TAG = "PublishResourceMessage";
    private List<MediaResourceInfo> uris = new ArrayList<MediaResourceInfo>();
    private String extra;
    private boolean ignore;
    public static final Parcelable.Creator<PublishResourceMessage> CREATOR = new Parcelable.Creator<PublishResourceMessage>(){

        public PublishResourceMessage createFromParcel(Parcel source) {
            return new PublishResourceMessage(source);
        }

        public PublishResourceMessage[] newArray(int size) {
            return new PublishResourceMessage[size];
        }
    };

    public PublishResourceMessage(List<MediaResourceInfo> mediaResourceInfoList) {
        this.uris = mediaResourceInfoList;
    }

    public PublishResourceMessage(List<MediaResourceInfo> mediaResourceInfoList, boolean ignore) {
        this.uris = mediaResourceInfoList;
        this.ignore = ignore;
    }

    private PublishResourceMessage(Parcel source) {
        this.extra = source.readString();
        this.ignore = source.readByte() != 0;
        source.readList(this.uris, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public PublishResourceMessage(byte[] data) {
        super(data);
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)e);
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("uris")) {
                if (jsonObj.has("extra")) {
                    this.extra = jsonObj.getString("extra");
                }
                if (jsonObj.has("ignore")) {
                    this.ignore = jsonObj.getBoolean("ignore");
                }
                JSONArray array = null;
                if (jsonObj.has("uris")) {
                    array = jsonObj.getJSONArray("uris");
                }
                this.uris = new ArrayList<MediaResourceInfo>();
                if (array != null) {
                    FinLog.d(TAG, "PublishResourceMessage size() =  " + array.length());
                    for (int i = 0; i < array.length(); ++i) {
                        this.uris.add(new MediaResourceInfo((JSONObject)array.get(i), ""));
                    }
                }
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            JSONArray jsonArray = new JSONArray();
            for (MediaResourceInfo info : this.uris) {
                jsonArray.put((Object)info.getJsonObject());
            }
            jsonObj.putOpt("extra", (Object)this.extra);
            jsonObj.putOpt("ignore", (Object)this.ignore);
            jsonObj.putOpt("uris", (Object)jsonArray);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.extra);
        dest.writeByte(this.ignore ? (byte)1 : 0);
        dest.writeList(this.uris);
    }

    public List<MediaResourceInfo> getPublishResource() {
        return this.uris;
    }

    public String getExtra() {
        return this.extra;
    }

    public boolean isIgnore() {
        return this.ignore;
    }
}

