/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.tencent.liteav.base.VisibleForTesting;
import com.tencent.liteav.base.annotations.CalledByNative;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class ThreadUtils {
    private static final Object sLock = new Object();
    private static boolean sWillOverride;
    private static Handler sUiThreadHandler;
    private static boolean sThreadAssertsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWillOverrideUiThread(boolean willOverrideUiThread) {
        Object object = sLock;
        synchronized (object) {
            sWillOverride = willOverrideUiThread;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUiThread(Looper looper) {
        Object object = sLock;
        synchronized (object) {
            if (looper == null) {
                sUiThreadHandler = null;
                return;
            }
            if (sUiThreadHandler != null && sUiThreadHandler.getLooper() != looper) {
                throw new RuntimeException("UI thread looper is already set to " + sUiThreadHandler.getLooper() + " (Main thread looper is " + Looper.getMainLooper() + "), cannot set to new looper " + looper);
            }
            sUiThreadHandler = new Handler(looper);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handler getUiThreadHandler() {
        Object object = sLock;
        synchronized (object) {
            if (sUiThreadHandler == null) {
                if (sWillOverride) {
                    throw new RuntimeException("Did not yet override the UI thread");
                }
                sUiThreadHandler = new Handler(Looper.getMainLooper());
            }
            return sUiThreadHandler;
        }
    }

    @Deprecated
    public static void runOnUiThreadBlocking(Runnable r2) {
        if (ThreadUtils.runningOnUiThread()) {
            r2.run();
            return;
        }
        FutureTask<Object> futureTask = new FutureTask<Object>(r2, null);
        ThreadUtils.postOnUiThread(futureTask);
        try {
            futureTask.get();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception occurred while waiting for runnable", exception);
        }
    }

    @Deprecated
    @VisibleForTesting
    public static <T> T runOnUiThreadBlockingNoException(Callable<T> c2) {
        try {
            return ThreadUtils.runOnUiThreadBlocking(c2);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException("Error occurred waiting for callable", executionException);
        }
    }

    @Deprecated
    public static <T> T runOnUiThreadBlocking(Callable<T> c2) throws ExecutionException {
        FutureTask<T> futureTask = new FutureTask<T>(c2);
        ThreadUtils.runOnUiThread(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for callable", interruptedException);
        }
    }

    @Deprecated
    public static <T> FutureTask<T> runOnUiThread(FutureTask<T> task) {
        if (ThreadUtils.runningOnUiThread()) {
            task.run();
        } else {
            ThreadUtils.postOnUiThread(task);
        }
        return task;
    }

    @Deprecated
    public static <T> FutureTask<T> runOnUiThread(Callable<T> c2) {
        return ThreadUtils.runOnUiThread(new FutureTask<T>(c2));
    }

    @Deprecated
    public static void runOnUiThread(Runnable r2) {
        if (ThreadUtils.runningOnUiThread()) {
            r2.run();
            return;
        }
        ThreadUtils.getUiThreadHandler().post(r2);
    }

    @Deprecated
    public static <T> FutureTask<T> postOnUiThread(FutureTask<T> task) {
        ThreadUtils.getUiThreadHandler().post(task);
        return task;
    }

    @Deprecated
    public static void postOnUiThread(Runnable task) {
        ThreadUtils.getUiThreadHandler().post(task);
    }

    @Deprecated
    @VisibleForTesting
    public static void postOnUiThreadDelayed(Runnable task, long delayMillis) {
        ThreadUtils.getUiThreadHandler().postDelayed(task, delayMillis);
    }

    public static void assertOnUiThread() {
        if (sThreadAssertsDisabled) {
            return;
        }
        assert (ThreadUtils.runningOnUiThread()) : "Must be called on the UI thread.";
    }

    public static void checkUiThread() {
        if (!sThreadAssertsDisabled && !ThreadUtils.runningOnUiThread()) {
            throw new IllegalStateException("Must be called on the UI thread.");
        }
    }

    public static void assertOnBackgroundThread() {
        if (sThreadAssertsDisabled) {
            return;
        }
        assert (!ThreadUtils.runningOnUiThread()) : "Must be called on a thread other than UI.";
    }

    public static void setThreadAssertsDisabledForTesting(boolean disabled) {
        sThreadAssertsDisabled = disabled;
    }

    public static boolean runningOnUiThread() {
        return ThreadUtils.getUiThreadHandler().getLooper() == Looper.myLooper();
    }

    public static Looper getUiThreadLooper() {
        return ThreadUtils.getUiThreadHandler().getLooper();
    }

    @CalledByNative
    public static void setThreadPriorityAudio(int tid) {
        Process.setThreadPriority((int)tid, (int)-19);
    }

    @CalledByNative
    private static boolean isThreadPriorityAudio(int tid) {
        return Process.getThreadPriority((int)tid) == -19;
    }
}

