/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.util;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;

@JNINamespace(value="liteav")
public class Size {
    public int width;
    public int height;

    public Size() {
        this(0, 0);
    }

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Size(Size size) {
        this.set(size);
    }

    public void swap() {
        int n2 = this.width;
        this.width = this.height;
        this.height = n2;
    }

    @CalledByNative
    public int getWidth() {
        return this.width;
    }

    @CalledByNative
    public int getHeight() {
        return this.height;
    }

    public int getArea() {
        if (!this.isValid()) {
            return 0;
        }
        return this.width * this.height;
    }

    public void set(Size size) {
        if (size != null) {
            this.width = size.width;
            this.height = size.height;
            return;
        }
        this.width = 0;
        this.height = 0;
    }

    public void set(int inWidth, int inHeight) {
        this.width = inWidth;
        this.height = inHeight;
    }

    public double aspectRatio() {
        return (double)this.width * 1.0 / (double)this.height;
    }

    public boolean isValid() {
        return this.width > 0 && this.height > 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Size)) {
            return false;
        }
        Size size = (Size)obj;
        return size.width == this.width && size.height == this.height;
    }

    public int hashCode() {
        return this.width * 32713 + this.height;
    }

    public String toString() {
        return "Size(" + this.width + ", " + this.height + ")";
    }
}

