/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.media.player.custom;

import android.media.AudioTrack;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AudioTrackProxy
extends AudioTrack {
    private static Map<String, IPcmListener> mPcmListeners = new ConcurrentHashMap<String, IPcmListener>();
    private static boolean playerAble = true;
    private static Object lockOb = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(String tag, IPcmListener listener) {
        Object object = lockOb;
        synchronized (object) {
            Log.d((String)"AudioTrackProxy", (String)"addListener lock");
            if (null == mPcmListeners.get(tag)) {
                mPcmListeners.put(tag, listener);
            } else {
                mPcmListeners.remove(tag);
                mPcmListeners.put(tag, listener);
            }
            Log.d((String)"AudioTrackProxy", (String)"addListener unlock");
        }
    }

    public static void setPlayerAble(boolean playerAble) {
        AudioTrackProxy.playerAble = playerAble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(String tag) {
        Object object = lockOb;
        synchronized (object) {
            Log.d((String)"AudioTrackProxy", (String)"removeListener lock");
            if (null != mPcmListeners.get(tag)) {
                mPcmListeners.remove(tag);
            }
            Log.d((String)"AudioTrackProxy", (String)"removeListener unlock");
        }
    }

    public AudioTrackProxy(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode) throws IllegalArgumentException {
        super(streamType, sampleRateInHz, channelConfig, audioFormat, bufferSizeInBytes, mode);
    }

    public int write(@NonNull byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return super.write(audioData, offsetInBytes, sizeInBytes);
    }

    public int write_with_pcm(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        for (String key : mPcmListeners.keySet()) {
            IPcmListener listener = mPcmListeners.get(key);
            if (null == listener) continue;
            listener.onWrite(audioData, offsetInBytes, sizeInBytes, this.getSampleRate(), this.getChannelCount(), this.getAudioFormat());
        }
        if (playerAble) {
            return super.write(audioData, offsetInBytes, sizeInBytes);
        }
        return 0;
    }

    public static interface IPcmListener {
        public void onWrite(byte[] var1, int var2, int var3, int var4, int var5, int var6);
    }
}

