/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::ugc")
public class AudioFrame {
    private ByteBuffer mData;
    private long mTimestampMs;
    private int mSampleRate;
    private int mChannels;
    private AudioCodecFormat mCodecFormat;

    @CalledByNative
    public int getSampleRate() {
        return this.mSampleRate;
    }

    @CalledByNative
    public int getChannelCount() {
        return this.mChannels;
    }

    @CalledByNative
    public ByteBuffer getData() {
        return this.mData;
    }

    @CalledByNative
    public long getTimestamp() {
        return this.mTimestampMs;
    }

    public AudioCodecFormat getCodecFormat() {
        return this.mCodecFormat;
    }

    public void setSampleRate(int sampleRate) {
        this.mSampleRate = sampleRate;
    }

    public void setChannelCount(int channels) {
        this.mChannels = channels;
    }

    public void setData(ByteBuffer data) {
        this.mData = data;
    }

    public void setTimestamp(long pts) {
        this.mTimestampMs = pts;
    }

    public void setCodecFormat(AudioCodecFormat codecFormat) {
        this.mCodecFormat = codecFormat;
    }

    public boolean isValidFrame() {
        return this.mData != null && this.mData.remaining() > 0 && this.mCodecFormat != null && this.mSampleRate > 0 && this.mChannels > 0;
    }

    public static enum AudioCodecFormat {
        UNKNOWN(0),
        PCM(99),
        AAC(10);

        private final int mValue;

        private AudioCodecFormat(int value) {
            this.mValue = value;
        }

        public final int getValue() {
            return this.mValue;
        }
    }
}

