/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.graphics.Bitmap;
import android.os.HandlerThread;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.f;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videoproducer.capture.ax;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.UGCPixelFrameProvider;
import com.tencent.ugc.UGCTransitionRules;
import com.tencent.ugc.cp;
import com.tencent.ugc.cq;
import com.tencent.ugc.cr;
import com.tencent.ugc.cs;
import com.tencent.ugc.ct;
import com.tencent.ugc.cu;
import com.tencent.ugc.cv;
import com.tencent.ugc.cw;
import com.tencent.ugc.cx;
import com.tencent.ugc.cy;
import com.tencent.ugc.cz;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class UGCImageProvider
implements UGCFrameQueue.UGCFrameQueueListener,
UGCPixelFrameProvider {
    private static final String TAG = "UGCImageProvider";
    private static final int MAX_FRAME_SIZE = 5;
    private final List<Bitmap> mBitmapList;
    private final Map<Bitmap, d> mGLTextureMap;
    private final b mThrottlers = new b();
    private CustomHandler mWorkHandler;
    private final UGCFrameQueue<List<PixelFrame>> mFrameQueue;
    private final int mFps;
    private final int mFrameIntervalMs;
    private int mTotalFrameCount;
    private int mCurrentFrameCount = 0;
    private long mStayDurationMs = 1000L;
    private long mMotionDurationMs = 500L;
    private long mDurationMs;
    private int mTransitionType = 1;
    private EGLCore mEGLCore;
    private e mGLTexturePool;
    private FutureTask<Long> mDurationFuture;

    public UGCImageProvider(List<Bitmap> bitmapList, int fps) {
        LiteavLog.i(TAG, TAG);
        this.mFps = fps > 0 ? fps : 20;
        this.mFrameIntervalMs = 1000 / this.mFps;
        this.mFrameQueue = new UGCFrameQueue();
        this.mGLTextureMap = new HashMap<Bitmap, d>();
        this.mBitmapList = bitmapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        LiteavLog.i(TAG, "initialize");
        UGCImageProvider uGCImageProvider = this;
        synchronized (uGCImageProvider) {
            if (this.mWorkHandler != null) {
                LiteavLog.w(TAG, "UGCPixelFrameProvider is initialized");
                return;
            }
            HandlerThread handlerThread = new HandlerThread("ugc-image-frame-provider");
            handlerThread.start();
            this.mWorkHandler = new CustomHandler(handlerThread.getLooper());
        }
        UGCImageProvider uGCImageProvider2 = this;
        uGCImageProvider2.runOnWorkThread(cp.a(uGCImageProvider2));
    }

    @Override
    public void uninitialize() {
        LiteavLog.i(TAG, "unInitialize");
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(cs.a(uGCImageProvider));
    }

    @Override
    public void start() {
        Log.i(TAG, "Start", new Object[0]);
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(ct.a(uGCImageProvider));
    }

    @Override
    public void stop() {
        LiteavLog.i(TAG, "stop");
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(cu.a(uGCImageProvider));
    }

    @Override
    public void seekTo(long timeMs, boolean isPreciseSeek) {
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(cv.a(uGCImageProvider, timeMs));
    }

    @Override
    public void setPlayEndPts(long playEndPts) {
    }

    @Override
    public void setMaxBufferFrameCount(int count) {
    }

    @Override
    public UGCFrameQueue<List<PixelFrame>> getFrameQueue() {
        return this.mFrameQueue;
    }

    @Override
    public void setReverse(boolean isReverse) {
    }

    public void setPictureTransition(int type) {
        LiteavLog.i(TAG, "setPictureTransition type = ".concat(String.valueOf(type)));
        this.mDurationFuture = new FutureTask(cw.a(this, type));
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(uGCImageProvider.mDurationFuture);
    }

    public long getDuration() {
        if (this.mDurationFuture == null) {
            return 0L;
        }
        Long l2 = 0L;
        try {
            l2 = this.mDurationFuture.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            LiteavLog.w(TAG, "getDuration future task exception: ".concat(String.valueOf(exception)));
        }
        return l2;
    }

    @Override
    public void onFrameDequeued() {
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(cx.a(uGCImageProvider));
    }

    private void uninitGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        try {
            if (this.mGLTexturePool != null) {
                this.mGLTexturePool.a();
                this.mGLTexturePool.b();
                this.mGLTexturePool = null;
            }
            this.mEGLCore.makeCurrent();
        }
        catch (f f2) {
            LiteavLog.e(this.mThrottlers.a("uninitGL"), TAG, "EGLCore destroy failed.", f2);
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    private void initializeGLComponents() {
        this.mEGLCore = new EGLCore();
        try {
            this.mEGLCore.initialize(ax.a().b(), null, 128, 128);
            this.mEGLCore.makeCurrent();
            this.mGLTexturePool = new e();
            return;
        }
        catch (f f2) {
            LiteavLog.e(this.mThrottlers.a("initGL"), TAG, "create EGLCore failed.", f2);
            this.mEGLCore = null;
            return;
        }
    }

    private void decodeBitmapFrame() {
        if (this.mEGLCore == null || this.mFrameQueue.size() > 5) {
            return;
        }
        if (this.mCurrentFrameCount >= this.mTotalFrameCount) {
            this.mFrameQueue.queue(END_OF_STREAM);
            return;
        }
        ArrayList<PixelFrame> arrayList = new ArrayList<PixelFrame>();
        long l2 = (long)this.mCurrentFrameCount * (long)this.mFrameIntervalMs;
        ++this.mCurrentFrameCount;
        int n2 = (int)(l2 / (this.mStayDurationMs + this.mMotionDurationMs));
        n2 = this.clamp(n2, 0, this.mBitmapList.size() - 1);
        Bitmap bitmap = this.mBitmapList.get(n2);
        arrayList.add(this.loadBitmapToPixelFrame(bitmap, l2));
        n2 = this.clamp(n2 + 1, 0, this.mBitmapList.size() - 1);
        Bitmap bitmap2 = this.mBitmapList.get(n2);
        arrayList.add(this.loadBitmapToPixelFrame(bitmap2, l2));
        this.mFrameQueue.queue(arrayList);
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            customHandler.removeCallbacks(cy.a(this));
            customHandler.post(cz.a(this));
        }
    }

    private int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private PixelFrame loadBitmapToPixelFrame(Bitmap bitmap, long pts) {
        d d2;
        try {
            if (this.mEGLCore != null) {
                this.mEGLCore.makeCurrent();
            }
        }
        catch (Exception exception) {
            LiteavLog.e(this.mThrottlers.a("make_current_fail"), TAG, "loadBitmapToPixelFrame makeCurrent fail".concat(String.valueOf(exception)), new Object[0]);
        }
        if (!this.mGLTextureMap.containsKey(bitmap)) {
            d2 = this.mGLTexturePool.a(bitmap.getWidth(), bitmap.getHeight());
            OpenGlUtils.loadTexture(bitmap, d2.a(), false);
            this.mGLTextureMap.put(bitmap, d2);
        } else {
            d2 = this.mGLTextureMap.get(bitmap);
        }
        PixelFrame pixelFrame = d2.a(ax.a().b());
        pixelFrame.setTimestamp(pts);
        return pixelFrame;
    }

    private void setPictureTransitionInternal(int type) {
        this.mTransitionType = type;
        this.mStayDurationMs = UGCTransitionRules.getStayDurationMs(type);
        this.mMotionDurationMs = UGCTransitionRules.getMotionDurationMs(type);
        if (this.mBitmapList == null) {
            return;
        }
        this.mDurationMs = type == 5 || type == 4 ? (long)this.mBitmapList.size() * (this.mStayDurationMs + this.mMotionDurationMs) : (long)this.mBitmapList.size() * (this.mStayDurationMs + this.mMotionDurationMs) - this.mMotionDurationMs;
        this.mTotalFrameCount = (int)(this.mDurationMs / 1000L * (long)this.mFps);
    }

    private void clearPixelFrameQueue() {
        for (List<PixelFrame> list : this.mFrameQueue.dequeueAll()) {
            if (list == null) continue;
            Iterator<PixelFrame> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
    }

    private void clearGLTextureCache() {
        for (d d2 : this.mGLTextureMap.values()) {
            if (d2 == null) continue;
            d2.release();
        }
        this.mGLTextureMap.clear();
    }

    private boolean runOnWorkThread(Runnable runnable) {
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            return customHandler.runOrPost(runnable, 0);
        }
        return false;
    }

    static /* synthetic */ Long lambda$setPictureTransition$5(UGCImageProvider this_, int type) throws Exception {
        this_.setPictureTransitionInternal(type);
        return this_.mDurationMs;
    }

    static /* synthetic */ void lambda$seekTo$4(UGCImageProvider this_, long timeMs) {
        this_.mCurrentFrameCount = (int)(timeMs - 1L) / this_.mFrameIntervalMs + 1;
        this_.clearPixelFrameQueue();
        UGCImageProvider uGCImageProvider = this_;
        uGCImageProvider.runOnWorkThread(cq.a(uGCImageProvider));
    }

    static /* synthetic */ void lambda$stop$3(UGCImageProvider this_) {
        if (this_.mWorkHandler != null) {
            this_.mWorkHandler.removeCallbacks(cr.a(this_));
        }
    }

    static /* synthetic */ void lambda$start$2(UGCImageProvider this_) {
        UGCImageProvider uGCImageProvider = this_;
        uGCImageProvider.setPictureTransitionInternal(uGCImageProvider.mTransitionType);
        this_.decodeBitmapFrame();
    }

    static /* synthetic */ void lambda$uninitialize$1(UGCImageProvider this_) {
        this_.clearPixelFrameQueue();
        this_.clearGLTextureCache();
        this_.uninitGLComponents();
        this_.mFrameQueue.setUGCFrameQueueListener(null);
        if (this_.mWorkHandler != null) {
            this_.mWorkHandler.quitLooper();
            this_.mWorkHandler = null;
        }
    }

    static /* synthetic */ void lambda$initialize$0(UGCImageProvider this_) {
        this_.mFrameQueue.setUGCFrameQueueListener(this_);
        this_.initializeGLComponents();
    }

    static /* synthetic */ void access$lambda$0(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }

    static /* synthetic */ void access$lambda$1(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }

    static /* synthetic */ void access$lambda$2(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }

    static /* synthetic */ void access$lambda$3(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }

    static /* synthetic */ void access$lambda$4(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }
}

