/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.content.Context;
import android.text.TextUtils;
import androidx.collection.ArrayMap;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.fastjson.JSON;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.common.IWXObject;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.BasicListComponent;
import com.taobao.weex.ui.component.list.GapItemDecoration;
import com.taobao.weex.ui.component.list.WXPagerSnapHelper;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Component(lazyload=false)
public class WXListComponent
extends BasicListComponent<BounceRecyclerView> {
    private String TAG = "WXListComponent";
    private float mPaddingLeft;
    private float mPaddingRight;
    private String mSpanOffsetsStr;
    private Float[] mSpanOffsets;
    private boolean hasSetGapItemDecoration = false;

    @Deprecated
    public WXListComponent(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, isLazy, basicComponentData);
    }

    public WXListComponent(WXSDKInstance instance, WXVContainer parent, boolean lazy, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
    }

    @Override
    protected BounceRecyclerView generateListView(Context context, int orientation) {
        BounceRecyclerView bounceRecyclerView = new BounceRecyclerView(context, this.mLayoutType, this.mColumnCount, this.mColumnGap, orientation);
        if (bounceRecyclerView.getSwipeLayout() != null && WXUtils.getBoolean(this.getAttrs().get("nestedScrollingEnabled"), false).booleanValue()) {
            bounceRecyclerView.getSwipeLayout().setNestedScrollingEnabled(true);
        }
        if (WXUtils.getBoolean(this.getAttrs().get("pagingEnabled"), false).booleanValue()) {
            Object snapHelper = null;
            String pageSize = WXUtils.getString(this.getAttrs().get("pageSize"), null);
            snapHelper = TextUtils.isEmpty((CharSequence)pageSize) ? new PagerSnapHelper() : new WXPagerSnapHelper();
            snapHelper.attachToRecyclerView((RecyclerView)bounceRecyclerView.getInnerView());
        }
        return bounceRecyclerView;
    }

    @Override
    public void addChild(WXComponent child, int index) {
        super.addChild(child, index);
        if (child == null || index < -1) {
            return;
        }
        this.setRefreshOrLoading(child);
        if (this.getHostView() != null && this.hasColumnPros()) {
            this.updateRecyclerAttr();
            ((WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView()).initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    private boolean hasColumnPros() {
        return this.getAttrs().containsKey("columnWidth") && this.mColumnWidth != WXUtils.parseFloat(this.getAttrs().get("columnWidth")) || this.getAttrs().containsKey("columnCount") && this.mColumnCount != WXUtils.parseInt(this.getAttrs().get("columnCount")) || this.getAttrs().containsKey("columnGap") && this.mColumnGap != WXUtils.parseFloat(this.getAttrs().get("columnGap"));
    }

    private boolean setRefreshOrLoading(final WXComponent child) {
        if (this.getHostView() == null) {
            WXLogUtils.e(this.TAG, "setRefreshOrLoading: HostView == null !!!!!! check list attr has append =tree");
            return true;
        }
        if (child instanceof WXRefresh) {
            ((BounceRecyclerView)this.getHostView()).setOnRefreshListener((WXRefresh)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXListComponent.this.getHostView()).setHeaderView(child);
                }
            }), 100L);
            return true;
        }
        if (child instanceof WXLoading) {
            ((BounceRecyclerView)this.getHostView()).setOnLoadingListener((WXLoading)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXListComponent.this.getHostView()).setFooterView(child);
                }
            }), 100L);
            return true;
        }
        return false;
    }

    private void updateRecyclerAttr() {
        this.mColumnCount = WXUtils.parseInt(this.getAttrs().get("columnCount"));
        if (this.mColumnCount <= 0 && this.mLayoutType != 1) {
            ArrayMap ext = new ArrayMap();
            ext.put("componentType", this.getComponentType());
            ext.put("attribute", this.getAttrs().toString());
            ext.put("stackTrace", Arrays.toString(Thread.currentThread().getStackTrace()));
            WXExceptionUtils.commitCriticalExceptionRT(this.getInstanceId(), WXErrorCode.WX_RENDER_ERR_LIST_INVALID_COLUMN_COUNT, "columnCount", String.format(Locale.ENGLISH, "You are trying to set the list/recycler/vlist/waterfall's column to %d, which is illegal. The column count should be a positive integer", this.mColumnCount), (Map<String, String>)ext);
            this.mColumnCount = 1;
        }
        this.mColumnGap = WXUtils.parseFloat(this.getAttrs().get("columnGap"));
        this.mColumnWidth = WXUtils.parseFloat(this.getAttrs().get("columnWidth"));
        this.mPaddingLeft = WXUtils.parseFloat(this.getAttrs().get("paddingLeft"));
        this.mPaddingRight = WXUtils.parseFloat(this.getAttrs().get("paddingRight"));
        this.mSpanOffsetsStr = (String)this.getAttrs().get("spanOffsets");
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mSpanOffsetsStr)) {
                List list = JSON.parseArray((String)this.mSpanOffsetsStr, Float.class);
                int size = list.size();
                if (null == this.mSpanOffsets || this.mSpanOffsets.length != size) {
                    this.mSpanOffsets = new Float[size];
                }
                list.toArray(this.mSpanOffsets);
            } else {
                this.mSpanOffsets = null;
            }
        }
        catch (Throwable e) {
            WXLogUtils.w("Parser SpanOffsets error ", e);
        }
        if (!this.hasSetGapItemDecoration && null != this.getSpanOffsets() && null != this.getHostView() && null != ((BounceRecyclerView)this.getHostView()).getInnerView()) {
            this.hasSetGapItemDecoration = true;
            ((WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView()).addItemDecoration(new GapItemDecoration(this));
        }
    }

    @WXComponentProp(name="spanOffsets")
    public void setSpanOffsets(String spanOffsets) {
        if (!TextUtils.equals((CharSequence)spanOffsets, (CharSequence)this.mSpanOffsetsStr)) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="columnWidth")
    public void setColumnWidth(float columnWidth) {
        if (columnWidth != this.mColumnWidth) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            if (wxRecyclerView.getLayoutManager() != null) {
                wxRecyclerView.getAdapter().notifyDataSetChanged();
            } else {
                wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
            }
        }
    }

    @WXComponentProp(name="columnCount")
    public void setColumnCount(int columnCount) {
        if (columnCount != this.mColumnCount) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="columnGap")
    public void setColumnGap(float columnGap) throws InterruptedException {
        if (columnGap != this.mColumnGap) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @Override
    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean scrollable) {
        WXRecyclerView inner = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
        inner.setScrollable(scrollable);
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        super.updateProperties(props);
        if (this.isRecycler(this)) {
            this.mLayoutType = "waterfall".equals(this.getComponentType()) ? 3 : this.getAttrs().getLayoutType();
        }
        if ((props.containsKey("padding") || props.containsKey("paddingLeft") || props.containsKey("paddingRight")) && (this.mPaddingLeft != WXUtils.parseFloat(props.get("paddingLeft")) || this.mPaddingRight != WXUtils.parseFloat(props.get("paddingRight")))) {
            this.markComponentUsable();
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @Override
    public void createChildViewAt(int index) {
        int indexToCreate = index;
        if (indexToCreate < 0 && (indexToCreate = this.childCount() - 1) < 0) {
            return;
        }
        IWXObject child = this.getListChild(indexToCreate);
        if (child instanceof WXBaseRefresh) {
            final WXComponent childComponent = (WXComponent)child;
            childComponent.createView();
            if (child instanceof WXRefresh) {
                ((BounceRecyclerView)this.getHostView()).setOnRefreshListener((WXRefresh)child);
                ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((BounceRecyclerView)WXListComponent.this.getHostView()).setHeaderView(childComponent);
                    }
                }, 100L);
            } else if (child instanceof WXLoading) {
                ((BounceRecyclerView)this.getHostView()).setOnLoadingListener((WXLoading)child);
                ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((BounceRecyclerView)WXListComponent.this.getHostView()).setFooterView(childComponent);
                    }
                }, 100L);
            }
        } else {
            super.createChildViewAt(indexToCreate);
        }
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        super.remove(child, destroy);
        this.removeFooterOrHeader(child);
    }

    private void removeFooterOrHeader(WXComponent child) {
        if (child instanceof WXLoading) {
            ((BounceRecyclerView)this.getHostView()).removeFooterView(child);
        } else if (child instanceof WXRefresh) {
            ((BounceRecyclerView)this.getHostView()).removeHeaderView(child);
        }
    }

    private boolean isRecycler(WXComponent component) {
        return "waterfall".equals(component.getComponentType()) || "recycle-list".equals(component.getComponentType()) || "recycler".equals(component.getComponentType());
    }

    public Float[] getSpanOffsets() {
        return this.mSpanOffsets;
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXListComponent(instance, parent, true, basicComponentData);
        }
    }
}

