/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloader;
import java.util.ArrayList;
import java.util.List;

public class FileDownloadQueueSet {
    private FileDownloadListener target;
    private boolean isSerial;
    private List<BaseDownloadTask.FinishListener> taskFinishListenerList;
    private Integer autoRetryTimes;
    private Boolean syncCallback;
    private Boolean isForceReDownload;
    private Boolean isWifiRequired;
    private Integer callbackProgressTimes;
    private Integer callbackProgressMinIntervalMillis;
    private Object tag;
    private String directory;
    private BaseDownloadTask[] tasks;

    public FileDownloadQueueSet(FileDownloadListener target) {
        if (target == null) {
            throw new IllegalArgumentException("create FileDownloadQueueSet must with valid target!");
        }
        this.target = target;
    }

    public FileDownloadQueueSet downloadTogether(BaseDownloadTask ... tasks) {
        this.isSerial = false;
        this.tasks = tasks;
        return this;
    }

    public FileDownloadQueueSet downloadTogether(List<BaseDownloadTask> tasks) {
        this.isSerial = false;
        this.tasks = new BaseDownloadTask[tasks.size()];
        tasks.toArray(this.tasks);
        return this;
    }

    public FileDownloadQueueSet downloadSequentially(BaseDownloadTask ... tasks) {
        this.isSerial = true;
        this.tasks = tasks;
        return this;
    }

    public FileDownloadQueueSet downloadSequentially(List<BaseDownloadTask> tasks) {
        this.isSerial = true;
        this.tasks = new BaseDownloadTask[tasks.size()];
        tasks.toArray(this.tasks);
        return this;
    }

    public void reuseAndStart() {
        for (BaseDownloadTask task : this.tasks) {
            task.reuse();
        }
        this.start();
    }

    public void start() {
        for (BaseDownloadTask task : this.tasks) {
            task.setListener(this.target);
            if (this.autoRetryTimes != null) {
                task.setAutoRetryTimes(this.autoRetryTimes);
            }
            if (this.syncCallback != null) {
                task.setSyncCallback(this.syncCallback);
            }
            if (this.isForceReDownload != null) {
                task.setForceReDownload(this.isForceReDownload);
            }
            if (this.callbackProgressTimes != null) {
                task.setCallbackProgressTimes(this.callbackProgressTimes);
            }
            if (this.callbackProgressMinIntervalMillis != null) {
                task.setCallbackProgressMinInterval(this.callbackProgressMinIntervalMillis);
            }
            if (this.tag != null) {
                task.setTag(this.tag);
            }
            if (this.taskFinishListenerList != null) {
                for (BaseDownloadTask.FinishListener finishListener : this.taskFinishListenerList) {
                    task.addFinishListener(finishListener);
                }
            }
            if (this.directory != null) {
                task.setPath(this.directory, true);
            }
            if (this.isWifiRequired != null) {
                task.setWifiRequired(this.isWifiRequired);
            }
            task.asInQueueTask().enqueue();
        }
        FileDownloader.getImpl().start(this.target, this.isSerial);
    }

    public FileDownloadQueueSet setDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    public FileDownloadQueueSet setAutoRetryTimes(int autoRetryTimes) {
        this.autoRetryTimes = autoRetryTimes;
        return this;
    }

    public FileDownloadQueueSet setSyncCallback(boolean syncCallback) {
        this.syncCallback = syncCallback;
        return this;
    }

    public FileDownloadQueueSet setForceReDownload(boolean isForceReDownload) {
        this.isForceReDownload = isForceReDownload;
        return this;
    }

    public FileDownloadQueueSet setCallbackProgressTimes(int callbackProgressTimes) {
        this.callbackProgressTimes = callbackProgressTimes;
        return this;
    }

    public FileDownloadQueueSet setCallbackProgressMinInterval(int minIntervalMillis) {
        this.callbackProgressMinIntervalMillis = minIntervalMillis;
        return this;
    }

    public FileDownloadQueueSet ignoreEachTaskInternalProgress() {
        this.setCallbackProgressTimes(-1);
        return this;
    }

    public FileDownloadQueueSet disableCallbackProgressTimes() {
        return this.setCallbackProgressTimes(0);
    }

    public FileDownloadQueueSet setTag(Object tag) {
        this.tag = tag;
        return this;
    }

    public FileDownloadQueueSet addTaskFinishListener(BaseDownloadTask.FinishListener finishListener) {
        if (this.taskFinishListenerList == null) {
            this.taskFinishListenerList = new ArrayList<BaseDownloadTask.FinishListener>();
        }
        this.taskFinishListenerList.add(finishListener);
        return this;
    }

    public FileDownloadQueueSet setWifiRequired(boolean isWifiRequired) {
        this.isWifiRequired = isWifiRequired;
        return this;
    }
}

