/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.os.Message;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.RCRTCRoomConfig;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.RCRTCLiveCallback;
import cn.rongcloud.rtc.api.probe.RTCProbeConfig;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCLiveRole;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCLocalUserImpl;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCCameraOutputStreamImpl;
import cn.rongcloud.rtc.core.MediaConstraints;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.tools.HandleChatRoomKVTools;
import cn.rongcloud.rtc.engine.tools.MultiRoomManager;
import cn.rongcloud.rtc.module.HardwareTestManager;
import cn.rongcloud.rtc.module.ping.RTCPingManager;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.RTCConnectionEventsImpl;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.IRongCoreRTCCallback;
import io.rong.imlib.model.RTCUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.json.JSONArray;
import org.json.JSONException;

public class IdleState
extends AbstractBaseState {
    private static final String TAG = "IdleState";
    private static final long JOIN_CHAT_ROOM_TIMEOUT = 30000L;
    private boolean joinIng;
    private boolean connection_Initialized;
    private Queue<Message> deferSubLiveMessages = new LinkedList<Message>();
    private String roomId;
    private RCRTCRoomConfig roomConfig;
    private String liveUrl;

    public IdleState(RTCEngineImpl engine) {
        super(engine);
    }

    @Override
    public void enter() {
        super.enter();
        this.liveUrl = null;
        this.joinIng = false;
        this.connection_Initialized = false;
        this.clearChatRoomData();
    }

    @Override
    protected boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 2000: {
                this.joinRoom((String)obj.getData(0), (RCRTCRoomConfig)obj.getData(1), (IRCRTCResultDataCallback)obj.getData(2));
                break;
            }
            case 2001: {
                this.onJoinRoomSuccess((String)obj.getData(0), (RCRTCRoomConfig)obj.getData(1), (List)obj.getData(2), (Map)obj.getData(3), (IRCRTCResultDataCallback)obj.getData(4));
                break;
            }
            case 2002: {
                this.joinIng = false;
                break;
            }
            case 2080: {
                Object[] viewerJoinRoomSuccessObjects = (Object[])obj.getData(0);
                IRCRTCResultDataCallback viewerJoinRoomCallback = (IRCRTCResultDataCallback)obj.getData(1);
                this.onGetChatRoomKVSuccess(viewerJoinRoomSuccessObjects, viewerJoinRoomCallback);
                break;
            }
            case 2081: {
                this.joinIng = false;
                this.clearChatRoomData();
                break;
            }
            case 5000: {
                if (this.joinIng) {
                    Message message = this.mEngine.obtainMessage();
                    message.copyFrom(msg);
                    this.deferSubLiveMessages.add(message);
                    break;
                }
                this.subscribeLive((String)obj.getData(0), (RCRTCAVStreamType)((Object)obj.getData(1)), (RCRTCLiveCallback)obj.getData(2));
                break;
            }
            case 5002: {
                this.onSubscribeLiveFailed();
                break;
            }
            case 5001: {
                this.onSubscribeLiveSuccess((RCRTCAVStreamType)((Object)obj.getData(0)), (RCRTCLiveCallback)obj.getData(1));
                break;
            }
            case 2010: 
            case 2060: 
            case 2086: 
            case 7000: {
                this.mEngine.deferMessage(msg);
                break;
            }
            case 1011: 
            case 10000: {
                this.unInit(msg);
                break;
            }
            case 2061: {
                RCRTCParamsType.AudioQuality audioQuality = (RCRTCParamsType.AudioQuality)((Object)obj.getData());
                if (audioQuality == null) break;
                this.mEngine.mConfig.audioBitrate.setLocalValue(audioQuality.getBitrate());
                break;
            }
            case 2062: {
                MediaConstraints audioConstraints = (MediaConstraints)obj.getData();
                if (audioConstraints == null) break;
                this.mEngine.mRTCCore.updateAudioConstraints(audioConstraints);
                break;
            }
            case 2088: {
                this.mEngine.mRTCCore.setEarphoneOn((Boolean)obj.getData(), null);
                break;
            }
            case 2101: {
                HardwareTestManager manager = (HardwareTestManager)obj.getData(0);
                if (manager == null) break;
                int seconds = (Integer)obj.getData(1);
                manager.startEchoTest(seconds);
                break;
            }
            case 2102: {
                HardwareTestManager m = (HardwareTestManager)obj.getData();
                if (m == null) break;
                m.stopEchoTest();
                break;
            }
            case 2066: {
                this.startRTCProbe((IRCRTCResultCallback)obj.getData());
                break;
            }
            case 2067: {
                this.stopRTCProbe((IRCRTCResultCallback)obj.getData());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void startRTCProbe(IRCRTCResultCallback callback) {
        ReportUtil.libStatus(ReportUtil.TAG.STARTPROBEFORENGINE, "joining", this.joinIng);
        if (this.joinIng) {
            this.onFailedCallback(RTCErrorCode.ILLEGAL_OPERATION_FOR_JOINING, callback);
            return;
        }
        RCCameraOutputStreamImpl defaultVideoStream = (RCCameraOutputStreamImpl)this.mEngine.getDefaultVideoStream();
        RCRTCVideoStreamConfig videoConfig = defaultVideoStream.getVideoConfig();
        RTCProbeConfig config = new RTCProbeConfig(videoConfig.getVideoResolution(), videoConfig.getVideoFps(), defaultVideoStream.getMinBitrate(), defaultVideoStream.getMaxBitrate());
        this.mEngine.mRTCCore.startRTCProbe(config, this.createCallbackWrapper(callback));
    }

    private void stopRTCProbe(IRCRTCResultCallback callback) {
        ReportUtil.libStatus(ReportUtil.TAG.STOPPROBEFORENGINE, "", "");
        this.onStopRTCProbe(false, callback);
    }

    private void onStopRTCProbe(boolean interiorForceStop, IRCRTCResultCallback callback) {
        this.mEngine.mRTCCore.stopRTCProbe(interiorForceStop, this.createCallbackWrapper(callback));
    }

    private IRCRTCResultCallback createCallbackWrapper(final IRCRTCResultCallback callback) {
        if (callback == null) {
            return null;
        }
        return new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                IdleState.this.onSuccessCallback(callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                IdleState.this.onFailedCallback(errorCode, callback);
            }
        };
    }

    private void subscribeLive(String liveUrl, final RCRTCAVStreamType avStreamType, final RCRTCLiveCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, "liveUrl|mediaType|simulcast", liveUrl, avStreamType.getMediaType(), avStreamType.getSimulcast());
        this.joinIng = true;
        this.liveUrl = liveUrl;
        if (TextUtils.isEmpty((CharSequence)liveUrl)) {
            ReportUtil.libError(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "liveUrl is null !");
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        if (!this.connection_Initialized) {
            this.initPeerConnection();
        }
        this.mEngine.mRTCCore.subscribeLiveStream(liveUrl, avStreamType, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, "code|desc", errorCode.getValue(), errorCode.getReason());
                IdleState.this.sendMessage(5002, new Object[0]);
                IdleState.this.onFailedCallback(errorCode, callBack);
            }

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, "code", 0);
                IdleState.this.sendMessage(5001, new Object[]{avStreamType, callBack});
            }
        });
    }

    private void onSubscribeLiveSuccess(RCRTCAVStreamType avStreamType, final RCRTCLiveCallback callback) {
        this.mEngine.mObserverState.setLiveParams(avStreamType, this.liveUrl, callback);
        if (callback == null) {
            return;
        }
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess();
            }
        });
        while (!this.deferSubLiveMessages.isEmpty()) {
            this.mEngine.deferMessage(this.deferSubLiveMessages.poll());
        }
        this.transitionTo(this.mEngine.mObserverState);
    }

    private void onSubscribeLiveFailed() {
        this.liveUrl = null;
        if (this.deferSubLiveMessages.isEmpty()) {
            this.transitionTo(this.mEngine.mDisConnectingState);
        } else {
            Message msg = this.deferSubLiveMessages.poll();
            MsgObjectWraper obj = new MsgObjectWraper(msg.obj);
            this.subscribeLive((String)obj.getData(0), (RCRTCAVStreamType)((Object)obj.getData(1)), (RCRTCLiveCallback)obj.getData(2));
        }
    }

    private void initPeerConnection() {
        this.mEngine.mRTCCore.initPeerConnection(this.mEngine.mUserId, SignalManager.getInstance().getMaxStreamCount(), new RTCConnectionEventsImpl());
        this.connection_Initialized = true;
    }

    private void joinRoom(String roomId, RCRTCRoomConfig roomConfig, IRCRTCResultDataCallback<RCRTCRoom> callBack) {
        boolean isAudience = roomConfig.getRoomType() != RCRTCRoomType.MEETING && roomConfig.getLiveRole() == RCRTCLiveRole.AUDIENCE;
        ReportUtil.libTask(ReportUtil.TAG.JOINROOM, "roomId|uid|roomType|role|joinType", new Object[]{roomId, this.mEngine.getUserId(), roomConfig.getRoomType(), roomConfig.getLiveRole(), roomConfig.getJoinType()});
        if (this.joinIng) {
            ReportUtil.libErrorW(ReportUtil.TAG.JOINROOM, RTCErrorCode.RongRTCCodeJoinRepeatedRoom, "roomId", roomId);
            this.onFailedCallback(RTCErrorCode.RongRTCCodeJoinRepeatedRoom, callBack);
            return;
        }
        this.joinIng = true;
        this.onStopRTCProbe(true, null);
        this.roomConfig = roomConfig;
        ReportUtil.libStatus(ReportUtil.TAG.RTCCONFIG, "config", this.mEngine.mConfig.formatLogString());
        if (isAudience) {
            this.viewerJoinRoom(roomId, roomConfig.getRoomType(), callBack);
        } else {
            this.joinRTCRoom(roomId, roomConfig, callBack);
        }
    }

    private void viewerJoinRoom(String roomId, RCRTCRoomType roomType, final IRCRTCResultDataCallback<RCRTCRoom> callBack) {
        this.roomId = roomId;
        SignalManager.getInstance().viewerJoinRoom(roomId, roomType, new IRCRTCResultDataCallback<Object[]>(){

            @Override
            public void onSuccess(Object[] data) {
                IdleState.this.sendMessage(2080, data, callBack);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                IdleState.this.sendMessage(2081, new Object[]{errorCode, callBack});
                IdleState.this.onFailedCallback(RTCErrorCode.valueOf(errorCode.getValue()), callBack);
            }
        });
    }

    private void clearChatRoomData() {
        this.roomId = null;
        this.roomConfig = null;
    }

    public void onGetChatRoomKVSuccess(Object[] objects, IRCRTCResultDataCallback<RCRTCRoom> callback) {
        if (!this.joinIng) {
            FinLog.e(TAG, "onGetChatRoomKVSuccess: joinIng is false");
            return;
        }
        this.joinIng = false;
        String token = (String)objects[0];
        Map data = (Map)objects[1];
        this.handleIMChatRoomInfo(data, token);
        this.initPeerConnection();
        this.mEngine.storePreSpeakerphoneState();
        RongRtcStatMagr.instance.start(this.roomId, RCRTCLiveRole.AUDIENCE);
        this.transitionTo(this.mEngine.mAudienceState);
        this.onSuccessCallback(this.mEngine.mRoom, callback);
        this.clearChatRoomData();
    }

    private void handleIMChatRoomInfo(Map<String, String> data, String token) {
        RCLocalUserImpl localUser = new RCLocalUserImpl(this.mEngine.mUserId, null);
        LinkedHashMap<String, RCRTCRemoteUser> remoteUsers = new LinkedHashMap<String, RCRTCRemoteUser>();
        RCRTCRemoteUser mcuUser = null;
        if (!TextUtils.isEmpty((CharSequence)data.get("RC_ANCHOR_LIST"))) {
            String userId;
            try {
                JSONArray jsonArray = new JSONArray(data.get("RC_ANCHOR_LIST"));
                for (int i = 0; i < jsonArray.length(); ++i) {
                    userId = jsonArray.getString(i);
                    remoteUsers.put(userId, new RCRemoteUserImpl(userId, ""));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            for (Map.Entry<String, String> entry : data.entrySet()) {
                RCRTCRemoteUser user;
                if (TextUtils.isEmpty((CharSequence)entry.getValue()) || !entry.getKey().startsWith("RC_RES_") || (user = (RCRTCRemoteUser)remoteUsers.get(userId = entry.getKey().substring("RC_RES_".length()))) == null) continue;
                try {
                    HandleChatRoomKVTools.updateRemoteUserRes((RCRemoteUserImpl)user, entry.getValue(), null);
                    if (mcuUser != null) continue;
                    mcuUser = (RCRTCRemoteUser)HandleChatRoomKVTools.updateLiveStreams(null, (String)entry.getValue(), (String)this.roomId, (RCRTCRoomType)this.roomConfig.getRoomType(), null).first;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        String sessionId = "";
        if (data.containsKey("RC_RTC_SESSIONID")) {
            sessionId = data.get("RC_RTC_SESSIONID");
        }
        RCRoomImpl room = new RCRoomImpl(this.roomId, this.roomConfig, localUser, remoteUsers, sessionId, token, null, this.mEngine.mCallbackHandler, null);
        if (data.containsKey("RC_CDN")) {
            String json_cdn = data.remove("RC_CDN");
            HandleChatRoomKVTools.updateCDNStream(room, mcuUser, json_cdn, this.roomId, this.roomConfig.getRoomType(), null);
        }
        FinLog.d(TAG, "setVirtualLiveUser: " + mcuUser);
        room.setVirtualLiveUser(mcuUser);
        this.mEngine.mRoom = room;
        SignalManager.getInstance().setRtcToken(this.mEngine.mRoom.getRtcToken());
    }

    private void joinRTCRoom(final String roomId, final RCRTCRoomConfig roomConfig, final IRCRTCResultDataCallback<RCRTCRoom> callBack) {
        SignalManager.getInstance().joinRoom(roomId, roomConfig.getRoomType(), false, roomConfig.getLocalUserDatas(), roomConfig.getJoinType(), new IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>>(){

            public void onSuccess(List<RTCUser> rtcUsers, Map<String, Object> exarams) {
                ReportUtil.libRes(ReportUtil.TAG.JOINROOM, roomId);
                IdleState.this.sendMessage(2001, roomId, roomConfig, rtcUsers, exarams, callBack);
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                RTCErrorCode code = RTCErrorCode.valueOf(errorCode.getValue());
                ReportUtil.libErrorW(ReportUtil.TAG.JOINROOM, code, "roomId", roomId);
                IdleState.this.sendMessage(2002, new Object[0]);
                IdleState.this.onFailedCallback(code, callBack);
            }
        });
    }

    private void onJoinRoomSuccess(String roomId, RCRTCRoomConfig roomConfig, List<RTCUser> list, Map<String, Object> exParams, IRCRTCResultDataCallback<RCRTCRoom> callback) {
        this.handleRoomInfo(roomId, roomConfig, list, exParams);
        SignalManager.getInstance().setRtcToken(this.mEngine.mRoom.getRtcToken());
        this.initPeerConnection();
        RongRtcStatMagr.instance.start(roomId, RCRTCLiveRole.BROADCASTER);
        this.mEngine.storePreSpeakerphoneState();
        this.transitionTo(this.mEngine.mInRoomState);
        this.onSuccessCallback(this.mEngine.mRoom, callback);
    }

    private void handleRoomInfo(String roomId, RCRTCRoomConfig roomConfig, List<RTCUser> list, Map<String, Object> exParams) {
        RCRoomImpl rcRoom;
        this.mEngine.mRoom = rcRoom = this.createRCRoom(roomId, roomConfig, list, exParams);
        SignalManager.getInstance().setRtcToken(rcRoom.getRtcToken());
    }

    private RCRoomImpl createRCRoom(String roomId, RCRTCRoomConfig roomConfig, List<RTCUser> list, Map<String, Object> exParams) {
        RCLocalUserImpl localUser = new RCLocalUserImpl(this.mEngine.mUserId, null);
        String sessionId = null;
        String rtcToken = null;
        rtcToken = (String)exParams.get("joinRoomToken");
        sessionId = (String)exParams.get("joinRoomSessionId");
        HashMap roomData = (HashMap)exParams.get("joinRoomData");
        Object[] objects = RongRTCUtils.parseRTCUser(list, this.mEngine.mUserId);
        Map remoteUsers = null;
        ArrayList otherRoomIdList = null;
        List oldStreams = null;
        if (objects != null) {
            remoteUsers = (Map)objects[0];
            otherRoomIdList = (ArrayList)objects[1];
            oldStreams = (List)objects[2];
        }
        RongRTCUtils.sendUnpublishedCmd(oldStreams, roomId);
        int offlineKickTime = -1;
        if (exParams.get("offlineKickTime") != null) {
            offlineKickTime = (Integer)exParams.get("offlineKickTime");
        }
        RTCPingManager rtcPingManager = new RTCPingManager(roomId, this.mEngine.mContext, this.mEngine.mConfig.isAutoReconnect(), offlineKickTime);
        FinLog.d(TAG, "JoinMainRoomSuccess->roomId : " + roomId + " , sessionId :" + sessionId);
        RCRoomImpl impl = new RCRoomImpl(roomId, roomConfig, localUser, remoteUsers, sessionId, rtcToken, rtcPingManager, this.mEngine.mCallbackHandler, otherRoomIdList);
        MultiRoomManager multiRoomManager = new MultiRoomManager(impl, rtcPingManager);
        RongRTCUtils.parseRoomKV(roomId, impl, multiRoomManager, roomData);
        this.mEngine.mInRoomState.setMultiRoomManager(multiRoomManager);
        return impl;
    }

    private void unInit(Message msg) {
        if (!TextUtils.isEmpty((CharSequence)this.roomId)) {
            SignalManager.getInstance().viewerQuitRoom(this.roomId, null);
        }
        this.onStopRTCProbe(true, null);
        this.mEngine.unInitFaceBeautyPlugin();
        this.mEngine.unInitVoiceBeautyPlugin();
        this.mEngine.clearDeferredMessage();
        this.mEngine.deferMessage(msg);
        this.transitionTo(this.mEngine.mDisConnectingState);
    }

    @Override
    public void exit() {
        super.exit();
        this.joinIng = false;
        this.liveUrl = null;
        this.clearChatRoomData();
    }

    @Override
    public String getName() {
        return TAG;
    }
}

