/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.opengl.GLES20;
import android.util.Pair;
import com.daasuu.mp4compose.filter.GlFilter;
import com.daasuu.mp4compose.gl.GlFramebufferObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class GlFilterGroup
extends GlFilter {
    private final Collection<GlFilter> filters;
    private final ArrayList<Pair<GlFilter, GlFramebufferObject>> list = new ArrayList();
    private int prevTexName;

    public GlFilterGroup(GlFilter ... glFilters) {
        this(Arrays.asList(glFilters));
    }

    public GlFilterGroup(Collection<GlFilter> glFilters) {
        this.filters = glFilters;
    }

    @Override
    public void setup() {
        super.setup();
        if (this.filters != null) {
            int max = this.filters.size();
            int count = 0;
            for (GlFilter shader : this.filters) {
                shader.setup();
                GlFramebufferObject fbo = count + 1 < max ? new GlFramebufferObject() : null;
                this.list.add((Pair<GlFilter, GlFramebufferObject>)Pair.create((Object)shader, (Object)fbo));
                ++count;
            }
        }
    }

    @Override
    public void release() {
        for (Pair<GlFilter, GlFramebufferObject> pair : this.list) {
            if (pair.first != null) {
                ((GlFilter)pair.first).release();
            }
            if (pair.second == null) continue;
            ((GlFramebufferObject)pair.second).release();
        }
        this.list.clear();
        super.release();
    }

    @Override
    public void setFrameSize(int width, int height) {
        super.setFrameSize(width, height);
        for (Pair<GlFilter, GlFramebufferObject> pair : this.list) {
            if (pair.first != null) {
                ((GlFilter)pair.first).setFrameSize(width, height);
            }
            if (pair.second == null) continue;
            ((GlFramebufferObject)pair.second).setup(width, height);
        }
    }

    @Override
    public void draw(int texName, GlFramebufferObject fbo) {
        this.prevTexName = texName;
        for (Pair<GlFilter, GlFramebufferObject> pair : this.list) {
            if (pair.second != null) {
                if (pair.first != null) {
                    ((GlFramebufferObject)pair.second).enable();
                    GLES20.glClear((int)16384);
                    ((GlFilter)pair.first).draw(this.prevTexName, (GlFramebufferObject)pair.second);
                }
                this.prevTexName = ((GlFramebufferObject)pair.second).getTexName();
                continue;
            }
            if (fbo != null) {
                fbo.enable();
            } else {
                GLES20.glBindFramebuffer((int)36160, (int)0);
            }
            if (pair.first == null) continue;
            ((GlFilter)pair.first).draw(this.prevTexName, fbo);
        }
    }
}

