/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.util.Log;
import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.JavaI420Buffer;
import cn.rongcloud.rtc.core.JniCommon;
import cn.rongcloud.rtc.core.VideoFrame;
import java.nio.ByteBuffer;

class WrappedNativeI420Buffer
implements VideoFrame.I420Buffer {
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final int strideY;
    private final ByteBuffer dataU;
    private final int strideU;
    private final ByteBuffer dataV;
    private final int strideV;
    private final long nativeBuffer;

    @CalledByNative
    WrappedNativeI420Buffer(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV, long nativeBuffer) {
        this.width = width;
        this.height = height;
        this.dataY = dataY;
        this.strideY = strideY;
        this.dataU = dataU;
        this.strideU = strideU;
        this.dataV = dataV;
        this.strideV = strideV;
        this.nativeBuffer = nativeBuffer;
        this.retain();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public byte[] getData() {
        int chromaHeight = (this.height + 1) / 2;
        int yLength = this.height * this.width;
        int uLength = chromaHeight * this.strideU;
        int vLength = chromaHeight * this.strideV;
        int dataLength = yLength + uLength + vLength;
        byte[] data = new byte[dataLength];
        this.dataY.get(data, 0, this.height * this.width);
        this.dataU.get(data, yLength, uLength);
        this.dataV.get(data, uLength + yLength, vLength);
        return data;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        this.retain();
        return this;
    }

    @Override
    public void updateData(byte[] data) {
        int yLength = this.height * this.width;
        int chromaHeight = (this.height + 1) / 2;
        int uLength = chromaHeight * this.strideU;
        int vLength = chromaHeight * this.strideV;
        int dataLength = yLength + uLength + vLength;
        if (data.length < dataLength) {
            Log.w((String)"JavaI420Buffer", (String)"data length short than dst");
            return;
        }
        this.dataY.flip();
        this.dataU.flip();
        this.dataV.flip();
        this.dataY.put(data, 0, yLength);
        this.dataU.put(data, yLength, uLength);
        this.dataV.put(data, yLength + uLength, vLength);
    }

    @Override
    public void retain() {
        JniCommon.nativeAddRef(this.nativeBuffer);
    }

    @Override
    public void release() {
        JniCommon.nativeReleaseRef(this.nativeBuffer);
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        return JavaI420Buffer.cropAndScaleI420(this, cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight);
    }
}

