/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_barcode;

import android.content.Context;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXResourceUtils;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.weex_barcode.BarcodeView;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class BarcodeComponent
extends WXComponent<BarcodeView> {
    private AtomicBoolean isLoad = new AtomicBoolean(false);
    private boolean isAnimationEnd = false;

    public BarcodeComponent(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
    }

    public BarcodeComponent(WXSDKInstance instance, WXVContainer parent, int type, BasicComponentData basicComponentData) {
        super(instance, parent, type, basicComponentData);
    }

    @Override
    protected BarcodeView initComponentHostView(Context context) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)context, (String)"nvue-Barcode");
        return new BarcodeView(context, this, this.getInstance());
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        super.updateProperties(props);
        if (this.getHostView() != null && !this.getAttrs().containsKey("background")) {
            ((BarcodeView)((Object)this.getHostView())).setBackgroundColor(-16777216);
        }
    }

    @WXComponentProp(name="frameColor")
    public void setFrameColor(String color2) {
        ((BarcodeView)((Object)this.getHostView())).setFrameColor(WXResourceUtils.getColor(color2));
    }

    @WXComponentProp(name="autoDecodeCharset")
    public void setAutoDecodeCharset(boolean autoDecodeCharset) {
        ((BarcodeView)((Object)this.getHostView())).setAutoDecodeCharset(autoDecodeCharset);
    }

    @WXComponentProp(name="background")
    public void setBackground(String color2) {
        ((BarcodeView)((Object)this.getHostView())).setBackground(WXResourceUtils.getColor(color2));
    }

    @WXComponentProp(name="scanbarColor")
    public void setScanbarColor(String color2) {
        ((BarcodeView)((Object)this.getHostView())).setScanBarColor(WXResourceUtils.getColor(color2));
    }

    @WXComponentProp(name="filters")
    public void setFilters(JSONArray filters) {
        ((BarcodeView)((Object)this.getHostView())).initDecodeFormats(filters);
    }

    @WXComponentProp(name="autostart")
    public void setSutoStart(final boolean isstart) {
        if (!this.isAnimationEnd) {
            this.getInstance().addFrameViewEventListener(new WXSDKInstance.FrameViewEventListener(){

                @Override
                public void onShowAnimationEnd() {
                    BarcodeComponent.this.isAnimationEnd = true;
                    if (isstart) {
                        BarcodeComponent.this.start(null);
                    }
                    BarcodeComponent.this.getInstance().removeFrameViewEventListener(this);
                }
            });
        } else if (isstart) {
            this.start(null);
        }
    }

    @JSMethod
    public void start(JSONObject option) {
        if (option != null) {
            ((BarcodeView)((Object)this.getHostView())).setConserve(option.containsKey((Object)"conserve") ? option.getBoolean("conserve") : false);
            ((BarcodeView)((Object)this.getHostView())).setFilename(PdrUtil.getDefaultPrivateDocPath((String)option.getString("filename"), (String)"png"));
            ((BarcodeView)((Object)this.getHostView())).setVibrate(option.containsKey((Object)"vibrate") ? option.getBoolean("vibrate") : true);
            ((BarcodeView)((Object)this.getHostView())).setPlayBeep(!option.containsKey((Object)"sound") || option.getString("sound").equals("default"));
        }
        ((BarcodeView)((Object)this.getHostView())).start();
    }

    @Override
    protected void setHostLayoutParams(BarcodeView host, int width, int height, int left, int right, int top, int bottom) {
        super.setHostLayoutParams(host, width, height, left, right, top, bottom);
        if (!this.isLoad.get()) {
            this.isLoad.set(true);
            ((BarcodeView)((Object)this.getHostView())).initBarcodeView(width, height);
        } else {
            ((BarcodeView)((Object)this.getHostView())).updateStyles(width, height);
        }
    }

    @JSMethod
    public void cancel() {
        ((BarcodeView)((Object)this.getHostView())).cancelScan();
    }

    @JSMethod
    public void close() {
    }

    @JSMethod
    public void setFlash(boolean open) {
        if (PdrUtil.isEmpty((Object)open)) {
            return;
        }
        ((BarcodeView)((Object)this.getHostView())).setFlash(open);
    }

    @Override
    public void destroy() {
        super.destroy();
        ((BarcodeView)((Object)this.getHostView())).closeScan();
        ((BarcodeView)((Object)this.getHostView())).onDestory();
    }

    @Override
    public void onActivityResume() {
        super.onActivityResume();
        ((BarcodeView)((Object)this.getHostView())).onResume(true);
    }

    @Override
    public void onActivityPause() {
        super.onActivityPause();
        ((BarcodeView)((Object)this.getHostView())).onPause();
    }
}

