/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.WXComponentRegistry;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;

public class WXComponentFactory {
    public static WXComponent newInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        if (instance == null || TextUtils.isEmpty((CharSequence)basicComponentData.mComponentType)) {
            return null;
        }
        IFComponentHolder holder = WXComponentRegistry.getComponent(basicComponentData.mComponentType);
        if (holder == null) {
            if (WXEnvironment.isApkDebugable()) {
                String tag = "WXComponentFactory error type:[" + basicComponentData.mComponentType + "] class not found";
                WXLogUtils.e(tag);
            }
            if ((holder = WXComponentRegistry.getComponent("container")) == null) {
                WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), WXErrorCode.WX_RENDER_ERR_COMPONENT_NOT_REGISTER, "createComponent", basicComponentData.mComponentType + " not registered", null);
                return null;
            }
        }
        try {
            return holder.createInstance(instance, parent, basicComponentData);
        }
        catch (Throwable e) {
            WXLogUtils.e("WXComponentFactory Exception type:[" + basicComponentData.mComponentType + "] ", e);
            return null;
        }
    }
}

