/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.app.Activity;
import android.content.Context;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXImageQuality;
import com.taobao.weex.performance.WXAnalyzerDataTransfer;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXImageView;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.ImageDrawable;
import com.taobao.weex.utils.ImgURIUtil;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXDomUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewToImageUtil;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(lazyload=false)
public class WXImage
extends WXComponent<ImageView> {
    public static final String SUCCEED = "success";
    public static final String ERRORDESC = "errorDesc";
    private static final int WRITE_EXTERNAL_STORAGE_PERMISSION_REQUEST_CODE = 2;
    private String mSrc;
    private int mBlurRadius;
    private boolean mAutoRecycle = true;
    protected boolean mIsUni = false;
    private static SingleFunctionParser.FlatMapper<Integer> BLUR_RADIUS_MAPPER = new SingleFunctionParser.FlatMapper<Integer>(){

        @Override
        public Integer map(String raw) {
            return WXUtils.getInteger(raw, 0);
        }
    };
    private WXSDKInstance.FrameViewEventListener mFrameViewEventListener;
    private String preImgUrlStr = "";

    @Deprecated
    public WXImage(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, basicComponentData);
    }

    public WXImage(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
    }

    @Override
    protected ImageView initComponentHostView(@NonNull Context context) {
        WXImageView view = new WXImageView(context);
        view.setScaleType(ImageView.ScaleType.FIT_XY);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setCropToPadding(true);
        }
        view.holdComponent(this);
        return view;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "resizeMode": {
                String resizeMode = WXUtils.getString(param, null);
                if (resizeMode != null) {
                    this.setResizeMode(resizeMode);
                }
                return true;
            }
            case "resize": {
                String resize = WXUtils.getString(param, null);
                if (resize != null) {
                    this.setResize(resize);
                }
                return true;
            }
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
            case "imageQuality": {
                return true;
            }
            case "autoBitmapRecycle": {
                this.mAutoRecycle = WXUtils.getBoolean(param, this.mAutoRecycle);
                if (!this.mAutoRecycle && null != this.getInstance()) {
                    this.getInstance().getApmForInstance().updateDiffStats("wxImgUnRecycleCount", 1.0);
                }
                return true;
            }
            case "filter": {
                int blurRadius = 0;
                if (param != null && param instanceof String) {
                    blurRadius = this.parseBlurRadius((String)param);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mSrc)) {
                    this.setBlurRadius(this.mSrc, blurRadius);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Override
    public void refreshData(WXComponent component) {
        super.refreshData(component);
        if (component instanceof WXImage) {
            this.setSrc(component.getAttrs().getImageSrc());
        }
    }

    @WXComponentProp(name="resizeMode")
    public void setResizeMode(String resizeMode) {
        ((ImageView)this.getHostView()).setScaleType(this.getResizeMode(resizeMode));
        ((ImageView)this.getHostView()).setImageDrawable(((ImageView)this.getHostView()).getDrawable());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected ImageView.ScaleType getResizeMode(String resizeMode) {
        ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_XY;
        if (TextUtils.isEmpty((CharSequence)resizeMode)) {
            return scaleType;
        }
        switch (resizeMode) {
            case "cover": {
                scaleType = ImageView.ScaleType.CENTER_CROP;
                break;
            }
            case "contain": {
                scaleType = ImageView.ScaleType.FIT_CENTER;
                break;
            }
            case "stretch": {
                scaleType = ImageView.ScaleType.FIT_XY;
                break;
            }
        }
        return scaleType;
    }

    @WXComponentProp(name="resize")
    public void setResize(String resize) {
        this.setResizeMode(resize);
    }

    private void setLocalSrc(Uri rewrited) {
        ImageView imageView;
        Drawable localDrawable = ImgURIUtil.getDrawableFromLoaclSrc(this.getContext(), rewrited);
        if (localDrawable != null && (imageView = (ImageView)this.getHostView()) != null) {
            imageView.setImageDrawable(localDrawable);
        }
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        this.runSrc(src);
    }

    private void runSrc(String src) {
        String localUrl;
        if (this.getInstance().getImageNetworkHandler() != null && !TextUtils.isEmpty((CharSequence)(localUrl = this.getInstance().getImageNetworkHandler().fetchLocal(src)))) {
            src = localUrl;
        }
        if (PdrUtil.isEmpty((Object)src)) {
            return;
        }
        ImageView image = (ImageView)this.getHostView();
        if (image != null && image.getDrawable() != null && !TextUtils.equals((CharSequence)this.mSrc, (CharSequence)src)) {
            image.setImageDrawable(null);
        }
        this.mSrc = src;
        WXSDKInstance instance = this.getInstance();
        Uri rewrited = instance.rewriteUri(Uri.parse((String)src), "image");
        if ("local".equals(rewrited.getScheme())) {
            this.setLocalSrc(rewrited);
        } else {
            int blur = 0;
            String blurStr = this.getStyles().getBlur();
            blur = this.parseBlurRadius(blurStr);
            this.setRemoteSrc(rewrited, blur);
        }
    }

    private void setBlurRadius(@NonNull String src, int blurRadius) {
        Uri parsedUri;
        if (this.getInstance() != null && blurRadius != this.mBlurRadius && !"local".equals((parsedUri = this.getInstance().rewriteUri(Uri.parse((String)src), "image")).getScheme())) {
            this.setRemoteSrc(parsedUri, blurRadius);
        }
    }

    private int parseBlurRadius(@Nullable String rawRadius) {
        if (rawRadius == null) {
            return 0;
        }
        SingleFunctionParser<Integer> parser = new SingleFunctionParser<Integer>(rawRadius, BLUR_RADIUS_MAPPER);
        List<Integer> list = null;
        try {
            list = parser.parse("blur");
        }
        catch (Exception e) {
            return 0;
        }
        if (list == null || list.isEmpty()) {
            return 0;
        }
        return list.get(0);
    }

    @Override
    public void recycled() {
        super.recycled();
        if (this.getInstance().getImgLoaderAdapter() != null) {
            this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)this.mHost, null, null);
        } else {
            if (WXEnvironment.isApkDebugable()) {
                throw new WXRuntimeException("getImgLoaderAdapter() == null");
            }
            WXLogUtils.e("Error getImgLoaderAdapter() == null");
        }
    }

    public void autoReleaseImage() {
        if (this.mAutoRecycle && this.getHostView() != null && this.getInstance() != null && this.getInstance().getImgLoaderAdapter() != null) {
            this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)this.mHost, null, null);
        }
    }

    public void autoRecoverImage() {
        if (this.mAutoRecycle) {
            this.setSrc(this.mSrc);
        }
    }

    private void setRemoteSrc(Uri rewrited, int blurRadius) {
        WXImageStrategy imageStrategy = new WXImageStrategy(this.getInstanceId());
        imageStrategy.isClipping = true;
        WXImageSharpen imageSharpen = this.getAttrs().getImageSharpen();
        imageStrategy.isSharpen = imageSharpen == WXImageSharpen.SHARPEN;
        imageStrategy.blurRadius = Math.max(0, blurRadius);
        this.mBlurRadius = blurRadius;
        String rewritedStr = rewrited.toString();
        imageStrategy.setImageListener(new MyImageListener(this, rewritedStr));
        if (this.getAttrs().containsKey("autoCompression")) {
            imageStrategy.setAutoCompression(WXUtils.getBoolean(this.getAttrs().get("autoCompression"), true));
        }
        String placeholder = null;
        if (this.getAttrs().containsKey("placeholder")) {
            placeholder = (String)this.getAttrs().get("placeholder");
        } else if (this.getAttrs().containsKey("placeHolder")) {
            placeholder = (String)this.getAttrs().get("placeHolder");
        }
        if (placeholder != null) {
            imageStrategy.placeHolder = this.getInstance().rewriteUri(Uri.parse((String)placeholder), "image").toString();
        }
        imageStrategy.instanceId = this.getInstanceId();
        this.setImage(rewritedStr, imageStrategy);
    }

    protected void setImage(String rewritedStr, WXImageStrategy imageStrategy) {
        IWXImgLoaderAdapter imgLoaderAdapter = this.getInstance().getImgLoaderAdapter();
        if (imgLoaderAdapter != null) {
            imgLoaderAdapter.setImage(rewritedStr, (ImageView)this.getHostView(), this.getImageQuality(), imageStrategy);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected WXImageQuality getImageQuality() {
        return this.getAttrs().getImageQuality();
    }

    @Override
    protected void onFinishLayout() {
        super.onFinishLayout();
        this.updateBorderRadius();
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        super.updateProperties(props);
        this.updateBorderRadius();
    }

    private void updateBorderRadius() {
        if (this.getHostView() instanceof WXImageView) {
            ImageDrawable imageDrawable;
            float[] previousRadius;
            float[] borderRadius;
            WXImageView imageView = (WXImageView)this.getHostView();
            BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(this.getHostView());
            if (borderDrawable != null) {
                RectF borderBox = new RectF(0.0f, 0.0f, WXDomUtils.getContentWidth(this), WXDomUtils.getContentHeight(this));
                borderRadius = borderDrawable.getBorderInnerRadius(borderBox);
            } else {
                borderRadius = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            }
            imageView.setBorderRadius(borderRadius);
            if (imageView.getDrawable() instanceof ImageDrawable && !Arrays.equals(previousRadius = (imageDrawable = (ImageDrawable)imageView.getDrawable()).getCornerRadii(), borderRadius)) {
                imageDrawable.setCornerRadii(borderRadius);
            }
        }
    }

    @JSMethod(uiThread=false)
    public void save(final JSCallback saveStatuCallback) {
        if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0 && this.getContext() instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)this.getContext()), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)2);
        }
        if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            if (saveStatuCallback != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCEED, false);
                result.put(ERRORDESC, "Permission denied: android.permission.WRITE_EXTERNAL_STORAGE");
                saveStatuCallback.invoke(result);
            }
            return;
        }
        if (this.mHost == null) {
            if (saveStatuCallback != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCEED, false);
                result.put(ERRORDESC, "Image component not initialized");
                saveStatuCallback.invoke(result);
            }
            return;
        }
        if (this.mSrc == null || this.mSrc.equals("")) {
            if (saveStatuCallback != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCEED, false);
                result.put(ERRORDESC, "Image does not have the correct src");
                saveStatuCallback.invoke(result);
            }
            return;
        }
        WXViewToImageUtil.generateImage(this.mHost, 0, -460552, new WXViewToImageUtil.OnImageSavedCallback(){

            @Override
            public void onSaveSucceed(String path) {
                if (saveStatuCallback != null) {
                    HashMap<String, Boolean> result = new HashMap<String, Boolean>();
                    result.put(WXImage.SUCCEED, true);
                    saveStatuCallback.invoke(result);
                }
            }

            @Override
            public void onSaveFailed(String errorDesc) {
                if (saveStatuCallback != null) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put(WXImage.SUCCEED, false);
                    result.put(WXImage.ERRORDESC, errorDesc);
                    saveStatuCallback.invoke(result);
                }
            }
        });
    }

    private void monitorImgSize(ImageView imageView, String currentImgUrlStr) {
        if (null == imageView) {
            return;
        }
        WXSDKInstance instance = this.getInstance();
        if (null == instance) {
            return;
        }
        ViewGroup.LayoutParams params = imageView.getLayoutParams();
        Drawable img = imageView.getDrawable();
        if (null == params || null == img) {
            return;
        }
        int imgHeight = img.getIntrinsicHeight();
        int imgWidth = img.getIntrinsicWidth();
        if (!this.preImgUrlStr.equals(currentImgUrlStr)) {
            this.preImgUrlStr = currentImgUrlStr;
            if (imgHeight > 1081 && imgWidth > 721) {
                instance.getApmForInstance().updateDiffStats("wxLargeImgMaxCount", 1.0);
                if (WXAnalyzerDataTransfer.isOpenPerformance) {
                    WXAnalyzerDataTransfer.transferPerformance(this.getInstanceId(), "details", "wxLargeImgMaxCount", imgWidth + "*" + imgHeight + "," + currentImgUrlStr);
                }
            }
            long imgSize = imgHeight * imgWidth;
            long viewSize = imageView.getMeasuredHeight() * imageView.getMeasuredWidth();
            if (viewSize == 0L) {
                return;
            }
            double scaleSize = (double)imgSize / (double)viewSize;
            if (scaleSize > 1.2 && imgSize - viewSize > 1600L) {
                instance.getWXPerformance().wrongImgSizeCount += 1.0;
                instance.getApmForInstance().updateDiffStats("wxWrongImgSizeCount", 1.0);
                if (WXAnalyzerDataTransfer.isOpenPerformance) {
                    WXAnalyzerDataTransfer.transferPerformance(this.getInstanceId(), "details", "wxWrongImgSizeCount", StringUtil.format((String)"imgSize:[%d,%d],viewSize:[%d,%d],urL:%s", (Object[])new Object[]{imgWidth, imgHeight, imageView.getMeasuredWidth(), imageView.getMeasuredHeight(), currentImgUrlStr}));
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (this.getHostView() instanceof WXImageView && this.getInstance().getImgLoaderAdapter() != null) {
            this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)this.mHost, null, null);
        }
        super.destroy();
    }

    public void onImageFinish(boolean result, Map extra) {
    }

    public class MyImageListener
    implements WXImageStrategy.ImageListener {
        private WeakReference<WXImage> wxImageWeakReference;
        private String rewritedStr;

        MyImageListener(WXImage image, String rewritedStr) {
            this.wxImageWeakReference = new WeakReference<WXImage>(image);
            this.rewritedStr = rewritedStr;
        }

        @Override
        public void onImageFinish(String url, ImageView imageView, boolean result, Map extra) {
            WXImage image = (WXImage)this.wxImageWeakReference.get();
            if (image == null) {
                return;
            }
            if (extra == null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(WXImage.SUCCEED, false);
                image.fireEvent("error", params);
                return;
            }
            image.onImageFinish(result, extra);
            HashMap<String, Object> params = new HashMap<String, Object>();
            HashMap size = new HashMap(2);
            size.put("width", extra.get("width"));
            size.put("height", extra.get("height"));
            if (WXImage.this.mIsUni) {
                if (!result && image.containsEvent("error")) {
                    params.put(WXImage.SUCCEED, result);
                    params.put("detail", size);
                    image.fireEvent("error", params);
                }
                if (result && image.containsEvent("load")) {
                    params.put(WXImage.SUCCEED, result);
                    params.put("detail", size);
                    image.fireEvent("load", params);
                }
            } else if (image.containsEvent("load")) {
                params.put(WXImage.SUCCEED, result);
                params.put("detail", size);
                image.fireEvent("load", params);
            }
            image.monitorImgSize(imageView, this.rewritedStr);
        }
    }

    public static interface Measurable {
        public int getNaturalWidth();

        public int getNaturalHeight();
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXImage(instance, parent, basicComponentData);
        }
    }
}

