/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.layout.measurefunc.TextContentBoxMeasurement;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.richtext.WXRichTextView;
import com.taobao.weex.ui.component.richtext.node.RichTextNode;
import com.taobao.weex.ui.component.richtext.node.RichTextNodeManager;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WXRichText
extends WXText {
    private List<RichTextNode> nodes = new LinkedList<RichTextNode>();

    public WXRichText(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.setContentBoxMeasurement(new RichTextContentBoxMeasurement(this));
    }

    public void AddChildNode(String ref, String nodeType, String parentRef, Map<String, String> styles, Map<String, String> attrs) {
        if (!(this.getInstance() == null || this.getInstance().getUIContext() == null || TextUtils.isEmpty((CharSequence)this.getInstanceId()) || TextUtils.isEmpty((CharSequence)ref) || TextUtils.isEmpty((CharSequence)nodeType))) {
            RichTextNode child = RichTextNodeManager.createRichTextNode(this.getInstance().getUIContext(), this.getInstanceId(), this.getRef(), ref, nodeType, styles, attrs);
            if (TextUtils.isEmpty((CharSequence)parentRef)) {
                this.nodes.add(child);
            } else {
                RichTextNode parent = this.findRichNode(parentRef);
                if (parent != null) {
                    parent.addChildNode(child);
                }
            }
        }
    }

    private Spannable toSpan() {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        if (this.nodes != null && !this.nodes.isEmpty()) {
            for (RichTextNode node : this.nodes) {
                spannableStringBuilder.append((CharSequence)node.toSpan(1));
            }
        }
        return spannableStringBuilder;
    }

    public void removeChildNode(String parentRef, String ref) {
        if (this.nodes != null && !this.nodes.isEmpty()) {
            if (parentRef.equals("")) {
                for (RichTextNode node : this.nodes) {
                    if (!TextUtils.equals((CharSequence)node.getRef(), (CharSequence)ref)) continue;
                    this.nodes.remove(node);
                }
            } else {
                RichTextNode parent = this.findRichNode(parentRef);
                if (parent != null) {
                    parent.removeChildNode(ref);
                }
            }
        }
    }

    public void updateChildNodeStyles(String ref, Map<String, Object> styles) {
        RichTextNode node = this.findRichNode(ref);
        if (node != null) {
            node.updateStyles(styles);
        }
    }

    public void updateChildNodeAttrs(String ref, Map<String, Object> attrs) {
        RichTextNode node = this.findRichNode(ref);
        if (node != null) {
            node.updateAttrs(attrs);
        }
    }

    private RichTextNode findRichNode(String ref) {
        if (!TextUtils.isEmpty((CharSequence)ref) && this.nodes != null && !this.nodes.isEmpty()) {
            for (RichTextNode node : this.nodes) {
                RichTextNode theNode = node.findRichNode(ref);
                if (theNode == null) continue;
                return theNode;
            }
        }
        return null;
    }

    @Override
    protected WXRichTextView initComponentHostView(@NonNull Context context) {
        return new WXRichTextView(context);
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXRichText(instance, parent, basicComponentData);
        }
    }

    static class RichTextContentBoxMeasurement
    extends TextContentBoxMeasurement {
        public RichTextContentBoxMeasurement(WXComponent component) {
            super(component);
        }

        @Override
        @NonNull
        protected Spanned createSpanned(String text) {
            if (!TextUtils.isEmpty((CharSequence)text)) {
                if (this.mComponent.getInstance() != null & this.mComponent.getInstance().getUIContext() != null && !TextUtils.isEmpty((CharSequence)this.mComponent.getInstanceId())) {
                    Spannable spannable = RichTextNode.parse(this.mComponent.getInstance().getUIContext(), this.mComponent.getInstanceId(), this.mComponent.getRef(), text);
                    this.updateSpannable(spannable, RichTextNode.createSpanFlag(0));
                    return spannable;
                }
                return new SpannedString((CharSequence)"");
            }
            Spannable spannable = ((WXRichText)this.mComponent).toSpan();
            this.updateSpannable(spannable, RichTextNode.createSpanFlag(0));
            return spannable;
        }
    }
}

