/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_barcode;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.Result;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.ui.component.WXComponent;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.feature.barcode2.camera.CameraManager;
import io.dcloud.feature.barcode2.decoding.CaptureActivityHandler;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.decoding.InactivityTimer;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import io.dcloud.feature.barcode2.view.ViewfinderView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class BarcodeView
extends AbsoluteLayout
implements IBarHandler,
TextureView.SurfaceTextureListener {
    private TextureView surfaceView;
    private ViewfinderView viewfinderView;
    private CaptureActivityHandler handler;
    private InactivityTimer inactivityTimer;
    private boolean nopermission;
    private Vector<BarcodeFormat> decodeFormats;
    private boolean hasSurface = false;
    private Context context;
    private String characterSet;
    public String errorMsg = null;
    private boolean playBeep;
    private boolean vibrate;
    private MediaPlayer mediaPlayer;
    private WXComponent component;
    private WXSDKInstance mInstance;
    private boolean mConserve = false;
    private String mFilename;
    private int viewWidth;
    private int viewHeight;
    private static final int ID_ADD_VIEW = 201;
    private static final int ID_UPDATE_VIEW = 202;
    private static final int ID_START_SCAN = 203;
    private boolean isSurfaceAvaliable = false;
    private boolean isVerticalScreen = false;
    public boolean autoDecodeCharset = false;
    @SuppressLint(value={"HandlerLeak"})
    Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 201) {
                AbsoluteLayout.LayoutParams param = (AbsoluteLayout.LayoutParams)msg.obj;
                if (BarcodeView.this.surfaceView != null) {
                    if (BarcodeView.this.surfaceView.getParent() != null) {
                        ((ViewGroup)BarcodeView.this.surfaceView.getParent()).removeView((View)BarcodeView.this.surfaceView);
                    }
                    BarcodeView.this.addView((View)BarcodeView.this.surfaceView, (ViewGroup.LayoutParams)param);
                }
                BarcodeView.this.addView((View)BarcodeView.this.viewfinderView);
            } else if (msg.what == 202) {
                if (BarcodeView.this.surfaceView != null && BarcodeView.this.surfaceView.getParent() != null) {
                    BarcodeView.this.surfaceView.setLayoutParams((ViewGroup.LayoutParams)((AbsoluteLayout.LayoutParams)msg.obj));
                    BarcodeView.this.viewfinderView.drawViewfinder();
                }
            } else if (msg.what == 203 && BarcodeView.this.surfaceView != null && BarcodeView.this.surfaceView.getParent() != null) {
                BarcodeView.this.surfaceView.setLayoutParams((ViewGroup.LayoutParams)((AbsoluteLayout.LayoutParams)msg.obj));
                BarcodeView.this.viewfinderView.drawViewfinder();
                BarcodeView.this.startP();
            }
        }
    };
    int mOrientationState;
    private boolean isCancelScan = false;
    private boolean mRunning = false;
    private Bitmap lastBiptmap;
    static final int UNKOWN = -1000;
    static final int QR = 0;
    static final int EAN13 = 1;
    static final int EAN8 = 2;
    static final int AZTEC = 3;
    static final int DATAMATRIX = 4;
    static final int UPCA = 5;
    static final int UPCE = 6;
    static final int CODABAR = 7;
    static final int CODE39 = 8;
    static final int CODE93 = 9;
    static final int CODE128 = 10;
    static final int ITF = 11;
    static final int MAXICODE = 12;
    static final int PDF417 = 13;
    static final int RSS14 = 14;
    static final int RSSEXPANDED = 15;
    private final MediaPlayer.OnCompletionListener beepListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mediaPlayer) {
            mediaPlayer.seekTo(0);
        }
    };
    private static final float BEEP_VOLUME = 0.8f;
    private static final long VIBRATE_DURATION = 200L;

    public BarcodeView(Context context, WXComponent component, WXSDKInstance mInstance) {
        super(context);
        this.component = component;
        this.mInstance = mInstance;
        this.surfaceView = new TextureView(context);
        this.viewfinderView = new ViewfinderView(context, (IBarHandler)this);
        this.inactivityTimer = new InactivityTimer((Activity)context);
        this.context = context;
        this.saveOrientationState();
        CameraManager.init((Context)this.context, (boolean)false);
        int rotation = ((Activity)context).getWindowManager().getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: 
            case 2: {
                ((Activity)this.context).setRequestedOrientation(7);
                CameraManager.init((Context)context, (boolean)true);
                this.isVerticalScreen = true;
                break;
            }
            case 3: {
                CameraManager.get().setHorizontalOrientation(true);
                ((Activity)this.context).setRequestedOrientation(8);
                break;
            }
            case 1: {
                CameraManager.get().setHorizontalOrientation(false);
                ((Activity)this.context).setRequestedOrientation(0);
            }
        }
        this.onResume(false);
        this.hasSurface = false;
    }

    private void saveOrientationState() {
        this.mOrientationState = ((Activity)this.context).getRequestedOrientation();
    }

    private void resumeOrientationState() {
        ((Activity)this.context).setRequestedOrientation(this.mOrientationState);
    }

    public void initBarcodeView(int width, int height) {
        this.viewWidth = width;
        this.viewHeight = height;
        ThreadPool.self().addThreadTask(new Runnable(){

            @Override
            public void run() {
                BarcodeView.this.addBarcodeView();
            }
        });
    }

    public void updateStyles(int viewWidth, int viewHeight) {
        if (this.viewHeight == viewHeight && this.viewWidth == viewWidth) {
            return;
        }
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        ThreadPool.self().addThreadTask(new Runnable(){

            @Override
            public void run() {
                AbsoluteLayout.LayoutParams params = BarcodeView.this.setLayoutParams();
                if (params == null) {
                    return;
                }
                Message msg = new Message();
                msg.what = 202;
                msg.obj = params;
                BarcodeView.this.mHandler.sendMessage(msg);
            }
        });
    }

    private void addBarcodeView() {
        AbsoluteLayout.LayoutParams lllp = this.setLayoutParams();
        if (lllp == null) {
            return;
        }
        Message msg = new Message();
        msg.what = 201;
        msg.obj = lllp;
        this.mHandler.sendMessage(msg);
    }

    private void initCamera() {
        SurfaceTexture surfaceHolder = this.surfaceView.getSurfaceTexture();
        try {
            CameraManager.get().openDriver(surfaceHolder);
        }
        catch (IOException e) {
            this.errorMsg = e.getMessage();
            return;
        }
        if (this.handler == null) {
            this.handler = new CaptureActivityHandler((IBarHandler)this, this.decodeFormats, this.characterSet, this.autoDecodeCharset);
            if (this.mRunning) {
                this.handler.restartPreviewAndDecode();
            }
        } else {
            this.handler.resume();
        }
    }

    public void setFrameColor(int color2) {
        DetectorViewConfig.cornerColor = color2 = color2 != -1 ? color2 : DetectorViewConfig.laserColor;
    }

    public void setAutoDecodeCharset(boolean autoDecodeCharsetParam) {
        this.autoDecodeCharset = autoDecodeCharsetParam;
    }

    public void setBackground(int color2) {
        color2 = color2 != -1 ? color2 : DetectorViewConfig.laserColor;
        this.setBackgroundColor(color2);
    }

    public void setScanBarColor(int color2) {
        DetectorViewConfig.laserColor = color2 = color2 != -1 ? color2 : DetectorViewConfig.laserColor;
    }

    public void setPlayBeep(boolean playBeep) {
        this.playBeep = playBeep;
    }

    public void setVibrate(boolean vibrate) {
        this.vibrate = vibrate;
    }

    public void setConserve(boolean mConserve) {
        this.mConserve = mConserve;
    }

    public void setFilename(String mFilename) {
        this.mFilename = mFilename;
    }

    public void setFlash(boolean enable) {
        CameraManager.get().setFlashlight(enable);
    }

    public void cancelScan() {
        if (this.mRunning) {
            if (this.handler != null) {
                this.handler.quitSynchronously();
                this.handler = null;
            }
            this.getViewfinderView().stopUpdateScreenTimer();
            CameraManager.get().removeAutoFocus();
            CameraManager.get().stopPreview();
            byte[] lastBitmapData = CameraManager.get().getLastBitmapData();
            Camera camera = CameraManager.get().getCameraHandler();
            if (lastBitmapData != null && camera != null) {
                this.lastBiptmap = this.byte2bitmap(lastBitmapData, camera);
            }
            CameraManager.get().closeDriver();
            this.mRunning = false;
            this.isCancelScan = true;
        }
    }

    public void closeScan() {
        this.onPause();
        CameraManager.get().closeDriver();
        DetectorViewConfig.clearData();
        this.surfaceView = null;
        if (this.lastBiptmap != null && !this.lastBiptmap.isRecycled()) {
            this.lastBiptmap.recycle();
            this.lastBiptmap = null;
        }
        CameraManager.get().clearLastBitmapData();
        System.gc();
    }

    public void onPause() {
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        if (!this.nopermission) {
            CameraManager.get().closeDriver();
        }
        boolean t = this.mRunning;
        this.cancel();
        this.mRunning = t;
    }

    public void onDestory() {
        this.resumeOrientationState();
        this.inactivityTimer.shutdown();
        this.hasSurface = false;
        this.decodeFormats = null;
        this.characterSet = null;
    }

    private Bitmap byte2bitmap(byte[] data, Camera mCamera) {
        Bitmap bmp = null;
        try {
            Camera.Size size = mCamera.getParameters().getPreviewSize();
            YuvImage image = new YuvImage(data, 17, size.width, size.height, null);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            image.compressToJpeg(new Rect(0, 0, size.width, size.height), 80, (OutputStream)stream);
            bmp = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
            stream.close();
            Matrix m = new Matrix();
            m.postRotate(90.0f);
            bmp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)bmp.getWidth(), (int)bmp.getHeight(), (Matrix)m, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bmp;
    }

    public void start() {
        PermissionUtil.useSystemPermissions((Activity)((Activity)this.context), (String[])new String[]{"android.permission.CAMERA"}, (PermissionUtil.Request)new PermissionUtil.Request(){

            public void onGranted(String streamPerName) {
                long timeout = BarcodeView.this.isSurfaceAvaliable ? 0L : 200L;
                BarcodeView.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!BarcodeView.this.isSurfaceAvaliable) {
                            BarcodeView.this.postDelayed(this, 100L);
                        } else {
                            AbsoluteLayout.LayoutParams params = BarcodeView.this.setLayoutParams();
                            if (params == null) {
                                return;
                            }
                            Message msg = new Message();
                            msg.what = 203;
                            msg.obj = params;
                            BarcodeView.this.mHandler.sendMessage(msg);
                        }
                    }
                }, timeout);
            }

            public void onDenied(String streamPerName) {
                BarcodeView.this.nopermission = true;
                BarcodeView.this.setBackground(-16777216);
                BarcodeView.this.invalidate();
            }
        });
    }

    private void startP() {
        this.initCamera();
        if (this.decodeFormats == null) {
            this.initDecodeFormats(null);
        }
        if (!TextUtils.isEmpty((CharSequence)this.errorMsg)) {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("code", 8);
            error.put("message", this.errorMsg);
            error.put("type", "fail");
            this.fireEvent("error", error);
            return;
        }
        if (!this.mRunning) {
            this.getViewfinderView().startUpdateScreenTimer();
            if (this.handler != null) {
                this.handler.restartPreviewAndDecode();
            } else {
                this.onResume(false);
            }
            if (this.isCancelScan) {
                this.surfaceView.setBackgroundDrawable(null);
                if (this.lastBiptmap != null && !this.lastBiptmap.isRecycled()) {
                    this.lastBiptmap.recycle();
                    this.lastBiptmap = null;
                }
                CameraManager.get().clearLastBitmapData();
                this.surfaceView.postInvalidate();
                this.initCamera();
            }
            this.mRunning = true;
            this.isCancelScan = false;
        }
    }

    public void onResume(boolean isSysEvent) {
        if (this.lastBiptmap != null && this.isCancelScan && isSysEvent) {
            this.surfaceView.setBackgroundDrawable((Drawable)new BitmapDrawable(this.context.getResources(), this.lastBiptmap));
        }
        if (!this.hasSurface) {
            this.surfaceView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        }
        AudioManager audioService = (AudioManager)this.context.getSystemService("audio");
        if (audioService.getRingerMode() != 2) {
            this.playBeep = false;
        }
        this.initBeepSound();
        if (isSysEvent && this.mRunning) {
            this.mRunning = false;
            this.start();
        }
    }

    private AbsoluteLayout.LayoutParams setLayoutParams() {
        int surfaceViewHeight;
        int surfaceViewWidth;
        CameraManager.sScreenWidth = this.context.getResources().getDisplayMetrics().widthPixels;
        CameraManager.sScreenAllHeight = this.context.getResources().getDisplayMetrics().heightPixels;
        Rect gatherRect = DetectorViewConfig.getInstance().gatherRect;
        gatherRect.left = 0;
        gatherRect.top = 0;
        gatherRect.right = this.viewWidth;
        gatherRect.bottom = this.viewHeight;
        Point camearResolution = this.isVerticalScreen ? CameraManager.getCR((int)gatherRect.height(), (int)gatherRect.width()) : CameraManager.getCR((int)gatherRect.width(), (int)gatherRect.height());
        if (camearResolution == null) {
            camearResolution = new Point(this.viewWidth, this.viewHeight);
        }
        int left = 0;
        int top = 0;
        if (this.isVerticalScreen) {
            surfaceViewWidth = this.viewWidth;
            surfaceViewHeight = surfaceViewWidth * camearResolution.x / camearResolution.y;
            if (surfaceViewHeight < this.viewHeight) {
                surfaceViewHeight = this.viewHeight;
                surfaceViewWidth = surfaceViewHeight * camearResolution.y / camearResolution.x;
                DetectorViewConfig.detectorRectOffestLeft = left = (this.viewWidth - surfaceViewWidth) / 2;
                DetectorViewConfig.detectorRectOffestTop = 0;
            } else {
                surfaceViewHeight = surfaceViewWidth * camearResolution.x / camearResolution.y;
                DetectorViewConfig.detectorRectOffestTop = top = (this.viewHeight - surfaceViewHeight) / 2;
                DetectorViewConfig.detectorRectOffestLeft = 0;
            }
        } else {
            surfaceViewHeight = this.viewHeight;
            surfaceViewWidth = surfaceViewHeight * camearResolution.x / camearResolution.y;
            if (surfaceViewWidth < this.viewWidth) {
                surfaceViewWidth = this.viewWidth;
                surfaceViewHeight = surfaceViewWidth * camearResolution.y / camearResolution.x;
                DetectorViewConfig.detectorRectOffestTop = top = (this.viewHeight - surfaceViewHeight) / 2;
                DetectorViewConfig.detectorRectOffestLeft = 0;
            } else {
                surfaceViewWidth = surfaceViewHeight * camearResolution.x / camearResolution.y;
                DetectorViewConfig.detectorRectOffestLeft = left = (this.viewWidth - surfaceViewWidth) / 2;
                DetectorViewConfig.detectorRectOffestTop = 0;
            }
        }
        AbsoluteLayout.LayoutParams lllp = new AbsoluteLayout.LayoutParams(surfaceViewWidth, surfaceViewHeight, left, top);
        DetectorViewConfig.getInstance().initSurfaceViewRect(left, top, surfaceViewWidth, surfaceViewHeight);
        return lllp;
    }

    public void initDecodeFormats(JSONArray filters) {
        this.decodeFormats = new Vector();
        if (filters == null || filters.size() == 0) {
            this.decodeFormats.add(BarcodeFormat.EAN_13);
            this.decodeFormats.add(BarcodeFormat.EAN_8);
            this.decodeFormats.add(BarcodeFormat.QR_CODE);
        } else {
            int size = filters.size();
            for (int i = 0; i < size; ++i) {
                int filter = -1;
                try {
                    filter = filters.getInteger(i);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (filter == -1) continue;
                this.decodeFormats.add(this.convertNumToBarcodeFormat(filter));
            }
        }
    }

    private BarcodeFormat convertNumToBarcodeFormat(int num) {
        BarcodeFormat _ret = null;
        switch (num) {
            case 0: {
                _ret = BarcodeFormat.QR_CODE;
                break;
            }
            case 1: {
                _ret = BarcodeFormat.EAN_13;
                break;
            }
            case 2: {
                _ret = BarcodeFormat.EAN_8;
                break;
            }
            case 3: {
                _ret = BarcodeFormat.AZTEC;
                break;
            }
            case 4: {
                _ret = BarcodeFormat.DATA_MATRIX;
                break;
            }
            case 5: {
                _ret = BarcodeFormat.UPC_A;
                break;
            }
            case 6: {
                _ret = BarcodeFormat.UPC_E;
                break;
            }
            case 7: {
                _ret = BarcodeFormat.CODABAR;
                break;
            }
            case 8: {
                _ret = BarcodeFormat.CODE_39;
                break;
            }
            case 9: {
                _ret = BarcodeFormat.CODE_93;
                break;
            }
            case 10: {
                _ret = BarcodeFormat.CODE_128;
                break;
            }
            case 11: {
                _ret = BarcodeFormat.ITF;
                break;
            }
            case 12: {
                _ret = BarcodeFormat.MAXICODE;
                break;
            }
            case 13: {
                _ret = BarcodeFormat.PDF_417;
                break;
            }
            case 14: {
                _ret = BarcodeFormat.RSS_14;
                break;
            }
            case 15: {
                _ret = BarcodeFormat.RSS_EXPANDED;
            }
        }
        return _ret;
    }

    private int convertTypestrToNum(BarcodeFormat format) {
        if (format == BarcodeFormat.QR_CODE) {
            return 0;
        }
        if (format == BarcodeFormat.EAN_13) {
            return 1;
        }
        if (format == BarcodeFormat.EAN_8) {
            return 2;
        }
        if (format == BarcodeFormat.AZTEC) {
            return 3;
        }
        if (format == BarcodeFormat.DATA_MATRIX) {
            return 4;
        }
        if (format == BarcodeFormat.UPC_A) {
            return 5;
        }
        if (format == BarcodeFormat.UPC_E) {
            return 6;
        }
        if (format == BarcodeFormat.CODABAR) {
            return 7;
        }
        if (format == BarcodeFormat.CODE_39) {
            return 8;
        }
        if (format == BarcodeFormat.CODE_93) {
            return 9;
        }
        if (format == BarcodeFormat.CODE_128) {
            return 10;
        }
        if (format == BarcodeFormat.ITF) {
            return 11;
        }
        if (format == BarcodeFormat.MAXICODE) {
            return 12;
        }
        if (format == BarcodeFormat.PDF_417) {
            return 13;
        }
        if (format == BarcodeFormat.RSS_14) {
            return 14;
        }
        if (format == BarcodeFormat.RSS_EXPANDED) {
            return 15;
        }
        return -1000;
    }

    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public void autoFocus() {
        this.handler.autoFocus();
    }

    public void handleDecode(Result obj, Bitmap barcode) {
        this.inactivityTimer.onActivity();
        this.playBeepSoundAndVibrate();
        boolean saveSuc = false;
        String realPath = null;
        if (this.mConserve) {
            if (!(PdrUtil.isEmpty((Object)this.mFilename) || PdrUtil.isDeviceRootDir((String)this.mFilename) || this.mFilename.startsWith("_doc"))) {
                this.mFilename = "_doc" + this.mFilename;
            }
            realPath = this.mInstance.rewriteUri(Uri.parse((String)this.mFilename), "image").getPath();
            saveSuc = PdrUtil.saveBitmapToFile((Bitmap)barcode, (String)realPath);
        }
        int num = this.convertTypestrToNum(obj.getBarcodeFormat());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", num);
        params.put("message", obj.getText());
        if (saveSuc && !PdrUtil.isEmpty((Object)realPath)) {
            params.put("file", realPath);
        }
        params.put("type", "success");
        params.put("charSet", obj.textCharset);
        this.fireEvent("marked", params);
        this.cancelScan();
    }

    private void cancel() {
        if (this.mRunning) {
            if (this.handler != null) {
                this.handler.stopDecode();
            }
            this.getViewfinderView().stopUpdateScreenTimer();
            this.mRunning = false;
        }
    }

    private void initBeepSound() {
        if (this.mediaPlayer == null) {
            ((Activity)this.context).setVolumeControlStream(3);
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setOnCompletionListener(this.beepListener);
            try {
                AssetFileDescriptor file = this.context.getResources().getAssets().openFd("res/dcloud_beep.ogg");
                this.mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
                file.close();
                this.mediaPlayer.setVolume(0.8f, 0.8f);
                this.mediaPlayer.prepare();
            }
            catch (IOException e) {
                this.mediaPlayer = null;
            }
        }
    }

    private void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            try {
                Vibrator vibrator = (Vibrator)this.context.getSystemService("vibrator");
                vibrator.vibrate(200L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.isSurfaceAvaliable = true;
        if (!this.hasSurface) {
            this.hasSurface = true;
            if (!this.isCancelScan) {
                // empty if block
            }
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.hasSurface = false;
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.nopermission) {
            TextPaint paint = new TextPaint();
            paint.setColor(-1);
            paint.setTextSize((float)PdrUtil.pxFromDp((float)18.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics()));
            paint.setTextAlign(Paint.Align.CENTER);
            Paint.FontMetrics fontMetrics = paint.getFontMetrics();
            float top = fontMetrics.top;
            float bottom = fontMetrics.bottom;
            int baseLineY = (int)((float)this.viewHeight / 2.0f - top / 2.0f - bottom / 2.0f);
            int pl = this.viewWidth / 2;
            String language = Build.VERSION.SDK_INT >= 24 ? this.getResources().getConfiguration().getLocales().get(0).getLanguage() : this.getResources().getConfiguration().locale.getLanguage();
            if (language.equalsIgnoreCase("en")) {
                canvas.drawText("Need camera permission", (float)pl, (float)baseLineY, (Paint)paint);
            } else {
                canvas.drawText("\u672a\u83b7\u5f97\u76f8\u673a\u6743\u9650", (float)pl, (float)baseLineY, (Paint)paint);
            }
        }
    }

    private void fireEvent(String type, Map<String, Object> params) {
        if (this.component.containsEvent(type)) {
            HashMap<String, Object> detail = new HashMap<String, Object>();
            detail.put("detail", params);
            this.component.fireEvent(type, detail);
        }
    }
}

