/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.weex;

import android.os.Handler;
import android.view.MotionEvent;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import java.util.Map;
import java.util.Set;

public class ViewHover {
    public static final String VIEW_HOVER_EVENT = "view_hover_event";
    private boolean hoverStopPropagation = false;
    private JSONObject hoverClass = null;
    private int hoverStartTime = 50;
    private int hoverStayTime = 400;
    private WXComponent component;
    private boolean isHover = false;
    private Map<String, Object> originalStyles;
    private boolean isReceiveTouch = true;
    private Handler handler = new Handler();
    public Runnable touchStartRunnable = new Runnable(){

        @Override
        public void run() {
            if (ViewHover.this.isHover) {
                return;
            }
            if (ViewHover.this.component != null && ViewHover.this.component.getInstance() != null) {
                ViewHover.this.originalStyles = ViewHover.this.component.getStyles().clone();
                ViewHover.this.component.setHoverClassStatus(true);
            }
        }
    };
    public Runnable touchEndRunnable = new Runnable(){

        @Override
        public void run() {
            if (ViewHover.this.component != null && ViewHover.this.component.getInstance() != null) {
                ViewHover.this.component.setHoverClassStatus(false);
                ViewHover.this.isHover = false;
            }
        }
    };

    public ViewHover(WXComponent component) {
        this(component, null);
    }

    public ViewHover(WXComponent component, JSONObject data) {
        this.update(data);
        this.component = component;
    }

    public void update(JSONObject data) {
        if (data == null) {
            return;
        }
        if (this.hoverClass == null) {
            this.hoverClass = data;
        } else {
            this.hoverClass.putAll((Map)data);
        }
    }

    public boolean isHoverStopPropagation() {
        return this.hoverStopPropagation;
    }

    public void setHoverStopPropagation(boolean hoverStopPropagation) {
        this.hoverStopPropagation = hoverStopPropagation;
    }

    public int getHoverStartTime() {
        return this.hoverStartTime;
    }

    public void setHoverStartTime(int hoverStartTime) {
        this.hoverStartTime = hoverStartTime;
    }

    public int getHoverStayTime() {
        return this.hoverStayTime;
    }

    public void setHoverStayTime(int hoverStayTime) {
        this.hoverStayTime = hoverStayTime;
    }

    public void handleMotionEvent(WXGestureType wxGestureType, MotionEvent motionEvent) {
        if (this.hoverClass == null || !this.isReceiveTouch) {
            return;
        }
        switch (wxGestureType.toString()) {
            case "touchstart": {
                this.handler.removeCallbacks(this.touchEndRunnable);
                this.handler.removeCallbacks(this.touchStartRunnable);
                this.handler.postDelayed(this.touchStartRunnable, (long)this.hoverStartTime);
                break;
            }
            case "touchmove": {
                break;
            }
            case "touchend": {
                this.isHover = true;
                this.handler.removeCallbacks(this.touchEndRunnable);
                this.handler.postDelayed(this.touchEndRunnable, (long)this.hoverStayTime);
                break;
            }
            case "touchcancel": {
                this.isHover = true;
                this.handler.removeCallbacks(this.touchEndRunnable);
                this.handler.postDelayed(this.touchEndRunnable, (long)this.hoverStayTime);
            }
        }
    }

    public Map<String, Object> updateStatusAndGetUpdateStyles(boolean status) {
        JSONObject resultStyles = new JSONObject();
        if (status) {
            resultStyles = this.hoverClass;
        } else if (this.originalStyles != null) {
            Set keys = this.hoverClass.keySet();
            resultStyles = new JSONObject();
            for (String key : keys) {
                if (this.originalStyles.containsKey(key)) {
                    resultStyles.put(key, this.originalStyles.get(key));
                    continue;
                }
                resultStyles.put(key, "");
            }
        }
        return resultStyles;
    }

    public void setReceiveTouch(boolean receiveTouch) {
        this.isReceiveTouch = receiveTouch;
    }

    public void destroy() {
        this.component = null;
        this.originalStyles = null;
    }
}

