/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Choreographer;
import androidx.annotation.NonNull;

abstract class AnimationFrame {
    AnimationFrame() {
    }

    static AnimationFrame newInstance() {
        AnimationFrame frame = null;
        frame = Build.VERSION.SDK_INT >= 16 ? new ChoreographerAnimationFrameImpl() : new HandlerAnimationFrameImpl();
        return frame;
    }

    abstract void clear();

    abstract void terminate();

    abstract void requestAnimationFrame(@NonNull Callback var1);

    private static class HandlerAnimationFrameImpl
    extends AnimationFrame
    implements Handler.Callback {
        private HandlerThread mInnerHandlerThread;
        private Handler mInnerHandler;
        private Callback callback;
        private boolean isRunning;
        private static final int MSG_FRAME_CALLBACK = 100;
        private static final long DEFAULT_DELAY_MILLIS = 16L;

        HandlerAnimationFrameImpl() {
            if (this.mInnerHandlerThread != null) {
                this.terminate();
            }
            this.mInnerHandlerThread = new HandlerThread("expression-timing-thread");
            this.mInnerHandlerThread.start();
            this.mInnerHandler = new Handler(this.mInnerHandlerThread.getLooper(), (Handler.Callback)this);
        }

        @Override
        void clear() {
            if (this.mInnerHandler != null) {
                this.mInnerHandler.removeCallbacksAndMessages(null);
            }
            this.isRunning = false;
        }

        @Override
        void terminate() {
            this.clear();
            if (Build.VERSION.SDK_INT >= 18) {
                this.mInnerHandlerThread.quitSafely();
            } else {
                this.mInnerHandlerThread.quit();
            }
            this.mInnerHandler = null;
            this.mInnerHandlerThread = null;
        }

        @Override
        void requestAnimationFrame(@NonNull Callback callback) {
            this.callback = callback;
            this.isRunning = true;
            if (this.mInnerHandler != null) {
                this.mInnerHandler.sendEmptyMessage(100);
            }
        }

        public boolean handleMessage(Message msg) {
            if (msg != null && msg.what == 100 && this.mInnerHandler != null) {
                if (this.callback != null) {
                    this.callback.doFrame();
                }
                if (this.isRunning) {
                    this.mInnerHandler.sendEmptyMessageDelayed(100, 16L);
                }
                return true;
            }
            return false;
        }
    }

    @TargetApi(value=16)
    private static class ChoreographerAnimationFrameImpl
    extends AnimationFrame
    implements Choreographer.FrameCallback {
        private Choreographer choreographer;
        private Callback callback;
        private boolean isRunning;

        @TargetApi(value=16)
        ChoreographerAnimationFrameImpl() {
            if (Looper.myLooper() == null) {
                Looper.prepare();
            }
            this.choreographer = Choreographer.getInstance();
        }

        @Override
        void clear() {
            if (this.choreographer != null) {
                this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
            }
            this.isRunning = false;
        }

        @Override
        void terminate() {
            this.clear();
            this.choreographer = null;
        }

        @Override
        void requestAnimationFrame(@NonNull Callback callback) {
            this.callback = callback;
            this.isRunning = true;
            if (this.choreographer != null) {
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }

        public void doFrame(long frameTimeNanos) {
            if (this.callback != null) {
                this.callback.doFrame();
            }
            if (this.choreographer != null && this.isRunning) {
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }
    }

    static interface Callback {
        public void doFrame();
    }
}

