/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import com.daasuu.mp4compose.filter.GlFilter;
import com.daasuu.mp4compose.utils.EglUtil;

public class GlLut512Filter
extends GlFilter {
    private int hTex;
    private final int NO_TEXTURE = -1;
    private Bitmap lutTexture;
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;uniform mediump sampler2D lutTexture; \nuniform lowp sampler2D sTexture; \nvarying vec2 vTextureCoord; \nvec4 lookup(in vec4 textureColor, in sampler2D lookupTable);\nvoid main() {\n   vec4 color = texture2D(sTexture, vTextureCoord);\n   gl_FragColor = lookup(color, lutTexture);\n }\nvec4 lookup(in vec4 textureColor, in sampler2D lookupTable) {\n  textureColor = clamp(textureColor, 0.0, 1.0);\n  mediump float blueColor = textureColor.b * 63.0;\n  \n  mediump vec2 quad1;\n  quad1.y = floor(floor(blueColor) / 8.0);\n  quad1.x = floor(blueColor) - (quad1.y * 8.0);\n  \n  mediump vec2 quad2;\n  quad2.y = floor(ceil(blueColor) / 8.0);\n  quad2.x = ceil(blueColor) - (quad2.y * 8.0);\n  \n  highp vec2 texPos1;\n  texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);\n  texPos1.y = (quad1.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);\n  \n  highp vec2 texPos2;\n  texPos2.x = (quad2.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);\n  texPos2.y = (quad2.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);\n  \n  lowp vec4 newColor1 = texture2D(lookupTable, texPos1);\n  lowp vec4 newColor2 = texture2D(lookupTable, texPos2);\n  \n  lowp vec4 newColor = mix(newColor1, newColor2, fract(blueColor));\n  return newColor;\n}";

    public GlLut512Filter(Bitmap bitmap) {
        super("attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n", FRAGMENT_SHADER);
        this.lutTexture = bitmap;
        this.hTex = -1;
    }

    public GlLut512Filter(Resources resources, int fxID) {
        super("attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n", FRAGMENT_SHADER);
        this.lutTexture = BitmapFactory.decodeResource((Resources)resources, (int)fxID);
        this.hTex = -1;
    }

    @Override
    public void setup() {
        super.setup();
        this.loadTexture();
    }

    private void loadTexture() {
        if (this.hTex == -1) {
            this.hTex = EglUtil.loadTexture(this.lutTexture, -1, false);
        }
    }

    @Override
    public void onDraw() {
        int offsetDepthMapTextureUniform = this.getHandle("lutTexture");
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)3553, (int)this.hTex);
        GLES20.glUniform1i((int)offsetDepthMapTextureUniform, (int)3);
    }
}

