/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.extend;

import android.net.Uri;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.SimpleJSCallback;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.feature.internal.sdk.SDK;
import io.dcloud.feature.uniapp.common.UniModule;
import io.dcloud.feature.weex.EnumStateCode;
import io.dcloud.feature.weex.WeexInstanceMgr;
import java.util.HashMap;

public class DCUniMPModule
extends UniModule {
    @JSMethod
    public void showUniMP(final String appId, final JSCallback callback) {
        MessageHandler.post((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (SDK.isUniMP) {
                        if (callback != null) {
                            callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
                        }
                    } else {
                        if (TextUtils.isEmpty((CharSequence)appId)) {
                            if (callback != null) {
                                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
                            }
                            return;
                        }
                        IWebview hostWebview = WeexInstanceMgr.self().findWebview(DCUniMPModule.this.mWXSDKInstance);
                        if (hostWebview != null) {
                            ICallBack callBack = new ICallBack(){

                                public Object onCallBack(int pType, Object pArgs) {
                                    HashMap<String, Object> data = new HashMap<String, Object>();
                                    if (pType >= 0) {
                                        data.put("type", "success");
                                        data.put("code", 0);
                                    } else {
                                        data.put("type", "fail");
                                        data.put("code", pType);
                                        data.put("message", pArgs != null ? pArgs.toString() : "Unknown error");
                                    }
                                    if (callback != null) {
                                        callback.invoke(data);
                                    }
                                    return null;
                                }
                            };
                            Object[] objects = new Object[]{hostWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "showUniMP", new Object[]{appId, callBack}};
                            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JSMethod
    public void closeUniMP(final String appId, final JSCallback callback) {
        MessageHandler.post((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (SDK.isUniMP) {
                        if (callback != null) {
                            callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
                        }
                    } else {
                        if (TextUtils.isEmpty((CharSequence)appId)) {
                            if (callback != null) {
                                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
                            }
                            return;
                        }
                        IWebview hostWebview = WeexInstanceMgr.self().findWebview(DCUniMPModule.this.mWXSDKInstance);
                        if (hostWebview != null) {
                            ICallBack callBack = new ICallBack(){

                                public Object onCallBack(int pType, Object pArgs) {
                                    HashMap<String, Object> data = new HashMap<String, Object>();
                                    if (pType >= 0) {
                                        data.put("type", "success");
                                        data.put("code", 0);
                                    } else {
                                        data.put("type", "fail");
                                        data.put("code", pType);
                                        data.put("message", pArgs != null ? pArgs.toString() : "Unknown error");
                                    }
                                    if (callback != null) {
                                        callback.invoke(data);
                                    }
                                    return null;
                                }
                            };
                            Object[] objects = new Object[]{hostWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "closeUniMP", new Object[]{appId, callBack}};
                            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JSMethod
    public void hideUniMP(final String appId, final JSCallback callback) {
        MessageHandler.post((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (SDK.isUniMP) {
                        if (callback != null) {
                            callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
                        }
                    } else {
                        if (TextUtils.isEmpty((CharSequence)appId)) {
                            if (callback != null) {
                                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
                            }
                            return;
                        }
                        IWebview hostWebview = WeexInstanceMgr.self().findWebview(DCUniMPModule.this.mWXSDKInstance);
                        if (hostWebview != null) {
                            ICallBack callBack = new ICallBack(){

                                public Object onCallBack(int pType, Object pArgs) {
                                    HashMap<String, Object> data = new HashMap<String, Object>();
                                    if (pType >= 0) {
                                        data.put("type", "success");
                                        data.put("code", 0);
                                    } else {
                                        data.put("type", "fail");
                                        data.put("code", pType);
                                        data.put("message", pArgs != null ? pArgs.toString() : "Unknown error");
                                    }
                                    if (callback != null) {
                                        callback.invoke(data);
                                    }
                                    return null;
                                }
                            };
                            Object[] objects = new Object[]{hostWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "hideUniMP", new Object[]{appId, callBack}};
                            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JSMethod
    public void setDefaultMenuItems(String opStr, final JSCallback callback) {
        JSONObject op = null;
        try {
            op = JSON.parseObject((String)opStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!SDK.isUniMPSDK()) {
            if (op != null) {
                ICallBack callBack = new ICallBack(){

                    public Object onCallBack(int pType, Object pArgs) {
                        JSONObject resultArgs = JSON.parseObject((String)String.valueOf(pArgs));
                        String resultAppId = resultArgs.getString("appId");
                        String resultClickId = resultArgs.getString("id");
                        if (TextUtils.isEmpty((CharSequence)resultAppId) || TextUtils.isEmpty((CharSequence)resultClickId)) {
                            return null;
                        }
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("appId", resultAppId);
                        data.put("id", resultClickId);
                        if (callback != null) {
                            callback.invokeAndKeepAlive(data);
                        }
                        return null;
                    }
                };
                IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
                if (hostWebview != null) {
                    Object[] objects = new Object[]{hostWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "setDefaultMenuItems", new Object[]{opStr, callBack}};
                    WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
                }
            } else if (callback != null) {
                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
            }
        }
    }

    @JSMethod
    public void openUniMP(final String opStr, final JSCallback callback) {
        MessageHandler.post((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject op = null;
                    try {
                        op = JSON.parseObject((String)opStr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (SDK.isUniMP) {
                        if (callback != null) {
                            callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
                        }
                    } else {
                        if (op == null) {
                            if (callback != null) {
                                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
                            }
                            return;
                        }
                        IWebview hostWebview = WeexInstanceMgr.self().findWebview(DCUniMPModule.this.mWXSDKInstance);
                        if (hostWebview != null) {
                            ICallBack callBack = new ICallBack(){

                                public Object onCallBack(int pType, Object pArgs) {
                                    HashMap<String, Object> data = new HashMap<String, Object>();
                                    if (pType >= 0) {
                                        data.put("type", "success");
                                        data.put("code", 0);
                                    } else {
                                        data.put("type", "fail");
                                        data.put("code", pType);
                                        data.put("message", pArgs != null ? pArgs.toString() : "Unknown error");
                                    }
                                    if (callback != null) {
                                        callback.invoke(data);
                                    }
                                    return null;
                                }
                            };
                            op.put("appInfo", (Object)hostWebview.obtainApp().obtainAppInfo());
                            Object[] objects = new Object[]{hostWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "openUniMP", new Object[]{op.toJSONString(), callBack}};
                            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JSMethod
    public void installUniMP(String opStr, final JSCallback callback) {
        JSONObject op = null;
        try {
            op = JSON.parseObject((String)opStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (SDK.isUniMPSDK()) {
            if (callback != null) {
                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
            }
        } else if (op != null) {
            String appid = op.getString("appid");
            String wgtFile = op.getString("wgtFile");
            String password = "";
            if (op.containsKey((Object)"password")) {
                password = op.getString("password");
            }
            if (!TextUtils.isEmpty((CharSequence)wgtFile)) {
                Uri uri = this.mUniSDKInstance.rewriteUri(Uri.parse((String)wgtFile), "file");
                if (uri != null) {
                    wgtFile = uri.getPath();
                }
            } else if (callback != null) {
                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_RESOURCE_EXIST));
            }
            ICallBack callBack = new ICallBack(){

                public Object onCallBack(int pType, Object pArgs) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    if (pType >= 0) {
                        data.put("type", "success");
                        data.put("code", 0);
                    } else {
                        data.put("type", "fail");
                        data.put("code", pType);
                        data.put("message", pArgs != null ? pArgs.toString() : "Unknown error");
                    }
                    if (callback != null) {
                        callback.invoke(data);
                    }
                    return null;
                }
            };
            IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
            if (hostWebview != null) {
                Object[] objects = new Object[]{hostWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "installUniMP", new Object[]{appid, wgtFile, password, callBack}};
                WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
            }
        } else if (callback != null) {
            callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
        }
    }

    @JSMethod
    public void sendUniMPEvent(String appid, String event, String data, final JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)appid) || TextUtils.isEmpty((CharSequence)event)) {
            if (callback != null) {
                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
            }
            return;
        }
        if (SDK.isUniMPSDK()) {
            if (callback != null) {
                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
            }
            return;
        }
        String appIdParam = appid;
        String eventParam = event;
        String dataParam = data;
        JSONObject dataParamObject = JSON.parseObject((String)data);
        if (dataParamObject != null) {
            dataParam = dataParamObject;
        }
        ICallBack callBack = new ICallBack(){

            public Object onCallBack(int pType, Object pArgs) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                if (pType >= 0) {
                    data.put("type", "success");
                    data.put("code", 0);
                } else {
                    data.put("type", "fail");
                    data.put("code", pType);
                    data.put("message", pArgs != null ? pArgs.toString() : "Unknown error");
                }
                if (callback != null) {
                    callback.invoke(data);
                }
                return null;
            }
        };
        IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        if (hostWebview != null) {
            Object[] objects = new Object[]{hostWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "sendUniMPEvent", new Object[]{appIdParam, eventParam, dataParam, callBack}};
            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
        }
    }

    @JSMethod
    public void getUniMPVersion(String appid, final JSCallback callback) {
        HashMap data = new HashMap();
        if (SDK.isUniMPSDK()) {
            if (callback != null) {
                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
            }
        } else {
            IWebview hostWebview;
            if ((TextUtils.isEmpty((CharSequence)appid) || !appid.startsWith("__UNI__")) && callback != null) {
                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
            }
            if ((hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance)) != null) {
                ICallBack callBack = new ICallBack(){

                    public Object onCallBack(int pType, Object pArgs) {
                        if (pArgs == null) {
                            if (callback != null) {
                                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_RESOURCE_EXIST));
                            }
                        } else {
                            JSONObject object = JSON.parseObject((String)pArgs.toString());
                            if (callback != null) {
                                callback.invoke(EnumStateCode.obtainMap(EnumStateCode.SUCCESS_NO_BODY, "versionInfo", object));
                            }
                        }
                        return null;
                    }
                };
                Object[] objects = new Object[]{hostWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "getUniMPVersion", new Object[]{appid, callBack}};
                WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
            }
        }
    }

    @JSMethod
    public void onUniMPEventReceive(JSCallback callback) {
        IWebview hostWebview;
        if (!SDK.isUniMPSDK() && (hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance)) != null && callback instanceof SimpleJSCallback) {
            Object[] objects = new Object[]{hostWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "onUniMPEventReceive", new Object[]{hostWebview.obtainApp().obtainAppId(), this.mWXSDKInstance.getInstanceId(), ((SimpleJSCallback)callback).getCallbackId()}};
            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
        }
    }
}

