/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.helper;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.android.AudioDispatcherFactory;
import be.tarsos.dsp.pitch.PitchDetectionHandler;
import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchProcessor;

public class MusicTunerHelper {
    private AudioDispatcher mDispatcher;
    private Thread mThread;
    private OnEventListener onEventListener;

    public MusicTunerHelper(OnEventListener onEventListener) {
        this.onEventListener = onEventListener;
    }

    public void start() {
        this.mDispatcher = AudioDispatcherFactory.fromDefaultMicrophone((int)44100, (int)6144, (int)0);
        PitchDetectionHandler pdh = new PitchDetectionHandler(){

            public void handlePitch(PitchDetectionResult res, AudioEvent e) {
                float pitchInHz = res.getPitch();
                float probability = res.getProbability();
                if (MusicTunerHelper.this.onEventListener != null) {
                    MusicTunerHelper.this.onEventListener.onResult(pitchInHz);
                }
            }
        };
        PitchProcessor p = new PitchProcessor(PitchProcessor.PitchEstimationAlgorithm.FFT_YIN, 44100.0f, 6144, pdh);
        this.mDispatcher.addAudioProcessor((AudioProcessor)p);
        this.mThread = new Thread((Runnable)this.mDispatcher, "Audio Dispatcher");
        this.mThread.start();
    }

    public void stop() {
        try {
            if (this.mDispatcher != null) {
                this.mDispatcher.stop();
            }
            if (this.mThread != null) {
                this.mThread.interrupt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void release() {
        this.stop();
        if (this.mDispatcher != null) {
            this.mDispatcher = null;
        }
    }

    public static interface OnEventListener {
        public void onResult(float var1);
    }
}

