/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.decoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.tencent.thumbplayer.core.common.TPCodecUtils;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.common.TPSystemInfo;
import com.tencent.thumbplayer.core.decoder.ITPMediaCodecDecoder;
import com.tencent.thumbplayer.core.decoder.TPFrameInfo;
import com.tencent.thumbplayer.core.decoder.TPMediaCodecManager;
import com.tencent.thumbplayer.core.decoder.TPMediaDrmInfo;
import com.tencent.thumbplayer.g.a.b;
import com.tencent.thumbplayer.g.b;
import com.tencent.thumbplayer.g.h.a;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

@RequiresApi(api=16)
public abstract class TPBaseMediaCodecDecoder
implements ITPMediaCodecDecoder {
    private static final int MEDIA_CODEC_ERROR_INDEX = -1000;
    private static long MEDIA_CODEC_INPUT_TIMEOUT_US = 2000L;
    private static long MEDIA_CODEC_OUTPUT_TIMEOUT_US = 2000L;
    private static final int DUMP_BYTE_BUFFER_BYTES = 100;
    private static final int DUMP_ONE_LINE_BYTES = 20;
    private static boolean sTMediaCodecInited = false;
    private com.tencent.thumbplayer.g.b mCodec = null;
    protected Surface mSurface = null;
    protected boolean mStarted = false;
    private TPFrameInfo mFrameInfo = new TPFrameInfo();
    private boolean mEnableSetOutputSurfaceApi = false;
    private MediaCodec.CryptoInfo mCryptoInfo = null;
    protected MediaCrypto mMediaCrypto = null;
    protected boolean mEnableAsyncMode = false;
    private HandlerThread mDecodeThread = null;
    private AsyncDecodeHandler mDecoderHandler = null;
    private BlockingQueue<Integer> mInputQueue = new LinkedBlockingQueue<Integer>();
    private BlockingQueue<TPFrameInfo> mOutputQueue = new LinkedBlockingQueue<TPFrameInfo>();
    private boolean mRestartCodecOnException = false;
    protected int mDrmType = -1;
    private boolean mEnableAudioPassThrough = false;
    protected boolean mEnableMediaCodecReuse = false;
    protected int mCodecId;
    private static final int MSG_RELEASE_OUTPUT_BUFFER = 1000;
    private static final int MSG_SET_OUTPUT_SURFACE = 1001;
    private static final int MSG_FLUSH = 1002;
    private static final int MSG_RELEASE = 1003;
    private final Object mThreadLock = new Object();
    private int mHandlerResult = 0;

    abstract List<String> getMimeCandidates();

    abstract String getCodecName(@NonNull String var1, boolean var2);

    abstract void configCodec(@NonNull com.tencent.thumbplayer.g.b var1, @NonNull String var2);

    abstract void processOutputFormatChanged(@NonNull MediaFormat var1);

    abstract void processOutputBuffer(@NonNull com.tencent.thumbplayer.g.b var1, int var2, @NonNull MediaCodec.BufferInfo var3, @NonNull TPFrameInfo var4);

    abstract void processOutputConfigData(@NonNull com.tencent.thumbplayer.g.b var1, int var2, @NonNull MediaCodec.BufferInfo var3, @NonNull TPFrameInfo var4);

    abstract void processMediaCodecException(Exception var1);

    abstract String getLogTag();

    private static synchronized void initTMediaCodec() {
        if (sTMediaCodecInited) {
            return;
        }
        com.tencent.thumbplayer.g.a.b();
        com.tencent.thumbplayer.g.a.a().a(true);
        com.tencent.thumbplayer.g.a.a().a(new a(){

            @Override
            public final void v(@NonNull String string, @NonNull String string2) {
                TPNativeLog.printLog(0, string, string2);
            }

            @Override
            public final void d(@NonNull String string, @NonNull String string2) {
                TPNativeLog.printLog(1, string, string2);
            }

            @Override
            public final void i(@NonNull String string, @NonNull String string2) {
                TPNativeLog.printLog(2, string, string2);
            }

            @Override
            public final void w(@NonNull String string, @NonNull String string2, @Nullable Throwable throwable) {
                TPNativeLog.printLog(3, string, string2);
            }

            @Override
            public final void e(@NonNull String string, @NonNull String string2, @Nullable Throwable throwable) {
                TPNativeLog.printLog(4, string, string2);
            }
        });
        sTMediaCodecInited = true;
    }

    public TPBaseMediaCodecDecoder(int n2) {
        this.mCodecId = n2;
        TPBaseMediaCodecDecoder.initTMediaCodec();
    }

    private boolean initMediaCodecInternal() {
        try {
            int n2;
            String string = null;
            List<String> list = this.getMimeCandidates();
            String string2 = null;
            boolean bl2 = false;
            for (n2 = 0; n2 < list.size() && string == null; ++n2) {
                string2 = list.get(n2);
                TPNativeLog.printLog(2, this.getLogTag(), "initMediaCodec with mime:" + string2 + " mDrmType:" + this.mDrmType);
                bl2 = this.mMediaCrypto != null ? this.mMediaCrypto.requiresSecureDecoderComponent(string2) : false;
                if (bl2 && TPCodecUtils.isInDRMLevel1Blacklist(this.mDrmType)) {
                    TPNativeLog.printLog(2, this.getLogTag(), "Device " + TPSystemInfo.getDeviceName() + " DrmType " + this.mDrmType + " fallback to L3.");
                    bl2 = false;
                }
                string = this.getCodecName(string2, bl2);
                TPNativeLog.printLog(2, this.getLogTag(), "initMediaCodec got codecName:" + string + " secureComponent " + bl2);
            }
            if (string == null) {
                TPNativeLog.printLog(4, this.getLogTag(), "initMediaCodec failed, codecName is null.");
                return false;
            }
            if ("audio/vnd.dts".equals(string2)) {
                TPNativeLog.printLog(2, this.getLogTag(), "initMediaCodec current mime type:" + string2 + " is audio dts, need set input timeout to 0!");
                MEDIA_CODEC_INPUT_TIMEOUT_US = 0L;
                MEDIA_CODEC_OUTPUT_TIMEOUT_US = 0L;
            }
            this.mCodec = com.tencent.thumbplayer.g.b.a(string);
            this.mCodec.a(this.mEnableMediaCodecReuse && !this.mEnableAsyncMode);
            this.mCodec.a(new b(){

                @Override
                public void onStarted(Boolean bl2, String string) {
                    super.onStarted(bl2, string);
                    TPMediaCodecManager.onMediaCodecReady(TPBaseMediaCodecDecoder.this.mCodecId, string);
                }

                @Override
                public void onReuseCodecAPIException(String string, Throwable throwable) {
                    super.onReuseCodecAPIException(string, throwable);
                    TPMediaCodecManager.onMediaCodecException(TPBaseMediaCodecDecoder.this.mCodecId, string);
                }
            });
            TPNativeLog.printLog(2, this.getLogTag(), "initMediaCodec codec name: ".concat(String.valueOf(string)));
            if (this.mEnableAsyncMode && Build.VERSION.SDK_INT >= 23) {
                TPNativeLog.printLog(2, this.getLogTag(), "MediaCodec EnableAsyncMode\uff01");
                this.mDecodeThread = new HandlerThread("MediaCodecThread");
                this.mDecodeThread.start();
                TPBaseMediaCodecDecoder tPBaseMediaCodecDecoder = this;
                this.mDecoderHandler = tPBaseMediaCodecDecoder.new AsyncDecodeHandler(tPBaseMediaCodecDecoder.mDecodeThread.getLooper());
                this.mCodec.a(new BufferCallback(), this.mDecoderHandler);
            }
            TPMediaCodecManager.onMediaCodecReportEvent(this.mCodecId, 1);
            TPBaseMediaCodecDecoder tPBaseMediaCodecDecoder = this;
            tPBaseMediaCodecDecoder.configCodec(tPBaseMediaCodecDecoder.mCodec, string2);
            TPMediaCodecManager.onMediaCodecReportEvent(this.mCodecId, 2);
            TPMediaCodecManager.onMediaCodecReportEvent(this.mCodecId, 3);
            TPNativeLog.printLog(2, this.getLogTag(), "initMediaCodec, start codec start");
            this.mCodec.e();
            TPNativeLog.printLog(2, this.getLogTag(), "initMediaCodec, start codec finished");
            TPMediaCodecManager.onMediaCodecReportEvent(this.mCodecId, 4);
            this.mStarted = true;
            if (this.mDrmType != -1) {
                n2 = TPCodecUtils.getDecoderName(string2, true) != null ? 1 : 0;
                TPMediaDrmInfo tPMediaDrmInfo = new TPMediaDrmInfo();
                new TPMediaDrmInfo().supportSecureDecoder = n2;
                tPMediaDrmInfo.supportSecureDecrypt = bl2;
                tPMediaDrmInfo.componentName = string;
                tPMediaDrmInfo.drmType = this.mDrmType;
                TPNativeLog.printLog(2, this.getLogTag(), "DRM Info: supportSecureDecoder: " + tPMediaDrmInfo.supportSecureDecoder + " supportSecureDecrypt:" + tPMediaDrmInfo.supportSecureDecrypt + " componentName: " + tPMediaDrmInfo.componentName + " drmType: " + tPMediaDrmInfo.drmType);
                TPMediaCodecManager.onMediaDrmInfo(this.mCodecId, tPMediaDrmInfo);
            }
        }
        catch (Exception exception) {
            TPMediaCodecManager.onMediaCodecReportEvent(this.mCodecId, 4);
            TPNativeLog.printLog(4, this.getLogTag(), this.getStackTrace(exception));
            return false;
        }
        return true;
    }

    @Override
    public boolean startDecoder() {
        return this.initMediaCodecInternal();
    }

    @Override
    public int decode(byte[] byArray, boolean bl2, long l2, boolean bl3) {
        if (!this.mStarted || this.mCodec == null) {
            return 101;
        }
        if (this.mEnableAsyncMode && Build.VERSION.SDK_INT >= 23) {
            return this.decodeAsync(byArray, bl2, l2, bl3);
        }
        return this.queueInputBuffer(byArray, l2, bl3);
    }

    @Override
    public void setCryptoInfo(int n2, @NonNull int[] nArray, @NonNull int[] nArray2, @NonNull byte[] byArray, @NonNull byte[] byArray2, int n3) {
        if (this.mCryptoInfo == null) {
            this.mCryptoInfo = new MediaCodec.CryptoInfo();
        }
        this.mCryptoInfo.set(n2, nArray, nArray2, byArray, byArray2, n3);
    }

    @Override
    public int setOutputSurface(Surface surface) {
        if (this.mEnableAsyncMode) {
            return this.setOutputSurfaceAsync(surface);
        }
        return this.handleSetOutputSurface(surface);
    }

    private int handleSetOutputSurface(Surface surface) {
        TPNativeLog.printLog(2, this.getLogTag(), "setOutputSurface: ".concat(String.valueOf(surface)));
        if (this.mSurface == surface) {
            TPNativeLog.printLog(3, this.getLogTag(), "setOutputSurface: set the same surface.");
            return 0;
        }
        Surface surface2 = this.mSurface;
        this.mSurface = surface;
        int n2 = 0;
        if (this.mCodec != null) {
            try {
                if (surface2 != null && surface != null && surface.isValid() && Build.VERSION.SDK_INT >= 23 && this.mEnableSetOutputSurfaceApi) {
                    this.mCodec.a(surface);
                    n2 = 0;
                } else {
                    n2 = 3;
                }
            }
            catch (Exception exception) {
                TPNativeLog.printLog(4, this.getLogTag(), "setOutputSurface onMediaCodecException:\n" + this.getStackTrace(exception));
                return 3;
            }
        }
        return n2;
    }

    @Override
    public int releaseOutputBuffer(int n2, boolean bl2) {
        if (this.mCodec == null || n2 < 0) {
            return 3;
        }
        if (this.mEnableAsyncMode) {
            return this.releaseOutputBufferAsync(n2, bl2);
        }
        return this.handleReleaseOutputBuffer(n2, bl2);
    }

    private int handleReleaseOutputBuffer(int n2, boolean bl2) {
        if (this.mCodec == null || n2 < 0) {
            return 3;
        }
        try {
            this.mCodec.a(n2, bl2);
        }
        catch (Exception exception) {
            return this.onMediaCodecException(exception);
        }
        return 0;
    }

    private void bufferSizeCheck(ByteBuffer byteBuffer, byte[] byArray) {
        if (byteBuffer.remaining() < byArray.length) {
            TPNativeLog.printLog(4, this.getLogTag(), "decodeAsync, not enough space, byteBuffer.remaining:" + byteBuffer.remaining() + ", buffer size:" + byArray.length);
            try {
                this.dumpByteArray(byArray, 0, 100, 20);
                return;
            }
            catch (Exception exception) {
                TPNativeLog.printLog(4, this.getLogTag(), exception.toString());
            }
        }
    }

    private int queueInputBuffer(byte[] byArray, long l2, boolean bl2) {
        int n2 = 103;
        try {
            ByteBuffer[] byteBufferArray = this.mCodec.j();
            int n3 = this.mCodec.a(MEDIA_CODEC_INPUT_TIMEOUT_US);
            if (n3 >= 0) {
                ByteBuffer byteBuffer = byteBufferArray[n3];
                this.bufferSizeCheck(byteBuffer, byArray);
                byteBuffer.put(byArray);
                if (bl2 && this.mCryptoInfo != null) {
                    this.mCodec.a(n3, 0, this.mCryptoInfo, l2, 0);
                } else {
                    this.mCodec.a(n3, 0, byArray.length, l2, 0);
                }
                n2 = 0;
            } else if (n3 == -1) {
                n2 = 1;
            }
        }
        catch (Exception exception) {
            return this.onMediaCodecException(exception);
        }
        return n2;
    }

    @Override
    public TPFrameInfo dequeueOutputBuffer() {
        int n2;
        if (this.mCodec == null) {
            return this.mFrameInfo;
        }
        this.resetFrameInfo();
        if (this.mEnableAsyncMode) {
            return this.dequeueOutputBufferAsync();
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        try {
            n2 = this.mCodec.a(bufferInfo, MEDIA_CODEC_OUTPUT_TIMEOUT_US);
        }
        catch (Exception exception) {
            this.mFrameInfo.errCode = this.onMediaCodecException(exception);
            return this.mFrameInfo;
        }
        if (n2 >= 0) {
            if (bufferInfo.flags == 4) {
                TPNativeLog.printLog(2, this.getLogTag(), "dequeueOutputBuffer: BUFFER_FLAG_END_OF_STREAM");
                this.mFrameInfo.errCode = 2;
            } else if (bufferInfo.flags == 2 && this.mEnableAudioPassThrough) {
                TPNativeLog.printLog(2, this.getLogTag(), "dequeueOutputBuffer: BUFFER_FLAG_CODEC_CONFIG, AudioPassThrough");
                this.mFrameInfo.bufferIndex = n2;
                this.mFrameInfo.ptsUs = bufferInfo.presentationTimeUs;
                TPBaseMediaCodecDecoder tPBaseMediaCodecDecoder = this;
                tPBaseMediaCodecDecoder.processOutputConfigData(tPBaseMediaCodecDecoder.mCodec, n2, bufferInfo, this.mFrameInfo);
            } else {
                this.mFrameInfo.bufferIndex = n2;
                this.mFrameInfo.ptsUs = bufferInfo.presentationTimeUs;
                this.mFrameInfo.errCode = 0;
                TPBaseMediaCodecDecoder tPBaseMediaCodecDecoder = this;
                tPBaseMediaCodecDecoder.processOutputBuffer(tPBaseMediaCodecDecoder.mCodec, n2, bufferInfo, this.mFrameInfo);
            }
        } else if (n2 == -2) {
            TPBaseMediaCodecDecoder tPBaseMediaCodecDecoder = this;
            tPBaseMediaCodecDecoder.processOutputFormatChanged(tPBaseMediaCodecDecoder.mCodec.i());
            this.mFrameInfo.errCode = 1;
        } else if (n2 == -1) {
            this.mFrameInfo.errCode = 1;
        } else if (n2 == -3) {
            TPNativeLog.printLog(2, this.getLogTag(), "dequeueOutputBuffer: INFO_OUTPUT_BUFFERS_CHANGED!");
            this.mFrameInfo.errCode = 1;
        } else if (bufferInfo.flags == 4) {
            TPNativeLog.printLog(2, this.getLogTag(), "dequeueOutputBuffer: BUFFER_FLAG_END_OF_STREAM!");
            this.mFrameInfo.errCode = 2;
        } else {
            TPNativeLog.printLog(4, this.getLogTag(), "dequeueOutputBuffer: TP_ERROR_DECODE_FAILED! index = ".concat(String.valueOf(n2)));
            this.mFrameInfo.errCode = 103;
        }
        return this.mFrameInfo;
    }

    @Override
    public int signalEndOfStream() {
        TPNativeLog.printLog(2, this.getLogTag(), "signalEndOfStream: ");
        if (this.mCodec == null) {
            return 3;
        }
        if (this.mEnableAsyncMode) {
            return this.signalEndOfStreamAsync();
        }
        int n2 = this.mCodec.a(MEDIA_CODEC_INPUT_TIMEOUT_US);
        if (n2 >= 0) {
            return this.handleSignalEndOfStream(n2);
        }
        if (n2 == -1) {
            return 1;
        }
        return 3;
    }

    private int handleSignalEndOfStream(int n2) {
        try {
            this.mCodec.a(n2, 0, 0, 0L, 4);
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, this.getLogTag(), "handleSignalEndOfStream: failed!" + this.getStackTrace(exception));
            return 3;
        }
        return 0;
    }

    @Override
    public int flush() {
        TPNativeLog.printLog(2, this.getLogTag(), "flush: ");
        if (this.mCodec == null) {
            return 104;
        }
        if (this.mEnableAsyncMode) {
            return this.flushAsync();
        }
        return this.handleFlush();
    }

    private int handleFlush() {
        TPNativeLog.printLog(2, this.getLogTag(), "handleFlush: ");
        if (this.mCodec == null) {
            return 104;
        }
        try {
            this.mCodec.h();
        }
        catch (Exception exception) {
            return this.onMediaCodecException(exception);
        }
        return 0;
    }

    @Override
    public int release() {
        if (this.mEnableAsyncMode) {
            return this.releaseAsync();
        }
        return this.handleRelease();
    }

    private int handleRelease() {
        if (this.mCodec == null) {
            return 101;
        }
        this.mStarted = false;
        try {
            this.mCodec.f();
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, this.getLogTag(), "stop: failed!" + this.getStackTrace(exception));
            return 3;
        }
        finally {
            this.mCodec.g();
            this.mCodec = null;
        }
        return 0;
    }

    @Override
    public boolean setParamBool(int n2, boolean bl2) {
        switch (n2) {
            case 0: {
                this.mEnableSetOutputSurfaceApi = bl2;
                break;
            }
            case 1: {
                if (!this.mStarted) {
                    this.mEnableAsyncMode = bl2;
                    break;
                }
                TPNativeLog.printLog(3, this.getLogTag(), "BOOL_ENABLE_ASYNC_MODE must setup before started!");
                break;
            }
            case 3: {
                this.mEnableAudioPassThrough = bl2;
                TPNativeLog.printLog(2, this.getLogTag(), "BOOL_SET_IS_AUDIO_PASSTHROUGH mEnableAudioPassThrough:" + this.mEnableAudioPassThrough);
                break;
            }
            case 4: {
                this.mEnableMediaCodecReuse = bl2;
                break;
            }
            default: {
                TPNativeLog.printLog(3, this.getLogTag(), "Unknown paramKey: ".concat(String.valueOf(n2)));
                return false;
            }
        }
        return true;
    }

    @Override
    public int setOperateRate(float f2) {
        if (this.mCodec != null) {
            try {
                if (Build.VERSION.SDK_INT >= 19) {
                    TPNativeLog.printLog(2, this.getLogTag(), "setOperateRate: ".concat(String.valueOf(f2)));
                    Bundle bundle = new Bundle();
                    bundle.putShort("priority", (short)0);
                    bundle.putFloat("operating-rate", f2);
                    this.mCodec.a(bundle);
                }
            }
            catch (Exception exception) {
                TPNativeLog.printLog(3, this.getLogTag(), "setOperateRate: " + f2 + " failed.");
            }
        }
        return 0;
    }

    private int onMediaCodecException(Exception exception) {
        TPNativeLog.printLog(4, this.getLogTag(), "onMediaCodecException!\n" + this.getStackTrace(exception));
        int n2 = 103;
        this.resetFrameInfo();
        this.processMediaCodecException(exception);
        if (this.mRestartCodecOnException) {
            this.initMediaCodecInternal();
            n2 = 4;
        } else {
            this.handleRelease();
        }
        return n2;
    }

    @Override
    public boolean setParamInt(int n2, int n3) {
        return false;
    }

    @Override
    public boolean setParamLong(int n2, long l2) {
        return false;
    }

    @Override
    public boolean setParamString(int n2, String string) {
        return false;
    }

    @Override
    public boolean setParamBytes(int n2, byte[] byArray) {
        return false;
    }

    @Override
    public boolean setParamObject(int n2, Object object) {
        if (n2 == 300) {
            this.mMediaCrypto = (MediaCrypto)object;
            return true;
        }
        return false;
    }

    private void resetFrameInfo() {
        this.mFrameInfo.bufferIndex = -1000;
        this.mFrameInfo.ptsUs = -1L;
        this.mFrameInfo.data = null;
        this.mFrameInfo.errCode = 103;
    }

    private void dumpByteArray(byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null || n2 < 0 || n3 <= 0 || n2 >= byArray.length || n2 >= n3 || n4 <= 0) {
            throw new IllegalArgumentException();
        }
        n3 = Math.min((byArray.length <= n3 ? byArray.length : n3) - n2, 100) + n2;
        int n5 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        TPNativeLog.printLog(2, this.getLogTag(), "dumpByteArray begin:");
        for (int i2 = n2; i2 < n3; ++i2) {
            String string = Integer.toHexString(byArray[i2] & 0xFF);
            if (string.length() == 1) {
                string = "0".concat(String.valueOf(string));
            }
            stringBuilder.append(string.toUpperCase());
            if (++n5 % n4 == 0) {
                TPNativeLog.printLog(2, this.getLogTag(), stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(" ");
        }
        TPNativeLog.printLog(2, this.getLogTag(), "dumpByteArray end.");
    }

    @RequiresApi(api=21)
    private int decodeAsync(byte[] byArray, boolean bl2, long l2, boolean bl3) {
        Integer n2 = (Integer)this.mInputQueue.poll();
        if (n2 == null) {
            return 1;
        }
        try {
            ByteBuffer byteBuffer = this.mCodec.c(n2);
            if (byteBuffer != null) {
                this.bufferSizeCheck(byteBuffer, byArray);
                byteBuffer.put(byArray);
            }
            if (bl3 && this.mCryptoInfo != null) {
                this.mCodec.a((int)n2, 0, this.mCryptoInfo, l2, bl2 ? 1 : 0);
            } else {
                this.mCodec.a((int)n2, 0, byArray.length, l2, bl2 ? 1 : 0);
            }
        }
        catch (Exception exception) {
            return this.onMediaCodecException(exception);
        }
        return 0;
    }

    private TPFrameInfo dequeueOutputBufferAsync() {
        this.mFrameInfo.errCode = 1;
        TPFrameInfo tPFrameInfo = (TPFrameInfo)this.mOutputQueue.poll();
        if (tPFrameInfo == null) {
            return this.mFrameInfo;
        }
        return tPFrameInfo;
    }

    private int signalEndOfStreamAsync() {
        Integer n2 = (Integer)this.mInputQueue.poll();
        if (n2 == null) {
            return 1;
        }
        return this.handleSignalEndOfStream(n2);
    }

    private int releaseOutputBufferAsync(int n2, boolean bl2) {
        Message message = this.mDecoderHandler.obtainMessage();
        this.mDecoderHandler.obtainMessage().what = 1000;
        message.arg1 = n2;
        message.arg2 = bl2 ? 1 : 0;
        return this.waitingForHandleMessage(message);
    }

    private int setOutputSurfaceAsync(Surface surface) {
        TPNativeLog.printLog(2, this.getLogTag(), "setOutputSurfaceAsync: ".concat(String.valueOf(surface)));
        Message message = this.mDecoderHandler.obtainMessage();
        this.mDecoderHandler.obtainMessage().what = 1001;
        message.obj = surface;
        return this.waitingForHandleMessage(message);
    }

    private int flushAsync() {
        TPNativeLog.printLog(2, this.getLogTag(), "flushAsync: ");
        Message message = this.mDecoderHandler.obtainMessage();
        this.mDecoderHandler.obtainMessage().what = 1002;
        return this.waitingForHandleMessage(message);
    }

    private int releaseAsync() {
        TPNativeLog.printLog(2, this.getLogTag(), "releaseAsync: ");
        Message message = this.mDecoderHandler.obtainMessage();
        this.mDecoderHandler.obtainMessage().what = 1003;
        int n2 = this.waitingForHandleMessage(message);
        this.exitDecodeThread();
        return n2;
    }

    private void exitDecodeThread() {
        if (this.mDecodeThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                this.mDecodeThread.quitSafely();
            } else {
                this.mDecodeThread.quit();
            }
            try {
                this.mDecodeThread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int waitingForHandleMessage(Message message) {
        Object object = this.mThreadLock;
        synchronized (object) {
            message.sendToTarget();
            try {
                this.mThreadLock.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.mHandlerResult;
    }

    private void handleMessageComplete(int n2) {
        this.mHandlerResult = n2;
        this.mThreadLock.notify();
    }

    private int onReleaseOutputBuffer(int n2, boolean bl2) {
        return this.handleReleaseOutputBuffer(n2, bl2);
    }

    private int onSetOutputSurface(Surface surface) {
        return this.handleSetOutputSurface(surface);
    }

    private int onFlush() {
        this.mInputQueue.clear();
        this.mOutputQueue.clear();
        int n2 = this.handleFlush();
        this.mCodec.e();
        return n2;
    }

    private int onRelease() {
        this.mInputQueue.clear();
        this.mOutputQueue.clear();
        return this.handleRelease();
    }

    protected String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    private MediaCodecInfo selectCodec(String string) {
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (mediaCodecInfo.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string)) continue;
                return mediaCodecInfo;
            }
        }
        return null;
    }

    class AsyncDecodeHandler
    extends Handler {
        AsyncDecodeHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            int n2 = 0;
            Object object = TPBaseMediaCodecDecoder.this.mThreadLock;
            synchronized (object) {
                switch (message.what) {
                    case 1000: {
                        n2 = TPBaseMediaCodecDecoder.this.onReleaseOutputBuffer(message.arg1, message.arg2 == 1);
                        break;
                    }
                    case 1001: {
                        n2 = TPBaseMediaCodecDecoder.this.onSetOutputSurface((Surface)message.obj);
                        break;
                    }
                    case 1002: {
                        n2 = TPBaseMediaCodecDecoder.this.onFlush();
                        break;
                    }
                    case 1003: {
                        n2 = TPBaseMediaCodecDecoder.this.onRelease();
                    }
                }
                TPBaseMediaCodecDecoder.this.handleMessageComplete(n2);
                return;
            }
        }
    }

    @RequiresApi(api=21)
    class BufferCallback
    extends b.a {
        private BufferCallback() {
        }

        @Override
        public void onInputBufferAvailable(@NonNull com.tencent.thumbplayer.g.b b2, int n2) {
            try {
                TPBaseMediaCodecDecoder.this.mInputQueue.put(n2);
                return;
            }
            catch (Exception exception) {
                TPNativeLog.printLog(3, TPBaseMediaCodecDecoder.this.getLogTag(), TPBaseMediaCodecDecoder.this.getStackTrace(exception));
                return;
            }
        }

        @Override
        public void onOutputBufferAvailable(@NonNull com.tencent.thumbplayer.g.b b2, int n2, @NonNull MediaCodec.BufferInfo bufferInfo) {
            try {
                TPFrameInfo tPFrameInfo = new TPFrameInfo();
                new TPFrameInfo().errCode = 0;
                tPFrameInfo.bufferIndex = n2;
                tPFrameInfo.ptsUs = bufferInfo.presentationTimeUs;
                TPBaseMediaCodecDecoder.this.processOutputBuffer(b2, n2, bufferInfo, tPFrameInfo);
                TPBaseMediaCodecDecoder.this.mOutputQueue.put(tPFrameInfo);
                return;
            }
            catch (Exception exception) {
                TPNativeLog.printLog(3, TPBaseMediaCodecDecoder.this.getLogTag(), TPBaseMediaCodecDecoder.this.getStackTrace(exception));
                return;
            }
        }

        @Override
        public void onError(@NonNull com.tencent.thumbplayer.g.b b2, @NonNull MediaCodec.CodecException codecException) {
            TPNativeLog.printLog(4, TPBaseMediaCodecDecoder.this.getLogTag(), "onError: " + TPBaseMediaCodecDecoder.this.getStackTrace((Throwable)codecException));
            TPBaseMediaCodecDecoder.this.handleRelease();
        }

        @Override
        public void onOutputFormatChanged(@NonNull com.tencent.thumbplayer.g.b b2, @NonNull MediaFormat mediaFormat) {
            TPBaseMediaCodecDecoder.this.processOutputFormatChanged(mediaFormat);
        }
    }
}

