/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.preprocessor;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.beauty.b.o;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.a;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.preprocessor.BeautyProcessor;
import com.tencent.liteav.videoproducer.preprocessor.aa;
import com.tencent.liteav.videoproducer.preprocessor.ab;
import com.tencent.liteav.videoproducer.preprocessor.ac;
import com.tencent.liteav.videoproducer.preprocessor.ad;
import com.tencent.liteav.videoproducer.preprocessor.ae;
import com.tencent.liteav.videoproducer.preprocessor.af;
import com.tencent.liteav.videoproducer.preprocessor.ag;
import com.tencent.liteav.videoproducer.preprocessor.ah;
import com.tencent.liteav.videoproducer.preprocessor.h;
import com.tencent.liteav.videoproducer.preprocessor.k;
import com.tencent.liteav.videoproducer.preprocessor.l;
import com.tencent.liteav.videoproducer.preprocessor.p;
import com.tencent.liteav.videoproducer.preprocessor.q;
import com.tencent.liteav.videoproducer.preprocessor.r;
import com.tencent.liteav.videoproducer.preprocessor.s;
import com.tencent.liteav.videoproducer.preprocessor.t;
import com.tencent.liteav.videoproducer.preprocessor.u;
import com.tencent.liteav.videoproducer.preprocessor.v;
import com.tencent.liteav.videoproducer.preprocessor.w;
import com.tencent.liteav.videoproducer.preprocessor.x;
import com.tencent.liteav.videoproducer.preprocessor.y;
import com.tencent.liteav.videoproducer.preprocessor.z;
import java.util.List;
import java.util.concurrent.CyclicBarrier;

@JNINamespace(value="liteav::video")
public class VideoPreprocessor
implements BeautyProcessor.a {
    private static final String TAG = "VideoPreprocessor";
    private final h mPreprocessor;
    private final IVideoReporter mVideoReporter;
    private final CyclicBarrier mLoadFrameCyclicBarrier = new CyclicBarrier(2);
    private final SparseArray<a> mConvertParamsList = new SparseArray();
    private CustomHandler mWorkHandler;
    private float mLookupMixLevel = 0.5f;
    private long mTotalFrameCount = 0L;
    private long mLastProcessTimestamp = 0L;
    private final com.tencent.liteav.videobase.utils.a mAverageCostCalculator;
    private CaptureSourceInterface.SourceType mSourceType = CaptureSourceInterface.SourceType.a;

    public VideoPreprocessor(@NonNull Context context, @NonNull BeautyProcessor beautyProcessor, @NonNull IVideoReporter reporter) {
        this.mPreprocessor = new h(context, beautyProcessor, reporter);
        this.mVideoReporter = reporter;
        beautyProcessor.setBeautyManagerStatusListener(this);
        com.tencent.liteav.beauty.a.a(this.mVideoReporter);
        VideoPreprocessor videoPreprocessor = this;
        this.mAverageCostCalculator = new com.tencent.liteav.videobase.utils.a("preprocess", new q(videoPreprocessor));
    }

    public void initialize() {
        LiteavLog.i(TAG, "initialize");
        HandlerThread handlerThread = new HandlerThread("video-preprocessor");
        handlerThread.start();
        this.mWorkHandler = new CustomHandler(handlerThread.getLooper());
    }

    public void setSourceType(CaptureSourceInterface.SourceType sourceType) {
        this.mWorkHandler.post(z.a(this, sourceType));
    }

    public synchronized boolean processFrame(PixelFrame pixelFrame) {
        long l2 = SystemClock.elapsedRealtime();
        pixelFrame.retain();
        pixelFrame.getProducerChainTimestamp().setPreprocessTimestamp(TimeUtil.c());
        boolean bl2 = this.mWorkHandler.post(aa.a(this, pixelFrame, l2));
        if (!bl2) {
            pixelFrame.release();
        }
        return bl2;
    }

    public void registerVideoProcessedListener(int identity, a convertParams, GLConstants.PixelBufferType bufferType, GLConstants.PixelFormatType formatType, boolean withWatermark, ah listener) {
        if (bufferType == GLConstants.PixelBufferType.b) {
        }
        this.mWorkHandler.post(ab.a(this, identity, convertParams, bufferType, formatType, withWatermark, listener));
    }

    public void unregisterVideoProcessedListener(int identity, ah listener) {
        this.mWorkHandler.post(ac.a(this, identity, listener));
    }

    @CalledByNative
    public boolean setGreenScreenFile(String path, boolean isLoop) {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 18) {
            return false;
        }
        LiteavLog.i(TAG, "setGreenScreenFile: path=" + path + ", isLoop=" + isLoop);
        this.mWorkHandler.post(ad.a(this, path, isLoop));
        return true;
    }

    public void setGreenScreenParam(GLConstants.GLScaleType scaleType, boolean mirror) {
        this.mWorkHandler.post(ae.a(this, scaleType, mirror));
    }

    @CalledByNative
    public void setFilterMixLevel(float mixLevel) {
        LiteavLog.i(TAG, "setFilterMixLevel: ".concat(String.valueOf(mixLevel)));
        this.mLookupMixLevel = mixLevel;
        this.mWorkHandler.post(af.a(this, mixLevel));
    }

    @CalledByNative
    public void setLookupImage(Bitmap bitmap) {
        LiteavLog.i(TAG, "setLookupImage: ".concat(String.valueOf(bitmap)));
        this.mWorkHandler.post(ag.a(this, bitmap));
    }

    @CalledByNative
    public void setFilterGroupImages(float leftBitmapRatio, Bitmap leftBitmap, float leftSpecialRatio, Bitmap rightBitmap, float rightSpecialRatio) {
        VideoPreprocessor videoPreprocessor = this;
        videoPreprocessor.postTaskToGlThread(r.a(videoPreprocessor, leftBitmapRatio, leftBitmap, leftSpecialRatio, rightBitmap, rightSpecialRatio));
    }

    public void setWatermark(Bitmap watermark, float xOffsetRatio, float yOffsetRatio, float widthRatio) {
        this.mWorkHandler.post(s.a(this, watermark, xOffsetRatio, yOffsetRatio, widthRatio));
    }

    public void setWatermarkList(List<o> watermarkList) {
        this.mWorkHandler.post(t.a(this, watermarkList));
    }

    public void setGaussianBlurLevel(float level) {
        this.mWorkHandler.post(u.a(this, level));
    }

    public void updateHomeOrientation(int orientation) {
        this.mWorkHandler.post(v.a(this, orientation));
    }

    public void runTaskInGlThreadAndWaitDone(Runnable runnable) {
        this.mWorkHandler.runAndWaitDone(runnable);
    }

    public void postTaskToGlThread(Runnable runnable) {
        this.mWorkHandler.post(runnable);
    }

    public void uninitialize() {
        LiteavLog.i(TAG, "uninitialize");
        this.mAverageCostCalculator.a();
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            h h2 = this.mPreprocessor;
            h2.getClass();
            customHandler.post(w.a(h2));
            customHandler.quitLooper();
        }
    }

    public void uninitializeGLComponents() {
        h h2 = this.mPreprocessor;
        h2.getClass();
        this.mWorkHandler.post(x.a(h2));
    }

    public BeautyProcessor getBeautyProcessor() {
        return this.mPreprocessor.d;
    }

    public void setInterceptorBeforeWatermark(com.tencent.liteav.videobase.a.a interceptor) {
        this.mWorkHandler.post(y.a(this, interceptor));
    }

    private void recalculateProcessSizeInternal() {
        if (this.mConvertParamsList.size() == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.mConvertParamsList.size(); ++i2) {
            int n4;
            a a2 = (a)this.mConvertParamsList.valueAt(i2);
            boolean bl2 = a2.c == Rotation.b || a2.c == Rotation.d;
            int n5 = bl2 ? a2.b : a2.a;
            int n6 = n4 = bl2 ? a2.a : a2.b;
            if (n2 * n4 != n3 * n5) {
                LiteavLog.w(TAG, "video preprocessor has different w/h ratio: %dx%d vs %dx%d", n2, n3, n5, n4);
            }
            if (n5 * n4 <= n2 * n3) continue;
            n2 = n5;
            n3 = n4;
        }
        this.mPreprocessor.a(n2, n3);
    }

    @Override
    public void onBeautyStatsChanged(String stats) {
        this.mVideoReporter.updateStatus(com.tencent.liteav.videobase.videobase.h.H, stats);
    }

    private void reportProcessFrameRate() {
        ++this.mTotalFrameCount;
        long l2 = SystemClock.elapsedRealtime();
        if (l2 > this.mLastProcessTimestamp + 2000L) {
            double d2 = (double)this.mTotalFrameCount * 1000.0 / (double)(l2 - this.mLastProcessTimestamp);
            this.mVideoReporter.updateStatus(com.tencent.liteav.videobase.videobase.h.h, d2);
            this.mTotalFrameCount = 0L;
            this.mLastProcessTimestamp = l2;
        }
    }

    static /* synthetic */ void lambda$setInterceptorBeforeWatermark$14(VideoPreprocessor this_, com.tencent.liteav.videobase.a.a interceptor) {
        this_.mPreprocessor.a(interceptor);
    }

    static /* synthetic */ void lambda$updateHomeOrientation$13(VideoPreprocessor this_, int orientation) {
        this_.mPreprocessor.d.setHomeOrientation(orientation);
    }

    static /* synthetic */ void lambda$setGaussianBlurLevel$12(VideoPreprocessor this_, float level) {
        float f2 = level / 4.0f;
        h h2 = this_.mPreprocessor;
        h2.c.a(l.a(h2, f2));
    }

    static /* synthetic */ void lambda$setWatermarkList$11(VideoPreprocessor this_, List watermarkList) {
        List list = watermarkList;
        h h2 = this_.mPreprocessor;
        h2.c.a(k.a(h2, list));
    }

    static /* synthetic */ void lambda$setWatermark$10(VideoPreprocessor this_, Bitmap watermark, float xOffsetRatio, float yOffsetRatio, float widthRatio) {
        this_.mPreprocessor.a(watermark, xOffsetRatio, yOffsetRatio, widthRatio);
    }

    static /* synthetic */ void lambda$setFilterGroupImages$9(VideoPreprocessor this_, float leftBitmapRatio, Bitmap leftBitmap, float leftSpecialRatio, Bitmap rightBitmap, float rightSpecialRatio) {
        this_.mPreprocessor.a(leftBitmapRatio, leftBitmap, leftSpecialRatio, rightBitmap, rightSpecialRatio);
    }

    static /* synthetic */ void lambda$setLookupImage$8(VideoPreprocessor this_, Bitmap bitmap) {
        this_.mPreprocessor.a(1.0f, bitmap, this_.mLookupMixLevel, null, 0.0f);
    }

    static /* synthetic */ void lambda$setFilterMixLevel$7(VideoPreprocessor this_, float mixLevel) {
        this_.mPreprocessor.a(mixLevel);
    }

    static /* synthetic */ void lambda$setGreenScreenParam$6(VideoPreprocessor this_, GLConstants.GLScaleType scaleType, boolean mirror) {
        GLConstants.GLScaleType gLScaleType = scaleType;
        h h2 = this_.mPreprocessor;
        h2.c.a(p.a(h2, gLScaleType, mirror));
    }

    static /* synthetic */ void lambda$setGreenScreenFile$5(VideoPreprocessor this_, String path, boolean isLoop) {
        this_.mPreprocessor.a(path, isLoop);
    }

    static /* synthetic */ void lambda$unregisterVideoProcessedListener$4(VideoPreprocessor this_, int identity, ah listener) {
        this_.mPreprocessor.a(identity, listener);
        this_.mConvertParamsList.remove(identity);
        this_.recalculateProcessSizeInternal();
    }

    static /* synthetic */ void lambda$registerVideoProcessedListener$3(VideoPreprocessor this_, int identity, a convertParams, GLConstants.PixelBufferType bufferType, GLConstants.PixelFormatType formatType, boolean withWatermark, ah listener) {
        this_.mPreprocessor.a(identity, convertParams, bufferType, formatType, withWatermark, listener);
        this_.mConvertParamsList.put(identity, (Object)convertParams);
        this_.recalculateProcessSizeInternal();
    }

    static /* synthetic */ void lambda$processFrame$2(VideoPreprocessor this_, PixelFrame pixelFrame, long startTime) {
        GLConstants.GLScaleType gLScaleType = this_.mSourceType == CaptureSourceInterface.SourceType.c ? GLConstants.GLScaleType.b : GLConstants.GLScaleType.a;
        this_.mPreprocessor.a(pixelFrame, gLScaleType);
        long l2 = SystemClock.elapsedRealtime() - startTime;
        this_.mVideoReporter.updateStatus(com.tencent.liteav.videobase.videobase.h.G, l2);
        this_.reportProcessFrameRate();
        pixelFrame.release();
    }

    static /* synthetic */ void lambda$setSourceType$1(VideoPreprocessor this_, CaptureSourceInterface.SourceType sourceType) {
        this_.mSourceType = sourceType;
    }

    static /* synthetic */ void lambda$new$0(VideoPreprocessor this_, double averageCost) {
        this_.mVideoReporter.updateStatus(com.tencent.liteav.videobase.videobase.h.f, averageCost);
    }
}

