/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.retriver;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.f;
import com.tencent.ugc.MediaExtractorWrapper;
import com.tencent.ugc.common.MediaExtractorBuilder;
import com.tencent.ugc.retriver.VideoMetaData;

public class FFmpegMediaRetriever {
    private static final String TAG = "FFmpegMediaRetriever";
    private final boolean mIsUseMediaExtractor;
    private String mPath;
    private VideoMetaData mMediaInfo;

    public FFmpegMediaRetriever() {
        this(true);
    }

    public FFmpegMediaRetriever(boolean isUseMediaExtractor) {
        this.mIsUseMediaExtractor = isUseMediaExtractor;
    }

    private static native VideoMetaData nativeGetMediaInfo(String var0);

    public int setDataSource(String path) {
        if (path == null) {
            LiteavLog.e(TAG, "path can't be null!");
            return -1;
        }
        if (path.equals(this.mPath)) {
            return 0;
        }
        if (!MediaExtractorBuilder.isContentUri(path) && !f.a(path)) {
            LiteavLog.e(TAG, "file isn't exists!");
            return -1;
        }
        this.mPath = path;
        this.mMediaInfo = FFmpegMediaRetriever.nativeGetMediaInfo(this.mPath);
        LiteavLog.i(TAG, "nativeGetMediaInfo media info = " + this.mMediaInfo);
        if (this.mMediaInfo == null && this.mIsUseMediaExtractor) {
            this.mMediaInfo = this.getMediaInfoFromMediaExtractor(this.mPath);
        }
        if (this.mMediaInfo == null) {
            return -1;
        }
        return 0;
    }

    private VideoMetaData getMediaInfoFromMediaExtractor(String path) {
        MediaExtractorWrapper mediaExtractorWrapper = new MediaExtractorWrapper();
        if (!mediaExtractorWrapper.setDataSource(path)) {
            return null;
        }
        VideoMetaData videoMetaData = new VideoMetaData();
        videoMetaData.setWidth(mediaExtractorWrapper.getWidth());
        videoMetaData.setHeight(mediaExtractorWrapper.getHeight());
        videoMetaData.setVideoDuration(mediaExtractorWrapper.getVideoDuration());
        videoMetaData.setAudioDuration(mediaExtractorWrapper.getAudioDuration());
        videoMetaData.setFps(mediaExtractorWrapper.getVideoFrameRate());
        videoMetaData.setVideoMimeType(mediaExtractorWrapper.getVideoMimeType());
        videoMetaData.setChannels(mediaExtractorWrapper.getChannelCount());
        videoMetaData.setSampleRate(mediaExtractorWrapper.getSampleRate());
        videoMetaData.setAudioBitrate(mediaExtractorWrapper.getAudioBitrate());
        videoMetaData.setVideoBitrate(mediaExtractorWrapper.getVideoBitrate());
        mediaExtractorWrapper.release();
        return videoMetaData;
    }

    public int getRotation() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getRotation();
        }
        return 0;
    }

    public int getVideoWidth() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getWidth();
        }
        return 0;
    }

    public int getVideoHeight() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getHeight();
        }
        return 0;
    }

    public float getFPS() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getFps();
        }
        return 0.0f;
    }

    public long getVideoBitrate() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getVideoBitrate();
        }
        return 0L;
    }

    public long getVideoDurationMs() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getVideoDuration() / 1000L;
        }
        return 0L;
    }

    public int getSampleRate() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getSampleRate();
        }
        return 0;
    }

    public int getChannels() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getChannels();
        }
        return 0;
    }

    public long getAudioBitrate() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getAudioBitrate();
        }
        return 0L;
    }

    public long getAudioDurationMs() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getAudioDuration() / 1000L;
        }
        return 0L;
    }

    public String getVideoMimeType() {
        if (this.mMediaInfo != null) {
            return this.mMediaInfo.getVideoMimeType();
        }
        return null;
    }
}

