/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.core.PeerConnection;
import cn.rongcloud.rtc.core.SdpObserver;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.RTCSDPTools;
import cn.rongcloud.rtc.utils.ReportUtil;

public class RTCLocalSdpObserver
implements SdpObserver {
    private RTCSdpLocalSetListener listener;
    private PeerConnection rongRTCConnection;
    private SessionDescription sessionDescription;
    private static final String TAG = "RongRTCLocalSdpObserver";
    private RCRTCConfigImpl config;
    private int totalMaxBitRate;
    private String mRoomId;

    public RTCLocalSdpObserver(String roomId, RCRTCConfigImpl config, PeerConnection rongRTCConnection, int totalMaxBitRate, RTCSdpLocalSetListener listener) {
        this.listener = listener;
        this.config = config;
        this.rongRTCConnection = rongRTCConnection;
        this.totalMaxBitRate = totalMaxBitRate;
        this.mRoomId = roomId;
    }

    @Override
    public void onCreateSuccess(SessionDescription sdp) {
        ReportUtil.libRes(ReportUtil.TAG.CREATEOFFER, "code", 0);
        String sdpDescription = RTCSDPTools.preferCodec(this.config, sdp.description, "H264", false, this.totalMaxBitRate);
        sdpDescription = RTCSDPTools.preferCodec(this.config, sdpDescription, null, true, this.totalMaxBitRate);
        if (this.config.getAudioBitrate() > 0 || this.config.isStereo()) {
            sdpDescription = RTCSDPTools.setStartBitrate("opus", false, sdpDescription, this.config.getAudioBitrate(), this.config.isStereo());
        }
        FinLog.i(TAG, "setLocalDescription: " + (Object)((Object)sdp.type) + "\r\n" + sdpDescription);
        this.sessionDescription = new SessionDescription(sdp.type, sdpDescription);
        ReportUtil.libTask(ReportUtil.TAG.SETLOCALSDP, "roomId", this.mRoomId);
        if (this.rongRTCConnection != null && !this.rongRTCConnection.isClose()) {
            this.rongRTCConnection.setLocalDescription(this, this.sessionDescription);
        } else {
            ReportUtil.libError(ReportUtil.TAG.SETLOCALSDP, "code|desc", RTCErrorCode.RongRTCCodeSessionNegotiateOfferError.getValue(), "PeerConnection is Null or close");
            this.listener.onLocalSetError("PeerConnection is Null or close");
        }
    }

    @Override
    public void onSetSuccess() {
        ReportUtil.libRes(ReportUtil.TAG.SETLOCALSDP, "code", 0);
        if (this.listener != null) {
            this.listener.onLocalSdpSetSuccess(this.sessionDescription);
        }
    }

    @Override
    public void onCreateFailure(String error) {
        ReportUtil.libError(ReportUtil.TAG.CREATEOFFER, "code|desc", RTCErrorCode.RongRTCCodeSessionNegotiateOfferError.getValue(), error);
        if (this.listener != null) {
            this.listener.onLocalSetError(error);
        }
    }

    @Override
    public void onSetFailure(String error) {
        ReportUtil.libError(ReportUtil.TAG.SETLOCALSDP, "code|desc|sdp", RTCErrorCode.RongRTCCodeSessionNegotiateOfferError.getValue(), error, this.sessionDescription.toJsonString());
        if (this.listener != null) {
            this.listener.onLocalSetError(error);
        }
    }

    public static interface RTCSdpLocalSetListener {
        public void onLocalSdpSetSuccess(SessionDescription var1);

        public void onLocalSetError(String var1);
    }
}

