/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.signal;

import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCJoinType;
import cn.rongcloud.rtc.base.RCRTCJoinedRoomInfo;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.proto.APIType;
import cn.rongcloud.rtc.proxy.message.messagebeans.ExchangeSDPDataResult;
import cn.rongcloud.rtc.proxy.message.messagebeans.InviteInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.SubscribeLiveDataResult;
import cn.rongcloud.rtc.signal.IMSignalWrapper;
import cn.rongcloud.rtc.signal.IRTCSwitchRoleCallback;
import cn.rongcloud.rtc.signal.IUpdateUdpObfuscationKeyListener;
import cn.rongcloud.rtc.signal.MediaSignalWrapper;
import cn.rongcloud.rtc.signal.SignalEventListener;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.IRongCoreRTCCallback;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.RTCStatusDate;
import java.util.List;
import java.util.Map;

public class SignalManager
implements IUpdateUdpObfuscationKeyListener {
    private MediaSignalWrapper mMediaSignal;
    private IMSignalWrapper mIMSignal;
    private IUpdateUdpObfuscationKeyListener mObfuscationKeyListener;
    private IRongCoreListener.ConnectionStatusListener.ConnectionStatus mConnectionStatus = IRongCoreListener.ConnectionStatusListener.ConnectionStatus.UNCONNECTED;

    public static SignalManager getInstance() {
        return SignalManagerHolder.instance;
    }

    private SignalManager() {
        this.init();
    }

    public IUpdateUdpObfuscationKeyListener getObfuscationKeyListener() {
        return this.mObfuscationKeyListener;
    }

    public void setObfuscationKeyListener(IUpdateUdpObfuscationKeyListener obfuscationKeyListener) {
        this.mObfuscationKeyListener = obfuscationKeyListener;
    }

    public int getMaxStreamCount() {
        return this.mMediaSignal.getMaxStreamCount();
    }

    public boolean imSignalIsConnected() {
        return this.mConnectionStatus == IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED;
    }

    public void quitLive(String liveUrl, int roomType, String serverSessionId, String clientSessionId, IRCRTCResultCallback callback) {
        this.mMediaSignal.quitLive(liveUrl, roomType, serverSessionId, clientSessionId, callback);
    }

    private void init() {
        this.mIMSignal = new IMSignalWrapper();
        this.mMediaSignal = new MediaSignalWrapper(this.mIMSignal, this);
    }

    public void onIMConnectChanged(IRongCoreListener.ConnectionStatusListener.ConnectionStatus connectionStatus) {
        this.mConnectionStatus = connectionStatus;
        this.mMediaSignal.onIMConnectChanged(connectionStatus);
    }

    public void setMediaServerUrl(String url) {
        this.mMediaSignal.setMediaServerUrl(url);
    }

    public void getProbeRTCToken(IRCRTCResultDataCallback<Pair<String, String>> callback) {
        this.mIMSignal.getProbeRTCToken(callback);
    }

    public void startRTCProbe(SessionDescription data, String token, String clientSessionId, IRCRTCResultDataCallback<SessionDescription> callback) {
        this.mMediaSignal.startRTCProbe(data, token, clientSessionId, callback);
    }

    public void stopRTCProbe(String token, String clientSessionId, IRCRTCResultCallback callback) {
        this.mMediaSignal.stopRTCProbe(token, clientSessionId, callback);
    }

    public AsyncResult<ExchangeSDPDataResult> syncSendSDPOffer(String roomId, SessionDescription sdp, String clientSessionId, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> subStreams, RCRTCRoomType roomType, String autoMixJSONInfo, String role) {
        final AsyncResult.TemporaryResult res = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.mMediaSignal.sendSDPOffer(roomId, sdp, clientSessionId, pubStreams, subStreams, roomType, autoMixJSONInfo, role, new IRCRTCResultDataCallback<ExchangeSDPDataResult>(){

            @Override
            public void onSuccess(ExchangeSDPDataResult data) {
                res.setAndNotify(data);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                res.setAndNotify(errorCode);
            }
        });
        return res.waitForGetResult();
    }

    public void rtcPutInnerData(String roomId, RCAttributeType type, String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        this.mIMSignal.rtcPutInnerData(roomId, type.getValue(), key, value, message, callback);
    }

    public AsyncResult syncRtcPutInnerData(String roomId, RCAttributeType type, String key, String value, MessageContent message) {
        final AsyncResult.TemporaryResult res = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.mIMSignal.rtcPutInnerData(roomId, type.getValue(), key, value, message, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                res.setAndNotify(null);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                res.setAndNotify(RTCErrorCode.RongRTCCodeIMError);
            }
        });
        return res.waitForGetResult();
    }

    public boolean voipIsEnable() {
        return !TextUtils.isEmpty((CharSequence)this.mIMSignal.getVoIPInfo());
    }

    public boolean wisseIsEnable() {
        return this.mMediaSignal.wisseIsEnable();
    }

    public void joinRoom(String roomId, RCRTCRoomType roomType, boolean isReJoin, Map<String, String> localUserDatas, RCRTCJoinType joinType, IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>> callback) {
        this.mIMSignal.joinRoom(roomId, roomType, isReJoin, localUserDatas, joinType, callback);
    }

    public void viewerJoinRoom(String roomId, RCRTCRoomType roomType, IRCRTCResultDataCallback<Object[]> callback) {
        this.mIMSignal.viewerJoinRoom(roomId, roomType, callback);
    }

    public void joinOtherRoom(String roomId, RCRTCRoomType roomType, RCRTCJoinType joinType, String key, String value, IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>> callback) {
        this.mIMSignal.joinOtherRoom(roomId, roomType, joinType, key, value, callback);
    }

    public AsyncResult syncRTCSetUserResource(String roomId, RTCStatusDate[] kv, String objNameTotalContent, RTCStatusDate[] content) {
        return this.mIMSignal.rtcSetUserResource(roomId, kv, objNameTotalContent, content, true, null);
    }

    public void diffusionKV(String roomId, RTCStatusDate[] kv, String objNameTotalContent, RTCStatusDate[] content, IRCRTCResultCallback callback) {
        this.mIMSignal.rtcSetUserResource(roomId, kv, objNameTotalContent, content, true, callback);
    }

    public void rtcSetUserResource(String roomId, RTCStatusDate[] kv, String objNameTotalContent, RTCStatusDate[] content, IRCRTCResultCallback callback) {
        this.mIMSignal.rtcSetUserResource(roomId, kv, objNameTotalContent, content, false, callback);
    }

    public AsyncResult<SubscribeLiveDataResult> syncSubscribeLive(SessionDescription sessionDescription, String liveUrl, RCRTCAVStreamType avStreamType, List<? extends IStreamResource> allSubStreams, String serverSessionId, String clientSessionId) {
        final AsyncResult.TemporaryResult tmp = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.mMediaSignal.subscribeLive(sessionDescription, liveUrl, avStreamType, allSubStreams, serverSessionId, clientSessionId, new IRCRTCResultDataCallback<SubscribeLiveDataResult>(){

            @Override
            public void onSuccess(SubscribeLiveDataResult data) {
                tmp.setAndNotify(data);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                tmp.setAndNotify(errorCode);
            }
        });
        return tmp.waitForGetResult();
    }

    public AsyncResult syncResolutionChanged(String roomId, RCRTCRoomType roomType, String clientSessionId, List<? extends IStreamResource> pubStreamRes) {
        final AsyncResult.TemporaryResult tmp = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.mMediaSignal.onResolutionChanged(roomId, roomType, clientSessionId, pubStreamRes, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                tmp.setAndNotify(null);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                tmp.setAndNotify(errorCode);
            }
        });
        return tmp.waitForGetResult();
    }

    public void leaveRoom(final String roomId, final RCRTCRoomType roomType, final String clientSessionId, final IRCRTCResultCallback callback) {
        this.mIMSignal.leaveRoom(roomId, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                SignalManager.this.mMediaSignal.quit(roomId, roomType, clientSessionId, null);
                if (callback != null) {
                    callback.onFailed(errorCode);
                }
            }

            @Override
            public void onSuccess() {
                SignalManager.this.mMediaSignal.quit(roomId, roomType, clientSessionId, null);
                if (callback != null) {
                    callback.onSuccess();
                }
            }
        });
    }

    public void leaveSignalRoom(String roomId) {
        ReportUtil.libTask(ReportUtil.TAG.LEAVEROOM, "roomId|desc", roomId, "leaveSignalRoom");
        this.mIMSignal.leaveRoom(roomId, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.LEAVEROOM, "errorCode|desc", errorCode.getValue(), "leaveSignalRoom");
            }

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.LEAVEROOM, "desc", "leaveSignalRoom");
            }
        });
    }

    public void sendleaveOtherRoomMessage(String roomId, IRCRTCResultCallback callBack) {
        this.mIMSignal.sendleaveOtherRoomMessage(roomId, callBack);
    }

    public void getRTCConfig(String model, String osVersion, long timestamp, String sdkVersion, IRCRTCResultDataCallback<String> callback) {
        this.mIMSignal.getRTCConfig(model, osVersion, timestamp, sdkVersion, callback);
    }

    public void setAttributeValue(String roomId, RCAttributeType type, String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        this.mIMSignal.setAttributeValue(roomId, type, key, value, message, callback);
    }

    public void deleteAttributes(String roomId, RCAttributeType type, List<String> attributeKeys, MessageContent message, IRCRTCResultCallback callback) {
        this.mIMSignal.deleteAttributes(roomId, type, attributeKeys, message, callback);
    }

    public void getAttributes(String roomId, RCAttributeType type, List<String> attributeKeys, APIType apiType, IRCRTCResultDataCallback<Map<String, String>> callback) {
        this.mIMSignal.getAttributes(roomId, type, attributeKeys, apiType, callback);
    }

    public void sendIMSignal(String roomId, MessageContent messageContent, IRongCoreCallback.ISendMessageCallback callback) {
        this.mIMSignal.sendIMSignal(roomId, messageContent, callback);
    }

    public void requestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String mainRoomId, int timeoutTime, String inviteSessionId, String inviteInfo, IRCRTCResultCallback callback) {
        this.mIMSignal.requestJoinOtherRoom(inviteeRoomId, inviteeUserId, mainRoomId, timeoutTime, inviteSessionId, inviteInfo, callback);
    }

    public void cancelRequestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String mainRoomId, String localUserId, String inviteSessionId, String extra, IRCRTCResultCallback callback) {
        this.mIMSignal.cancelRequestJoinOtherRoom(inviteeRoomId, inviteeUserId, mainRoomId, localUserId, inviteSessionId, extra, callback);
    }

    public void responseJoinOtherRoom(String inviterRoomId, String inviterUserId, boolean agree, String extra, boolean autoMix, String mainRoomId, InviteInfo inviteInfo, String key, String inviteSessionId, IRCRTCResultCallback callback) {
        this.mIMSignal.responseJoinOtherRoom(inviterRoomId, inviterUserId, agree, extra, autoMix, mainRoomId, inviteInfo, key, inviteSessionId, callback);
    }

    public void finishOtherRoom(String otherRoomId, String extra, String mainRoomId, String inviteSessionId, String localUserId, String[] keys, IRCRTCResultCallback callback) {
        this.mIMSignal.finishOtherRoom(otherRoomId, extra, mainRoomId, inviteSessionId, localUserId, keys, callback);
    }

    public void setMCUConfig(String serverUrl, String roomId, String sessionId, String configJson, IRCRTCResultDataCallback<String> callBack) {
        this.mMediaSignal.setMCUConfig(serverUrl, roomId, sessionId, configJson, callBack);
    }

    public void reportWisseInfo(String roomId, int roomType, String sessionId, long startUTC, long endUTC) {
        this.mMediaSignal.reportWisseInfo(roomId, roomType, sessionId, startUTC, endUTC);
    }

    public void enableInnerCDN(String serverUrl, String roomId, String sessionId, String configJson, IRCRTCResultDataCallback<String> callBack) {
        this.mMediaSignal.enableInnerCDN(serverUrl, roomId, sessionId, configJson, callBack);
    }

    public void getCDNUri(String cdnServer, String roomId, String sessionId, int width, int height, int fps, IRCRTCResultDataCallback<Object[]> callBack) {
        this.mMediaSignal.getCDNUri(cdnServer, roomId, sessionId, width, height, fps, callBack);
    }

    public void viewerQuitRoom(String roomId, IRCRTCResultCallback callback) {
        this.mIMSignal.viewerQuitRoom(roomId, callback);
    }

    public void setRTCRoomEventListener(SignalEventListener signalEventListener) {
        this.mIMSignal.setRTCRoomEventListener(signalEventListener);
    }

    public void pullKV(String roomId, IRCRTCResultDataCallback<Map<String, String>> callback) {
        this.mIMSignal.pullKV(roomId, callback);
    }

    public void switchRole(String roomId, int role, RCRTCRoomType roomType, String key, String value, IRTCSwitchRoleCallback callBack) {
        this.mIMSignal.switchRole(roomId, role, roomType, key, value, callBack);
    }

    @Override
    public void onUpdate(String key) {
        if (this.mObfuscationKeyListener != null) {
            this.mObfuscationKeyListener.onUpdate(key);
        }
    }

    public void setRtcToken(String rtcToken) {
        this.mMediaSignal.setRtcToken(rtcToken);
    }

    public void reset() {
        this.mMediaSignal.reset();
    }

    public void setRTCUserState(String roomId, String state, IRCRTCResultCallback callback) {
        this.mIMSignal.setRTCUserState(roomId, state, callback);
    }

    public void quitMediaServer(String roomId, RCRTCRoomType roomType, String clientSessionId, IRCRTCResultCallback callback) {
        this.mMediaSignal.quit(roomId, roomType, clientSessionId, callback);
    }

    public void sendModifyResource(String roomId, String sessionId, String configJson, IRCRTCResultCallback callBack) {
        this.mMediaSignal.sendModifyResource(roomId, sessionId, configJson, callBack);
    }

    public void getRTCUserData(String roomId, IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Object[]> callBack) {
        this.mIMSignal.getRTCUserData(roomId, callBack);
    }

    public void queryJoinedRoom(String roomId, String userId, IRCRTCResultDataCallback<RCRTCJoinedRoomInfo[]> callBack) {
        this.mIMSignal.queryJoinedRoom(roomId, userId, callBack);
    }

    private static class SignalManagerHolder {
        private static SignalManager instance = new SignalManager();

        private SignalManagerHolder() {
        }
    }
}

