/*
 * Decompiled with CFR 0.152.
 */
package com.cooleshow.ffmpegcmd.util;

import androidx.annotation.Keep;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/cooleshow/ffmpegcmd/util/TimeUtil;", "", "()V", "YMDHMS", "", "addZero", "time", "", "getDetailTime", "", "getLongTime", "locale", "Ljava/util/Locale;", "getVideoTime", "t", "timeStrToLong", "timeStr", "ffmpegCmd_release"})
@Keep
public final class TimeUtil {
    @NotNull
    public static final TimeUtil INSTANCE = new TimeUtil();
    @NotNull
    private static final String YMDHMS = "yyyy-MM-dd HH:mm:ss";

    private TimeUtil() {
    }

    @NotNull
    public final String getDetailTime(long time) {
        SimpleDateFormat format = new SimpleDateFormat(YMDHMS, Locale.getDefault());
        Date date = new Date(time);
        String string = format.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format.format(date)");
        return string;
    }

    public final long getLongTime(@NotNull String time, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YMDHMS, locale);
        try {
            Date dt = simpleDateFormat.parse(time);
            return dt.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private final String addZero(int time) {
        return (0 <= time ? time < 10 : false) ? "" + '0' + time : (time >= 10 ? "" + time : "");
    }

    @Nullable
    public final String getVideoTime(long t) {
        long time = t;
        if (time <= 0L) {
            return null;
        }
        int second = 0;
        int minute = 0;
        int hour = 0;
        second = (int)(time /= (long)1000) % 60;
        if ((time /= (long)60) > 0L) {
            minute = (int)time % 60;
            hour = (int)time / 60;
        }
        return hour > 0 ? this.addZero(hour) + ':' + this.addZero(minute) + ':' + this.addZero(second) : (minute > 0 ? this.addZero(minute) + ':' + this.addZero(second) : "00:" + this.addZero(second));
    }

    /*
     * WARNING - void declaration
     */
    public final long timeStrToLong(@NotNull String timeStr) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)timeStr, (String)"timeStr");
        String timeString = timeStr;
        timeString = StringsKt.replace$default((String)timeString, (char)'.', (char)':', (boolean)false, (int)4, null);
        Object object = timeString;
        Regex regex = new Regex(":");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] times = stringArray;
        int n2 = Integer.valueOf(times[0]) * 60 * 1000 + Integer.valueOf(times[1]) * 1000;
        Integer n3 = Integer.valueOf(times[2]);
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"valueOf(times[2])");
        return n2 + ((Number)n3).intValue();
    }
}

