/*
 * Decompiled with CFR 0.152.
 */
package com.bassmedia;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.bassmedia.PlayerListener;
import com.un4seen.bass.BASS;
import com.un4seen.bass.BASSMIDI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BassMusicPlay {
    private static BassMusicPlay instance = null;
    private int midi = -1;
    int soundFont;
    private FmlHandler mFmlHandler;
    private ExecutorService mSingleExecutor;
    private PlayerListener.OnCompletionListener mCompletionListener;
    private PlayerListener.OnErrorListener mErrorListener;
    private PlayerListener.OnPreparedListener mPreparedListener;
    private final BASS.SYNCPROC mEndSync = new BASS.SYNCPROC(){

        @Override
        public void SYNCPROC(int handle, int channel, int data, Object user) {
            if (BassMusicPlay.this.mCompletionListener != null) {
                BassMusicPlay.this.mFmlHandler.sendEmptyMessage(5);
            }
        }
    };
    private int mEndSyncHandle = 0;

    public static BassMusicPlay getInstance() {
        if (instance == null) {
            instance = new BassMusicPlay();
        }
        return instance;
    }

    public boolean Load(Context context, String pathMusic) {
        this.Stop();
        if (this.mFmlHandler == null) {
            this.mFmlHandler = new FmlHandler(context.getMainLooper());
        }
        if (this.mSingleExecutor == null) {
            this.mSingleExecutor = Executors.newSingleThreadExecutor();
        }
        if (this.midi != 0) {
            BASS.BASS_StreamFree(this.midi);
        }
        if (!BASS.BASS_Init(-1, 44100, 0)) {
            this.Error("Can't initialize device");
            return false;
        }
        this.midi = BASSMIDI.BASS_MIDI_StreamCreateFile(pathMusic, 0L, 0L, 2048, 1);
        if (this.midi == 0) {
            this.Error("Can't initialize BASS_StreamCreateFile");
            return false;
        }
        this.CallPrepareListener();
        return true;
    }

    public boolean SetTrackVolume2(int track, float volume) {
        try {
            return BASS.BASS_ChannelSetAttribute(this.midi, 73984 + track, volume);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public float GetTrackVolume(int track) {
        try {
            BASS.FloatValue vol = new BASS.FloatValue();
            BASS.BASS_ChannelGetAttribute(this.midi, 73984 + track, vol);
            return vol.value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public boolean LoadSoundFont(String path) {
        this.SetCompletionListener();
        int newfont = BASSMIDI.BASS_MIDI_FontInit(path, 0);
        if (newfont == 0) {
            Log.i((String)"Bass", (String)"Can't load the file");
            return false;
        }
        BASSMIDI.BASS_MIDI_FONT[] sf = new BASSMIDI.BASS_MIDI_FONT[]{new BASSMIDI.BASS_MIDI_FONT()};
        sf[0].font = newfont;
        sf[0].preset = -1;
        sf[0].bank = 0;
        BASSMIDI.BASS_MIDI_StreamSetFonts(this.midi, sf, 1);
        BASSMIDI.BASS_MIDI_FontFree(this.soundFont);
        this.soundFont = newfont;
        return true;
    }

    public void Seek(long position) {
        BASS.BASS_ChannelSetPosition(this.midi, position, 0);
    }

    public void SetVolume(float volume) {
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        BASS.BASS_SetConfig(5, (int)(volume * 10000.0f));
    }

    public boolean IsPlaying() {
        return BASS.BASS_ChannelIsActive(this.midi) == 1;
    }

    public boolean IsPause() {
        return BASS.BASS_ChannelIsActive(this.midi) == 3;
    }

    public boolean IsStop() {
        return BASS.BASS_ChannelIsActive(this.midi) == 0;
    }

    public void setSpeed(float speed) {
        BASS.BASS_ChannelSetAttribute(this.midi, 73736, speed);
    }

    public void Play() {
        BASS.BASS_ChannelPlay(this.midi, false);
    }

    private int calculateFineTune(int targetHz) {
        return (int)((Math.log((double)targetHz / 440.0) * 3986.0 + 100.0) * 8192.0 / 100.0);
    }

    public boolean setNoteFineTune(int trackNum, int targetHz) {
        return BASSMIDI.BASS_MIDI_StreamEvent(this.midi, trackNum, 7, BASS.Utils.LOWORD(this.calculateFineTune(targetHz)));
    }

    public void Pause() {
        BASS.BASS_ChannelPause(this.midi);
    }

    public void Resume() {
        BASS.BASS_ChannelPlay(this.midi, false);
    }

    public void Stop() {
        this.mEndSyncHandle = 0;
        BASS.BASS_ChannelStop(this.midi);
        BASS.BASS_StreamFree(this.midi);
        BASS.BASS_Stop();
        BASS.BASS_Free();
    }

    public long GetCurrentPosition() {
        return BASS.BASS_ChannelGetPosition(this.midi, 0);
    }

    public int GetCurrentTICK() {
        return (int)BASS.BASS_ChannelGetPosition(this.midi, 2);
    }

    public int GetTotalTICK() {
        return (int)BASS.BASS_ChannelGetLength(this.midi, 2);
    }

    public long GetTotalLength() {
        return BASS.BASS_ChannelGetLength(this.midi, 0);
    }

    public double getTotalLength2Second() {
        return BASS.BASS_ChannelBytes2Seconds(this.midi, BASS.BASS_ChannelGetLength(this.midi, 0));
    }

    private void CallErrorListener() {
        int errorCode;
        if (this.mErrorListener != null && (errorCode = BASS.BASS_ErrorGetCode()) != 0) {
            this.mFmlHandler.obtainMessage(1, errorCode, 0).sendToTarget();
        }
    }

    private void CallPrepareListener() {
        if (this.mPreparedListener != null) {
            this.mFmlHandler.obtainMessage(3).sendToTarget();
        }
    }

    private void SetCompletionListener() {
        if (this.mCompletionListener != null) {
            if (this.mEndSyncHandle == 0) {
                this.mEndSyncHandle = BASS.BASS_ChannelSetSync(this.midi, 2, 0L, this.mEndSync, 0);
            }
            if (this.mEndSyncHandle == 0) {
                this.CallErrorListener();
            }
        }
    }

    public void SetOnCompletionListener(PlayerListener.OnCompletionListener listener) {
        this.mCompletionListener = listener;
    }

    public void SetOnErrorListener(PlayerListener.OnErrorListener listener) {
        this.mErrorListener = listener;
    }

    public void SetOnPreparedListener(PlayerListener.OnPreparedListener listener) {
        this.mPreparedListener = listener;
    }

    void Error(String es) {
        String s = String.format("%s\n(error code: %d)", es, BASS.BASS_ErrorGetCode());
        Log.e((String)"BassMusicPlay", (String)s);
    }

    private class FmlHandler
    extends Handler {
        public static final int MSG_ERROR = 1;
        public static final int MSG_PREPARED = 3;
        public static final int MSG_COMPLETION = 5;

        public FmlHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (BassMusicPlay.this.mErrorListener == null) break;
                    BassMusicPlay.this.mErrorListener.onError(BassMusicPlay.this, msg.arg1);
                    break;
                }
                case 3: {
                    if (BassMusicPlay.this.mPreparedListener == null) break;
                    BassMusicPlay.this.mPreparedListener.OnPrepared(BassMusicPlay.this);
                    break;
                }
                case 5: {
                    if (BassMusicPlay.this.mCompletionListener == null) break;
                    BassMusicPlay.this.mCompletionListener.onCompletion(BassMusicPlay.this);
                }
            }
        }
    }
}

