/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.ViewGroup;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IWaiter;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.DHInterface.ReceiveSystemEventVoucher;
import io.dcloud.common.DHInterface.StandardFeature;
import io.dcloud.common.adapter.ui.AdaUniWebView;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.weex.WXBaseWrapper;
import io.dcloud.feature.weex.WXViewWrapper;
import io.dcloud.feature.weex.WeexInstanceMgr;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class WeexFeature
extends StandardFeature
implements IWaiter,
ReceiveSystemEventVoucher {
    IApp mApp;
    boolean isRegisterAllEvent = false;

    public void init(AbsMgr pFeatureMgr, String pFeatureName) {
        super.init(pFeatureMgr, pFeatureName);
        WeexInstanceMgr.self().init(pFeatureMgr);
    }

    public void onStart(Context pContext, Bundle pSavedInstanceState, String[] pRuntimeArgs) {
        super.onStart(pContext, pSavedInstanceState, pRuntimeArgs);
        if (pContext instanceof Application) {
            WeexInstanceMgr.self().initWeexEnv((Application)pContext);
        }
    }

    public void onResume() {
        super.onResume();
        WeexInstanceMgr.self().onActivityResume();
    }

    public void onPause() {
        super.onPause();
        WeexInstanceMgr.self().onActivityPause();
    }

    protected void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        WeexInstanceMgr.self().onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onDestroy() {
        if (this.mApp != null && this.mApp.getQuitModel() == 2) {
            WeexInstanceMgr.self().onActivityDestroy(false);
        } else {
            WeexInstanceMgr.self().onActivityDestroy();
        }
        WeexInstanceMgr.self().setUniServiceCreated(false, null);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        WeexInstanceMgr.self().onActivityResult(requestCode, resultCode, data);
    }

    public void registerAllEvent(IApp app) {
        this.mApp = app;
        if (!this.isRegisterAllEvent) {
            this.isRegisterAllEvent = true;
            this.unregisterSysEvent(this.mApp);
            this.registerSysEvent(this.mApp);
        }
    }

    public void dispose(String pAppid) {
        super.dispose(pAppid);
        if (this.mApp != null) {
            this.onDestroy();
            if (this.isRegisterAllEvent) {
                this.unregisterSysEvent(this.mApp);
                this.isRegisterAllEvent = false;
                this.mApp = null;
            }
        }
    }

    public Object doForFeature(String actionType, Object args) {
        Object ret = null;
        switch (actionType) {
            case "createUniNView": {
                Object[] pArgs = (Object[])args;
                ret = this.createWeexWindow(pArgs);
                break;
            }
            case "weexViewUpdate": {
                Object[] pArgs = (Object[])args;
                IWebview webview = (IWebview)pArgs[0];
                ViewGroup parent = (ViewGroup)pArgs[1];
                org.json.JSONObject jsonObject = (org.json.JSONObject)pArgs[2];
                String weexId = (String)pArgs[3];
                if (PdrUtil.isEmpty((Object)weexId)) {
                    weexId = webview.obtainApp().obtainAppId();
                }
                if (!jsonObject.has("path") || PdrUtil.isEmpty((Object)jsonObject.optString("path"))) break;
                WXBaseWrapper wrapper = WeexInstanceMgr.self().findWXBaseWrapper(weexId);
                org.json.JSONObject weexData = new org.json.JSONObject();
                String path = jsonObject.optString("path");
                if (webview.isUniWebView()) {
                    ((AdaUniWebView)webview).setNVuePath(path);
                }
                try {
                    weexData.put("js", (Object)path);
                    weexData.put("data", (Object)jsonObject);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (wrapper != null) {
                    wrapper.loadTemplate(weexData);
                    break;
                }
                this.createUniNView(webview, parent, weexId, weexData);
                break;
            }
            case "postMessageToUniNView": {
                Object[] pArgs = (Object[])args;
                IWebview webview = (IWebview)pArgs[0];
                String weexId = (String)pArgs[1];
                String targetId = (String)pArgs[2];
                String appid = (String)pArgs[3];
                String data = (String)pArgs[4];
                JSONObject json = JSON.parseObject((String)data);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("targetId", targetId);
                params.put("originId", webview.getWebviewUUID());
                params.put("data", json);
                WXBaseWrapper wrapper = null;
                if (PdrUtil.isEmpty((Object)weexId)) {
                    weexId = targetId;
                }
                if ((wrapper = appid.equalsIgnoreCase(weexId) ? WeexInstanceMgr.self().findWXBaseWrapper(appid) : WeexInstanceMgr.self().findWXBaseWrapper(weexId)) == null) break;
                wrapper.fireGlobalEvent("plusMessage", params);
                break;
            }
            case "updateReload": {
                Object[] pArgs = (Object[])args;
                String path = (String)pArgs[0];
                WXViewWrapper viewWrapper = WeexInstanceMgr.self().findPathByWrapper(path);
                if (viewWrapper == null) break;
                viewWrapper.reload();
                break;
            }
            case "updateServiceReload": {
                WeexInstanceMgr.self().reloadWXServiceWrapper();
                break;
            }
            case "createServiceUniNView": {
                Object[] pArgs = (Object[])args;
                ret = this.createWeexService(pArgs);
                break;
            }
            case "getUniNViewModules": {
                JSONObject modules;
                ret = WeexInstanceMgr.self().getUniNViewModules();
                if (ret != null || (modules = WXModuleManager.getRegisterJsModules()) == null) break;
                ret = modules.toJSONString();
                break;
            }
            case "setUniNViewModuleReladyCallBack": {
                Object[] pArgs = (Object[])args;
                ICallBack callBack = (ICallBack)pArgs[0];
                WeexInstanceMgr.self().setUniNViewModuleReladyCallBack(callBack);
                break;
            }
            case "callNativeModuleSync": {
                Object[] pArgs = (Object[])args;
                IWebview webview = (IWebview)pArgs[0];
                String weexId = (String)pArgs[1];
                String targetId = (String)pArgs[2];
                String appid = (String)pArgs[3];
                String data = (String)pArgs[4];
                JSONObject json = JSON.parseObject((String)data);
                WXSDKInstance instance = null;
                if (PdrUtil.isEmpty((Object)weexId)) {
                    weexId = targetId;
                }
                if ((instance = appid.equalsIgnoreCase(weexId) ? WeexInstanceMgr.self().findWXSDKInstance(appid) : WeexInstanceMgr.self().findWXSDKInstance(weexId)) == null) break;
                ret = this.callNativeModule(instance.getInstanceId(), json);
                break;
            }
            case "onKeyboardHeightChange": {
                Object[] pArgs = (Object[])args;
                String weexId = (String)pArgs[0];
                int height = (Integer)pArgs[1];
                WXBaseWrapper wrapper = WeexInstanceMgr.self().findWXBaseWrapper(weexId);
                if (wrapper != null) {
                    int keyboardHeight = (int)((float)height / wrapper.mWebview.getScale());
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("height", keyboardHeight);
                    wrapper.fireGlobalEvent("KeyboardHeightChange", params);
                }
            }
            case "findWebviewByInstanceId": {
                Object[] pArgs = (Object[])args;
                String instanceId = (String)pArgs[0];
                IWebview b = WeexInstanceMgr.self().findWebviewByInstanceId(instanceId);
                ret = b;
            }
        }
        return ret;
    }

    private void createUniNView(IWebview webview, ViewGroup parent, String weexId, org.json.JSONObject info) {
        this.createUniNView(webview, parent, weexId, info, WXBaseWrapper.DE_INDEX);
    }

    private void createUniNView(IWebview webview, ViewGroup parent, String weexId, org.json.JSONObject info, int zIndex) {
        WeexInstanceMgr.self().createWeexView(webview, parent, info, weexId, zIndex);
    }

    private Object createWeexWindow(Object[] args) {
        IWebview webview = (IWebview)args[0];
        this.registerAllEvent(webview.obtainApp());
        ViewGroup parent = (ViewGroup)args[1];
        org.json.JSONObject jsonObject = (org.json.JSONObject)args[2];
        String weexId = (String)args[3];
        return WeexInstanceMgr.self().createWeexView(webview, parent, jsonObject, weexId, WXViewWrapper.DE_INDEX);
    }

    private Object createWeexService(Object[] args) {
        IApp app = (IApp)args[0];
        this.registerAllEvent(app);
        org.json.JSONObject data = (org.json.JSONObject)args[1];
        ViewGroup parent = (ViewGroup)args[2];
        String weexId = (String)args[3];
        return WeexInstanceMgr.self().createWeexService(app, parent, weexId, data);
    }

    public String callNativeModule(String instanceId, JSONObject data) {
        String module = data.getString("plugin");
        String method = data.getString("method");
        com.alibaba.fastjson.JSONArray arguments = JSON.parseArray((String)data.getString("args"));
        Object object = WXBridgeManager.getInstance().callNativeModule(instanceId, module, method, arguments, null);
        if (object != null) {
            if (object instanceof JSONObject) {
                org.json.JSONObject json = JSONUtil.createJSONObject((String)((JSONObject)object).toJSONString());
                return JSUtil.wrapJsVar((org.json.JSONObject)json);
            }
            if (object instanceof HashMap) {
                org.json.JSONObject json = JSONUtil.createJSONObject((String)new JSONObject((Map)((HashMap)object)).toJSONString());
                return JSUtil.wrapJsVar((org.json.JSONObject)json);
            }
            if (object instanceof com.alibaba.fastjson.JSONArray) {
                JSONArray json = JSONUtil.createJSONArray((String)((com.alibaba.fastjson.JSONArray)object).toJSONString());
                return JSUtil.wrapJsVar((JSONArray)json);
            }
            if (object instanceof String) {
                return JSUtil.wrapJsVar((String)String.valueOf(object));
            }
            if (object instanceof org.json.JSONObject) {
                return JSUtil.wrapJsVar((org.json.JSONObject)((org.json.JSONObject)object));
            }
            if (object instanceof JSONArray) {
                return JSUtil.wrapJsVar((JSONArray)((JSONArray)object));
            }
        }
        return JSUtil.wrapJsVar((String)"");
    }
}

