/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.uniapp.ui.shadow;

import android.graphics.PointF;
import android.graphics.Rect;
import android.text.TextUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.List;

public class UniBoxShadowOptions {
    private static final String TAG = "UniBoxShadowOptions";
    public List<IParser> optionParamParsers;
    private float viewport = 750.0f;
    public float hShadow;
    public float vShadow;
    public float blur = 0.0f;
    public float spread = 0.0f;
    public float[] radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public int color = -16777216;
    public boolean isInset = false;
    public int viewWidth = 0;
    public int viewHeight = 0;
    public PointF topLeft = null;

    public UniBoxShadowOptions(float vp) {
        if (this.viewport != 0.0f) {
            this.viewport = vp;
        }
        this.optionParamParsers = new ArrayList<IParser>();
        IParser spreadParser = new IParser(){

            @Override
            public void parse(String param) {
                if (!TextUtils.isEmpty((CharSequence)param)) {
                    float px = WXUtils.getFloat(param, Float.valueOf(0.0f)).floatValue();
                    UniBoxShadowOptions.this.spread = WXViewUtils.getRealSubPxByWidth(px, UniBoxShadowOptions.this.viewport);
                    WXLogUtils.w(UniBoxShadowOptions.TAG, "Experimental box-shadow attribute: spread");
                }
            }
        };
        IParser blurParser = new IParser(){

            @Override
            public void parse(String param) {
                if (!TextUtils.isEmpty((CharSequence)param)) {
                    float px = WXUtils.getFloat(param, Float.valueOf(0.0f)).floatValue();
                    UniBoxShadowOptions.this.blur = WXViewUtils.getRealSubPxByWidth(px, UniBoxShadowOptions.this.viewport);
                }
            }
        };
        this.optionParamParsers.add(blurParser);
        this.optionParamParsers.add(spreadParser);
    }

    public UniBoxShadowOptions scale(float scale) {
        if (scale > 0.0f && scale <= 1.0f) {
            UniBoxShadowOptions scaledOptions = new UniBoxShadowOptions(this.viewport);
            scaledOptions.hShadow = this.hShadow * scale;
            scaledOptions.vShadow = this.vShadow * scale;
            scaledOptions.blur = this.blur * scale;
            scaledOptions.spread = this.spread * scale;
            for (int i = 0; i < this.radii.length; ++i) {
                scaledOptions.radii[i] = this.radii[i] * scale;
            }
            scaledOptions.viewHeight = (int)((float)this.viewHeight * scale);
            scaledOptions.viewWidth = (int)((float)this.viewWidth * scale);
            if (this.topLeft != null) {
                scaledOptions.topLeft = new PointF();
                scaledOptions.topLeft.x = this.topLeft.x * scale;
                scaledOptions.topLeft.y = this.topLeft.y * scale;
            }
            scaledOptions.color = this.color;
            scaledOptions.isInset = this.isInset;
            WXLogUtils.d(TAG, "Scaled BoxShadowOptions: [" + scale + "] " + scaledOptions);
            return scaledOptions;
        }
        return null;
    }

    public Rect getTargetCanvasRect() {
        int canvasWidth = this.viewWidth + 2 * (int)(this.blur + this.spread + Math.abs(this.hShadow));
        int canvasHeight = this.viewHeight + 2 * (int)(this.blur + this.spread + Math.abs(this.vShadow));
        return new Rect(0, 0, canvasWidth, canvasHeight);
    }

    public String toString() {
        String r = "[" + this.radii[0] + "," + this.radii[2] + "," + this.radii[4] + "," + this.radii[6] + "]";
        StringBuffer sb = new StringBuffer("BoxShadowOptions{");
        sb.append("h-shadow=").append(this.hShadow);
        sb.append(", v-shadow=").append(this.vShadow);
        sb.append(", blur=").append(this.blur);
        sb.append(", spread=").append(this.spread);
        sb.append(", corner-radius=").append(r);
        sb.append(", color=#").append(Integer.toHexString(this.color));
        sb.append(", inset=").append(this.isInset);
        sb.append('}');
        return sb.toString();
    }

    public static interface IParser {
        public void parse(String var1);
    }
}

