/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.os.SystemClock;
import com.liulishuo.filedownloader.IDownloadSpeed;

public class DownloadSpeedMonitor
implements IDownloadSpeed.Monitor,
IDownloadSpeed.Lookup {
    private long mLastRefreshTime;
    private long mLastRefreshSofarBytes;
    private long mStartSofarBytes;
    private long mStartTime;
    private int mSpeed;
    private long mTotalBytes;
    private int mMinIntervalUpdateSpeed = 1000;

    @Override
    public void start(long startBytes) {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mStartSofarBytes = startBytes;
    }

    @Override
    public void end(long sofarBytes) {
        if (this.mStartTime <= 0L) {
            return;
        }
        long downloadSize = sofarBytes - this.mStartSofarBytes;
        this.mLastRefreshTime = 0L;
        long interval = SystemClock.uptimeMillis() - this.mStartTime;
        this.mSpeed = interval <= 0L ? (int)downloadSize : (int)(downloadSize / interval);
    }

    @Override
    public void update(long sofarBytes) {
        if (this.mMinIntervalUpdateSpeed <= 0) {
            return;
        }
        boolean isUpdateData = false;
        if (this.mLastRefreshTime == 0L) {
            isUpdateData = true;
        } else {
            long interval = SystemClock.uptimeMillis() - this.mLastRefreshTime;
            if (interval >= (long)this.mMinIntervalUpdateSpeed || this.mSpeed == 0 && interval > 0L) {
                this.mSpeed = (int)((sofarBytes - this.mLastRefreshSofarBytes) / interval);
                this.mSpeed = Math.max(0, this.mSpeed);
                isUpdateData = true;
            }
        }
        if (isUpdateData) {
            this.mLastRefreshSofarBytes = sofarBytes;
            this.mLastRefreshTime = SystemClock.uptimeMillis();
        }
    }

    @Override
    public void reset() {
        this.mSpeed = 0;
        this.mLastRefreshTime = 0L;
    }

    @Override
    public int getSpeed() {
        return this.mSpeed;
    }

    @Override
    public void setMinIntervalUpdateSpeed(int minIntervalUpdateSpeed) {
        this.mMinIntervalUpdateSpeed = minIntervalUpdateSpeed;
    }
}

