/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.ICheckBindingScroller;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.AppearanceHelper;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXBaseScroller;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.helper.ScrollStartEndHelper;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.WXBaseRefreshLayout;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.util.DensityUtils;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.weex_scroller.helper.DCScrollStartEndHelper;
import io.dcloud.feature.weex_scroller.view.DCBounceScrollerView;
import io.dcloud.feature.weex_scroller.view.DCWXHorizontalScrollView;
import io.dcloud.feature.weex_scroller.view.DCWXScrollView;
import io.dcloud.feature.weex_scroller.view.WXStickyHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@Component(lazyload=false)
public class DCWXScroller
extends WXBaseScroller
implements DCWXScrollView.WXScrollViewListener,
Scrollable {
    public static final String DIRECTION = "direction";
    protected int mOrientation = 1;
    private List<WXComponent> mRefreshs = new ArrayList<WXComponent>();
    private int mChildrenLayoutOffset = 0;
    private boolean mForceLoadmoreNextTime = false;
    private int mOffsetAccuracy = 10;
    private Point mLastReport = new Point(-1, -1);
    private boolean mHasAddScrollEvent = false;
    private static final int SWIPE_MIN_DISTANCE = 5;
    private static final int SWIPE_THRESHOLD_VELOCITY = 300;
    private int mActiveFeature = 0;
    private ScrollStartEndHelper mScrollStartEndHelper;
    private GestureDetector mGestureDetector;
    private int pageSize = 0;
    private boolean pageEnable = false;
    private boolean mIsHostAttachedToWindow = false;
    private View.OnAttachStateChangeListener mOnAttachStateChangeListener;
    private boolean isAnimation = false;
    private boolean canScroll2Top = false;
    private FrameLayout mScrollerView;
    private Map<String, AppearanceHelper> mAppearanceComponents = new HashMap<String, AppearanceHelper>();
    private Map<String, Map<String, WXComponent>> mStickyMap = new HashMap<String, Map<String, WXComponent>>();
    private FrameLayout mRealView;
    private int mContentHeight = 0;
    private int mContentWidth = 0;
    private WXStickyHelper stickyHelper;
    private Handler handler = new Handler(Looper.getMainLooper());
    private boolean isScrollable = true;
    Map<String, WXComponent> childens = new HashMap<String, WXComponent>();
    private AtomicBoolean isViewLayoutFinished = new AtomicBoolean(false);

    @Deprecated
    public DCWXScroller(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, basicComponentData);
    }

    public DCWXScroller(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.stickyHelper = new WXStickyHelper(this);
        instance.getApmForInstance().updateDiffStats("wxScrollerCount", 1.0);
    }

    @Override
    public ViewGroup getRealView() {
        return this.mScrollerView;
    }

    @Override
    public void createViewImpl() {
        super.createViewImpl();
        for (int i = 0; i < this.mRefreshs.size(); ++i) {
            WXComponent component = this.mRefreshs.get(i);
            component.createViewImpl();
            this.checkRefreshOrLoading(component);
        }
    }

    @Override
    public ViewGroup getInnerView() {
        if (this.getHostView() == null) {
            return null;
        }
        if (this.getHostView() instanceof DCBounceScrollerView) {
            return (ViewGroup)((DCBounceScrollerView)((Object)this.getHostView())).getInnerView();
        }
        return (ViewGroup)this.getHostView();
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (DCScrollStartEndHelper.isScrollEvent(type) && this.getInnerView() != null && !this.mHasAddScrollEvent) {
            this.mHasAddScrollEvent = true;
            if (this.getInnerView() instanceof DCWXScrollView) {
                ((DCWXScrollView)this.getInnerView()).addScrollViewListener(new DCWXScrollView.WXScrollViewListener(){

                    @Override
                    public void onScrollChanged(DCWXScrollView scrollView, int x, int y, int oldx, int oldy) {
                        DCWXScroller.this.getScrollStartEndHelper().onScrolled(x, y);
                        if (!DCWXScroller.this.getEvents().contains("scroll")) {
                            return;
                        }
                        if (DCWXScroller.this.shouldReport(x, y)) {
                            DCWXScroller.this.fireScrollEvent(scrollView.getContentFrame(), x, y, oldx, oldy);
                        }
                    }

                    @Override
                    public void onScrollToBottom(DCWXScrollView scrollView, int x, int y) {
                        HashMap<String, String> values = new HashMap<String, String>(1);
                        values.put(DCWXScroller.DIRECTION, "bottom");
                        HashMap<String, Object> detail = new HashMap<String, Object>(1);
                        detail.put("detail", values);
                        DCWXScroller.this.fireEvent("scrolltolower", detail);
                    }

                    @Override
                    public void onScrollToTop(DCWXScrollView scrollView, int x, int y) {
                        HashMap<String, String> values = new HashMap<String, String>(1);
                        values.put(DCWXScroller.DIRECTION, "top");
                        HashMap<String, Object> detail = new HashMap<String, Object>(1);
                        detail.put("detail", values);
                        DCWXScroller.this.fireEvent("scrolltoupper", detail);
                    }

                    @Override
                    public void onScrollStopped(DCWXScrollView scrollView, int x, int y) {
                        DCWXScroller.this.getScrollStartEndHelper().onScrolled(x, y);
                        if (!DCWXScroller.this.getEvents().contains("scroll")) {
                            return;
                        }
                        DCWXScroller.this.fireScrollEvent(scrollView.getContentFrame(), x, y, 0, 0);
                    }

                    @Override
                    public void onScroll(DCWXScrollView scrollView, int x, int y) {
                    }
                });
            } else if (this.getInnerView() instanceof DCWXHorizontalScrollView) {
                ((DCWXHorizontalScrollView)this.getInnerView()).addScrollViewListener(new DCWXHorizontalScrollView.ScrollViewListener(){

                    @Override
                    public void onScrollChanged(DCWXHorizontalScrollView scrollView, int x, int y, int oldx, int oldy) {
                        DCWXScroller.this.getScrollStartEndHelper().onScrolled(x, y);
                        if (!DCWXScroller.this.getEvents().contains("scroll")) {
                            return;
                        }
                        if (DCWXScroller.this.shouldReport(x, y)) {
                            DCWXScroller.this.fireScrollEvent(scrollView.getContentFrame(), x, y, oldx, oldy);
                        }
                    }

                    @Override
                    public void onScrolltoTop() {
                        HashMap<String, String> values = new HashMap<String, String>(1);
                        values.put(DCWXScroller.DIRECTION, "top");
                        HashMap<String, Object> detail = new HashMap<String, Object>(1);
                        detail.put("detail", values);
                        DCWXScroller.this.fireEvent("scrolltoupper", detail);
                    }

                    @Override
                    public void onScrollToBottom() {
                        HashMap<String, String> values = new HashMap<String, String>(1);
                        values.put(DCWXScroller.DIRECTION, "bottom");
                        HashMap<String, Object> detail = new HashMap<String, Object>(1);
                        detail.put("detail", values);
                        DCWXScroller.this.fireEvent("scrolltolower", detail);
                    }
                });
            }
        }
    }

    private void fireScrollEvent(Rect contentFrame, int x, int y, int oldx, int oldy) {
        this.fireEvent("scroll", this.getScrollEvent(x, y, oldx, oldy));
    }

    public Map<String, Object> getScrollEvent(int x, int y, int oldx, int oldy) {
        Rect contentFrame = new Rect();
        int scrollLeft = 0;
        int scrollTop = 0;
        if (this.getInnerView() instanceof DCWXScrollView) {
            contentFrame = ((DCWXScrollView)this.getInnerView()).getContentFrame();
            scrollTop = this.getInnerView().getScrollY();
        } else if (this.getInnerView() instanceof DCWXHorizontalScrollView) {
            contentFrame = ((DCWXHorizontalScrollView)this.getInnerView()).getContentFrame();
            scrollLeft = this.getInnerView().getScrollX();
        }
        HashMap<String, Object> event = new HashMap<String, Object>(2);
        HashMap<String, Float> contentSize = new HashMap<String, Float>(6);
        HashMap contentOffset = new HashMap(2);
        float viewport = this.getInstance().getInstanceViewPortWidthWithFloat();
        contentSize.put("scrollWidth", Float.valueOf(WXViewUtils.getWebPxByWidth((float)contentFrame.width(), viewport)));
        contentSize.put("scrollHeight", Float.valueOf(WXViewUtils.getWebPxByWidth((float)contentFrame.height(), viewport)));
        contentSize.put("scrollLeft", Float.valueOf(WXViewUtils.getWebPxByWidth((float)scrollLeft, viewport)));
        contentSize.put("scrollTop", Float.valueOf(WXViewUtils.getWebPxByWidth((float)scrollTop, viewport)));
        contentSize.put("deltaX", Float.valueOf(WXViewUtils.getWebPxByWidth((float)oldx, viewport)));
        contentSize.put("deltaY", Float.valueOf(WXViewUtils.getWebPxByWidth((float)oldy, viewport)));
        event.put("detail", contentSize);
        return event;
    }

    @Override
    public Map<String, Object> getScrollEvent(int x, int y) {
        Rect contentFrame = new Rect();
        if (this.getInnerView() instanceof DCWXScrollView) {
            contentFrame = ((DCWXScrollView)this.getInnerView()).getContentFrame();
        } else if (this.getInnerView() instanceof DCWXHorizontalScrollView) {
            contentFrame = ((DCWXHorizontalScrollView)this.getInnerView()).getContentFrame();
        }
        HashMap<String, Object> event = new HashMap<String, Object>(2);
        HashMap<String, Float> contentSize = new HashMap<String, Float>(2);
        HashMap<String, Float> contentOffset = new HashMap<String, Float>(2);
        float viewport = this.getInstance().getInstanceViewPortWidthWithFloat();
        contentSize.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth((float)contentFrame.width(), viewport)));
        contentSize.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth((float)contentFrame.height(), viewport)));
        contentOffset.put("x", Float.valueOf(WXViewUtils.getWebPxByWidth((float)x, viewport)));
        contentOffset.put("y", Float.valueOf(WXViewUtils.getWebPxByWidth((float)y, viewport)));
        event.put("contentSize", contentSize);
        event.put("contentOffset", contentOffset);
        return event;
    }

    private boolean shouldReport(int x, int y) {
        if (this.mLastReport.x == -1 && this.mLastReport.y == -1) {
            this.mLastReport.x = x;
            this.mLastReport.y = y;
            return true;
        }
        if (this.mOrientation == 0 && Math.abs(x - this.mLastReport.x) >= this.mOffsetAccuracy) {
            this.mLastReport.x = x;
            this.mLastReport.y = y;
            return true;
        }
        if (this.mOrientation == 1 && Math.abs(y - this.mLastReport.y) >= this.mOffsetAccuracy) {
            this.mLastReport.x = x;
            this.mLastReport.y = y;
            return true;
        }
        return false;
    }

    @Override
    public void addSubView(View child, int index) {
        if (child == null || this.mRealView == null) {
            return;
        }
        if (child instanceof WXBaseRefreshLayout) {
            return;
        }
        int count = this.mRealView.getChildCount();
        int n = index = index >= count ? -1 : index;
        if (child.getParent() != null) {
            ((ViewGroup)child.getParent()).removeView(child);
        }
        if (index == -1) {
            this.mRealView.addView(child);
        } else {
            this.mRealView.addView(child, index);
        }
    }

    @Override
    protected int getChildrenLayoutTopOffset() {
        int listSize;
        if (this.mChildrenLayoutOffset == 0 && (listSize = this.mRefreshs.size()) > 0) {
            for (int i = 0; i < listSize; ++i) {
                WXComponent child = this.mRefreshs.get(i);
                this.mChildrenLayoutOffset += child.getLayoutTopOffsetForSibling();
            }
        }
        return this.mChildrenLayoutOffset;
    }

    @Override
    public void addChild(WXComponent child, int index) {
        if (child.getAttrs().containsKey("id")) {
            this.childens.put(child.getAttrs().get("id").toString(), child);
        }
        if (child instanceof WXBaseRefresh && this.checkRefreshOrLoading(child)) {
            this.mRefreshs.add(child);
        }
        super.addChild(child, index);
    }

    private boolean checkRefreshOrLoading(final WXComponent child) {
        Runnable runnable;
        boolean result = false;
        if (child instanceof WXRefresh && this.getHostView() != null) {
            ((BaseBounceView)((Object)this.getHostView())).setOnRefreshListener((WXRefresh)child);
            runnable = WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)((Object)DCWXScroller.this.getHostView())).setHeaderView(child);
                }
            });
            this.handler.postDelayed(runnable, 100L);
            result = true;
        }
        if (child instanceof WXLoading && this.getHostView() != null) {
            ((BaseBounceView)((Object)this.getHostView())).setOnLoadingListener((WXLoading)child);
            runnable = WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)((Object)DCWXScroller.this.getHostView())).setFooterView(child);
                }
            });
            this.handler.postDelayed(runnable, 100L);
            result = true;
        }
        return result;
    }

    @Override
    public void remove(WXComponent child, boolean destory) {
        super.remove(child, destory);
        if (child instanceof WXLoading) {
            ((BaseBounceView)((Object)this.getHostView())).removeFooterView(child);
        } else if (child instanceof WXRefresh) {
            ((BaseBounceView)((Object)this.getHostView())).removeHeaderView(child);
        }
    }

    @Override
    public void destroy() {
        if (this.getInnerView() != null && this.getInnerView() instanceof IWXScroller) {
            ((IWXScroller)this.getInnerView()).destroy();
        }
        if (this.mAppearanceComponents != null) {
            this.mAppearanceComponents.clear();
        }
        if (this.mStickyMap != null) {
            this.mStickyMap.clear();
        }
        if (this.mOnAttachStateChangeListener != null && this.getInnerView() != null) {
            this.getInnerView().removeOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        }
        super.destroy();
    }

    @Override
    public void setMarginsSupportRTL(ViewGroup.MarginLayoutParams lp, int left, int top, int right, int bottom) {
        if (Build.VERSION.SDK_INT >= 17) {
            lp.setMargins(left, top, right, bottom);
            lp.setMarginStart(left);
            lp.setMarginEnd(right);
        } else if (lp instanceof FrameLayout.LayoutParams) {
            FrameLayout.LayoutParams lp_frameLayout = (FrameLayout.LayoutParams)lp;
            if (this.isLayoutRTL()) {
                lp_frameLayout.gravity = 53;
                lp.setMargins(right, top, left, bottom);
            } else {
                lp_frameLayout.gravity = 51;
                lp.setMargins(left, top, right, bottom);
            }
        } else {
            lp.setMargins(left, top, right, bottom);
        }
    }

    @Override
    public void setLayout(WXComponent component) {
        if (TextUtils.isEmpty((CharSequence)component.getComponentType()) || TextUtils.isEmpty((CharSequence)component.getRef()) || component.getLayoutPosition() == null || component.getLayoutSize() == null) {
            return;
        }
        if (component.getHostView() != null) {
            int layoutDirection = component.isLayoutRTL() ? 1 : 0;
            ViewCompat.setLayoutDirection(component.getHostView(), (int)layoutDirection);
        }
        super.setLayout(component);
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        WXComponent.MeasureOutput measureOutput = new WXComponent.MeasureOutput();
        if (this.mOrientation == 0) {
            int screenW = WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
            int weexW = WXViewUtils.getWeexWidth(this.getInstanceId());
            measureOutput.width = width > (weexW >= screenW ? screenW : weexW) ? -1 : width;
            measureOutput.height = height;
        } else {
            int screenH = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
            int weexH = WXViewUtils.getWeexHeight(this.getInstanceId());
            measureOutput.height = height > (weexH >= screenH ? screenH : weexH) ? -1 : height;
            measureOutput.width = width;
        }
        return measureOutput;
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    protected ViewGroup initComponentHostView(@NonNull Context context) {
        Object host;
        String scroll;
        boolean scrollable = true;
        boolean scrollX = false;
        boolean scrollY = false;
        if (this.getAttrs().isEmpty()) {
            scroll = "vertical";
        } else {
            float aFloat;
            float realPxByWidth;
            if (this.getAttrs().containsKey("scrollX")) {
                scrollX = Boolean.parseBoolean(this.getAttrs().get("scrollX").toString());
            }
            if (this.getAttrs().containsKey("scrollY")) {
                scrollY = Boolean.parseBoolean(this.getAttrs().get("scrollY").toString());
            }
            if (scrollY) {
                scroll = "vertical";
                scrollable = !this.getAttrs().get("scrollY").equals("false");
            } else if (scrollX) {
                scroll = "horizontal";
                scrollable = !this.getAttrs().get("scrollX").equals("false");
            } else {
                scroll = this.getAttrs().containsKey("scrollDirection") ? this.getAttrs().getScrollDirection() : "vertical";
            }
            Object o = this.getAttrs().get("pagingEnabled");
            this.pageEnable = o != null && Boolean.parseBoolean(o.toString());
            Object pageSize = this.getAttrs().get("pageSize");
            if (pageSize != null && (realPxByWidth = WXViewUtils.getRealPxByWidth(aFloat = WXUtils.getFloat(pageSize), this.getInstance().getInstanceViewPortWidth())) != 0.0f) {
                this.pageSize = (int)realPxByWidth;
            }
        }
        if ("horizontal".equals(scroll)) {
            this.mOrientation = 0;
            final DCWXHorizontalScrollView scrollView = new DCWXHorizontalScrollView(context);
            scrollView.setWAScroller(this);
            scrollView.setScrollable(scrollable);
            this.mRealView = new FrameLayout(context);
            scrollView.setScrollViewListener(new DCWXHorizontalScrollView.ScrollViewListener(){

                @Override
                public void onScrollChanged(DCWXHorizontalScrollView scrollView, int x, int y, int oldx, int oldy) {
                    if (DCWXScroller.this.getInstance() == null) {
                        return;
                    }
                    DCWXScroller.this.procAppear(x, y, oldx, oldy);
                    DCWXScroller.this.onLoadMore((FrameLayout)scrollView, x, y);
                }

                @Override
                public void onScrolltoTop() {
                }

                @Override
                public void onScrollToBottom() {
                }
            });
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            scrollView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            scrollView.setHorizontalScrollBarEnabled(true);
            this.mScrollerView = scrollView;
            scrollView.setScrollBarSize(DensityUtils.dip2px((Context)this.getInstance().getContext(), (float)4.0f));
            final DCWXScroller component = this;
            final View.OnLayoutChangeListener listener = new View.OnLayoutChangeListener(){

                public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    final View frameLayout = view;
                    scrollView.post(new Runnable(){

                        @Override
                        public void run() {
                            if (DCWXScroller.this.isLayoutRTL()) {
                                int mw = frameLayout.getMeasuredWidth();
                                scrollView.scrollTo(mw, component.getScrollY());
                            } else {
                                scrollView.scrollTo(0, component.getScrollY());
                            }
                        }
                    });
                    if (DCWXScroller.this.mRealView != null) {
                        DCWXScroller.this.mRealView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    }
                }
            };
            this.mRealView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View view) {
                    view.addOnLayoutChangeListener(listener);
                }

                public void onViewDetachedFromWindow(View view) {
                    view.removeOnLayoutChangeListener(listener);
                }
            });
            if (this.pageEnable) {
                this.mGestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new MyGestureDetector(scrollView));
                scrollView.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        if (DCWXScroller.this.pageSize == 0) {
                            DCWXScroller.this.pageSize = v.getMeasuredWidth();
                        }
                        if (DCWXScroller.this.mGestureDetector.onTouchEvent(event)) {
                            return true;
                        }
                        if (event.getAction() == 1 || event.getAction() == 3) {
                            int scrollX = DCWXScroller.this.getScrollX();
                            int featureWidth = DCWXScroller.this.pageSize;
                            DCWXScroller.this.mActiveFeature = (scrollX + featureWidth / 2) / featureWidth;
                            int scrollTo = DCWXScroller.this.mActiveFeature * featureWidth;
                            scrollView.smoothScrollTo(scrollTo, 0);
                            return true;
                        }
                        return false;
                    }
                });
            }
            host = scrollView;
        } else {
            this.mOrientation = 1;
            DCBounceScrollerView scrollerView = new DCBounceScrollerView(context, this.mOrientation, this);
            this.mRealView = new FrameLayout(context);
            DCWXScrollView innerView = (DCWXScrollView)scrollerView.getInnerView();
            innerView.addScrollViewListener(this);
            if (!scrollX && !scrollY) {
                innerView.setScrollable(false);
            } else {
                innerView.setScrollable(scrollable);
            }
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            innerView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            innerView.setVerticalScrollBarEnabled(true);
            this.mScrollerView = innerView;
            innerView.setNestedScrollingEnabled(WXUtils.getBoolean(this.getAttrs().get("nestedScrollingEnabled"), true));
            innerView.addScrollViewListener(new DCWXScrollView.WXScrollViewListener(){

                @Override
                public void onScrollChanged(DCWXScrollView scrollView, int x, int y, int oldx, int oldy) {
                }

                @Override
                public void onScrollToBottom(DCWXScrollView scrollView, int x, int y) {
                }

                @Override
                public void onScrollToTop(DCWXScrollView scrollView, int x, int y) {
                }

                @Override
                public void onScrollStopped(DCWXScrollView scrollView, int x, int y) {
                    if (DCWXScroller.this.getInstance() == null) {
                        return;
                    }
                    List<OnWXScrollListener> listeners = DCWXScroller.this.getInstance().getWXScrollListeners();
                    if (listeners != null && listeners.size() > 0) {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            listener.onScrollStateChanged((View)scrollView, x, y, 0);
                        }
                    }
                    DCWXScroller.this.getScrollStartEndHelper().onScrollStateChanged(0);
                }

                @Override
                public void onScroll(DCWXScrollView scrollView, int x, int y) {
                    if (DCWXScroller.this.getInstance() == null) {
                        return;
                    }
                    List<OnWXScrollListener> listeners = DCWXScroller.this.getInstance().getWXScrollListeners();
                    if (listeners != null && listeners.size() > 0) {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            if (listener instanceof ICheckBindingScroller) {
                                if (!((ICheckBindingScroller)((Object)listener)).isNeedScroller(DCWXScroller.this.getRef(), null)) continue;
                                listener.onScrolled((View)scrollView, x, y);
                                continue;
                            }
                            listener.onScrolled((View)scrollView, x, y);
                        }
                    }
                }
            });
            host = scrollerView;
        }
        host.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                DCWXScroller.this.procAppear(0, 0, 0, 0);
                Object view = DCWXScroller.this.getHostView();
                if (view == null || DCWXScroller.this.getInstance() == null) {
                    return;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.mOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                DCWXScroller.this.mIsHostAttachedToWindow = true;
                DCWXScroller.this.procAppear(DCWXScroller.this.getScrollX(), DCWXScroller.this.getScrollY(), DCWXScroller.this.getScrollX(), DCWXScroller.this.getScrollY());
            }

            public void onViewDetachedFromWindow(View v) {
                DCWXScroller.this.mIsHostAttachedToWindow = false;
                DCWXScroller.this.dispatchDisappearEvent();
            }
        };
        host.addOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        return host;
    }

    @Override
    public int getScrollY() {
        return this.getInnerView() == null ? 0 : this.getInnerView().getScrollY();
    }

    @Override
    public int getScrollX() {
        return this.getInnerView() == null ? 0 : this.getInnerView().getScrollX();
    }

    @Override
    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public Map<String, Map<String, WXComponent>> getStickMap() {
        return this.mStickyMap;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "showScrollbar": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setShowScrollbar(result);
                }
                return true;
            }
            case "scrollable": {
                boolean scrollable = WXUtils.getBoolean(param, true);
                this.setScrollable(scrollable);
                return true;
            }
            case "scrollX": 
            case "scrollY": {
                boolean scrollable = !String.valueOf(param).equals("false");
                this.setScrollable(scrollable);
                return true;
            }
            case "offsetAccuracy": {
                int accuracy = WXUtils.getInteger(param, 10);
                this.setOffsetAccuracy(accuracy);
                return true;
            }
            case "scrollWithAnimation": {
                boolean animation = WXUtils.getBoolean(param, false);
                this.setScrollWithAnimation(animation);
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="scrollIntoView")
    public void setScrollIntoView(final String ref) {
        if (!this.isViewLayoutFinished.get()) {
            this.getInnerView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (DCWXScroller.this.getInstance() == null) {
                        return;
                    }
                    WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponentById(DCWXScroller.this.getInstanceId(), ref);
                    if (component != null) {
                        DCWXScroller.this.scrollTo(component, (Map<String, Object>)JSONObject.parseObject((String)"{'animated':false}"));
                    }
                    DCWXScroller.this.isViewLayoutFinished.set(true);
                    final 12 that = this;
                    DCWXScroller.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            DCWXScroller.this.getInnerView().getViewTreeObserver().removeOnGlobalLayoutListener(that);
                        }
                    }, 100L);
                }
            });
        } else {
            WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponentById(this.getInstanceId(), ref);
            if (component != null) {
                this.scrollTo(component, (Map<String, Object>)JSONObject.parseObject((String)StringUtil.format((String)"{'animated':%b}", (Object[])new Object[]{this.isAnimation})));
            }
        }
    }

    @JSMethod
    public void scrollTo(int top) {
        float realPx = WXViewUtils.getRealPxByWidth((float)top, this.getInstance().getInstanceViewPortWidth());
        if (this.getInnerView() instanceof DCWXScrollView) {
            ((DCWXScrollView)this.getInnerView()).smoothScrollTo(0, (int)realPx);
        } else if (this.getInnerView() instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView)this.getInnerView()).smoothScrollTo((int)realPx, 0);
        }
    }

    @JSMethod
    public void scrollTo(String op, JSCallback callback) {
        JSONObject opJson = JSON.parseObject((String)op);
        String topStr = opJson.getString("scrollTop");
        float realPx = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(topStr), this.getInstance().getInstanceViewPortWidth());
        if (this.getInnerView() instanceof DCWXScrollView) {
            ((DCWXScrollView)this.getInnerView()).smoothScrollTo(0, (int)realPx);
        } else if (this.getInnerView() instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView)this.getInnerView()).smoothScrollTo((int)realPx, 0);
        }
        if (callback != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("type", "success");
            callback.invoke(params);
        }
    }

    private WXComponent getViewById(String id2) {
        if (this.childens.containsKey(id2)) {
            return this.childens.get(id2);
        }
        for (WXComponent child : this.childens.values()) {
            if (!child.getAttrs().containsKey("id") || !child.getAttrs().get("id").equals(id2)) continue;
            return child;
        }
        return null;
    }

    @WXComponentProp(name="showScrollbar")
    public void setShowScrollbar(boolean show) {
        if (this.getInnerView() == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.getInnerView().setVerticalScrollBarEnabled(show);
        } else {
            this.getInnerView().setHorizontalScrollBarEnabled(show);
        }
    }

    @WXComponentProp(name="scrollWithAnimation")
    public void setScrollWithAnimation(boolean isAnimation) {
        this.isAnimation = isAnimation;
    }

    @WXComponentProp(name="upperThreshold")
    public void setUpperHeight(int height) {
        ViewGroup host = this.getInnerView();
        float realPx = WXViewUtils.getRealPxByWidth((float)height, this.getInstance().getInstanceViewPortWidth());
        if (host instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView)host).setUpperLength(realPx);
        } else if (host instanceof DCWXScrollView) {
            ((DCWXScrollView)host).setUpperLength(realPx);
        }
    }

    @WXComponentProp(name="enable-back-to-top")
    public void isEnableBackToTop(boolean toTop) {
        this.canScroll2Top = toTop;
    }

    @JSMethod
    public void scrollToTop() {
        if (this.getInnerView() instanceof DCWXScrollView && this.canScroll2Top) {
            ((DCWXScrollView)this.getInnerView()).smoothScrollTo(0, 0);
        }
    }

    @WXComponentProp(name="scrollTop")
    public void setScrollTop(String topStr) {
        if (this.getInnerView() instanceof DCWXScrollView) {
            final float realPy = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(topStr), this.getInstance().getInstanceViewPortWidth());
            if (!this.isViewLayoutFinished.get()) {
                this.getInnerView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        DCWXScroller.this.getInnerView().scrollTo(0, (int)realPy);
                        DCWXScroller.this.isViewLayoutFinished.set(true);
                        final 13 that = this;
                        DCWXScroller.this.handler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                DCWXScroller.this.getInnerView().getViewTreeObserver().removeOnGlobalLayoutListener(that);
                            }
                        }, 100L);
                    }
                });
            } else {
                if (this.isAnimation) {
                    if (this.getInnerView() instanceof DCWXScrollView) {
                        ((DCWXScrollView)this.getInnerView()).stopScroll();
                    }
                    ObjectAnimator xAnimator = ObjectAnimator.ofInt((Object)this.getInnerView(), (String)"scrollY", (int[])new int[]{this.getInnerView().getScrollY(), (int)realPy});
                    xAnimator.setDuration(200L).start();
                } else {
                    this.getInnerView().post(new Runnable(){

                        @Override
                        public void run() {
                            DCWXScroller.this.getInnerView().scrollTo(0, (int)realPy);
                        }
                    });
                }
                this.isViewLayoutFinished.set(true);
            }
        }
    }

    @WXComponentProp(name="scrollLeft")
    public void setScrollLeft(String leftStr) {
        if (this.getInnerView() instanceof DCWXHorizontalScrollView) {
            final float realPx = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(leftStr), this.getInstance().getInstanceViewPortWidth());
            if (!this.isViewLayoutFinished.get()) {
                this.getInnerView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        ObjectAnimator xAnimator = ObjectAnimator.ofInt((Object)DCWXScroller.this.getInnerView(), (String)"scrollX", (int[])new int[]{DCWXScroller.this.getInnerView().getScrollX(), (int)realPx});
                        xAnimator.setDuration(1L).start();
                        DCWXScroller.this.isViewLayoutFinished.set(true);
                        final 15 that = this;
                        DCWXScroller.this.handler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                DCWXScroller.this.getInnerView().getViewTreeObserver().removeOnGlobalLayoutListener(that);
                            }
                        }, 100L);
                    }
                });
            } else {
                if (this.isAnimation) {
                    if (this.getInnerView() instanceof DCWXHorizontalScrollView) {
                        ((DCWXHorizontalScrollView)this.getInnerView()).stopScroll();
                    }
                    ObjectAnimator xAnimator = ObjectAnimator.ofInt((Object)this.getInnerView(), (String)"scrollX", (int[])new int[]{this.getInnerView().getScrollX(), (int)realPx});
                    xAnimator.setDuration(200L).start();
                } else {
                    ((DCWXHorizontalScrollView)this.getInnerView()).smoothScrollTo((int)realPx, 0);
                }
                this.isViewLayoutFinished.set(true);
            }
        }
    }

    @WXComponentProp(name="lowerThreshold")
    public void setLowwerHeight(int height) {
        ViewGroup host = this.getInnerView();
        float realPx = WXViewUtils.getRealPxByWidth((float)height, this.getInstance().getInstanceViewPortWidth());
        if (host instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView)host).setLowwerLength(realPx);
        } else if (host instanceof DCWXScrollView) {
            ((DCWXScrollView)host).setLowwerLength(realPx);
        }
    }

    @Override
    protected void onFinishLayout() {
        super.onFinishLayout();
    }

    public void setScrollable(boolean scrollable) {
        this.isScrollable = scrollable;
        ViewGroup hostView = this.getInnerView();
        if (hostView instanceof DCWXHorizontalScrollView) {
            ((DCWXHorizontalScrollView)hostView).setScrollable(scrollable);
        } else if (hostView instanceof DCWXScrollView) {
            ((DCWXScrollView)hostView).setScrollable(scrollable);
        }
    }

    @WXComponentProp(name="offsetAccuracy")
    public void setOffsetAccuracy(int accuracy) {
        float realPx = WXViewUtils.getRealPxByWidth((float)accuracy, this.getInstance().getInstanceViewPortWidth());
        this.mOffsetAccuracy = (int)realPx;
    }

    @WXComponentProp(name="decelerationRate")
    public void setDecelerationRate(float rate) {
        if (this.getInnerView() instanceof DCWXScrollView) {
            ((DCWXScrollView)this.getInnerView()).setRate(rate);
        }
    }

    @Override
    public boolean isScrollable() {
        return this.isScrollable;
    }

    @Override
    public void bindStickStyle(WXComponent component) {
        this.stickyHelper.bindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void unbindStickStyle(WXComponent component) {
        this.stickyHelper.unbindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void bindAppearEvent(WXComponent component) {
        this.setWatch(0, component, true);
    }

    private void setWatch(int event, WXComponent component, boolean isWatch) {
        AppearanceHelper item = this.mAppearanceComponents.get(component.getRef());
        if (item == null) {
            item = new AppearanceHelper(component);
            this.mAppearanceComponents.put(component.getRef(), item);
        }
        item.setWatchEvent(event, isWatch);
        this.procAppear(0, 0, 0, 0);
    }

    @Override
    public void bindDisappearEvent(WXComponent component) {
        this.setWatch(1, component, true);
    }

    @Override
    public void unbindAppearEvent(WXComponent component) {
        this.setWatch(0, component, false);
    }

    @Override
    public void unbindDisappearEvent(WXComponent component) {
        this.setWatch(1, component, false);
    }

    @Override
    public void scrollTo(WXComponent component, Map<String, Object> options) {
        float offsetFloat = 0.0f;
        boolean smooth = true;
        if (options != null) {
            String offset = options.get("offset") == null ? "0" : options.get("offset").toString();
            smooth = WXUtils.getBoolean(options.get("animated"), true);
            if (offset != null) {
                try {
                    offsetFloat = WXViewUtils.getRealPxByWidth(Float.parseFloat(offset), this.getInstance().getInstanceViewPortWidth());
                }
                catch (Exception e) {
                    WXLogUtils.e("Float parseFloat error :" + e.getMessage());
                }
            }
        }
        if (this.pageEnable) {
            this.mActiveFeature = this.mChildren.indexOf(component);
        }
        int viewYInScroller = component.getAbsoluteY() - this.getAbsoluteY();
        int viewXInScroller = 0;
        if (this.isLayoutRTL()) {
            if (this.getInnerView().getChildCount() > 0) {
                int totalWidth = this.getInnerView().getChildAt(0).getWidth();
                int displayWidth = this.getInnerView().getMeasuredWidth();
                viewXInScroller = totalWidth - (component.getAbsoluteX() - this.getAbsoluteX()) - displayWidth;
            } else {
                viewXInScroller = component.getAbsoluteX() - this.getAbsoluteX();
            }
            offsetFloat = -offsetFloat;
        } else {
            viewXInScroller = component.getAbsoluteX() - this.getAbsoluteX();
        }
        this.scrollBy(viewXInScroller - this.getScrollX() + (int)offsetFloat, viewYInScroller - this.getScrollY() + (int)offsetFloat, smooth);
    }

    public void scrollBy(int x, int y) {
        this.scrollBy(x, y, false);
    }

    public void scrollBy(final int x, final int y, final boolean smooth) {
        if (this.getInnerView() == null) {
            return;
        }
        this.getInnerView().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (DCWXScroller.this.mOrientation == 1) {
                    if (smooth) {
                        ((DCWXScrollView)DCWXScroller.this.getInnerView()).smoothScrollBy(0, y);
                    } else {
                        ((DCWXScrollView)DCWXScroller.this.getInnerView()).scrollBy(0, y);
                    }
                } else if (smooth) {
                    ((DCWXHorizontalScrollView)DCWXScroller.this.getInnerView()).smoothScrollBy(x, 0);
                } else {
                    ((DCWXHorizontalScrollView)DCWXScroller.this.getInnerView()).scrollBy(x, 0);
                }
                DCWXScroller.this.getInnerView().invalidate();
            }
        }, 16L);
    }

    @Override
    public void onScrollChanged(DCWXScrollView scrollView, int x, int y, int oldx, int oldy) {
        this.procAppear(x, y, oldx, oldy);
    }

    @Override
    public void notifyAppearStateChange(String wxEventType, String direction) {
        if (this.containsEvent("appear") || this.containsEvent("disappear")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(DIRECTION, direction);
            this.fireEvent(wxEventType, params);
        }
    }

    private void procAppear(int x, int y, int oldx, int oldy) {
        String direction;
        if (!this.mIsHostAttachedToWindow) {
            return;
        }
        int moveY = y - oldy;
        int moveX = x - oldx;
        String string2 = moveY > 0 ? "up" : (direction = moveY < 0 ? "down" : null);
        if (this.mOrientation == 0 && moveX != 0) {
            direction = moveX > 0 ? "right" : "left";
        }
        for (Map.Entry<String, AppearanceHelper> item : this.mAppearanceComponents.entrySet()) {
            boolean visible;
            int result;
            AppearanceHelper helper = item.getValue();
            if (!helper.isWatch() || (result = helper.setAppearStatus(visible = this.checkItemVisibleInScroller(helper.getAwareChild()))) == 0) continue;
            helper.getAwareChild().notifyAppearStateChange(result == 1 ? "appear" : "disappear", direction);
        }
    }

    private boolean checkItemVisibleInScroller(WXComponent component) {
        boolean visible = false;
        while (component != null && !(component instanceof DCWXScroller)) {
            if (component.getParent() instanceof DCWXScroller) {
                int offsetTop;
                int offsetLeft;
                visible = this.mOrientation == 0 ? (float)(offsetLeft = (int)component.getLayoutPosition().getLeft() - this.getScrollX()) > 0.0f - component.getLayoutWidth() && (float)offsetLeft < this.getLayoutWidth() : (float)(offsetTop = (int)component.getLayoutPosition().getTop() - this.getScrollY()) > 0.0f - component.getLayoutHeight() && (float)offsetTop < this.getLayoutHeight();
            }
            component = component.getParent();
        }
        return visible;
    }

    private void dispatchDisappearEvent() {
        for (Map.Entry<String, AppearanceHelper> item : this.mAppearanceComponents.entrySet()) {
            int result;
            AppearanceHelper helper = item.getValue();
            if (!helper.isWatch() || (result = helper.setAppearStatus(false)) == 0) continue;
            helper.getAwareChild().notifyAppearStateChange(result == 1 ? "appear" : "disappear", "");
        }
    }

    @Override
    public void onScrollToBottom(DCWXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScrollToTop(DCWXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScrollStopped(DCWXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScroll(DCWXScrollView scrollView, int x, int y) {
        this.onLoadMore((FrameLayout)scrollView, x, y);
    }

    protected void onLoadMore(FrameLayout scrollView, int x, int y) {
        try {
            String offset = this.getAttrs().getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                return;
            }
            int offsetInt = (int)WXViewUtils.getRealPxByWidth(Float.parseFloat(offset), this.getInstance().getInstanceViewPortWidth());
            if (scrollView instanceof DCWXHorizontalScrollView) {
                int contentWidth = scrollView.getChildAt(0).getWidth();
                int offScreenX = contentWidth - x - scrollView.getWidth();
                if (offScreenX < offsetInt && (this.mContentWidth != contentWidth || this.mForceLoadmoreNextTime)) {
                    this.fireEvent("loadmore");
                    this.mContentWidth = contentWidth;
                    this.mForceLoadmoreNextTime = false;
                }
            } else {
                int scrollerH;
                int contentH = scrollView.getChildAt(0).getHeight();
                int offScreenY = contentH - y - (scrollerH = scrollView.getHeight());
                if (offScreenY < offsetInt) {
                    if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.d("[WXScroller-onScroll] offScreenY :" + offScreenY);
                    }
                    if (this.mContentHeight != contentH || this.mForceLoadmoreNextTime) {
                        this.fireEvent("loadmore");
                        this.mContentHeight = contentH;
                        this.mForceLoadmoreNextTime = false;
                    }
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.d("[DCWXScroller-onScroll] ", e);
        }
    }

    @JSMethod
    public void resetLoadmore() {
        this.mForceLoadmoreNextTime = true;
    }

    public ScrollStartEndHelper getScrollStartEndHelper() {
        if (this.mScrollStartEndHelper == null) {
            this.mScrollStartEndHelper = new ScrollStartEndHelper(this);
        }
        return this.mScrollStartEndHelper;
    }

    class MyGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        private final DCWXHorizontalScrollView scrollView;

        public DCWXHorizontalScrollView getScrollView() {
            return this.scrollView;
        }

        MyGestureDetector(DCWXHorizontalScrollView horizontalScrollView) {
            this.scrollView = horizontalScrollView;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            int mItems = DCWXScroller.this.mChildren.size();
            try {
                if (e1.getX() - e2.getX() > 5.0f && Math.abs(velocityX) > 300.0f) {
                    int featureWidth = DCWXScroller.this.pageSize;
                    DCWXScroller.this.mActiveFeature = DCWXScroller.this.mActiveFeature < mItems - 1 ? DCWXScroller.this.mActiveFeature + 1 : mItems - 1;
                    this.scrollView.smoothScrollTo(DCWXScroller.this.mActiveFeature * featureWidth, 0);
                    return true;
                }
                if (e2.getX() - e1.getX() > 5.0f && Math.abs(velocityX) > 300.0f) {
                    int featureWidth = DCWXScroller.this.pageSize;
                    DCWXScroller.this.mActiveFeature = DCWXScroller.this.mActiveFeature > 0 ? DCWXScroller.this.mActiveFeature - 1 : 0;
                    this.scrollView.smoothScrollTo(DCWXScroller.this.mActiveFeature * featureWidth, 0);
                    return true;
                }
            }
            catch (Exception e) {
                WXLogUtils.e("There was an error processing the Fling event:" + e.getMessage());
            }
            return false;
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            instance.setUseScroller(true);
            return new DCWXScroller(instance, parent, basicComponentData);
        }
    }
}

