/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class TempFile {
    private FileOutputStream fos;
    private FileChannel channel;
    private byte[] localFrame;

    public TempFile(String fileName) {
        this.createFileToSDCard(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileToSDCard(String filename) {
        try {
            File parent_path = Environment.getExternalStorageDirectory();
            File dir = new File(parent_path.getAbsoluteFile(), "ARTCRecord");
            dir.mkdir();
            File file = new File(dir.getAbsoluteFile(), filename);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            this.fos = new FileOutputStream(file);
            this.channel = this.fos.getChannel();
            Log.d((String)this.getClass().getSimpleName(), (String)("kurt create file success " + file.getAbsolutePath()));
        }
        catch (IOException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)"kurt create file failed");
        }
    }

    public void write(ByteBuffer buffer) {
        try {
            if (this.channel != null) {
                this.channel.write(buffer);
            }
        }
        catch (IOException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)"kurt write file failed");
        }
    }

    public void write(byte[] buffer) {
        try {
            if (this.channel != null) {
                this.channel.write(ByteBuffer.wrap(buffer));
            }
        }
        catch (IOException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)"kurt write file failed");
        }
    }

    public void close() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.fos != null) {
                this.fos.flush();
                this.fos.close();
            }
            this.localFrame = null;
            this.channel = null;
            this.fos = null;
        }
        catch (IOException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)"kurt close file failed");
        }
    }
}

