/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.opengl.GLES20;
import com.daasuu.mp4compose.filter.GlFilter;

public class GlGammaFilter
extends GlFilter {
    private static final String GAMMA_FRAGMENT_SHADER = "precision mediump float; varying vec2 vTextureCoord;\n \n uniform lowp sampler2D sTexture;\n uniform lowp float gamma;\n \n void main()\n {\n     lowp vec4 textureColor = texture2D(sTexture, vTextureCoord);\n     \n     gl_FragColor = vec4(pow(textureColor.rgb, vec3(gamma)), textureColor.w);\n }";
    private float gamma = 1.2f;

    public GlGammaFilter() {
        super("attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n", GAMMA_FRAGMENT_SHADER);
    }

    public void setGamma(float gamma) {
        this.gamma = gamma;
    }

    @Override
    public void onDraw() {
        GLES20.glUniform1f((int)this.getHandle("gamma"), (float)this.gamma);
    }
}

