/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.android.vending.developer.signing.tools.extern.export;

import com.google.common.collect.ImmutableList;
import com.google.security.keymaster.lite.KeymaestroHybridEncrypter;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.KeystoreHelper;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.KeystoreKey;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.UnsupportedAlgorithmException;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.Utils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ExportEncryptedPrivateKeyTool {
    private static final String FLAG_KEYSTORE = "keystore";
    private static final String FLAG_ALIAS = "alias";
    private static final String FLAG_ENCRYPTION_KEY = "encryptionkey";
    private static final String FLAG_OUTPUT = "output";
    private static final String FLAG_SIGNING_KEYSTORE = "signing-keystore";
    private static final String FLAG_SIGNING_KEY_ALIAS = "signing-key-alias";
    private static final String FLAG_KEYSTORE_PWD = "keystore-pass";
    private static final String FLAG_KEY_PWD = "key-pass";
    private static final String FLAG_INCLUDE_CERT = "include-cert";
    private static final ImmutableList<String> SUPPORTED_SIGNING_ALGORITHMS = ImmutableList.of("RSA", "DSA");
    private static final String HELP_PAGE = "help.txt";
    private final KeystoreHelper keystoreHelper;

    public static void main(String[] args) {
        if (args.length == 0 || args[0].equals("--help")) {
            ExportEncryptedPrivateKeyTool.printUsage();
            return;
        }
        String keystoreFile = null;
        String alias = null;
        String encryptionPublicKeyHex = null;
        String outputFile = null;
        String signingKeyAlias = null;
        String signingKeystoreFile = null;
        String keystorePassword = null;
        String keyPassword = null;
        String includeCert = null;
        try {
            Map<String, String> parsedFlags = Utils.processArgs(args);
            keystoreFile = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_KEYSTORE);
            alias = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_ALIAS);
            encryptionPublicKeyHex = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_ENCRYPTION_KEY);
            outputFile = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_OUTPUT);
            if (parsedFlags.containsKey(FLAG_SIGNING_KEY_ALIAS)) {
                signingKeyAlias = parsedFlags.remove(FLAG_SIGNING_KEY_ALIAS);
                signingKeystoreFile = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_SIGNING_KEYSTORE);
            } else if (parsedFlags.containsKey(FLAG_INCLUDE_CERT)) {
                includeCert = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_INCLUDE_CERT);
            }
            if (parsedFlags.containsKey(FLAG_KEYSTORE_PWD)) {
                keystorePassword = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_KEYSTORE_PWD);
            }
            if (parsedFlags.containsKey(FLAG_KEY_PWD)) {
                keyPassword = ExportEncryptedPrivateKeyTool.getFlagValue(parsedFlags, FLAG_KEY_PWD);
            }
            if (keyPassword == null) {
                keyPassword = keystorePassword;
            }
            if (!parsedFlags.isEmpty()) {
                String string = String.valueOf(parsedFlags);
                throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Unrecognized flags: ").append(string).toString());
            }
        }
        catch (RuntimeException e) {
            String string = String.valueOf(Arrays.toString(args));
            System.err.println(string.length() != 0 ? "Error: Unable to parse the input: ".concat(string) : new String("Error: Unable to parse the input: "));
            e.printStackTrace();
            ExportEncryptedPrivateKeyTool.printUsage();
            System.exit(1);
        }
        try {
            ExportEncryptedPrivateKeyTool tool = new ExportEncryptedPrivateKeyTool(new KeystoreHelper());
            KeystoreKey keyToExport = keystorePassword != null && keyPassword != null ? new KeystoreKey(Paths.get(keystoreFile, new String[0]), alias, keystorePassword.toCharArray(), keyPassword.toCharArray()) : new KeystoreKey(Paths.get(keystoreFile, new String[0]), alias);
            Optional<KeystoreKey> keyToSignWith = signingKeystoreFile != null && signingKeyAlias != null ? Optional.of(new KeystoreKey(Paths.get(signingKeystoreFile, new String[0]), signingKeyAlias)) : Optional.empty();
            boolean includeCertificate = Boolean.parseBoolean(includeCert);
            tool.run(encryptionPublicKeyHex, outputFile, keyToExport, keyToSignWith, includeCertificate);
        }
        catch (Exception e) {
            System.err.println("Error: Unable to export or encrypt the private key");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String getFlagValue(Map<String, String> parsedFlags, String flagName) {
        return Utils.checkNotNull(parsedFlags.remove(flagName), new StringBuilder(20 + String.valueOf(flagName).length()).append("--").append(flagName).append(" must be specified").toString());
    }

    ExportEncryptedPrivateKeyTool(KeystoreHelper keystoreHelper) {
        this.keystoreHelper = keystoreHelper;
    }

    public ExportEncryptedPrivateKeyTool() {
        this.keystoreHelper = new KeystoreHelper();
    }

    public void run(String encryptionPublicKeyHex, String outputFile, KeystoreKey keyToExport, Optional<KeystoreKey> keyToSignWith, boolean includeCertificate) throws Exception {
        KeyStore keyStoreForKeyToExport = this.keystoreHelper.getKeystore(keyToExport);
        PrivateKey privateKeyToExport = this.keystoreHelper.getPrivateKey(keyStoreForKeyToExport, keyToExport);
        byte[] privateKeyPem = ExportEncryptedPrivateKeyTool.privateKeyToPem(privateKeyToExport);
        byte[] encryptedPrivateKey = this.encryptPrivateKey(ExportEncryptedPrivateKeyTool.fromHex(encryptionPublicKeyHex), privateKeyPem);
        if (keyToSignWith.isPresent() || includeCertificate) {
            Certificate certificate = this.keystoreHelper.getCertificate(keyStoreForKeyToExport, keyToExport);
            Optional<byte[]> signature = keyToSignWith.isPresent() ? Optional.of(this.sign(encryptedPrivateKey, keyToSignWith.get())) : Optional.empty();
            this.writeToZipFile(outputFile, signature, encryptedPrivateKey, ExportEncryptedPrivateKeyTool.certificateToPem(certificate));
        } else {
            Files.write(Paths.get(outputFile, new String[0]), encryptedPrivateKey, new OpenOption[0]);
        }
    }

    public byte[] sign(byte[] payload, KeystoreKey signingKey) throws Exception {
        KeyStore keyStoreOfSigningKey = this.keystoreHelper.getKeystore(signingKey);
        PrivateKey pk = this.keystoreHelper.getPrivateKey(keyStoreOfSigningKey, signingKey);
        if (!SUPPORTED_SIGNING_ALGORITHMS.contains(pk.getAlgorithm())) {
            throw new UnsupportedAlgorithmException(String.format("The signing key uses an unsupported algorithm. The tool only supports %s .", SUPPORTED_SIGNING_ALGORITHMS));
        }
        String string = String.valueOf(pk.getAlgorithm());
        Signature sig = Signature.getInstance(string.length() != 0 ? "SHA512with".concat(string) : new String("SHA512with"));
        sig.initSign(pk);
        sig.update(payload);
        return sig.sign();
    }

    static byte[] privateKeyToPem(PrivateKey privateKey) {
        String string = Base64.getEncoder().encodeToString(privateKey.getEncoded());
        String pemString = new StringBuilder(55 + String.valueOf(string).length()).append("-----BEGIN PRIVATE KEY-----\n").append(string).append("\n-----END PRIVATE KEY-----\n").toString();
        return pemString.getBytes(StandardCharsets.US_ASCII);
    }

    private static byte[] certificateToPem(Certificate certificate) throws CertificateEncodingException {
        String string = Base64.getEncoder().encodeToString(certificate.getEncoded());
        return new StringBuilder(55 + String.valueOf(string).length()).append("-----BEGIN CERTIFICATE-----\n").append(string).append("\n-----END CERTIFICATE-----\n").toString().getBytes(StandardCharsets.US_ASCII);
    }

    private byte[] encryptPrivateKey(byte[] encryptionPublicKey, byte[] plaintext) throws GeneralSecurityException {
        return new KeymaestroHybridEncrypter(encryptionPublicKey).encrypt(plaintext);
    }

    private void writeToZipFile(String outputFile, Optional<byte[]> signature, byte[] encryptedPrivateKey, byte[] pemEncodedCertificate) throws Exception {
        Path tempFile = Files.createFile(Paths.get(outputFile, new String[0]), new FileAttribute[0]);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(tempFile.toString()));){
            if (signature.isPresent()) {
                zipOutputStream.putNextEntry(new ZipEntry("encryptedPrivateKeySignature"));
                zipOutputStream.write(signature.get());
            }
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("encryptedPrivateKey"));
            zipOutputStream.write(encryptedPrivateKey);
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("certificate.pem"));
            zipOutputStream.write(pemEncodedCertificate);
            zipOutputStream.closeEntry();
        }
    }

    private static byte[] fromHex(String s2) {
        int len = s2.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException(new StringBuilder(102 + String.valueOf(s2).length()).append("Hex encoded byte array must have even length but instead has length: ").append(len).append(". Hex encoded string: ").append(s2).toString());
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s2.charAt(i), 16) << 4) + Character.digit(s2.charAt(i + 1), 16));
        }
        return data;
    }

    private static void printUsage() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(ExportEncryptedPrivateKeyTool.class.getResourceAsStream(HELP_PAGE), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read help.txt resource");
        }
    }
}

