/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.report;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.report.ReportUserInfo;
import cn.rongcloud.rtc.api.report.StatusBean;
import cn.rongcloud.rtc.api.report.StatusReport;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.core.StatsReport;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.report.StatusAudio;
import cn.rongcloud.rtc.engine.report.StatusRecvAudio;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.NetUtils;
import cn.rongcloud.rtc.utils.RTCSDPTools;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.ResourceTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatusReportParser {
    private HashMap<String, String> audioReceivedLevel = new HashMap();
    private String audioInputLevel;
    private int packetSendLossRate = 0;
    private int packetRcvLossRate = 0;
    int packetsSent = 0;
    int packetsSendLost = 0;
    int packetsSent_lastTime = 0;
    int packetsSendLost_lastTime = 0;
    int packetsRcv = 0;
    int packetsRcvLost = 0;
    int packetsRcv_lastTime = 0;
    int packetsRcvLost_lastTime = 0;
    int[] currentLevel = new int[]{0, 1, 2, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
    private static final String ssrc = "ssrc";
    private static final String packetsReceived = "packetsReceived";
    private static final String googTrackId = "googTrackId";
    private static final String googCodecName = "googCodecName";
    private static final String mediaType = "mediaType";
    private static final String googRtt = "googRtt";
    private static final String bytesReceived = "bytesReceived";
    private static final String googFrameRateReceived = "googFrameRateReceived";
    private static final String googFrameWidthReceived = "googFrameWidthReceived";
    private static final String googFrameHeightReceived = "googFrameHeightReceived";
    private static final String packetsLost = "packetsLost";
    private static final String mediaType_audio = "[mediaType: audio]";
    private static final String packetsSentStr = "packetsSent";
    private static final String googFrameHeightSent = "googFrameHeightSent";
    private static final String googFrameRateSent = "googFrameRateSent";
    private static final String googFrameWidthSent = "googFrameWidthSent";
    private static final String bytesSent = "bytesSent";
    private static final String googCandidatePair = "googCandidatePair";
    private static final String googActiveConnection_true = "[googActiveConnection: true]";
    private static final String audioOutputLevel = "audioOutputLevel";
    private static final String audioInputLevelStr = "audioInputLevel";
    private static final String googJitterReceived = "googJitterReceived";
    private static final String googFirsReceived = "googFirsReceived";
    private static final String googRenderDelayMs = "googRenderDelayMs";
    private static final String codecImplementationName = "codecImplementationName";
    private static final String localcandidate = "localcandidate";
    private static final String networkType = "networkType";
    private static final String ipAddress = "ipAddress";
    private static final String VideoBwe = "VideoBwe";
    private static final String googLocalAddress = "googLocalAddress";
    private static final String googAvailableSendBandwidth = "googAvailableSendBandwidth";
    private static final String googAvailableReceiveBandwidth = "googAvailableReceiveBandwidth";
    private static final String packetsDiscardedOnSend = "packetsDiscardedOnSend";
    private static final String googNacksReceived = "googNacksReceived";
    private static final String googPlisReceived = "googPlisReceived";
    private static final String googLocalCandidateType = "googLocalCandidateType";
    private StatusReport preStatusReport = new StatusReport();
    private static List<String> reportedIds = new ArrayList<String>();

    public int getAudioInputLevel(String audio) {
        int pos = Integer.valueOf(audio) / 1000;
        return this.currentLevel[pos];
    }

    public void parseAndCallback(StatsReport[] reports, IRCRTCStatusReportListener listener) {
        StatusReport statusReport = this.parseStatusReport(reports);
        StatusReportParser.reportLog(statusReport);
        if (listener == null) {
            return;
        }
        listener.onConnectionStats(statusReport);
        listener.onAudioReceivedLevel(this.audioReceivedLevel);
        listener.onAudioInputLevel(this.audioInputLevel);
    }

    private static void reportLog(StatusReport statusReport) {
        StatusReportParser.reportPacketLostRate(statusReport.statusVideoSends);
        StatusReportParser.reportPacketLostRate(statusReport.statusAudioSends);
        StatusReportParser.reportPacketLostRate(statusReport.statusAudioRcvs);
        StatusReportParser.reportPacketLostRate(statusReport.statusVideoRcvs);
    }

    private static void reportPacketLostRate(HashMap<String, StatusBean> statusBeanHashMap) {
        if (statusBeanHashMap == null || statusBeanHashMap.isEmpty()) {
            return;
        }
        block0: for (StatusBean bean : statusBeanHashMap.values()) {
            if (bean.packetLostRate > 25L) {
                ReportUtil.libStatus(ReportUtil.TAG.MONITORLOSSSTAT, "trackId|packetLostRate|isSend", StatusReportParser.getTrackId(bean), bean.packetLostRate, bean.isSend);
            }
            if (bean.isSend) continue;
            if (bean.bitRate <= 0L && !StatusReportParser.contains(bean.id)) {
                ReportUtil.libStatus(ReportUtil.TAG.MONITORRECEIVESTAT, "trackId|bitRate", StatusReportParser.getTrackId(bean), bean.bitRate);
                reportedIds.add(bean.id);
                continue;
            }
            if (bean.bitRate <= 0L || !StatusReportParser.contains(bean.id)) continue;
            ReportUtil.libStatus(ReportUtil.TAG.MONITORRECEIVESTAT, "trackId|bitRate", StatusReportParser.getTrackId(bean), bean.bitRate);
            for (String id : reportedIds) {
                if (!TextUtils.equals((CharSequence)id, (CharSequence)bean.id)) continue;
                reportedIds.remove(id);
                continue block0;
            }
        }
    }

    private static String getTrackId(StatusBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.mediaType)) {
            return bean.id;
        }
        return bean.id + "_" + bean.mediaType;
    }

    private static boolean contains(String id) {
        for (String v : reportedIds) {
            if (!id.equals(v)) continue;
            return true;
        }
        return false;
    }

    public StatusReport getParseResult(StatsReport[] reports) {
        return this.parseStatusReport(reports);
    }

    private StatusReport parseStatusReport(StatsReport[] reports) {
        StatusBean preStatusBean;
        this.packetSendLossRate = 0;
        this.packetRcvLossRate = 0;
        this.packetsRcv = 0;
        this.packetsRcvLost = 0;
        StatusReport statusReport = new StatusReport();
        this.audioReceivedLevel.clear();
        statusReport.bitRateRcv = 0L;
        statusReport.bitRateSend = 0L;
        ReportUserInfo reportUserInfo = null;
        for (StatsReport statsReport : reports) {
            try {
                StatsReport.Value[] valueArray;
                int pos;
                StatsReport.Value value;
                int n;
                Object statusBean;
                String trackId = "";
                if (statsReport.type.equals(ssrc)) {
                    int n2;
                    StatsReport.Value[] valueArray2;
                    if (statsReport.toString().contains(packetsReceived)) {
                        statusBean = new StatusBean();
                        statusBean.isSend = false;
                        valueArray2 = statsReport.values;
                        n = valueArray2.length;
                        block107: for (n2 = 0; n2 < n; ++n2) {
                            value = valueArray2[n2];
                            switch (value.name) {
                                case "googTrackId": {
                                    trackId = value.value;
                                    continue block107;
                                }
                                case "googCodecName": {
                                    statusBean.codecName = value.value;
                                    continue block107;
                                }
                                case "mediaType": {
                                    statusBean.mediaType = value.value;
                                    continue block107;
                                }
                                case "googRtt": {
                                    statusBean.rtt = this.toInt(value.value);
                                    continue block107;
                                }
                                case "bytesReceived": {
                                    statusBean.totalBitRate = this.toLong(value.value) * 8L / 1024L;
                                    continue block107;
                                }
                                case "googFrameRateReceived": {
                                    statusBean.frameRate = this.toInt(value.value);
                                    continue block107;
                                }
                                case "googFrameWidthReceived": {
                                    statusBean.frameWidth = this.toInt(value.value);
                                    continue block107;
                                }
                                case "googFrameHeightReceived": {
                                    statusBean.frameHeight = this.toInt(value.value);
                                    continue block107;
                                }
                                case "packetsLost": {
                                    statusBean.packetsLost = this.toLong(value.value);
                                    this.packetsRcvLost += this.toInt(value.value);
                                    continue block107;
                                }
                                case "packetsReceived": {
                                    statusBean.packets = this.toLong(value.value);
                                    this.packetsRcv += this.toInt(value.value);
                                    continue block107;
                                }
                                case "googJitterReceived": {
                                    statusBean.jitterReceived = this.toInt(value.value);
                                    continue block107;
                                }
                                case "googFirsReceived": {
                                    statusBean.firstReceived = this.toInt(value.value);
                                    continue block107;
                                }
                                case "googRenderDelayMs": {
                                    statusBean.renderDelayMs = this.toInt(value.value);
                                    continue block107;
                                }
                                case "audioOutputLevel": {
                                    pos = Integer.valueOf(value.value) / 1000;
                                    statusBean.audioLevel = this.currentLevel[pos];
                                    continue block107;
                                }
                                case "codecImplementationName": {
                                    statusBean.codecImplementationName = value.value;
                                    continue block107;
                                }
                                case "googNacksReceived": {
                                    statusBean.nacksReceived = value.value;
                                    continue block107;
                                }
                                case "googPlisReceived": {
                                    statusBean.plisReceived = value.value;
                                    continue block107;
                                }
                            }
                        }
                        if (trackId == null) {
                            throw new IllegalArgumentException("TrackId is empty.");
                        }
                        reportUserInfo = RTCSDPTools.mRemoteUserIdTrackIdMap.get(trackId);
                        if (reportUserInfo != null) {
                            statusBean.uid = reportUserInfo.getUserId();
                            statusBean.id = reportUserInfo.getMediaStreamId();
                            statusBean.streamType = ResourceTools.getSteamType(reportUserInfo.getMediaStreamId(), reportUserInfo.getTag());
                            statusBean.tag = reportUserInfo.getTag();
                            reportUserInfo = null;
                            if (statsReport.toString().contains(mediaType_audio)) {
                                if (statusReport.statusAudioRcvs.get(statusBean.id) == null) {
                                    statusReport.statusAudioRcvs.put(statusBean.id, (StatusBean)statusBean);
                                } else {
                                    statusBean.totalBitRate += statusReport.statusAudioRcvs.get((Object)statusBean.id).totalBitRate;
                                    statusBean.packetsLost += statusReport.statusAudioRcvs.get((Object)statusBean.id).packetsLost;
                                    statusReport.statusAudioRcvs.put(statusBean.id, (StatusBean)statusBean);
                                }
                            } else if (statusReport.statusVideoRcvs.get(statusBean.id) == null) {
                                statusReport.statusVideoRcvs.put(statusBean.id, (StatusBean)statusBean);
                            } else {
                                statusBean.totalBitRate += statusReport.statusVideoRcvs.get((Object)statusBean.id).totalBitRate;
                                statusBean.packetsLost += statusReport.statusVideoRcvs.get((Object)statusBean.id).packetsLost;
                                statusReport.statusVideoRcvs.put(statusBean.id, (StatusBean)statusBean);
                            }
                        }
                    }
                    if (statsReport.toString().contains(packetsSentStr)) {
                        statusBean = new StatusBean();
                        statusBean.isSend = true;
                        valueArray2 = statsReport.values;
                        n = valueArray2.length;
                        block108: for (n2 = 0; n2 < n; ++n2) {
                            value = valueArray2[n2];
                            switch (value.name) {
                                case "googCodecName": {
                                    statusBean.codecName = value.value;
                                    continue block108;
                                }
                                case "googTrackId": {
                                    trackId = value.value;
                                    continue block108;
                                }
                                case "mediaType": {
                                    statusBean.mediaType = value.value;
                                    continue block108;
                                }
                                case "googFrameHeightSent": {
                                    statusBean.frameHeight = this.toInt(value.value);
                                    continue block108;
                                }
                                case "googFrameRateSent": {
                                    statusBean.frameRate = this.toInt(value.value);
                                    continue block108;
                                }
                                case "googFrameWidthSent": {
                                    statusBean.frameWidth = this.toInt(value.value);
                                    continue block108;
                                }
                                case "googRtt": {
                                    statusBean.rtt = this.toInt(value.value);
                                    continue block108;
                                }
                                case "bytesSent": {
                                    statusBean.totalBitRate = this.toLong(value.value) * 8L / 1024L;
                                    continue block108;
                                }
                                case "packetsLost": {
                                    statusBean.packetsLost = this.toLong(value.value);
                                    this.packetsSendLost = this.toInt(value.value);
                                    continue block108;
                                }
                                case "packetsSent": {
                                    statusBean.packets = this.toLong(value.value);
                                    this.packetsSent = this.toInt(value.value);
                                    continue block108;
                                }
                                case "googJitterReceived": {
                                    statusBean.jitterReceived = this.toInt(value.value);
                                    continue block108;
                                }
                                case "googFirsReceived": {
                                    statusBean.firstReceived = this.toInt(value.value);
                                    continue block108;
                                }
                                case "codecImplementationName": {
                                    statusBean.codecImplementationName = value.value;
                                    continue block108;
                                }
                                case "googNacksReceived": {
                                    statusBean.nacksReceived = value.value;
                                    continue block108;
                                }
                                case "googPlisReceived": {
                                    statusBean.plisReceived = value.value;
                                    continue block108;
                                }
                                case "audioInputLevel": {
                                    pos = Integer.valueOf(value.value) / 1000;
                                    statusBean.audioLevel = this.currentLevel[pos];
                                    continue block108;
                                }
                            }
                        }
                        reportUserInfo = RTCSDPTools.mLocalUserIdTrackIdMap.get(trackId);
                        if (reportUserInfo != null) {
                            statusBean.id = reportUserInfo.getMediaStreamId();
                            statusBean.uid = RTCEngineImpl.getInstance().getUserId();
                            statusBean.streamType = ResourceTools.getSteamType(statusBean.id, reportUserInfo.getTag());
                            statusBean.tag = reportUserInfo.getTag();
                            reportUserInfo = null;
                            if (statsReport.toString().contains(mediaType_audio)) {
                                statusReport.statusAudioSends.put(statusBean.id, (StatusBean)statusBean);
                            } else {
                                statusReport.statusVideoSends.put(statusBean.id, (StatusBean)statusBean);
                            }
                        }
                    }
                }
                if (statsReport.type.equals(googCandidatePair) && statsReport.toString().contains(googActiveConnection_true)) {
                    statusBean = statsReport.values;
                    int n3 = ((StatsReport.Value[])statusBean).length;
                    for (n = 0; n < n3; ++n) {
                        StatsReport.Value value2 = statusBean[n];
                        if (value2.name.equals(bytesReceived)) {
                            statusReport.bitRateTotalRcv = this.toLong(value2.value) * 8L / 1024L;
                            statusReport.bitRateRcv = Math.max(0L, statusReport.bitRateTotalRcv - this.preStatusReport.bitRateTotalRcv);
                        }
                        if (value2.name.equals(bytesSent)) {
                            statusReport.bitRateTotalSend = this.toLong(value2.value) * 8L / 1024L;
                            statusReport.bitRateSend = Math.max(0L, statusReport.bitRateTotalSend - this.preStatusReport.bitRateTotalSend);
                        }
                        if (!value2.name.equals(googRtt)) continue;
                        statusReport.rtt = this.toInt(value2.value);
                    }
                }
                if (statsReport.type.equals(ssrc) && statsReport.toString().contains(mediaType_audio)) {
                    int value2;
                    if (statsReport.toString().contains(packetsReceived)) {
                        StatusRecvAudio statusReportRecv = new StatusRecvAudio();
                        StatsReport.Value[] valueArray3 = statsReport.values;
                        n = valueArray3.length;
                        block110: for (value2 = 0; value2 < n; ++value2) {
                            value = valueArray3[value2];
                            switch (value.name) {
                                case "googTrackId": {
                                    statusReportRecv.googTrackId = trackId = value.value;
                                    continue block110;
                                }
                                case "audioOutputLevel": {
                                    pos = Integer.valueOf(value.value) / 1000;
                                    statusReportRecv.audioOutputLevel = String.valueOf(this.currentLevel[pos]);
                                    continue block110;
                                }
                            }
                        }
                        ReportUserInfo userInfo = RTCSDPTools.mRemoteUserIdTrackIdMap.get(statusReportRecv.googTrackId);
                        if (userInfo != null) {
                            statusReportRecv.userID = userInfo.getUserId();
                        }
                        this.audioReceivedLevel.put(statusReportRecv.userID, statusReportRecv.audioOutputLevel);
                    }
                    if (statsReport.toString().contains(packetsSentStr)) {
                        StatusAudio statusReportAudio = new StatusAudio();
                        StatsReport.Value[] valueArray4 = statsReport.values;
                        n = valueArray4.length;
                        for (value2 = 0; value2 < n; ++value2) {
                            value = valueArray4[value2];
                            if (!value.name.equals(audioInputLevelStr)) continue;
                            int pos2 = Integer.valueOf(value.value) / 1000;
                            statusReportAudio.audioInputLevel = String.valueOf(this.currentLevel[pos2]);
                        }
                        this.audioInputLevel = statusReportAudio.audioInputLevel;
                    }
                }
                if (statsReport.type.equals(googCandidatePair)) {
                    valueArray = statsReport.values;
                    int n4 = valueArray.length;
                    block112: for (n = 0; n < n4; ++n) {
                        StatsReport.Value value3 = valueArray[n];
                        switch (value3.name) {
                            case "googLocalAddress": {
                                for (StatsReport.Value tmp : statsReport.values) {
                                    if (!TextUtils.equals((CharSequence)googLocalCandidateType, (CharSequence)tmp.name) || !TextUtils.equals((CharSequence)"prflx", (CharSequence)tmp.value)) continue;
                                    statusReport.ipAddress = value3.value;
                                }
                                continue block112;
                            }
                            case "packetsDiscardedOnSend": {
                                statusReport.packetsDiscardedOnSend = value3.value;
                            }
                        }
                    }
                }
                if (statsReport.type.equals(localcandidate)) {
                    valueArray = statsReport.values;
                    int n5 = valueArray.length;
                    for (n = 0; n < n5; ++n) {
                        StatsReport.Value value4 = valueArray[n];
                        switch (value4.name) {
                            case "networkType": {
                                statusReport.networkType = NetUtils.getNetworkStrState(RTCEngineImpl.getInstance().getContext());
                            }
                        }
                    }
                }
                if (!statsReport.type.equals(VideoBwe)) continue;
                valueArray = statsReport.values;
                int n6 = valueArray.length;
                block115: for (n = 0; n < n6; ++n) {
                    StatsReport.Value value5 = valueArray[n];
                    switch (value5.name) {
                        case "googAvailableReceiveBandwidth": {
                            statusReport.availableReceiveBandwidth = value5.value;
                            continue block115;
                        }
                        case "googAvailableSendBandwidth": {
                            statusReport.availableSendBandwidth = value5.value;
                        }
                    }
                }
            }
            catch (Exception e) {
                FinLog.e("StatusReportParser", e.getMessage());
            }
        }
        if (this.packetsRcv - this.packetsRcv_lastTime >= 0 && this.packetsRcvLost - this.packetsRcvLost_lastTime >= 0) {
            this.packetRcvLossRate = this.packetsRcv - this.packetsRcv_lastTime == 0 ? 100 : (this.packetsRcvLost - this.packetsRcvLost_lastTime) * 100 / (this.packetsRcv - this.packetsRcv_lastTime + this.packetsRcvLost - this.packetsRcvLost_lastTime);
        }
        this.packetsRcv_lastTime = this.packetsRcv;
        this.packetsRcvLost_lastTime = this.packetsRcvLost;
        for (Map.Entry entry : statusReport.statusVideoRcvs.entrySet()) {
            StatusBean statusBean = (StatusBean)entry.getValue();
            preStatusBean = this.preStatusReport.statusVideoRcvs.get(entry.getKey());
            if (statusReport.bitRateSend == 0L && statusReport.bitRateTotalSend > 0L) {
                statusBean.bitRate = 0L;
                statusBean.packetLostRate = 100L;
                continue;
            }
            statusBean.bitRate = this.calculateBitRate(statusBean, preStatusBean);
            statusBean.packetLostRate = this.calculateLossRate(statusBean, preStatusBean);
        }
        for (Map.Entry entry : statusReport.statusAudioRcvs.entrySet()) {
            StatusBean statusBean = (StatusBean)entry.getValue();
            preStatusBean = this.preStatusReport.statusAudioRcvs.get(entry.getKey());
            if (statusReport.bitRateSend == 0L && statusReport.bitRateTotalSend > 0L) {
                statusBean.bitRate = 0L;
                statusBean.packetLostRate = 100L;
                continue;
            }
            statusBean.bitRate = this.calculateBitRate(statusBean, preStatusBean);
            statusBean.packetLostRate = this.calculateLossRate(statusBean, preStatusBean);
        }
        for (Map.Entry entry : statusReport.statusVideoSends.entrySet()) {
            StatusBean statusBean = (StatusBean)entry.getValue();
            preStatusBean = this.preStatusReport.statusVideoSends.get(entry.getKey());
            statusBean.bitRate = this.calculateBitRate(statusBean, preStatusBean);
            statusBean.packetLostRate = this.calculateLossRate(statusBean, preStatusBean);
            if (statusReport.bitRateSend == 0L && statusReport.bitRateTotalSend > 0L) {
                statusBean.bitRate = 0L;
                statusBean.packetLostRate = 100L;
                continue;
            }
            statusBean.bitRate = this.calculateBitRate(statusBean, preStatusBean);
            statusBean.packetLostRate = this.calculateLossRate(statusBean, preStatusBean);
        }
        for (Map.Entry entry : statusReport.statusAudioSends.entrySet()) {
            StatusBean statusBean = (StatusBean)entry.getValue();
            preStatusBean = this.preStatusReport.statusAudioSends.get(entry.getKey());
            statusBean.bitRate = this.calculateBitRate(statusBean, preStatusBean);
            statusBean.packetLostRate = this.calculateLossRate(statusBean, preStatusBean);
            if (statusReport.bitRateSend == 0L && statusReport.bitRateTotalSend > 0L) {
                statusBean.bitRate = 0L;
                statusBean.packetLostRate = 100L;
                continue;
            }
            statusBean.bitRate = this.calculateBitRate(statusBean, preStatusBean);
            statusBean.packetLostRate = this.calculateLossRate(statusBean, preStatusBean);
        }
        this.preStatusReport = statusReport;
        return statusReport;
    }

    private int toInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private long toLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private long calculateLossRate(StatusBean status, StatusBean preStatus) {
        if (status != null && preStatus != null) {
            long packets = Math.abs(status.packets - preStatus.packets);
            long packetsLost = Math.abs(status.packetsLost - preStatus.packetsLost);
            if (packets == 0L) {
                return 0L;
            }
            return packetsLost * 100L / (packets + packetsLost);
        }
        return 0L;
    }

    private long calculateBitRate(StatusBean status, StatusBean preStatus) {
        long bitrate = 0L;
        if (preStatus != null) {
            if (status.totalBitRate - preStatus.totalBitRate > 0L) {
                bitrate = status.totalBitRate - preStatus.totalBitRate;
            }
        } else if (status.totalBitRate > 0L) {
            bitrate = status.totalBitRate;
        }
        return bitrate;
    }

    public String getAudioInputLevel() {
        return this.audioInputLevel;
    }

    private boolean needNotifyStatus(String userId, RCRTCMediaType mediaType) {
        boolean needNotifyStatus = false;
        RCRTCRoom room = RCRTCEngine.getInstance().getRoom();
        if (room != null) {
            List<RCRTCInputStream> remoteStreams;
            RCRTCRemoteUser remoteUser = room.getRemoteUser(userId);
            if (remoteUser != null && (remoteStreams = remoteUser.getStreams()) != null) {
                for (RCRTCInputStream stream : remoteStreams) {
                    if (!mediaType.equals((Object)stream.getMediaType())) continue;
                    needNotifyStatus = true;
                    break;
                }
            }
        } else {
            needNotifyStatus = true;
        }
        return needNotifyStatus;
    }
}

