/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.RCRTCLocalUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCSwitchRoleCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCSwitchRoleDataCallback;
import cn.rongcloud.rtc.api.callback.RCRTCLiveCallback;
import cn.rongcloud.rtc.api.stream.RCRTCAudioInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCCameraOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.api.stream.RCRTCMicOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoInputStream;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCLiveRole;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.RCUserImpl;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.center.stream.RCTinyVideoOutStream;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RCLocalUserImpl
extends RCUserImpl
implements RCRTCLocalUser {
    private static final String TAG = "RCLocalUserImpl";
    protected List<RCRTCOutputStream> mPublishStreams = new ArrayList<RCRTCOutputStream>();
    private String role;

    public RCLocalUserImpl(String userId, String extra) {
        super(userId, extra);
    }

    @Override
    public List<RCRTCOutputStream> getStreams() {
        ArrayList<RCRTCOutputStream> streams = new ArrayList<RCRTCOutputStream>(this.mPublishStreams);
        if (streams.isEmpty()) {
            return streams;
        }
        RCRTCOutputStream tinyStream = null;
        for (RCRTCOutputStream stream : streams) {
            if (!(stream instanceof RCTinyVideoOutStream)) continue;
            tinyStream = stream;
            break;
        }
        if (tinyStream != null) {
            streams.remove(tinyStream);
        }
        return streams;
    }

    public List<RCRTCOutputStream> getStreamsForInternal() {
        return new ArrayList<RCRTCOutputStream>(this.mPublishStreams);
    }

    public void addPublishedStream(RCRTCOutputStream stream) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        if (stream == null || this.mPublishStreams.contains(stream)) {
            return;
        }
        this.mPublishStreams.add(stream);
    }

    public void addPublishedStream(List<RCRTCOutputStream> streams) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        if (RongRTCUtils.isEmpty(streams)) {
            return;
        }
        for (RCRTCOutputStream stream : streams) {
            if (this.mPublishStreams.contains(stream)) continue;
            this.mPublishStreams.add(stream);
        }
    }

    public void removePublishedStream(RCRTCOutputStream stream) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        if (stream == null) {
            return;
        }
        Iterator<RCRTCOutputStream> iterator = this.mPublishStreams.iterator();
        while (iterator.hasNext()) {
            RCRTCOutputStream pubStream = iterator.next();
            if (pubStream != stream && !TextUtils.equals((CharSequence)pubStream.getStreamId(), (CharSequence)stream.getStreamId()) && (!TextUtils.equals((CharSequence)stream.getTag(), (CharSequence)pubStream.getTag()) || pubStream.getMediaType() != stream.getMediaType())) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public boolean containsStream(RCRTCOutputStream stream) {
        if (stream == null) {
            return false;
        }
        List<RCRTCOutputStream> streams = this.getStreams();
        for (RCRTCOutputStream pubStream : streams) {
            if (pubStream != stream && !TextUtils.equals((CharSequence)pubStream.getStreamId(), (CharSequence)stream.getStreamId()) && (!TextUtils.equals((CharSequence)stream.getTag(), (CharSequence)pubStream.getTag()) || pubStream.getMediaType() != stream.getMediaType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void subscribeStream(RCRTCInputStream stream, IRCRTCResultCallback callBack) {
        ArrayList<RCRTCInputStream> inputStreams = new ArrayList<RCRTCInputStream>();
        inputStreams.add(stream);
        this.subscribeStreams(inputStreams, callBack);
    }

    @Override
    public void unpublishDefaultStreams(IRCRTCResultCallback callback) {
        this.unpublishStreams(this.getDefaultStreams(), callback);
    }

    @Override
    public void unpublishDefaultLiveStreams(IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().unpublishDefaultLiveStreams(this.getDefaultStreams(), callback);
    }

    @Override
    public void subscribeLiveUrl(String liveUrl, RCRTCAVStreamType avStreamType, final RCRTCLiveCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)liveUrl)) {
            ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVEURL, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "liveUrl is null !");
            RTCEngineImpl.getInstance().onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        if (avStreamType == null) {
            ReportUtil.appError(ReportUtil.TAG.SUBSCRIBELIVEURL, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "RCRTCAVStreamType is null ");
            RTCEngineImpl.getInstance().onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        RCRTCRoom room = RTCEngineImpl.getInstance().getRoom();
        String roomId = "";
        if (room != null) {
            roomId = room.getRoomId();
        }
        ReportUtil.appTask(ReportUtil.TAG.SUBSCRIBELIVEURL, "roomId|liveUrl|liveType|simulcast", roomId, liveUrl, avStreamType.getMediaType(), avStreamType.getSimulcast());
        RTCEngineImpl.getInstance().sendMessage(5030, new Object[]{liveUrl, avStreamType, new RCRTCLiveCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.SUBSCRIBELIVEURL, "code", 0);
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            @Override
            public void onVideoStreamReceived(RCRTCVideoInputStream stream) {
                ReportUtil.appStatus(ReportUtil.TAG.SUBSCRIBELIVEURL, "videoStreamId", stream != null ? stream.getStreamId() : "");
                if (callBack != null) {
                    callBack.onVideoStreamReceived(stream);
                }
            }

            @Override
            public void onAudioStreamReceived(RCRTCAudioInputStream stream) {
                ReportUtil.appStatus(ReportUtil.TAG.SUBSCRIBELIVEURL, "audioStreamId", stream != null ? stream.getStreamId() : "");
                if (callBack != null) {
                    callBack.onAudioStreamReceived(stream);
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.SUBSCRIBELIVEURL, errorCode);
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }
        }});
    }

    @Override
    public void switchToAudience(final IRCRTCSwitchRoleCallback callBack) {
        RCRoomImpl room = (RCRoomImpl)RTCEngineImpl.getInstance().getRoom();
        RTCErrorCode errorCode = RTCErrorCode.UnknownError;
        RCRTCLiveRole liveRole = null;
        if (room.getRoomConfig() == null) {
            errorCode = RTCErrorCode.RongRTCCodeParameterError;
        } else if (room.getRoomConfig().getRoomType() == RCRTCRoomType.MEETING) {
            errorCode = RTCErrorCode.ROOM_TYPE_ERROR;
        } else {
            liveRole = room.getRoomConfig().getLiveRole();
            if (liveRole == RCRTCLiveRole.AUDIENCE) {
                errorCode = RTCErrorCode.SAME_ROLE_ERROR;
            }
        }
        ReportUtil.appTask(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "roomId|userId|liveRole", room.getRoomId(), this.getUserId(), liveRole != null ? liveRole.name() : "null");
        if (errorCode != RTCErrorCode.UnknownError) {
            ReportUtil.appError(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "code", errorCode.getValue());
            if (callBack != null) {
                callBack.onFailed(errorCode);
            }
            return;
        }
        RTCEngineImpl.getInstance().sendMessage(5060, (Object)new IRCRTCSwitchRoleCallback(){

            @Override
            public void onKicked() {
                ReportUtil.appError(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "desc", "onKicked");
                if (callBack != null) {
                    callBack.onKicked();
                }
            }

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "code", 0);
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.SWITCH_TO_AUDIENCE, "code", errorCode.getValue());
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }
        });
    }

    @Override
    public void switchToBroadcaster(List<? extends RCRTCOutputStream> publishLiveStreams, final IRCRTCSwitchRoleDataCallback<RCRTCLiveInfo> callBack) {
        RCRoomImpl room = (RCRoomImpl)RTCEngineImpl.getInstance().getRoom();
        RTCErrorCode errorCode = RTCErrorCode.UnknownError;
        RCRTCLiveRole liveRole = null;
        if (room.getRoomConfig() == null) {
            errorCode = RTCErrorCode.RongRTCCodeParameterError;
        } else if (room.getRoomConfig().getRoomType() == RCRTCRoomType.MEETING) {
            errorCode = RTCErrorCode.ROOM_TYPE_ERROR;
        } else {
            liveRole = room.getRoomConfig().getLiveRole();
            if (liveRole == RCRTCLiveRole.BROADCASTER) {
                errorCode = RTCErrorCode.SAME_ROLE_ERROR;
            }
        }
        int size = publishLiveStreams != null ? publishLiveStreams.size() : 0;
        ReportUtil.appTask(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "roomId|userId|size|liveRole", room.getRoomId(), this.getUserId(), size, liveRole != null ? liveRole.name() : "null");
        if (errorCode != RTCErrorCode.UnknownError) {
            ReportUtil.appError(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "code", errorCode.getValue());
            if (callBack != null) {
                callBack.onFailed(errorCode);
            }
            return;
        }
        RTCEngineImpl.getInstance().sendMessage(5064, publishLiveStreams, new IRCRTCSwitchRoleDataCallback<RCRTCLiveInfo>(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "code", errorCode.getValue());
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }

            @Override
            public void onSuccess(RCRTCLiveInfo data) {
                ReportUtil.appRes(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "code", 0);
                if (callBack != null) {
                    callBack.onSuccess(data);
                }
            }

            @Override
            public void onKicked() {
                ReportUtil.appError(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "desc", "onKicked");
                if (callBack != null) {
                    callBack.onKicked();
                }
            }
        });
    }

    private ArrayList<RCRTCOutputStream> getDefaultStreams() {
        ArrayList<RCRTCOutputStream> streams = new ArrayList<RCRTCOutputStream>();
        streams.add(this.getDefaultAudioStream());
        streams.add(this.getDefaultVideoStream());
        return streams;
    }

    @Override
    public void publishStreams(List<? extends RCRTCOutputStream> streams, IRCRTCResultCallback callBack) {
        ((RTCEngineImpl)RCRTCEngine.getInstance()).publishStreams(streams, callBack);
    }

    @Override
    public void unpublishStreams(List<RCRTCOutputStream> streams, IRCRTCResultCallback callBack) {
        RTCEngineImpl.getInstance().unpublishStreams(streams, callBack);
    }

    @Override
    public void publishDefaultStreams(IRCRTCResultCallback callback) {
        this.publishStreams(this.getDefaultStreams(), callback);
    }

    @Override
    public void publishStream(RCRTCOutputStream stream, IRCRTCResultCallback callback) {
        if (stream == null) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.PublishMediaStreamIsNull);
            }
            return;
        }
        ArrayList<RCRTCOutputStream> streams = new ArrayList<RCRTCOutputStream>();
        streams.add(stream);
        this.publishStreams(streams, callback);
    }

    @Override
    public void unpublishStream(RCRTCOutputStream stream, IRCRTCResultCallback callBack) {
        if (stream == null) {
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        ArrayList<RCRTCOutputStream> streams = new ArrayList<RCRTCOutputStream>();
        streams.add(stream);
        this.unpublishStreams(streams, callBack);
    }

    @Override
    public void publishDefaultLiveStreams(IRCRTCResultDataCallback<RCRTCLiveInfo> callBack) {
        this.publishDefaultLiveStreams(this.getDefaultStreams(), callBack);
    }

    private void publishDefaultLiveStreams(ArrayList<RCRTCOutputStream> streams, IRCRTCResultDataCallback<RCRTCLiveInfo> callBack) {
        RTCEngineImpl.getInstance().publishDefaultLiveStreams(streams, callBack);
    }

    private void publishLiveStreams(ArrayList<RCRTCOutputStream> streams, IRCRTCResultDataCallback<RCRTCLiveInfo> callBack) {
        RTCEngineImpl.getInstance().publishLiveStreams(streams, callBack);
    }

    @Override
    public void publishLiveStream(RCRTCOutputStream stream, IRCRTCResultDataCallback<RCRTCLiveInfo> callBack) {
        if (stream == null) {
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.PublishMediaStreamIsNull);
            }
            return;
        }
        ArrayList<RCRTCOutputStream> streams = new ArrayList<RCRTCOutputStream>();
        streams.add(stream);
        this.publishLiveStreams(streams, callBack);
    }

    @Override
    public void unpublishLiveStream(RCRTCOutputStream stream, IRCRTCResultCallback callback) {
        if (stream == null) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        ArrayList<RCRTCOutputStream> streams = new ArrayList<RCRTCOutputStream>();
        streams.add(stream);
        RTCEngineImpl.getInstance().unpublishLiveStreams(streams, callback);
    }

    @Override
    public void unsubscribeStream(RCRTCInputStream stream, IRCRTCResultCallback callBack) {
        ArrayList<RCRTCInputStream> streams = new ArrayList<RCRTCInputStream>();
        streams.add(stream);
        this.unsubscribeStreams(streams, callBack);
    }

    @Override
    public void subscribeStreams(List<? extends RCRTCInputStream> streams, IRCRTCResultCallback callBack) {
        RTCEngineImpl.getInstance().subscribeStreams(streams, callBack);
    }

    @Override
    public void unsubscribeStreams(List<? extends RCRTCInputStream> streams, IRCRTCResultCallback callBack) {
        RTCEngineImpl.getInstance().unsubscribeStreams(streams, callBack);
    }

    @Override
    public void setAttributeValue(String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().setUserAttributeValue(key, value, message, callback);
    }

    @Override
    public void deleteAttributes(List<String> attributeKeys, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().deleteUserAttributes(attributeKeys, message, callback);
    }

    @Override
    public void getAttributes(List<String> attributeKeys, IRCRTCResultDataCallback<Map<String, String>> callback) {
        RTCEngineImpl.getInstance().getUserAttributes(attributeKeys, callback);
    }

    public void setRole(String role, IRCRTCResultCallback callback) {
        this.role = role;
        RTCEngineImpl.getInstance().putInnerData(RCAttributeType.USER, "role", role, null, callback);
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public RCRTCCameraOutputStream getDefaultVideoStream() {
        return RCRTCEngine.getInstance().getDefaultVideoStream();
    }

    @Override
    public RCRTCMicOutputStream getDefaultAudioStream() {
        return RCRTCEngine.getInstance().getDefaultAudioStream();
    }

    @Override
    public void requestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, boolean inviterMCUAutoMix, String extra, IRCRTCResultCallback callback) {
        String taskkey = RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "inviterUserAutoMix");
        ReportUtil.appTask(ReportUtil.TAG.REQUESTJOINOTHERROOM, taskkey, inviteeRoomId, inviteeUserId, inviterMCUAutoMix);
        if (TextUtils.isEmpty((CharSequence)inviteeRoomId) || TextUtils.isEmpty((CharSequence)inviteeUserId)) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            ReportUtil.appError(ReportUtil.TAG.REQUESTJOINOTHERROOM, RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "code"), inviteeRoomId, inviteeUserId, RTCErrorCode.RongRTCCodeParameterError.getValue());
            return;
        }
        int inviteeTimeoutTime = 30;
        if (inviteeTimeoutTime < 5 || inviteeTimeoutTime > 300) {
            inviteeTimeoutTime = 10;
        }
        RTCEngineImpl.getInstance().requestJoinOtherRoom(inviteeRoomId, inviteeUserId, inviteeTimeoutTime, inviterMCUAutoMix, extra, callback);
    }

    @Override
    public void cancelRequestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String extra, IRCRTCResultCallback callback) {
        String key = RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "code");
        ReportUtil.appTask(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, key, inviteeRoomId, inviteeUserId);
        if (TextUtils.isEmpty((CharSequence)inviteeRoomId) || TextUtils.isEmpty((CharSequence)inviteeUserId)) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            ReportUtil.appError(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, key, inviteeRoomId, inviteeUserId, RTCErrorCode.RongRTCCodeParameterError.getValue());
            return;
        }
        RTCEngineImpl.getInstance().cancelRequestJoinOtherRoom(inviteeRoomId, inviteeUserId, extra, key, callback);
    }

    @Override
    public void responseJoinOtherRoom(String inviterRoomId, String inviterUserId, boolean agree, boolean inviteeUserAutoMix, String extra, IRCRTCResultCallback callback) {
        String key = RongRTCUtils.append("inviterRoomId", "inviterUserId", "agree", "inviteeUserAutoMix");
        ReportUtil.appTask(ReportUtil.TAG.RESPONSEJOINOTHERROOM, key, inviterRoomId, inviterUserId, agree, inviteeUserAutoMix);
        if (TextUtils.isEmpty((CharSequence)inviterRoomId) || TextUtils.isEmpty((CharSequence)inviterUserId)) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            ReportUtil.appError(ReportUtil.TAG.RESPONSEJOINOTHERROOM, RongRTCUtils.append("inviterRoomId", "inviterUserId", "agree", "inviteeUserAutoMix", "code"), inviterRoomId, inviterUserId, agree, inviteeUserAutoMix, RTCErrorCode.RongRTCCodeParameterError.getValue());
            return;
        }
        RTCEngineImpl.getInstance().responseJoinOtherRoom(inviterRoomId, inviterUserId, agree, inviteeUserAutoMix, extra, callback);
    }

    public void release() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        for (RCRTCOutputStream stream : this.mPublishStreams) {
            if (!TextUtils.equals((CharSequence)stream.getTag(), (CharSequence)"RongCloudRTC") && !TextUtils.equals((CharSequence)stream.getTag(), (CharSequence)"RongCloudScreenShare")) {
                ((RCStreamImpl)((Object)stream)).release();
                continue;
            }
            ((RCStreamImpl)((Object)stream)).setUri(null);
        }
        this.mPublishStreams.clear();
    }

    public void updateMediaInfos(List<MediaResourceInfo> mediaResourceInfos) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        block0: for (RCRTCOutputStream outputStream : this.mPublishStreams) {
            for (MediaResourceInfo info : mediaResourceInfos) {
                if (info.getType() != outputStream.getMediaType() || !info.getTag().equals(outputStream.getTag())) continue;
                ((RCOutputStreamImpl)outputStream).updateMediaInfo(info);
                continue block0;
            }
        }
    }
}

