/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message.messagebeans;

import android.os.Parcel;
import android.os.Parcelable;
import cn.rongcloud.rtc.utils.FinLog;
import org.json.JSONException;
import org.json.JSONObject;

public class CDNResourceInfo
implements Parcelable {
    private static final String TAG = "CDNResourceInfo";
    private int broadcast;
    private int fps;
    private int h;
    private boolean pull_safe;
    private int push_mode;
    private String url;
    private int w;
    private boolean enableInnerCDN;
    public static final Parcelable.Creator<CDNResourceInfo> CREATOR = new Parcelable.Creator<CDNResourceInfo>(){

        public CDNResourceInfo createFromParcel(Parcel in) {
            return new CDNResourceInfo(in);
        }

        public CDNResourceInfo[] newArray(int size) {
            return new CDNResourceInfo[size];
        }
    };

    public CDNResourceInfo(String pullUrl) {
        try {
            this.parse(new JSONObject(pullUrl));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public CDNResourceInfo(JSONObject jsonObject) {
        this.parse(jsonObject);
    }

    private void parse(JSONObject jsonObject) {
        if (jsonObject == null) {
            FinLog.e(TAG, "jsonObject is empty");
            return;
        }
        if (jsonObject.has("broadcast")) {
            this.broadcast = jsonObject.optInt("broadcast");
        }
        if (jsonObject.has("fps")) {
            this.fps = jsonObject.optInt("fps");
        }
        if (jsonObject.has("h")) {
            this.h = jsonObject.optInt("h");
        }
        if (jsonObject.has("pull_safe")) {
            this.pull_safe = jsonObject.optBoolean("pull_safe");
        }
        if (jsonObject.has("push_mode")) {
            this.push_mode = jsonObject.optInt("push_mode");
        }
        if (jsonObject.has("url")) {
            this.url = jsonObject.optString("url");
        }
        if (jsonObject.has("w")) {
            this.w = jsonObject.optInt("w");
        }
        if (jsonObject.has("enableInnerCDN")) {
            this.enableInnerCDN = jsonObject.optBoolean("enableInnerCDN");
        }
    }

    public JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.putOpt("broadcast", (Object)this.broadcast);
            jsonObject.putOpt("fps", (Object)this.fps);
            jsonObject.putOpt("h", (Object)this.h);
            jsonObject.putOpt("pull_safe", (Object)this.pull_safe);
            jsonObject.putOpt("push_mode", (Object)this.push_mode);
            jsonObject.putOpt("url", (Object)this.url);
            jsonObject.putOpt("w", (Object)this.w);
            jsonObject.putOpt("enableInnerCDN", (Object)this.enableInnerCDN);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    protected CDNResourceInfo(Parcel in) {
        this.broadcast = in.readInt();
        this.fps = in.readInt();
        this.h = in.readInt();
        this.pull_safe = in.readByte() != 0;
        this.push_mode = in.readInt();
        this.url = in.readString();
        this.w = in.readInt();
        this.enableInnerCDN = in.readByte() != 0;
    }

    public int getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(int broadcast) {
        this.broadcast = broadcast;
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isPull_safe() {
        return this.pull_safe;
    }

    public void setPull_safe(boolean pull_safe) {
        this.pull_safe = pull_safe;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public int getPush_mode() {
        return this.push_mode;
    }

    public void setPush_mode(int push_mode) {
        this.push_mode = push_mode;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public boolean isEnableInnerCDN() {
        return this.enableInnerCDN;
    }

    public void setEnableInnerCDN(boolean enableInnerCDN) {
        this.enableInnerCDN = enableInnerCDN;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.broadcast);
        dest.writeInt(this.fps);
        dest.writeInt(this.h);
        dest.writeByte((byte)(this.pull_safe ? 1 : 0));
        dest.writeInt(this.push_mode);
        dest.writeString(this.url);
        dest.writeInt(this.w);
        dest.writeByte((byte)(this.enableInnerCDN ? 1 : 0));
    }

    public void updateInfo(String pullUrl) {
        try {
            this.parse(new JSONObject(pullUrl));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

