/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.SparseArray;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.database.SqliteDatabaseOpenHelper;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SqliteDatabaseImpl
implements FileDownloadDatabase {
    private final SQLiteDatabase db;
    public static final String TABLE_NAME = "filedownloader";
    public static final String CONNECTION_TABLE_NAME = "filedownloaderConnection";

    public static Maker createMaker() {
        return new Maker();
    }

    public SqliteDatabaseImpl() {
        SqliteDatabaseOpenHelper openHelper = new SqliteDatabaseOpenHelper(FileDownloadHelper.getAppContext());
        this.db = openHelper.getWritableDatabase();
    }

    @Override
    public void onTaskStart(int id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileDownloadModel find(int id) {
        try (Cursor c = null;){
            c = this.db.rawQuery(FileDownloadUtils.formatString("SELECT * FROM %s WHERE %s = ?", TABLE_NAME, "_id"), new String[]{Integer.toString(id)});
            if (c.moveToNext()) {
                FileDownloadModel fileDownloadModel = SqliteDatabaseImpl.createFromCursor(c);
                return fileDownloadModel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConnectionModel> findConnectionModel(int id) {
        ArrayList<ConnectionModel> resultList = new ArrayList<ConnectionModel>();
        try (Cursor c = null;){
            c = this.db.rawQuery(FileDownloadUtils.formatString("SELECT * FROM %s WHERE %s = ?", CONNECTION_TABLE_NAME, "id"), new String[]{Integer.toString(id)});
            while (c.moveToNext()) {
                ConnectionModel model = new ConnectionModel();
                model.setId(id);
                model.setIndex(c.getInt(c.getColumnIndex("connectionIndex")));
                model.setStartOffset(c.getLong(c.getColumnIndex("startOffset")));
                model.setCurrentOffset(c.getLong(c.getColumnIndex("currentOffset")));
                model.setEndOffset(c.getLong(c.getColumnIndex("endOffset")));
                resultList.add(model);
            }
        }
        return resultList;
    }

    @Override
    public void removeConnections(int id) {
        this.db.execSQL("DELETE FROM filedownloaderConnection WHERE id = " + id);
    }

    @Override
    public void insertConnectionModel(ConnectionModel model) {
        this.db.insert(CONNECTION_TABLE_NAME, null, model.toContentValues());
    }

    @Override
    public void updateConnectionModel(int id, int index, long currentOffset) {
        ContentValues values = new ContentValues();
        values.put("currentOffset", Long.valueOf(currentOffset));
        this.db.update(CONNECTION_TABLE_NAME, values, "id = ? AND connectionIndex = ?", new String[]{Integer.toString(id), Integer.toString(index)});
    }

    @Override
    public void updateConnectionCount(int id, int count) {
        ContentValues values = new ContentValues();
        values.put("connectionCount", Integer.valueOf(count));
        this.db.update(TABLE_NAME, values, "_id = ? ", new String[]{Integer.toString(id)});
    }

    @Override
    public void insert(FileDownloadModel downloadModel) {
        this.db.insert(TABLE_NAME, null, downloadModel.toContentValues());
    }

    @Override
    public void update(FileDownloadModel downloadModel) {
        if (downloadModel == null) {
            FileDownloadLog.w(this, "update but model == null!", new Object[0]);
            return;
        }
        if (this.find(downloadModel.getId()) != null) {
            ContentValues cv = downloadModel.toContentValues();
            this.db.update(TABLE_NAME, cv, "_id = ? ", new String[]{String.valueOf(downloadModel.getId())});
        } else {
            this.insert(downloadModel);
        }
    }

    @Override
    public boolean remove(int id) {
        return this.db.delete(TABLE_NAME, "_id = ?", new String[]{String.valueOf(id)}) != 0;
    }

    @Override
    public void clear() {
        this.db.delete(TABLE_NAME, null, null);
        this.db.delete(CONNECTION_TABLE_NAME, null, null);
    }

    @Override
    public void updateOldEtagOverdue(int id, String newEtag, long sofar, long total, int connectionCount) {
        ContentValues values = new ContentValues();
        values.put("sofar", Long.valueOf(sofar));
        values.put("total", Long.valueOf(total));
        values.put("etag", newEtag);
        values.put("connectionCount", Integer.valueOf(connectionCount));
        this.update(id, values);
    }

    @Override
    public void updateConnected(int id, long total, String etag, String filename) {
        ContentValues cv = new ContentValues();
        cv.put("status", Byte.valueOf((byte)2));
        cv.put("total", Long.valueOf(total));
        cv.put("etag", etag);
        cv.put("filename", filename);
        this.update(id, cv);
    }

    @Override
    public void updateProgress(int id, long sofarBytes) {
        ContentValues cv = new ContentValues();
        cv.put("status", Byte.valueOf((byte)3));
        cv.put("sofar", Long.valueOf(sofarBytes));
        this.update(id, cv);
    }

    @Override
    public void updateError(int id, Throwable throwable, long sofar) {
        ContentValues cv = new ContentValues();
        cv.put("errMsg", throwable.toString());
        cv.put("status", Byte.valueOf((byte)-1));
        cv.put("sofar", Long.valueOf(sofar));
        this.update(id, cv);
    }

    @Override
    public void updateRetry(int id, Throwable throwable) {
        ContentValues cv = new ContentValues();
        cv.put("errMsg", throwable.toString());
        cv.put("status", Byte.valueOf((byte)5));
        this.update(id, cv);
    }

    @Override
    public void updateCompleted(int id, long total) {
        this.remove(id);
    }

    @Override
    public void updatePause(int id, long sofar) {
        ContentValues cv = new ContentValues();
        cv.put("status", Byte.valueOf((byte)-2));
        cv.put("sofar", Long.valueOf(sofar));
        this.update(id, cv);
    }

    @Override
    public void updatePending(int id) {
    }

    @Override
    public FileDownloadDatabase.Maintainer maintainer() {
        return new Maintainer();
    }

    public FileDownloadDatabase.Maintainer maintainer(SparseArray<FileDownloadModel> downloaderModelMap, SparseArray<List<ConnectionModel>> connectionModelListMap) {
        return new Maintainer(downloaderModelMap, connectionModelListMap);
    }

    private void update(int id, ContentValues cv) {
        this.db.update(TABLE_NAME, cv, "_id = ? ", new String[]{String.valueOf(id)});
    }

    private static FileDownloadModel createFromCursor(Cursor c) {
        FileDownloadModel model = new FileDownloadModel();
        model.setId(c.getInt(c.getColumnIndex("_id")));
        model.setUrl(c.getString(c.getColumnIndex("url")));
        model.setPath(c.getString(c.getColumnIndex("path")), c.getShort(c.getColumnIndex("pathAsDirectory")) == 1);
        model.setStatus((byte)c.getShort(c.getColumnIndex("status")));
        model.setSoFar(c.getLong(c.getColumnIndex("sofar")));
        model.setTotal(c.getLong(c.getColumnIndex("total")));
        model.setErrMsg(c.getString(c.getColumnIndex("errMsg")));
        model.setETag(c.getString(c.getColumnIndex("etag")));
        model.setFilename(c.getString(c.getColumnIndex("filename")));
        model.setConnectionCount(c.getInt(c.getColumnIndex("connectionCount")));
        return model;
    }

    public static class Maker
    implements FileDownloadHelper.DatabaseCustomMaker {
        @Override
        public FileDownloadDatabase customMake() {
            return new SqliteDatabaseImpl();
        }
    }

    class MaintainerIterator
    implements Iterator<FileDownloadModel> {
        private final Cursor c;
        private final List<Integer> needRemoveId = new ArrayList<Integer>();
        private int currentId;

        MaintainerIterator() {
            this.c = SqliteDatabaseImpl.this.db.rawQuery("SELECT * FROM filedownloader", null);
        }

        @Override
        public boolean hasNext() {
            return this.c.moveToNext();
        }

        @Override
        public FileDownloadModel next() {
            FileDownloadModel model = SqliteDatabaseImpl.createFromCursor(this.c);
            this.currentId = model.getId();
            return model;
        }

        @Override
        public void remove() {
            this.needRemoveId.add(this.currentId);
        }

        void onFinishMaintain() {
            this.c.close();
            if (!this.needRemoveId.isEmpty()) {
                String args = TextUtils.join((CharSequence)", ", this.needRemoveId);
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(this, "delete %s", args);
                }
                SqliteDatabaseImpl.this.db.execSQL(FileDownloadUtils.formatString("DELETE FROM %s WHERE %s IN (%s);", SqliteDatabaseImpl.TABLE_NAME, "_id", args));
                SqliteDatabaseImpl.this.db.execSQL(FileDownloadUtils.formatString("DELETE FROM %s WHERE %s IN (%s);", SqliteDatabaseImpl.CONNECTION_TABLE_NAME, "id", args));
            }
        }
    }

    public class Maintainer
    implements FileDownloadDatabase.Maintainer {
        private final SparseArray<FileDownloadModel> needChangeIdList = new SparseArray();
        private MaintainerIterator currentIterator;
        private final SparseArray<FileDownloadModel> downloaderModelMap;
        private final SparseArray<List<ConnectionModel>> connectionModelListMap;

        Maintainer() {
            this(null, null);
        }

        Maintainer(SparseArray<FileDownloadModel> downloaderModelMap, SparseArray<List<ConnectionModel>> connectionModelListMap) {
            this.downloaderModelMap = downloaderModelMap;
            this.connectionModelListMap = connectionModelListMap;
        }

        @Override
        public Iterator<FileDownloadModel> iterator() {
            this.currentIterator = new MaintainerIterator();
            return this.currentIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFinishMaintain() {
            int length;
            if (this.currentIterator != null) {
                this.currentIterator.onFinishMaintain();
            }
            if ((length = this.needChangeIdList.size()) < 0) {
                return;
            }
            SqliteDatabaseImpl.this.db.beginTransaction();
            try {
                List<ConnectionModel> connectionModelList;
                for (int i = 0; i < length; ++i) {
                    int oldId = this.needChangeIdList.keyAt(i);
                    FileDownloadModel modelWithNewId = (FileDownloadModel)this.needChangeIdList.get(oldId);
                    SqliteDatabaseImpl.this.db.delete(SqliteDatabaseImpl.TABLE_NAME, "_id = ?", new String[]{String.valueOf(oldId)});
                    SqliteDatabaseImpl.this.db.insert(SqliteDatabaseImpl.TABLE_NAME, null, modelWithNewId.toContentValues());
                    if (modelWithNewId.getConnectionCount() <= 1 || (connectionModelList = SqliteDatabaseImpl.this.findConnectionModel(oldId)).size() <= 0) continue;
                    SqliteDatabaseImpl.this.db.delete(SqliteDatabaseImpl.CONNECTION_TABLE_NAME, "id = ?", new String[]{String.valueOf(oldId)});
                    for (ConnectionModel connectionModel : connectionModelList) {
                        connectionModel.setId(modelWithNewId.getId());
                        SqliteDatabaseImpl.this.db.insert(SqliteDatabaseImpl.CONNECTION_TABLE_NAME, null, connectionModel.toContentValues());
                    }
                }
                if (this.downloaderModelMap != null && this.connectionModelListMap != null) {
                    int size = this.downloaderModelMap.size();
                    for (int i = 0; i < size; ++i) {
                        int id = ((FileDownloadModel)this.downloaderModelMap.valueAt(i)).getId();
                        connectionModelList = SqliteDatabaseImpl.this.findConnectionModel(id);
                        if (connectionModelList == null || connectionModelList.size() <= 0) continue;
                        this.connectionModelListMap.put(id, connectionModelList);
                    }
                }
                SqliteDatabaseImpl.this.db.setTransactionSuccessful();
            }
            finally {
                SqliteDatabaseImpl.this.db.endTransaction();
            }
        }

        @Override
        public void onRemovedInvalidData(FileDownloadModel model) {
        }

        @Override
        public void onRefreshedValidData(FileDownloadModel model) {
            if (this.downloaderModelMap != null) {
                this.downloaderModelMap.put(model.getId(), (Object)model);
            }
        }

        @Override
        public void changeFileDownloadModelId(int oldId, FileDownloadModel modelWithNewId) {
            this.needChangeIdList.put(oldId, (Object)modelWithNewId);
        }
    }
}

