/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.view.Surface;

class EncoderSurface {
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private EGLDisplay eglDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext eglContext = EGL14.EGL_NO_CONTEXT;
    private EGLSurface eglSurface = EGL14.EGL_NO_SURFACE;
    private Surface surface;

    EncoderSurface(Surface surface, EGLContext shareContext) {
        if (surface == null) {
            throw new NullPointerException();
        }
        this.surface = surface;
        this.eglSetup(shareContext);
    }

    private void eglSetup(EGLContext shareContext) {
        this.eglDisplay = EGL14.eglGetDisplay((int)0);
        if (this.eglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.eglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.eglDisplay = null;
            throw new RuntimeException("unable to initialize EGL14");
        }
        int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12610, 1, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.eglDisplay, (int[])attribList, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0)) {
            throw new RuntimeException("unable to find RGB888+recordable ES2 EGL config");
        }
        int[] attrib_list = new int[]{12440, 2, 12344};
        this.eglContext = EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (EGLContext)(shareContext != null ? shareContext : EGL14.EGL_NO_CONTEXT), (int[])attrib_list, (int)0);
        EncoderSurface.checkEglError("eglCreateContext");
        if (this.eglContext == null) {
            throw new RuntimeException("null context");
        }
        int[] surfaceAttribs = new int[]{12344};
        this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (Object)this.surface, (int[])surfaceAttribs, (int)0);
        EncoderSurface.checkEglError("eglCreateWindowSurface");
        if (this.eglSurface == null) {
            throw new RuntimeException("surface was null");
        }
    }

    public void release() {
        if (this.eglDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
        }
        this.surface.release();
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        this.eglContext = EGL14.EGL_NO_CONTEXT;
        this.eglSurface = EGL14.EGL_NO_SURFACE;
        this.surface = null;
    }

    void makeCurrent() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    void swapBuffers() {
        EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
    }

    void setPresentationTime(long nsecs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (long)nsecs);
    }

    private static void checkEglError(String msg) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }
}

