/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.ResourceTools;
import cn.rongcloud.rtc.webrtc.IStreamResource;

public class RCStreamImpl
implements RCRTCStream,
IStreamResource {
    protected String streamId;
    private RCRTCMediaType mediaType;
    private volatile String uri;
    private volatile long ssrc;
    private String tag;
    private String features;
    protected MediaStreamTrack track;
    private String userId;
    private RCRTCResourceState resourceState = RCRTCResourceState.NORMAL;
    private boolean enable = true;
    private RCRTCStream.RCRTCType type;
    private volatile boolean isLive;

    public RCStreamImpl(String tag, RCRTCMediaType mediaType, String streamId) {
        this.tag = tag;
        this.mediaType = mediaType;
        this.streamId = streamId;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public RCRTCMediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(RCRTCMediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    public void setIsLive(boolean live) {
        this.isLive = live;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public long getSsrc() {
        return this.ssrc;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    @Override
    public RCRTCResourceState getResourceState() {
        return this.resourceState;
    }

    @Override
    public synchronized void mute(boolean mute) {
        ReportUtil.appOperate(ReportUtil.TAG.SET_STREAM_MUTE, "streamId|mute", this.streamId, mute);
        boolean bl = this.enable = !mute;
        if (this.track != null) {
            this.track.setEnabled(this.enable);
        }
    }

    @Override
    public boolean isMute() {
        if (this.track != null) {
            return !this.track.enabled();
        }
        return !this.enable;
    }

    @Override
    public RCRTCStream.RCRTCType getType() {
        if (this.type == null) {
            this.type = ResourceTools.getSteamType(this.getStreamId(), this.getTag());
        }
        return this.type;
    }

    @Override
    public void setTrack(MediaStreamTrack track) {
        ReportUtil.libStatus(ReportUtil.TAG.SETTRACK, "streamId|mediaType", this.streamId, this.mediaType.getDescription());
        if (track == null) {
            return;
        }
        this.track = track;
        this.track.setEnabled(this.enable);
    }

    protected String getTrackId() {
        MediaStreamTrack track = this.track;
        if (track == null) {
            return "";
        }
        try {
            return track.id();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public MediaStreamTrack getTrack() {
        return this.track;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    protected void setUserId(String userId) {
        this.userId = userId;
    }

    public void setResourceState(RCRTCResourceState resourceState) {
        this.resourceState = resourceState;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void release() {
        this.track = null;
    }

    public static String makeStreamId(String userId, String tag) {
        return String.format("%s_%s", userId, tag);
    }

    public String toString() {
        return "RCStreamImpl{streamId='" + this.streamId + '\'' + ", type=" + (Object)((Object)this.mediaType) + ", uri='" + this.uri + '\'' + ", ssrc='" + this.ssrc + '\'' + ", tag='" + this.tag + '\'' + ", userId='" + this.userId + '\'' + ", resourceState=" + (Object)((Object)this.resourceState) + ", enable=" + this.enable + '}';
    }
}

