/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.view.Surface;
import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.CalledByNativeUnchecked;
import cn.rongcloud.rtc.core.CreateEglContextException;
import cn.rongcloud.rtc.core.DefaultVideoDecoderFactory;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.H264Utils;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.MediaCodecVideoEncoder;
import cn.rongcloud.rtc.core.PeerConnectionFactory;
import cn.rongcloud.rtc.core.SurfaceTextureHelper;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.VideoCodecInfo;
import cn.rongcloud.rtc.core.VideoDecoder;
import cn.rongcloud.rtc.core.VideoDecoderFactory;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoSink;
import cn.rongcloud.rtc.core.WrappedNativeVideoDecoder;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@Deprecated
public class MediaCodecVideoDecoder {
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final long MAX_DECODE_TIME_MS = 200L;
    private static final String FORMAT_KEY_STRIDE = "stride";
    private static final String FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static MediaCodecVideoDecoder runningInstance;
    private static MediaCodecVideoDecoderErrorCallback errorCallback;
    private static int codecErrors;
    private static Set<String> hwDecoderDisabledTypes;
    private static EglBase eglBase;
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String[] supportedVp9HwCodecPrefixes;
    private static final String supportedQcomH264HighProfileHwCodecPrefix = "OMX.qcom.";
    private static final String supportedExynosH264HighProfileHwCodecPrefix = "OMX.Exynos.";
    private static final String supportedMediaTekH264HighProfileHwCodecPrefix = "OMX.MTK.";
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList;
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private final Queue<TimeStamps> decodeStartTimeMs = new ArrayDeque<TimeStamps>();
    private TextureListener textureListener;
    private int droppedFrames;
    private Surface surface;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new ArrayDeque<DecodedOutputBuffer>();

    public static VideoDecoderFactory createFactory() {
        return new DefaultVideoDecoderFactory(new HwDecoderFactory());
    }

    private static final String[] supportedVp8HwCodecPrefixes() {
        ArrayList<String> supportedPrefixes = new ArrayList<String>();
        supportedPrefixes.add(supportedQcomH264HighProfileHwCodecPrefix);
        supportedPrefixes.add("OMX.Nvidia.");
        supportedPrefixes.add(supportedExynosH264HighProfileHwCodecPrefix);
        supportedPrefixes.add("OMX.Intel.");
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekVP8").equals("Enabled") && Build.VERSION.SDK_INT >= 24) {
            supportedPrefixes.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        return supportedPrefixes.toArray(new String[supportedPrefixes.size()]);
    }

    private static final String[] supportedH264HwCodecPrefixes() {
        ArrayList<String> supportedPrefixes = new ArrayList<String>();
        supportedPrefixes.add(supportedQcomH264HighProfileHwCodecPrefix);
        supportedPrefixes.add("OMX.Intel.");
        supportedPrefixes.add(supportedExynosH264HighProfileHwCodecPrefix);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled") && Build.VERSION.SDK_INT >= 27) {
            supportedPrefixes.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        return supportedPrefixes.toArray(new String[supportedPrefixes.size()]);
    }

    public static void setEglContext(EglBase.Context eglContext) throws CreateEglContextException {
        if (eglBase != null) {
            Logging.w(TAG, "Egl context already set.");
            eglBase.release();
        }
        eglBase = EglBase.create(eglContext);
    }

    public static void disposeEglContext() {
        if (eglBase != null) {
            eglBase.release();
            eglBase = null;
        }
    }

    static boolean useSurface() {
        return eglBase != null;
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback errorCallback) {
        Logging.d(TAG, "Set error callback");
        MediaCodecVideoDecoder.errorCallback = errorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes()) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, MediaCodecVideoDecoder.supportedH264HwCodecPrefixes()) != null;
    }

    public static boolean isH264HighProfileHwSupported() {
        if (hwDecoderDisabledTypes.contains(H264_MIME_TYPE)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedQcomH264HighProfileHwCodecPrefix}) != null) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedExynosH264HighProfileHwCodecPrefix}) != null) {
            return true;
        }
        return PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled") && Build.VERSION.SDK_INT >= 27 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedMediaTekH264HighProfileHwCodecPrefix}) != null;
    }

    public static void printStackTrace() {
        StackTraceElement[] mediaCodecStackTraces;
        if (runningInstance != null && MediaCodecVideoDecoder.runningInstance.mediaCodecThread != null && (mediaCodecStackTraces = MediaCodecVideoDecoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            for (StackTraceElement stackTrace : mediaCodecStackTraces) {
                Logging.d(TAG, stackTrace.toString());
            }
        }
    }

    private static DecoderProperties findDecoder(String mime, String[] supportedCodecPrefixes) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Logging.d(TAG, "Trying to find HW decoder for mime " + mime);
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo.CodecCapabilities capabilities;
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", e);
            }
            if (info == null || info.isEncoder()) continue;
            String name = null;
            for (String mimeType : info.getSupportedTypes()) {
                if (!mimeType.equals(mime)) continue;
                name = info.getName();
                break;
            }
            if (name == null) continue;
            Logging.d(TAG, "Found candidate decoder " + name);
            boolean supportedCodec = false;
            for (String codecPrefix : supportedCodecPrefixes) {
                if (!name.startsWith(codecPrefix)) continue;
                supportedCodec = true;
                break;
            }
            if (!supportedCodec) continue;
            try {
                capabilities = info.getCapabilitiesForType(mime);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve decoder capabilities", e);
                continue;
            }
            for (int colorFormat : capabilities.colorFormats) {
                Logging.v(TAG, "   Color: 0x" + Integer.toHexString(colorFormat));
            }
            Object object = supportedColorList.iterator();
            while (object.hasNext()) {
                int supportedColorFormat = (Integer)object.next();
                for (int codecColorFormat : capabilities.colorFormats) {
                    if (codecColorFormat != supportedColorFormat) continue;
                    Logging.d(TAG, "Found target decoder " + name + ". Color: 0x" + Integer.toHexString(codecColorFormat));
                    return new DecoderProperties(name, codecColorFormat);
                }
            }
        }
        Logging.d(TAG, "No HW decoder found for mime " + mime);
        return null;
    }

    @CalledByNative
    MediaCodecVideoDecoder() {
    }

    private void checkOnMediaCodecThread() throws IllegalStateException {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    @CalledByNativeUnchecked
    private boolean initDecode(VideoCodecType type, int width, int height) {
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        String mime = null;
        String[] supportedCodecPrefixes = null;
        if (type == VideoCodecType.VIDEO_CODEC_VP8) {
            mime = VP8_MIME_TYPE;
            supportedCodecPrefixes = MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes();
        } else if (type == VideoCodecType.VIDEO_CODEC_VP9) {
            mime = VP9_MIME_TYPE;
            supportedCodecPrefixes = supportedVp9HwCodecPrefixes;
        } else if (type == VideoCodecType.VIDEO_CODEC_H264) {
            mime = H264_MIME_TYPE;
            supportedCodecPrefixes = MediaCodecVideoDecoder.supportedH264HwCodecPrefixes();
        } else {
            throw new RuntimeException("initDecode: Non-supported codec " + (Object)((Object)type));
        }
        DecoderProperties properties = MediaCodecVideoDecoder.findDecoder(mime, supportedCodecPrefixes);
        if (properties == null) {
            throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)type));
        }
        Logging.d(TAG, "Java initDecode: " + (Object)((Object)type) + " : " + width + " x " + height + ". Color: 0x" + Integer.toHexString(properties.colorFormat) + ". Use Surface: " + MediaCodecVideoDecoder.useSurface());
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            SurfaceTextureHelper surfaceTextureHelper;
            this.width = width;
            this.height = height;
            this.stride = width;
            this.sliceHeight = height;
            if (MediaCodecVideoDecoder.useSurface() && (surfaceTextureHelper = SurfaceTextureHelper.create("Decoder SurfaceTextureHelper", eglBase.getEglBaseContext())) != null) {
                this.textureListener = new TextureListener(surfaceTextureHelper);
                this.textureListener.setSize(width, height);
                this.surface = new Surface(surfaceTextureHelper.getSurfaceTexture());
            }
            MediaFormat format = MediaFormat.createVideoFormat((String)mime, (int)width, (int)height);
            if (!MediaCodecVideoDecoder.useSurface()) {
                format.setInteger("color-format", properties.colorFormat);
            }
            Logging.d(TAG, "  Format: " + format);
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(properties.codecName);
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            this.mediaCodec.configure(format, this.surface, null, 0);
            this.mediaCodec.start();
            this.colorFormat = properties.colorFormat;
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            this.inputBuffers = this.mediaCodec.getInputBuffers();
            this.decodeStartTimeMs.clear();
            this.hasDecodedFirstFrame = false;
            this.dequeuedSurfaceOutputBuffers.clear();
            this.droppedFrames = 0;
            Logging.d(TAG, "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
            return true;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "initDecode failed", e);
            return false;
        }
    }

    @CalledByNativeUnchecked
    private void reset(int width, int height) {
        if (this.mediaCodecThread == null || this.mediaCodec == null) {
            throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
        }
        Logging.d(TAG, "Java reset: " + width + " x " + height);
        this.mediaCodec.flush();
        this.width = width;
        this.height = height;
        if (this.textureListener != null) {
            this.textureListener.setSize(width, height);
        }
        this.decodeStartTimeMs.clear();
        this.dequeuedSurfaceOutputBuffers.clear();
        this.hasDecodedFirstFrame = false;
        this.droppedFrames = 0;
    }

    @CalledByNativeUnchecked
    private void release() {
        Logging.d(TAG, "Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames);
        this.checkOnMediaCodecThread();
        final CountDownLatch releaseDone = new CountDownLatch(1);
        Runnable runMediaCodecRelease = new Runnable(){

            @Override
            public void run() {
                try {
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    MediaCodecVideoDecoder.this.mediaCodec.stop();
                    MediaCodecVideoDecoder.this.mediaCodec.release();
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception e) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", e);
                }
                releaseDone.countDown();
            }
        };
        new Thread(runMediaCodecRelease).start();
        if (!ThreadUtils.awaitUninterruptibly(releaseDone, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        if (MediaCodecVideoDecoder.useSurface()) {
            this.surface.release();
            this.surface = null;
            this.textureListener.release();
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    @CalledByNativeUnchecked
    private int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "dequeueIntputBuffer failed", e);
            return -2;
        }
    }

    @CalledByNativeUnchecked
    private boolean queueInputBuffer(int inputBufferIndex, int size, long presentationTimeStamUs, long timeStampMs, long ntpTimeStamp) {
        this.checkOnMediaCodecThread();
        try {
            this.inputBuffers[inputBufferIndex].position(0);
            this.inputBuffers[inputBufferIndex].limit(size);
            this.decodeStartTimeMs.add(new TimeStamps(SystemClock.elapsedRealtime(), timeStampMs, ntpTimeStamp));
            this.mediaCodec.queueInputBuffer(inputBufferIndex, 0, size, presentationTimeStamUs, 0);
            return true;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "decode failed", e);
            return false;
        }
    }

    @CalledByNativeUnchecked
    private DecodedOutputBuffer dequeueOutputBuffer(int dequeueTimeoutMs) {
        int result;
        this.checkOnMediaCodecThread();
        if (this.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        block5: while (true) {
            result = this.mediaCodec.dequeueOutputBuffer(info, TimeUnit.MILLISECONDS.toMicros(dequeueTimeoutMs));
            switch (result) {
                case -3: {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    Logging.d(TAG, "Decoder output buffers changed: " + this.outputBuffers.length);
                    if (!this.hasDecodedFirstFrame) continue block5;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: {
                    int newHeight;
                    int newWidth;
                    MediaFormat format = this.mediaCodec.getOutputFormat();
                    Logging.d(TAG, "Decoder format changed: " + format.toString());
                    if (format.containsKey(FORMAT_KEY_CROP_LEFT) && format.containsKey(FORMAT_KEY_CROP_RIGHT) && format.containsKey(FORMAT_KEY_CROP_BOTTOM) && format.containsKey(FORMAT_KEY_CROP_TOP)) {
                        newWidth = 1 + format.getInteger(FORMAT_KEY_CROP_RIGHT) - format.getInteger(FORMAT_KEY_CROP_LEFT);
                        newHeight = 1 + format.getInteger(FORMAT_KEY_CROP_BOTTOM) - format.getInteger(FORMAT_KEY_CROP_TOP);
                    } else {
                        newWidth = format.getInteger("width");
                        newHeight = format.getInteger("height");
                    }
                    if (this.hasDecodedFirstFrame && (newWidth != this.width || newHeight != this.height)) {
                        throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + newWidth + "*" + newHeight);
                    }
                    this.width = newWidth;
                    this.height = newHeight;
                    if (this.textureListener != null) {
                        this.textureListener.setSize(this.width, this.height);
                    }
                    if (!MediaCodecVideoDecoder.useSurface() && format.containsKey("color-format")) {
                        this.colorFormat = format.getInteger("color-format");
                        Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
                        if (!supportedColorList.contains(this.colorFormat)) {
                            throw new IllegalStateException("Non supported color format: " + this.colorFormat);
                        }
                    }
                    if (format.containsKey(FORMAT_KEY_STRIDE)) {
                        this.stride = format.getInteger(FORMAT_KEY_STRIDE);
                    }
                    if (format.containsKey(FORMAT_KEY_SLICE_HEIGHT)) {
                        this.sliceHeight = format.getInteger(FORMAT_KEY_SLICE_HEIGHT);
                    }
                    Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
                    this.stride = Math.max(this.width, this.stride);
                    this.sliceHeight = Math.max(this.height, this.sliceHeight);
                    continue block5;
                }
                case -1: {
                    return null;
                }
            }
            break;
        }
        this.hasDecodedFirstFrame = true;
        TimeStamps timeStamps = this.decodeStartTimeMs.remove();
        long decodeTimeMs = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
        if (decodeTimeMs > 200L) {
            Logging.e(TAG, "Very high decode time: " + decodeTimeMs + "ms. Q size: " + this.decodeStartTimeMs.size() + ". Might be caused by resuming H264 decoding after a pause.");
            decodeTimeMs = 200L;
        }
        return new DecodedOutputBuffer(result, info.offset, info.size, TimeUnit.MICROSECONDS.toMillis(info.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, decodeTimeMs, SystemClock.elapsedRealtime());
    }

    @CalledByNativeUnchecked
    private DecodedTextureBuffer dequeueTextureBuffer(int dequeueTimeoutMs) {
        this.checkOnMediaCodecThread();
        if (!MediaCodecVideoDecoder.useSurface()) {
            throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
        }
        DecodedOutputBuffer outputBuffer = this.dequeueOutputBuffer(dequeueTimeoutMs);
        if (outputBuffer != null) {
            this.dequeuedSurfaceOutputBuffers.add(outputBuffer);
        }
        this.MaybeRenderDecodedTextureBuffer();
        DecodedTextureBuffer renderedBuffer = this.textureListener.dequeueTextureBuffer(dequeueTimeoutMs);
        if (renderedBuffer != null) {
            this.MaybeRenderDecodedTextureBuffer();
            return renderedBuffer;
        }
        if (this.dequeuedSurfaceOutputBuffers.size() >= Math.min(3, this.outputBuffers.length) || dequeueTimeoutMs > 0 && !this.dequeuedSurfaceOutputBuffers.isEmpty()) {
            ++this.droppedFrames;
            DecodedOutputBuffer droppedFrame = this.dequeuedSurfaceOutputBuffers.remove();
            if (dequeueTimeoutMs > 0) {
                Logging.w(TAG, "Draining decoder. Dropping frame with TS: " + droppedFrame.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            } else {
                Logging.w(TAG, "Too many output buffers " + this.dequeuedSurfaceOutputBuffers.size() + ". Dropping frame with TS: " + droppedFrame.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            }
            this.mediaCodec.releaseOutputBuffer(droppedFrame.index, false);
            return new DecodedTextureBuffer(null, droppedFrame.presentationTimeStampMs, droppedFrame.timeStampMs, droppedFrame.ntpTimeStampMs, droppedFrame.decodeTimeMs, SystemClock.elapsedRealtime() - droppedFrame.endDecodeTimeMs);
        }
        return null;
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (this.dequeuedSurfaceOutputBuffers.isEmpty() || this.textureListener.isWaitingForTexture()) {
            return;
        }
        DecodedOutputBuffer buffer = this.dequeuedSurfaceOutputBuffers.remove();
        this.textureListener.addBufferToRender(buffer);
        this.mediaCodec.releaseOutputBuffer(buffer.index, true);
    }

    @CalledByNativeUnchecked
    private void returnDecodedOutputBuffer(int index) throws IllegalStateException, MediaCodec.CodecException {
        this.checkOnMediaCodecThread();
        if (MediaCodecVideoDecoder.useSurface()) {
            throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
        }
        this.mediaCodec.releaseOutputBuffer(index, false);
    }

    @CalledByNative
    ByteBuffer[] getInputBuffers() {
        return this.inputBuffers;
    }

    @CalledByNative
    ByteBuffer[] getOutputBuffers() {
        return this.outputBuffers;
    }

    @CalledByNative
    int getColorFormat() {
        return this.colorFormat;
    }

    @CalledByNative
    int getWidth() {
        return this.width;
    }

    @CalledByNative
    int getHeight() {
        return this.height;
    }

    @CalledByNative
    int getStride() {
        return this.stride;
    }

    @CalledByNative
    int getSliceHeight() {
        return this.sliceHeight;
    }

    private static native long nativeCreateDecoder(String var0, boolean var1);

    static {
        hwDecoderDisabledTypes = new HashSet<String>();
        supportedVp9HwCodecPrefixes = new String[]{supportedQcomH264HighProfileHwCodecPrefix, supportedExynosH264HighProfileHwCodecPrefix};
        supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    }

    private class TextureListener
    implements VideoSink {
        private final SurfaceTextureHelper surfaceTextureHelper;
        private final Object newFrameLock = new Object();
        private DecodedOutputBuffer bufferToRender;
        private DecodedTextureBuffer renderedBuffer;

        public TextureListener(SurfaceTextureHelper surfaceTextureHelper) {
            this.surfaceTextureHelper = surfaceTextureHelper;
            surfaceTextureHelper.startListening(this);
        }

        public void addBufferToRender(DecodedOutputBuffer buffer) {
            if (this.bufferToRender != null) {
                Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected addBufferToRender() called while waiting for a texture.");
                throw new IllegalStateException("Waiting for a texture.");
            }
            this.bufferToRender = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWaitingForTexture() {
            Object object = this.newFrameLock;
            synchronized (object) {
                return this.bufferToRender != null;
            }
        }

        public void setSize(int width, int height) {
            this.surfaceTextureHelper.setTextureSize(width, height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrame(VideoFrame frame) {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected onFrame() called while already holding a texture.");
                    throw new IllegalStateException("Already holding a texture.");
                }
                VideoFrame.Buffer buffer = frame.getBuffer();
                buffer.retain();
                this.renderedBuffer = new DecodedTextureBuffer(buffer, this.bufferToRender.presentationTimeStampMs, this.bufferToRender.timeStampMs, this.bufferToRender.ntpTimeStampMs, this.bufferToRender.decodeTimeMs, SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs);
                this.bufferToRender = null;
                this.newFrameLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DecodedTextureBuffer dequeueTextureBuffer(int timeoutMs) {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer == null && timeoutMs > 0 && this.isWaitingForTexture()) {
                    try {
                        this.newFrameLock.wait(timeoutMs);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                DecodedTextureBuffer returnedBuffer = this.renderedBuffer;
                this.renderedBuffer = null;
                return returnedBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.surfaceTextureHelper.stopListening();
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    this.renderedBuffer.getVideoFrameBuffer().release();
                    this.renderedBuffer = null;
                }
            }
            this.surfaceTextureHelper.dispose();
        }
    }

    private static class DecodedTextureBuffer {
        private final VideoFrame.Buffer videoFrameBuffer;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;

        public DecodedTextureBuffer(VideoFrame.Buffer videoFrameBuffer, long presentationTimeStampMs, long timeStampMs, long ntpTimeStampMs, long decodeTimeMs, long frameDelay) {
            this.videoFrameBuffer = videoFrameBuffer;
            this.presentationTimeStampMs = presentationTimeStampMs;
            this.timeStampMs = timeStampMs;
            this.ntpTimeStampMs = ntpTimeStampMs;
            this.decodeTimeMs = decodeTimeMs;
            this.frameDelayMs = frameDelay;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        VideoFrame.Buffer getVideoFrameBuffer() {
            return this.videoFrameBuffer;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getTimeStampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getFrameDelayMs() {
            return this.frameDelayMs;
        }
    }

    private static class DecodedOutputBuffer {
        private final int index;
        private final int offset;
        private final int size;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;

        public DecodedOutputBuffer(int index, int offset, int size, long presentationTimeStampMs, long timeStampMs, long ntpTimeStampMs, long decodeTime, long endDecodeTime) {
            this.index = index;
            this.offset = offset;
            this.size = size;
            this.presentationTimeStampMs = presentationTimeStampMs;
            this.timeStampMs = timeStampMs;
            this.ntpTimeStampMs = ntpTimeStampMs;
            this.decodeTimeMs = decodeTime;
            this.endDecodeTimeMs = endDecodeTime;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getIndex() {
            return this.index;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getOffset() {
            return this.offset;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getSize() {
            return this.size;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getTimestampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;

        public TimeStamps(long decodeStartTimeMs, long timeStampMs, long ntpTimeStampMs) {
            this.decodeStartTimeMs = decodeStartTimeMs;
            this.timeStampMs = timeStampMs;
            this.ntpTimeStampMs = ntpTimeStampMs;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String codecName, int colorFormat) {
            this.codecName = codecName;
            this.colorFormat = colorFormat;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_UNKNOWN,
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;


        @CalledByNative(value="VideoCodecType")
        static VideoCodecType fromNativeIndex(int nativeIndex) {
            return VideoCodecType.values()[nativeIndex];
        }
    }

    static class HwDecoderFactory
    extends VideoDecoderFactory {
        private final VideoCodecInfo[] supportedHardwareCodecs = HwDecoderFactory.getSupportedHardwareCodecs();

        HwDecoderFactory() {
        }

        private static boolean isSameCodec(VideoCodecInfo codecA, VideoCodecInfo codecB) {
            if (!codecA.name.equalsIgnoreCase(codecB.name)) {
                return false;
            }
            return codecA.name.equalsIgnoreCase("H264") ? H264Utils.isSameH264Profile(codecA.params, codecB.params) : true;
        }

        private static boolean isCodecSupported(VideoCodecInfo[] supportedCodecs, VideoCodecInfo codec) {
            for (VideoCodecInfo supportedCodec : supportedCodecs) {
                if (!HwDecoderFactory.isSameCodec(supportedCodec, codec)) continue;
                return true;
            }
            return false;
        }

        private static VideoCodecInfo[] getSupportedHardwareCodecs() {
            ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
            if (MediaCodecVideoDecoder.isVp8HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "VP8 HW Decoder supported.");
                codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isVp9HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "VP9 HW Decoder supported.");
                codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isH264HighProfileHwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 High Profile HW Decoder supported.");
                codecs.add(H264Utils.DEFAULT_H264_HIGH_PROFILE_CODEC);
            }
            if (MediaCodecVideoDecoder.isH264HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 HW Decoder supported.");
                codecs.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
            }
            return codecs.toArray(new VideoCodecInfo[codecs.size()]);
        }

        @Override
        public VideoCodecInfo[] getSupportedCodecs() {
            return this.supportedHardwareCodecs;
        }

        @Override
        public VideoDecoder createDecoder(final VideoCodecInfo codec) {
            if (!HwDecoderFactory.isCodecSupported(this.supportedHardwareCodecs, codec)) {
                Logging.d(MediaCodecVideoDecoder.TAG, "No HW video decoder for codec " + codec.name);
                return null;
            }
            Logging.d(MediaCodecVideoDecoder.TAG, "Create HW video decoder for " + codec.name);
            return new WrappedNativeVideoDecoder(){

                @Override
                public long createNativeVideoDecoder() {
                    return MediaCodecVideoDecoder.nativeCreateDecoder(codec.name, MediaCodecVideoDecoder.useSurface());
                }
            };
        }
    }
}

