/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import com.heytap.mcssdk.IPushService;
import com.heytap.mcssdk.base.Base64;
import com.heytap.mcssdk.manage.NotificatonChannelManager;
import com.heytap.mcssdk.mode.AppLimitBean;
import com.heytap.mcssdk.mode.CallBackResult;
import com.heytap.mcssdk.parser.CallBackResultParser;
import com.heytap.mcssdk.parser.DataMessageParser;
import com.heytap.mcssdk.parser.Parser;
import com.heytap.mcssdk.processor.CallBackResultProcessor;
import com.heytap.mcssdk.processor.DataMessageProcessor;
import com.heytap.mcssdk.processor.Processor;
import com.heytap.mcssdk.utils.LogUtil;
import com.heytap.mcssdk.utils.StatUtil;
import com.heytap.mcssdk.utils.Utils;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.heytap.msp.push.callback.IGetAppNotificationCallBackService;
import com.heytap.msp.push.callback.ISetAppNotificationCallBackService;
import com.heytap.msp.push.mode.MessageStat;
import com.mcs.aidl.IMcsSdkService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class PushService
implements IPushService {
    private static final int[] OLD_MCS_PACKAGE = new int[]{99, 111, 109, 46, 99, 111, 108, 111, 114, 111, 115, 46, 109, 99, 115};
    private static final int[] OLD_MCS_RECEIVE_SDK_ACTION = new int[]{99, 111, 109, 46, 99, 111, 108, 111, 114, 111, 115, 46, 109, 99, 115, 115, 100, 107, 46, 97, 99, 116, 105, 111, 110, 46, 82, 69, 67, 69, 73, 86, 69, 95, 83, 68, 75, 95, 77, 69, 83, 83, 65, 71, 69};
    private static String NEW_MCS_RECEIVE_SDK_ACTION = "";
    private static final String NEW_MCS_RECEIVE_SDK_ACTION_Base64 = "Y29tLm1jcy5hY3Rpb24uUkVDRUlWRV9TREtfTUVTU0FHRQ==";
    private static final String TYPE = "type";
    private static final int MCS_SUPPORT_VERSION = 1019;
    private static final String EVENT_ID = "eventID";
    private static final String TASK_ID = "taskID";
    private static final String APP_PACKAGE = "appPackage";
    private static final String EXTRA = "extra";
    private static final String MESSAGE_TYPE = "messageType";
    private static final String MESSAGE_ID = "messageID";
    private static final String GLOBAL_ID = "globalID";
    private static final String SUPPORT_OPEN_PUSH = "supportOpenPush";
    private static final String APP_VERSION_NAME = "versionName";
    private static final String APP_VERSION_CODE = "versionCode";
    private static final String PUSH_SDK_VERSION = "pushSdkVersion";
    private static final int MAX_HOUR_IN_DAY = 23;
    private static final int MAX_MIN_IN_HOUR = 59;
    private static final int SDK_INT_24 = 24;
    private static final int SYSTEM_UID = 1000;
    private static final int DEFAULT_API_MAX_COUNT = 2;
    private static int sCount = 0;
    private static String sMcsPkgName;
    private static boolean sIsNewMcsPkg;
    private Context mContext;
    private List<Processor> mProcessors = new ArrayList<Processor>();
    private List<Parser> mParsers = new ArrayList<Parser>();
    private String mAuthCode;
    private String mVerifyCode;
    private String mRegisterID = null;
    private ICallBackResultService mICallBackResultService;
    private ISetAppNotificationCallBackService mISetAppNotificationCallBackService;
    private IGetAppNotificationCallBackService mIGetAppNotificationCallBackService;
    private ConcurrentHashMap<Integer, AppLimitBean> mAppLimitMap;

    public PushService init(Context context, boolean needLog) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.innerInit(context);
        NotificatonChannelManager notificatonChannelManager = new NotificatonChannelManager();
        notificatonChannelManager.createDefaultChannel(this.mContext);
        LogUtil.setDebugs(needLog);
        return this;
    }

    public void innerInit(Context context) {
        this.mContext = context.getApplicationContext();
        if (sMcsPkgName == null) {
            String newMcsPkg = this.getNewMcsPackageName(this.mContext);
            if (newMcsPkg == null) {
                sMcsPkgName = Utils.getString(OLD_MCS_PACKAGE);
                sIsNewMcsPkg = false;
            } else {
                sMcsPkgName = newMcsPkg;
                sIsNewMcsPkg = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PushService() {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (sCount > 0) {
                throw new RuntimeException("PushService can't create again!");
            }
            ++sCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.addParser(new DataMessageParser());
            this.addParser(new CallBackResultParser());
            this.addProcessor(new DataMessageProcessor());
            this.addProcessor(new CallBackResultProcessor());
            this.mAppLimitMap = new ConcurrentHashMap();
            return;
        }
    }

    public static PushService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private String getNewMcsPackageName(Context context) {
        if (TextUtils.isEmpty((CharSequence)NEW_MCS_RECEIVE_SDK_ACTION)) {
            NEW_MCS_RECEIVE_SDK_ACTION = new String(Base64.decodeBase64(NEW_MCS_RECEIVE_SDK_ACTION_Base64));
        }
        Intent intent = new Intent(NEW_MCS_RECEIVE_SDK_ACTION);
        List resolveInfoList = context.getPackageManager().queryIntentServices(intent, 8192);
        if (Build.VERSION.SDK_INT >= 24) {
            for (ResolveInfo resolveInfo : resolveInfoList) {
                String pkg = resolveInfo.serviceInfo.packageName;
                try {
                    boolean isSystemUid;
                    ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(pkg, 0);
                    boolean hasSystemFlag = (applicationInfo.flags & 1) == 1;
                    int pkgUid = context.getPackageManager().getPackageUid(pkg, 0);
                    int systemUid = context.getPackageManager().getPackageUid("android", 0);
                    boolean bl = isSystemUid = pkgUid == systemUid;
                    if (!hasSystemFlag && !isSystemUid) continue;
                    return pkg;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                }
            }
        }
        return null;
    }

    public String getMcsPackageName(Context context) {
        if (sMcsPkgName == null) {
            String newMcsPkg = this.getNewMcsPackageName(context);
            if (newMcsPkg == null) {
                sMcsPkgName = Utils.getString(OLD_MCS_PACKAGE);
                sIsNewMcsPkg = false;
            } else {
                sMcsPkgName = newMcsPkg;
                sIsNewMcsPkg = true;
            }
        }
        return sMcsPkgName;
    }

    public String getReceiveSdkAction(Context context) {
        if (sMcsPkgName == null) {
            this.getNewMcsPackageName(context);
        }
        if (sIsNewMcsPkg) {
            if (TextUtils.isEmpty((CharSequence)NEW_MCS_RECEIVE_SDK_ACTION)) {
                NEW_MCS_RECEIVE_SDK_ACTION = new String(Base64.decodeBase64(NEW_MCS_RECEIVE_SDK_ACTION_Base64));
            }
            return NEW_MCS_RECEIVE_SDK_ACTION;
        }
        return Utils.getString(OLD_MCS_RECEIVE_SDK_ACTION);
    }

    public boolean isSupportPushByClient(Context context) {
        return this.isSupportPushInner(context);
    }

    private boolean isSupportPushInner(Context context) {
        String pkg;
        if (this.mContext == null) {
            this.mContext = context.getApplicationContext();
        }
        return Utils.isExistPackage(this.mContext, pkg = this.getMcsPackageName(this.mContext)) && Utils.getVersionCode(this.mContext, pkg) >= 1019 && Utils.isSupportPush(this.mContext, pkg, SUPPORT_OPEN_PUSH);
    }

    @Deprecated
    private static void onAppStart(Context context) {
        MessageStat message = new MessageStat(context.getPackageName(), "app_start", null);
        StatUtil.statisticMessage(context, message);
    }

    private synchronized void addProcessor(Processor processor) {
        if (null != processor) {
            this.mProcessors.add(processor);
        }
    }

    private synchronized void addParser(Parser parser) {
        if (null != parser) {
            this.mParsers.add(parser);
        }
    }

    public List<Parser> getParsers() {
        return this.mParsers;
    }

    public List<Processor> getProcessors() {
        return this.mProcessors;
    }

    private boolean checkContext() {
        return null != this.mContext;
    }

    private boolean checkRegisterID() {
        return null != this.mRegisterID;
    }

    private boolean checkAll() throws IllegalArgumentException {
        return this.checkContext() && this.checkRegisterID();
    }

    public void setAppKeySecret(String appKey, String appSecret) {
        this.mAuthCode = appKey;
        this.mVerifyCode = appSecret;
    }

    @Override
    public String getRegisterID() {
        return this.mRegisterID;
    }

    @Override
    public void setRegisterID(String mRegisterID) {
        this.mRegisterID = mRegisterID;
    }

    private void startMcsService(int commandType, JSONObject extra) {
        this.startMcsService(commandType, "", extra);
    }

    private void startMcsService(int commandType, String params, JSONObject extra) {
        if (this.checkCommandLimit(commandType)) {
            if (this.mICallBackResultService != null) {
                this.mICallBackResultService.onError(this.getErrorCode(commandType), "api_call_too_frequently");
            }
            return;
        }
        try {
            Intent intent = this.getIntent(commandType, params, extra);
            this.mContext.startService(intent);
        }
        catch (Exception e) {
            LogUtil.e("startMcsService--Exception" + e.getMessage());
        }
    }

    public void bindMcsService(int commandType) {
        if (this.checkCommandLimit(commandType)) {
            if (this.mICallBackResultService != null) {
                this.mICallBackResultService.onError(this.getErrorCode(commandType), "api_call_too_frequently");
            }
            return;
        }
        final Intent intent = this.getIntent(commandType, "", null);
        this.mContext.bindService(intent, new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                Bundle bundle = new Bundle();
                bundle.putAll(intent.getExtras());
                try {
                    IMcsSdkService service = IMcsSdkService.Stub.asInterface(iBinder);
                    service.process(bundle);
                }
                catch (Exception e) {
                    LogUtil.d("bindMcsService exception:" + e);
                }
                PushService.this.mContext.unbindService((ServiceConnection)this);
            }

            public void onServiceDisconnected(ComponentName componentName) {
            }
        }, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent getIntent(int commandType, String params, JSONObject extra) {
        Intent intent = new Intent();
        intent.setAction(this.getReceiveSdkAction(this.mContext));
        intent.setPackage(this.getMcsPackageName(this.mContext));
        intent.putExtra(TYPE, commandType);
        JSONObject extraJson = new JSONObject();
        try {
            extraJson.putOpt(APP_VERSION_NAME, (Object)Utils.getVersionName(this.mContext, this.mContext.getPackageName()));
            extraJson.putOpt(APP_VERSION_CODE, (Object)Utils.getVersionCode(this.mContext, this.mContext.getPackageName()));
            if (extra != null) {
                Iterator tmp = extra.keys();
                while (tmp.hasNext()) {
                    String key = (String)tmp.next();
                    extraJson.putOpt(key, extra.get(key));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            intent.putExtra(EXTRA, extraJson.toString());
        }
        intent.putExtra("params", params);
        intent.putExtra(APP_PACKAGE, this.mContext.getPackageName());
        intent.putExtra("appKey", this.mAuthCode);
        intent.putExtra("appSecret", this.mVerifyCode);
        intent.putExtra("registerID", this.mRegisterID);
        intent.putExtra("sdkVersion", PushService.getSDKVersionName());
        return intent;
    }

    public ICallBackResultService getPushCallback() {
        return this.mICallBackResultService;
    }

    public void setPushCallback(ICallBackResultService ICallBackResultService2) {
        this.mICallBackResultService = ICallBackResultService2;
    }

    public IGetAppNotificationCallBackService getPushGetAppNotificationCallBack() {
        return this.mIGetAppNotificationCallBackService;
    }

    public ISetAppNotificationCallBackService getPushSetAppNotificationCallBack() {
        return this.mISetAppNotificationCallBackService;
    }

    @Override
    public void register(Context applicationContext, String appKey, String appSecret, JSONObject extra, ICallBackResultService ICallBackResultService2) {
        if (applicationContext == null) {
            if (ICallBackResultService2 != null) {
                ICallBackResultService2.onRegister(-2, null);
            }
            return;
        }
        if (this.mContext == null) {
            this.mContext = applicationContext.getApplicationContext();
        }
        if (!Utils.isSupportPushByClient(this.mContext)) {
            if (ICallBackResultService2 != null) {
                ICallBackResultService2.onRegister(-2, null);
            }
            return;
        }
        this.mAuthCode = appKey;
        this.mVerifyCode = appSecret;
        this.mICallBackResultService = ICallBackResultService2;
        if (extra == null) {
            extra = new JSONObject();
        }
        try {
            extra.putOpt("appVersionCode", (Object)Utils.getVersionCode(applicationContext));
            extra.putOpt("appVersionName", (Object)Utils.getVersionName(applicationContext));
        }
        catch (JSONException e) {
            LogUtil.e("register-Exception:" + e.getMessage());
        }
        this.startMcsService(12289, extra);
    }

    @Override
    public void register(Context applicationContext, String appKey, String appSecret, ICallBackResultService ICallBackResultService2) {
        this.register(applicationContext, appKey, appSecret, null, ICallBackResultService2);
    }

    public void unRegister(Context applicationContext, String appKey, String appSecret, JSONObject extra, ICallBackResultService ICallBackResultService2) {
        this.mAuthCode = appKey;
        this.mVerifyCode = appSecret;
        this.mContext = applicationContext.getApplicationContext();
        this.mICallBackResultService = ICallBackResultService2;
        this.unRegister(extra);
    }

    @Override
    public void unRegister(JSONObject extra) {
        if (this.checkContext()) {
            this.startMcsService(12290, extra);
        } else if (this.getPushCallback() != null) {
            this.getPushCallback().onUnRegister(-2);
        }
    }

    @Override
    public void unRegister() {
        this.unRegister(null);
    }

    @Override
    public void getRegister(JSONObject extra) {
        if (this.checkContext()) {
            this.startMcsService(12289, extra);
        } else if (this.getPushCallback() != null) {
            this.getPushCallback().onRegister(-2, null);
        }
    }

    @Override
    public void getRegister() {
        this.getRegister(null);
    }

    @Override
    public void pausePush(JSONObject extra) {
        if (this.checkAll()) {
            this.startMcsService(12299, extra);
        } else {
            LogUtil.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void pausePush() {
        this.pausePush(null);
    }

    @Override
    public void resumePush(JSONObject extra) {
        if (this.checkAll()) {
            this.startMcsService(12300, extra);
        } else {
            LogUtil.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void resumePush() {
        this.resumePush(null);
    }

    @Override
    public void getNotificationStatus(JSONObject extra) {
        if (this.checkAll()) {
            this.startMcsService(12309, extra);
        } else if (this.getPushCallback() != null) {
            this.getPushCallback().onGetNotificationStatus(-2, 0);
        }
    }

    @Override
    public void getNotificationStatus() {
        this.getNotificationStatus(null);
    }

    @Override
    public void setNotificationType(int notificationType, JSONObject extra) {
        if (this.checkAll()) {
            this.startMcsService(12307, notificationType + "", extra);
        } else {
            LogUtil.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void setNotificationType(int notificationType) {
        this.setNotificationType(notificationType, null);
    }

    @Override
    public void clearNotificationType(JSONObject extra) {
        if (this.checkAll()) {
            this.startMcsService(12308, extra);
        } else {
            LogUtil.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void clearNotificationType() {
        this.clearNotificationType(null);
    }

    @Override
    public void openNotificationSettings(JSONObject extra) {
        if (this.checkAll()) {
            this.startMcsService(12310, extra);
        } else {
            LogUtil.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void openNotificationSettings() {
        this.openNotificationSettings(null);
    }

    @Override
    public void clearNotifications() {
        this.clearNotifications(null);
    }

    @Override
    public void clearNotifications(JSONObject extra) {
        if (this.checkContext()) {
            this.startMcsService(12311, extra);
        } else {
            LogUtil.e("mcssdk---", "please call the register first!");
        }
    }

    public void getPushStatus() {
        if (this.checkAll()) {
            this.startMcsService(12306, null);
        } else if (this.getPushCallback() != null) {
            this.getPushCallback().onGetPushStatus(-2, 0);
        }
    }

    public static String getSDKVersionName() {
        return "3.1.0";
    }

    public static int getSDKVersionCode() {
        return 3100;
    }

    public String getPushVersionName() {
        if (this.checkContext()) {
            return Utils.getVersionName(this.mContext, this.getMcsPackageName(this.mContext));
        }
        return "";
    }

    public int getPushVersionCode() {
        if (this.checkContext()) {
            return Utils.getVersionCode(this.mContext, this.getMcsPackageName(this.mContext));
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPushTime(List<Integer> weekDays, int startHour, int startMin, int endHour, int endMin, JSONObject extra) throws IllegalArgumentException {
        if (this.checkAll()) {
            if (null == weekDays || weekDays.size() <= 0 || startHour < 0 || startMin < 0 || endHour < startHour || endHour > 23 || endMin < startMin || endMin > 59) throw new IllegalArgumentException("params are not all right,please check params");
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("weekDays", (Object)CallBackResult.parseToString(weekDays));
                jsonObject.put("startHour", startHour);
                jsonObject.put("startMin", startMin);
                jsonObject.put("endHour", endHour);
                jsonObject.put("endMin", endMin);
                this.startMcsService(12298, jsonObject.toString(), extra);
                return;
            }
            catch (JSONException e) {
                LogUtil.e("mcssdk---", e.getLocalizedMessage());
            }
            return;
        } else {
            if (this.getPushCallback() == null) return;
            this.getPushCallback().onSetPushTime(-2, "please call the register first!");
        }
    }

    @Override
    public void setPushTime(List<Integer> weekDays, int startHour, int startMin, int endHour, int endMin) {
        this.setPushTime(weekDays, startHour, startMin, endHour, endMin, null);
    }

    @Override
    public void requestNotificationPermission() {
        if (this.checkContext()) {
            this.bindMcsService(12313);
        } else {
            LogUtil.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void enableAppNotificationSwitch(ISetAppNotificationCallBackService callBackService) {
        if (this.checkContext()) {
            this.mISetAppNotificationCallBackService = callBackService;
            this.startMcsService(12316, null);
        } else if (this.mISetAppNotificationCallBackService != null) {
            this.mISetAppNotificationCallBackService.onSetAppNotificationSwitch(-2);
        }
    }

    @Override
    public void disableAppNotificationSwitch(ISetAppNotificationCallBackService callBackService) {
        if (this.checkContext()) {
            this.mISetAppNotificationCallBackService = callBackService;
            this.startMcsService(12317, null);
        } else if (this.getPushCallback() != null) {
            this.mISetAppNotificationCallBackService.onSetAppNotificationSwitch(-2);
        }
    }

    @Override
    public void getAppNotificationSwitch(IGetAppNotificationCallBackService callBackService) {
        if (this.checkContext()) {
            this.mIGetAppNotificationCallBackService = callBackService;
            this.startMcsService(12318, null);
        } else if (this.mIGetAppNotificationCallBackService != null) {
            this.mIGetAppNotificationCallBackService.onGetAppNotificationSwitch(-2, 0);
        }
    }

    @Override
    public void cancelNotification(JSONObject jsonObject) {
        if (this.checkAll()) {
            this.startMcsService(12319, jsonObject);
        } else {
            LogUtil.e("mcssdk---", "please call the register first!");
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public Map<Integer, AppLimitBean> getAppLimitMap() {
        return this.mAppLimitMap;
    }

    public boolean checkCommandLimit(int type) {
        AppLimitBean appLimitBean = this.addCommandToMap(type);
        if (type != 12291 && type != 12312) {
            return appLimitBean.getCount() > 2;
        }
        return false;
    }

    private AppLimitBean addCommandToMap(int type) {
        AppLimitBean appLimitBean;
        if (this.mAppLimitMap.containsKey(type)) {
            appLimitBean = this.mAppLimitMap.get(type);
            if (this.checkTimeNeedUpdate(appLimitBean)) {
                appLimitBean.setCount(1);
                appLimitBean.setLastedTime(System.currentTimeMillis());
                LogUtil.d("addCommandToMap : appLimitBean.setCount(1)");
            } else {
                appLimitBean.setCount(appLimitBean.getCount() + 1);
                LogUtil.d("addCommandToMap :appLimitBean.getCount() + 1");
            }
        } else {
            appLimitBean = new AppLimitBean(System.currentTimeMillis(), 1);
            this.mAppLimitMap.put(type, appLimitBean);
            LogUtil.d("addCommandToMap :appBean is null");
        }
        return appLimitBean;
    }

    private boolean checkTimeNeedUpdate(AppLimitBean appLimitBean) {
        long lastedTime = appLimitBean.getLastedTime();
        long currentTime = System.currentTimeMillis();
        LogUtil.d("checkTimeNeedUpdate : lastedTime " + lastedTime + " currentTime:" + currentTime);
        return currentTime - lastedTime > 1000L;
    }

    public int getErrorCode(int type) {
        switch (type) {
            case 12289: {
                return -1;
            }
            case 12290: {
                return -2;
            }
            case 12299: {
                return -3;
            }
            case 12300: {
                return -4;
            }
            case 12309: {
                return -5;
            }
            case 12307: {
                return -6;
            }
            case 12308: {
                return -7;
            }
            case 12310: {
                return -8;
            }
            case 12311: {
                return -9;
            }
            case 12306: {
                return -10;
            }
            case 12298: {
                return -11;
            }
            case 12313: {
                return -12;
            }
            case 12312: {
                return -13;
            }
            case 12291: {
                return -14;
            }
            case 12316: {
                return -15;
            }
            case 12317: {
                return -16;
            }
            case 12318: {
                return -17;
            }
        }
        return 0;
    }

    private static class SingletonHolder {
        private static final PushService INSTANCE = new PushService();

        private SingletonHolder() {
        }
    }
}

