/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import cn.rongcloud.rtc.api.RCRTCAudioMixer;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.AudioBufferStream;
import cn.rongcloud.rtc.utils.AudioUtil;
import java.nio.ByteBuffer;

public class AudioWriteHelper
implements OnAudioBufferAvailableListener {
    private AudioBufferStream mAudioBufferStream;
    private static final int MAX_VOL = 100;
    private static final int MIN_VOL = 0;
    private int mixingVolume = 100;
    private RCRTCAudioMixer.Mode mode;
    private volatile boolean isRelease = false;

    public AudioWriteHelper() {
        RCMicOutputStreamImpl stream = (RCMicOutputStreamImpl)RTCEngineImpl.getInstance().getDefaultAudioStream();
        if (null != stream) {
            stream.registerAudioBufferListener(this);
        }
    }

    public void write(byte[] data, int sampleRate, int channelCount, int audioFormat, int volume, RCRTCAudioMixer.Mode mode) {
        if (this.isRelease) {
            return;
        }
        AudioBufferStream audioBufferStream = null;
        if (this.mAudioBufferStream == null) {
            this.mAudioBufferStream = new AudioBufferStream(sampleRate, channelCount, audioFormat, RTCEngineImpl.getInstance().getAudioSampleRate(), RTCEngineImpl.getInstance().isStereo() ? 2 : 1, 2);
        }
        this.mixingVolume = Math.max(0, Math.min(100, volume));
        this.mode = mode;
        audioBufferStream = this.mAudioBufferStream;
        if (null != audioBufferStream) {
            audioBufferStream.write(data);
        }
    }

    @Override
    public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        if (audioBufferStream == null) {
            return;
        }
        byte[] data = audioBufferStream.read(sizeInBytes / (channelCount * 2));
        if (data == null) {
            return;
        }
        AudioUtil.adjustVolumeAsShort(data, AudioUtil.linearToLog(this.mixingVolume));
        switch (this.mode) {
            case MIX: {
                AudioUtil.mixAsShort(data, byteBuffer);
                break;
            }
            case REPLACE: {
                byteBuffer.clear();
                byteBuffer.put(data);
                break;
            }
        }
    }

    public void release() {
        RCMicOutputStreamImpl stream;
        this.isRelease = true;
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        this.mAudioBufferStream = null;
        if (null != audioBufferStream) {
            audioBufferStream.release();
        }
        if (null != (stream = (RCMicOutputStreamImpl)RTCEngineImpl.getInstance().getDefaultAudioStream())) {
            stream.unregisterAudioBufferListener(this);
        }
    }
}

